/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl.shorthand;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.css.property.ICSSProperty;
import jakarta.annotation.Nonnull;

public final class CSSPropertyWithDefaultValue {
    private final ICSSProperty m_aProperty;
    private final String m_sDefaultValue;

    public CSSPropertyWithDefaultValue(@Nonnull ICSSProperty iCSSProperty, @Nonnull String string) {
        this.m_aProperty = (ICSSProperty)ValueEnforcer.notNull((Object)iCSSProperty, (String)"Property");
        this.m_sDefaultValue = (String)ValueEnforcer.notNull((Object)string, (String)"DefaultValue");
        if (!iCSSProperty.isValidValue(string)) {
            throw new IllegalArgumentException("Default value '" + string + "' does not match property " + String.valueOf(iCSSProperty));
        }
    }

    @Nonnull
    public ICSSProperty getProperty() {
        return this.m_aProperty;
    }

    @Nonnull
    public String getDefaultValue() {
        return this.m_sDefaultValue;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("property", (Object)this.m_aProperty).append("defaultValue", (Object)this.m_sDefaultValue).getToString();
    }
}

