/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.ICSSSupportsConditionMember;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@NotThreadSafe
public class CSSSupportsConditionNegation
implements ICSSSupportsConditionMember,
ICSSSourceLocationAware {
    private final ICSSSupportsConditionMember m_aSupportsMember;
    private CSSSourceLocation m_aSourceLocation;

    public CSSSupportsConditionNegation(@Nonnull ICSSSupportsConditionMember iCSSSupportsConditionMember) {
        this.m_aSupportsMember = (ICSSSupportsConditionMember)ValueEnforcer.notNull((Object)iCSSSupportsConditionMember, (String)"SupportsMember");
    }

    @Nonnull
    public ICSSSupportsConditionMember getSupportsMember() {
        return this.m_aSupportsMember;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        return "not " + this.m_aSupportsMember.getAsCSSString(iCSSWriterSettings, n);
    }

    @Override
    @Nullable
    public final CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    @Override
    public final void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSSupportsConditionNegation cSSSupportsConditionNegation = (CSSSupportsConditionNegation)object;
        return this.m_aSupportsMember.equals(cSSSupportsConditionNegation.m_aSupportsMember);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aSupportsMember).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("supportsMember", (Object)this.m_aSupportsMember).appendIfNotNull("SourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

