/*
 * Decompiled with CFR 0.152.
 */
package app.softwork.uuid;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.time.Clock;
import kotlin.time.ExperimentalTime;
import kotlin.time.Instant;
import kotlin.uuid.Uuid;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001\u001a\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0003H\u0000\u001a\u0016\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b\u001a\u0012\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\fH\u0007\u001a\u001a\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\t\u001a\u00020\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\"\u001e\u0010\r\u001a\u00020\f*\u00020\u00038FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"UNIX_48_TIMESTAMP", "", "Uuidv7", "Lkotlin/uuid/Uuid;", "timeStamp", "timestamp", "base", "random", "Lkotlin/random/Random;", "unixTimeStamp", "getUnixTimeStamp", "(Lkotlin/uuid/Uuid;)J", "Lkotlin/time/Instant;", "instant", "getInstant$annotations", "(Lkotlin/uuid/Uuid;)V", "getInstant", "(Lkotlin/uuid/Uuid;)Lkotlin/time/Instant;", "kotlinx-uuid-core"})
@SourceDebugExtension(value={"SMAP\nUuidv7.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Uuidv7.kt\napp/softwork/uuid/Uuidv7Kt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n1#2:91\n*E\n"})
public final class Uuidv7Kt {
    private static final long UNIX_48_TIMESTAMP = 0x1FFFFFFFFFFFFL;

    @NotNull
    public static final Uuid Uuidv7(long timeStamp) {
        if (!(timeStamp <= 0x1FFFFFFFFFFFFL)) {
            boolean bl = false;
            String string = "timeStamp " + timeStamp + " must be <= 48 bits, was " + timeStamp + '.';
            throw new IllegalArgumentException(string.toString());
        }
        Uuid base = Uuid.Companion.random();
        return Uuidv7Kt.Uuidv7(timeStamp, base);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Uuid Uuidv7(long timestamp, @NotNull Uuid base) {
        void leastSignificantBits;
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Uuid uuid = base;
        long l = uuid.getLeastSignificantBits();
        long randomValue = uuid.getMostSignificantBits();
        boolean bl = false;
        long shiftedRightBits = timestamp << 16;
        long left = randomValue & 0xFFFL;
        long result = left | 0x7000L | shiftedRightBits;
        return Uuid.Companion.fromLongs(result, (long)leastSignificantBits);
    }

    @NotNull
    public static final Uuid Uuidv7(long timeStamp, @NotNull Random random) {
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        if (!(timeStamp <= 0x1FFFFFFFFFFFFL)) {
            boolean bl = false;
            String string = "timeStamp " + timeStamp + " must be <= 48 bits, was " + timeStamp + '.';
            throw new IllegalArgumentException(string.toString());
        }
        byte[] value = random.nextBytes(16);
        value[0] = (byte)(timeStamp >> 40 & 0xFFL);
        value[1] = (byte)(timeStamp >> 32 & 0xFFL);
        value[2] = (byte)(timeStamp >> 24 & 0xFFL);
        value[3] = (byte)(timeStamp >> 16 & 0xFFL);
        value[4] = (byte)(timeStamp >> 8 & 0xFFL);
        value[5] = (byte)(timeStamp & 0xFFL);
        value[6] = (byte)(value[6] & 0xF | 0x70);
        value[8] = (byte)(value[8] & 0x3F | 0x80);
        return Uuid.Companion.fromByteArray(value);
    }

    public static final long getUnixTimeStamp(@NotNull Uuid $this$unixTimeStamp) {
        Intrinsics.checkNotNullParameter((Object)$this$unixTimeStamp, (String)"<this>");
        Uuid uuid = $this$unixTimeStamp;
        long l = uuid.getMostSignificantBits();
        uuid.getLeastSignificantBits();
        long mostSignificantBits = l;
        boolean bl = false;
        return mostSignificantBits >>> 16;
    }

    @ExperimentalTime
    @NotNull
    public static final Uuid Uuidv7(@NotNull Instant timeStamp) {
        Intrinsics.checkNotNullParameter((Object)timeStamp, (String)"timeStamp");
        return Uuidv7Kt.Uuidv7(timeStamp.toEpochMilliseconds());
    }

    public static /* synthetic */ Uuid Uuidv7$default(Instant instant, int n, Object object) {
        if ((n & 1) != 0) {
            instant = Clock.System.INSTANCE.now();
        }
        return Uuidv7Kt.Uuidv7(instant);
    }

    @ExperimentalTime
    @NotNull
    public static final Uuid Uuidv7(@NotNull Instant timeStamp, @NotNull Random random) {
        Intrinsics.checkNotNullParameter((Object)timeStamp, (String)"timeStamp");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        return Uuidv7Kt.Uuidv7(timeStamp.toEpochMilliseconds(), random);
    }

    public static /* synthetic */ Uuid Uuidv7$default(Instant instant, Random random, int n, Object object) {
        if ((n & 1) != 0) {
            instant = Clock.System.INSTANCE.now();
        }
        return Uuidv7Kt.Uuidv7(instant, random);
    }

    @NotNull
    public static final Instant getInstant(@NotNull Uuid $this$instant) {
        Intrinsics.checkNotNullParameter((Object)$this$instant, (String)"<this>");
        return Instant.Companion.fromEpochMilliseconds(Uuidv7Kt.getUnixTimeStamp($this$instant));
    }

    @ExperimentalTime
    public static /* synthetic */ void getInstant$annotations(Uuid uuid) {
    }
}

