/*
 * Decompiled with CFR 0.152.
 */
package app.softwork.uuid;

import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.uuid.Uuid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\u001a4\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\u0004\u001a\u0012\u0010\u0018\u001a\u00020\u0015*\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001a\u001a\n\u0010\u001b\u001a\u00020\u0001*\u00020\u001a\u001a\f\u0010\u001c\u001a\u0004\u0018\u00010\u0001*\u00020\u001a\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\"\u0015\u0010\u0007\u001a\u00020\u0004*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u001e\u0010\u0003\u001a\u00020\u0004*\u00020\u00018FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\r\"\u0015\u0010\u0011\u001a\u00020\u0004*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\r\"\u0015\u0010\t\u001a\u00020\u0004*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\r\"\u0015\u0010\u0014\u001a\u00020\u0015*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016\"\u0015\u0010\b\u001a\u00020\u0006*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000b\"\u0015\u0010\u001d\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"from", "Lkotlin/uuid/Uuid;", "Lkotlin/uuid/Uuid$Companion;", "versionNumber", "", "timeStamp", "", "clockSequence", "node", "variant", "getTimeStamp", "(Lkotlin/uuid/Uuid;)J", "getClockSequence", "(Lkotlin/uuid/Uuid;)I", "getVersionNumber$annotations", "(Lkotlin/uuid/Uuid;)V", "getVersionNumber", "version", "getVersion", "getVariant", "isRfcVariant", "", "(Lkotlin/uuid/Uuid;)Z", "getNode", "isValidUuidString", "spec", "", "toUuid", "toUuidOrNull", "MAX", "getMAX", "(Lkotlin/uuid/Uuid$Companion;)Lkotlin/uuid/Uuid;", "kotlinx-uuid-core"})
@SourceDebugExtension(value={"SMAP\nUuid.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Uuid.kt\napp/softwork/uuid/UuidKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n1#2:117\n*E\n"})
public final class UuidKt {
    @NotNull
    public static final Uuid from(@NotNull Uuid.Companion $this$from, int versionNumber, long timeStamp, int clockSequence, long node, int variant) {
        Intrinsics.checkNotNullParameter((Object)$this$from, (String)"<this>");
        if (!(0 <= versionNumber ? versionNumber < 16 : false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(0 <= variant ? variant < 8 : false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(0L <= timeStamp ? timeStamp < 0x1000000000000000L : false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(0L <= node ? node < 0x1000000000000L : false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(0 <= clockSequence ? clockSequence < 8192 : false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        long timeStampAndVersionRaw = timeStamp << 32 | (timeStamp & 0xFFFF00000000L) >> 16 | timeStamp >> 48 | (long)versionNumber << 12;
        long clockSequenceVariantAndNodeRaw = (long)clockSequence << 48 | (long)variant << 61 | node;
        return $this$from.fromLongs(timeStampAndVersionRaw, clockSequenceVariantAndNodeRaw);
    }

    public static /* synthetic */ Uuid from$default(Uuid.Companion companion, int n, long l, int n2, long l2, int n3, int n4, Object object) {
        if ((n4 & 0x10) != 0) {
            n3 = 5;
        }
        return UuidKt.from(companion, n, l, n2, l2, n3);
    }

    public static final long getTimeStamp(@NotNull Uuid $this$timeStamp) {
        Intrinsics.checkNotNullParameter((Object)$this$timeStamp, (String)"<this>");
        Uuid uuid = $this$timeStamp;
        long l = uuid.getMostSignificantBits();
        uuid.getLeastSignificantBits();
        long timeStampAndVersionRaw = l;
        boolean bl = false;
        return timeStampAndVersionRaw >>> 32 | (timeStampAndVersionRaw & 0xFFFF0000L) << 16 | (timeStampAndVersionRaw & 0xFFFL) << 48;
    }

    public static final int getClockSequence(@NotNull Uuid $this$clockSequence) {
        Intrinsics.checkNotNullParameter((Object)$this$clockSequence, (String)"<this>");
        Uuid uuid = $this$clockSequence;
        uuid.getMostSignificantBits();
        long clockSequenceVariantAndNodeRaw = uuid.getLeastSignificantBits();
        boolean bl = false;
        return (int)(clockSequenceVariantAndNodeRaw >> 48 & 0x1FFFL);
    }

    public static final int getVersionNumber(@NotNull Uuid $this$versionNumber) {
        Intrinsics.checkNotNullParameter((Object)$this$versionNumber, (String)"<this>");
        return UuidKt.getVersion($this$versionNumber);
    }

    @Deprecated(message="Use version instead", replaceWith=@ReplaceWith(expression="version", imports={}))
    public static /* synthetic */ void getVersionNumber$annotations(Uuid uuid) {
    }

    public static final int getVersion(@NotNull Uuid $this$version) {
        Intrinsics.checkNotNullParameter((Object)$this$version, (String)"<this>");
        Uuid uuid = $this$version;
        long l = uuid.getMostSignificantBits();
        uuid.getLeastSignificantBits();
        long timeStampAndVersionRaw = l;
        boolean bl = false;
        return (int)((timeStampAndVersionRaw & 0xF000L) >> 12);
    }

    public static final int getVariant(@NotNull Uuid $this$variant) {
        Intrinsics.checkNotNullParameter((Object)$this$variant, (String)"<this>");
        Uuid uuid = $this$variant;
        uuid.getMostSignificantBits();
        long clockSequenceVariantAndNodeRaw = uuid.getLeastSignificantBits();
        boolean bl = false;
        return (int)(clockSequenceVariantAndNodeRaw >>> 61);
    }

    public static final boolean isRfcVariant(@NotNull Uuid $this$isRfcVariant) {
        Intrinsics.checkNotNullParameter((Object)$this$isRfcVariant, (String)"<this>");
        return UuidKt.getVariant($this$isRfcVariant) == 4 || UuidKt.getVariant($this$isRfcVariant) == 5;
    }

    public static final long getNode(@NotNull Uuid $this$node) {
        Intrinsics.checkNotNullParameter((Object)$this$node, (String)"<this>");
        Uuid uuid = $this$node;
        uuid.getMostSignificantBits();
        long clockSequenceVariantAndNodeRaw = uuid.getLeastSignificantBits();
        boolean bl = false;
        return clockSequenceVariantAndNodeRaw & 0xFFFFFFFFFFFFL;
    }

    public static final boolean isValidUuidString(@NotNull Uuid.Companion $this$isValidUuidString, @NotNull String spec) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isValidUuidString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        try {
            $this$isValidUuidString.parse(spec);
            bl = true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public static final Uuid toUuid(@NotNull String $this$toUuid) {
        Intrinsics.checkNotNullParameter((Object)$this$toUuid, (String)"<this>");
        return Uuid.Companion.parse($this$toUuid);
    }

    @Nullable
    public static final Uuid toUuidOrNull(@NotNull String $this$toUuidOrNull) {
        Uuid uuid;
        Intrinsics.checkNotNullParameter((Object)$this$toUuidOrNull, (String)"<this>");
        try {
            uuid = Uuid.Companion.parse($this$toUuidOrNull);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            uuid = null;
        }
        return uuid;
    }

    @NotNull
    public static final Uuid getMAX(@NotNull Uuid.Companion $this$MAX) {
        Intrinsics.checkNotNullParameter((Object)$this$MAX, (String)"<this>");
        return $this$MAX.fromLongs(-1L, -1L);
    }
}

