/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jewel.window.utils.macos;

import androidx.compose.runtime.internal.StabilityInferred;
import com.sun.jna.Pointer;
import java.awt.Component;
import java.awt.Window;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jewel.window.utils.UnsafeAccessing;
import org.jetbrains.jewel.window.utils.UnsafeAccessingKt;
import org.jetbrains.jewel.window.utils.macos.Foundation;
import org.jetbrains.jewel.window.utils.macos.ID;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nR\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/jewel/window/utils/macos/MacUtil;", "", "<init>", "()V", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "getWindowFromJavaWindow", "Lorg/jetbrains/jewel/window/utils/macos/ID;", "w", "Ljava/awt/Window;", "getPlatformWindow", "updateColors", "", "updateFullScreenButtons", "intellij.platform.jewel.decoratedWindow"})
@StabilityInferred(parameters=0)
public final class MacUtil {
    @NotNull
    public static final MacUtil INSTANCE = new MacUtil();
    private static final Logger logger = Logger.getLogger(MacUtil.class.getSimpleName());
    public static final int $stable;

    private MacUtil() {
    }

    @NotNull
    public final ID getWindowFromJavaWindow(@Nullable Window w) {
        if (w == null) {
            return ID.NIL;
        }
        try {
            Object cPlatformWindow = this.getPlatformWindow(w);
            if (cPlatformWindow != null) {
                Field ptr = cPlatformWindow.getClass().getSuperclass().getDeclaredField("ptr");
                ptr.setAccessible(true);
                return new ID(ptr.getLong(cPlatformWindow));
            }
        }
        catch (IllegalAccessException e) {
            logger.log(Level.WARNING, "Fail to get cPlatformWindow from awt window.", e);
        }
        catch (NoSuchFieldException e) {
            logger.log(Level.WARNING, "Fail to get cPlatformWindow from awt window.", e);
        }
        return ID.NIL;
    }

    @Nullable
    public final Object getPlatformWindow(@NotNull Window w) {
        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
        try {
            Class<?> cWindowPeerClass;
            Method getPlatformWindowMethod;
            Object cPlatformWindow;
            Class<?> awtAccessor = Class.forName("sun.awt.AWTAccessor");
            Object componentAccessor = awtAccessor.getMethod("getComponentAccessor", new Class[0]).invoke(null, new Object[0]);
            Class[] classArray = new Class[]{Component.class};
            Method getPeer = (Method)UnsafeAccessingKt.accessible((AccessibleObject)componentAccessor.getClass().getMethod("getPeer", classArray));
            Object[] objectArray = new Object[]{w};
            Object peer = getPeer.invoke(componentAccessor, objectArray);
            if (peer != null && (cPlatformWindow = (getPlatformWindowMethod = (cWindowPeerClass = peer.getClass()).getDeclaredMethod("getPlatformWindow", new Class[0])).invoke(peer, new Object[0])) != null) {
                return cPlatformWindow;
            }
        }
        catch (NoSuchMethodException e) {
            logger.log(Level.WARNING, "Fail to get cPlatformWindow from awt window.", e);
        }
        catch (IllegalAccessException e) {
            logger.log(Level.WARNING, "Fail to get cPlatformWindow from awt window.", e);
        }
        catch (InvocationTargetException e) {
            logger.log(Level.WARNING, "Fail to get cPlatformWindow from awt window.", e);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.WARNING, "Fail to get cPlatformWindow from awt window.", e);
        }
        return null;
    }

    public final void updateColors(@NotNull Window w) {
        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
        SwingUtilities.invokeLater(() -> MacUtil.updateColors$lambda$0(w));
    }

    public final void updateFullScreenButtons(@NotNull Window w) {
        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
        SwingUtilities.invokeLater(() -> MacUtil.updateFullScreenButtons$lambda$1(w));
    }

    private static final void updateColors$lambda$0(Window $w) {
        ID window = INSTANCE.getWindowFromJavaWindow($w);
        ID delegate = Foundation.INSTANCE.invoke(window, "delegate", new Object[0]);
        Object[] objectArray = new Object[]{Foundation.INSTANCE.createSelector("updateColors")};
        if (Foundation.INSTANCE.invoke(delegate, "respondsToSelector:", objectArray).booleanValue()) {
            Foundation.INSTANCE.invoke(delegate, "updateColors", new Object[0]);
        }
    }

    private static final void updateFullScreenButtons$lambda$1(Window $w) {
        Pointer selector = Foundation.INSTANCE.createSelector("updateFullScreenButtons");
        ID window = INSTANCE.getWindowFromJavaWindow($w);
        ID delegate = Foundation.INSTANCE.invoke(window, "delegate", new Object[0]);
        Object[] objectArray = new Object[]{selector};
        if (Foundation.INSTANCE.invoke(delegate, "respondsToSelector:", objectArray).booleanValue()) {
            Foundation.INSTANCE.invoke(delegate, "updateFullScreenButtons", new Object[0]);
        }
    }

    static {
        try {
            Object[] objectArray = new String[]{"sun.awt", "sun.lwawt", "sun.lwawt.macosx"};
            UnsafeAccessing.INSTANCE.assignAccessibility(UnsafeAccessing.INSTANCE.getDesktopModule(), CollectionsKt.listOf((Object[])objectArray));
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Assign access for jdk.desktop failed.", e);
        }
        $stable = 8;
    }
}

