/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jewel.window.utils.macos;

import androidx.compose.runtime.internal.StabilityInferred;
import com.sun.jna.Function;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jewel.window.utils.JnaLoader;
import org.jetbrains.jewel.window.utils.macos.FoundationLibrary;
import org.jetbrains.jewel.window.utils.macos.ID;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u000e\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\u0015J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0015J;\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00132\b\u0010\u001e\u001a\u0004\u0018\u00010\u00192\u0010\u0010\u001f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u001cH\u0002\u00a2\u0006\u0002\u0010 J:\u0010!\u001a\u00020\u00132\b\u0010\u001d\u001a\u0004\u0018\u00010\u00132\b\u0010\u001e\u001a\u0004\u0018\u00010\u00192\u0016\u0010\u001f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u001c\"\u0004\u0018\u00010\u0001H\u0086\u0002\u00a2\u0006\u0002\u0010\"J7\u0010#\u001a\u00020\u00132\b\u0010\u001d\u001a\u0004\u0018\u00010\u00132\b\u0010\u001e\u001a\u0004\u0018\u00010\u00192\u0016\u0010\u001f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u001c\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\"J:\u0010!\u001a\u00020\u00132\b\u0010$\u001a\u0004\u0018\u00010\u00152\b\u0010\u001e\u001a\u0004\u0018\u00010\u00152\u0016\u0010\u001f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u001c\"\u0004\u0018\u00010\u0001H\u0086\u0002\u00a2\u0006\u0002\u0010%J7\u0010#\u001a\u00020\u00132\b\u0010$\u001a\u0004\u0018\u00010\u00152\b\u0010\u001e\u001a\u0004\u0018\u00010\u00152\u0016\u0010\u001f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u001c\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010%J7\u0010&\u001a\u00020\u00132\b\u0010'\u001a\u0004\u0018\u00010\u00152\b\u0010(\u001a\u0004\u0018\u00010\u00152\u0016\u0010\u001f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u001c\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010%J:\u0010!\u001a\u00020\u00132\b\u0010\u001d\u001a\u0004\u0018\u00010\u00132\b\u0010\u001e\u001a\u0004\u0018\u00010\u00152\u0016\u0010\u001f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u001c\"\u0004\u0018\u00010\u0001H\u0086\u0002\u00a2\u0006\u0002\u0010)R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0007\u001a\u0004\u0018\u00010\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001d\u0010\r\u001a\u0004\u0018\u00010\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\f\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006*"}, d2={"Lorg/jetbrains/jewel/window/utils/macos/Foundation;", "", "<init>", "()V", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "myFoundationLibrary", "Lorg/jetbrains/jewel/window/utils/macos/FoundationLibrary;", "getMyFoundationLibrary", "()Lorg/jetbrains/jewel/window/utils/macos/FoundationLibrary;", "myFoundationLibrary$delegate", "Lkotlin/Lazy;", "myObjcMsgSend", "Lcom/sun/jna/Function;", "getMyObjcMsgSend", "()Lcom/sun/jna/Function;", "myObjcMsgSend$delegate", "getObjcClass", "Lorg/jetbrains/jewel/window/utils/macos/ID;", "className", "", "getProtocol", "name", "createSelector", "Lcom/sun/jna/Pointer;", "s", "prepInvoke", "", "id", "selector", "args", "(Lorg/jetbrains/jewel/window/utils/macos/ID;Lcom/sun/jna/Pointer;[Ljava/lang/Object;)[Ljava/lang/Object;", "invoke", "(Lorg/jetbrains/jewel/window/utils/macos/ID;Lcom/sun/jna/Pointer;[Ljava/lang/Object;)Lorg/jetbrains/jewel/window/utils/macos/ID;", "invokeVarArg", "cls", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)Lorg/jetbrains/jewel/window/utils/macos/ID;", "safeInvoke", "stringCls", "stringSelector", "(Lorg/jetbrains/jewel/window/utils/macos/ID;Ljava/lang/String;[Ljava/lang/Object;)Lorg/jetbrains/jewel/window/utils/macos/ID;", "intellij.platform.jewel.decoratedWindow"})
@StabilityInferred(parameters=0)
public final class Foundation {
    @NotNull
    public static final Foundation INSTANCE = new Foundation();
    private static final Logger logger = Logger.getLogger(Foundation.class.getSimpleName());
    @NotNull
    private static final Lazy myFoundationLibrary$delegate;
    @NotNull
    private static final Lazy myObjcMsgSend$delegate;
    public static final int $stable;

    private Foundation() {
    }

    private final FoundationLibrary getMyFoundationLibrary() {
        Lazy lazy = myFoundationLibrary$delegate;
        return (FoundationLibrary)lazy.getValue();
    }

    private final Function getMyObjcMsgSend() {
        Lazy lazy = myObjcMsgSend$delegate;
        return (Function)lazy.getValue();
    }

    @Nullable
    public final ID getObjcClass(@Nullable String className) {
        FoundationLibrary foundationLibrary = this.getMyFoundationLibrary();
        return foundationLibrary != null ? foundationLibrary.objc_getClass(className) : null;
    }

    @Nullable
    public final ID getProtocol(@Nullable String name) {
        FoundationLibrary foundationLibrary = this.getMyFoundationLibrary();
        return foundationLibrary != null ? foundationLibrary.objc_getProtocol(name) : null;
    }

    @Nullable
    public final Pointer createSelector(@Nullable String s) {
        FoundationLibrary foundationLibrary = this.getMyFoundationLibrary();
        return foundationLibrary != null ? foundationLibrary.sel_registerName(s) : null;
    }

    private final Object[] prepInvoke(ID id, Pointer selector, Object[] args) {
        Object[] invokArgs = new Object[args.length + 2];
        invokArgs[0] = id;
        invokArgs[1] = selector;
        System.arraycopy(args, 0, invokArgs, 2, args.length);
        return invokArgs;
    }

    @NotNull
    public final ID invoke(@Nullable ID id, @Nullable Pointer selector, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Function function = this.getMyObjcMsgSend();
        return new ID(function != null ? function.invokeLong(this.prepInvoke(id, selector, args)) : 0L);
    }

    @NotNull
    public final ID invokeVarArg(@Nullable ID id, @Nullable Pointer selector, Object ... args) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Object object = this.getMyFoundationLibrary();
        if (object == null || (object = object.objc_msgSend(id, selector, args[0], Arrays.copyOf(objectArray = Arrays.copyOfRange(args, 1, args.length), objectArray.length))) == null) {
            object = ID.NIL;
        }
        return object;
    }

    @NotNull
    public final ID invoke(@Nullable String cls, @Nullable String selector, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return this.invoke(this.getObjcClass(cls), this.createSelector(selector), Arrays.copyOf(args, args.length));
    }

    @NotNull
    public final ID invokeVarArg(@Nullable String cls, @Nullable String selector, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return this.invokeVarArg(this.getObjcClass(cls), this.createSelector(selector), Arrays.copyOf(args, args.length));
    }

    @NotNull
    public final ID safeInvoke(@Nullable String stringCls, @Nullable String stringSelector, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        ID cls = this.getObjcClass(stringCls);
        Pointer selector = this.createSelector(stringSelector);
        Object[] objectArray = new Object[]{selector};
        if (!this.invoke(cls, "respondsToSelector:", objectArray).booleanValue()) {
            throw new IllegalStateException(("Missing selector " + stringSelector + " for " + stringCls).toString());
        }
        return this.invoke(cls, selector, Arrays.copyOf(args, args.length));
    }

    @NotNull
    public final ID invoke(@Nullable ID id, @Nullable String selector, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return this.invoke(id, this.createSelector(selector), Arrays.copyOf(args, args.length));
    }

    private static final FoundationLibrary myFoundationLibrary_delegate$lambda$0() {
        FoundationLibrary foundationLibrary;
        try {
            foundationLibrary = (FoundationLibrary)Native.load((String)"Foundation", FoundationLibrary.class, Collections.singletonMap("jna.encoding", "UTF8"));
        }
        catch (Throwable throwable) {
            foundationLibrary = null;
        }
        return foundationLibrary;
    }

    private static final Function myObjcMsgSend_delegate$lambda$1() {
        Function function;
        try {
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(INSTANCE.getMyFoundationLibrary());
            Intrinsics.checkNotNull((Object)invocationHandler, (String)"null cannot be cast to non-null type com.sun.jna.Library.Handler");
            function = ((Library.Handler)invocationHandler).getNativeLibrary().getFunction("objc_msgSend");
        }
        catch (Throwable throwable) {
            function = null;
        }
        return function;
    }

    static {
        if (!JnaLoader.INSTANCE.isLoaded()) {
            logger.log(Level.WARNING, "JNA is not loaded");
        }
        myFoundationLibrary$delegate = LazyKt.lazy(Foundation::myFoundationLibrary_delegate$lambda$0);
        myObjcMsgSend$delegate = LazyKt.lazy(Foundation::myObjcMsgSend_delegate$lambda$1);
        $stable = 8;
    }
}

