/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.base.operations;

import dev.whyoleg.cryptography.CryptographyProviderApi;
import dev.whyoleg.cryptography.providers.base.BytesKt;
import dev.whyoleg.cryptography.providers.base.operations.CipherFunction;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Buffer;
import kotlinx.io.RawSink;
import kotlinx.io.RawSource;
import kotlinx.io.Segment;
import kotlinx.io.SegmentKt;
import kotlinx.io.Sink;
import kotlinx.io.unsafe.UnsafeBufferOperations;
import org.jetbrains.annotations.NotNull;

@CryptographyProviderApi
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0012\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u00012\u00060\u0002j\u0002`\u0003:\u0002)*B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H$J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0014J$\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u00072\b\b\u0002\u0010\u0013\u001a\u00020\u0007H\u0014J6\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00102\b\b\u0002\u0010\u0016\u001a\u00020\u00072\b\b\u0002\u0010\u0012\u001a\u00020\u00072\b\b\u0002\u0010\u0013\u001a\u00020\u0007H$J\b\u0010\u0017\u001a\u00020\u0010H\u0014J\u001a\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00102\b\b\u0002\u0010\u0016\u001a\u00020\u0007H$J$\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u00072\b\b\u0002\u0010\u0013\u001a\u00020\u0007H\u0014J6\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00102\b\b\u0002\u0010\u0016\u001a\u00020\u00072\b\b\u0002\u0010\u0012\u001a\u00020\u00072\b\b\u0002\u0010\u0013\u001a\u00020\u0007H\u0014J \u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0016J \u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010$\u001a\u00020#H\u0002R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006+"}, d2={"Ldev/whyoleg/cryptography/providers/base/operations/BaseCipherFunction;", "Ldev/whyoleg/cryptography/providers/base/operations/CipherFunction;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "<init>", "()V", "blockSize", "", "getBlockSize", "()I", "maxOutputSize", "inputSize", "maxInputSize", "initialMaxInputSize", "expectedMaxOutputSize", "transformToByteArray", "", "source", "startIndex", "endIndex", "transformIntoByteArray", "destination", "destinationOffset", "finalizeToByteArray", "finalizeIntoByteArray", "transformAndFinalizeToByteArray", "transformAndFinalizeIntoByteArray", "transform", "transformedSource", "Lkotlinx/io/RawSource;", "transformedSink", "Lkotlinx/io/RawSink;", "sink", "transformTo", "inputBuffer", "Lkotlinx/io/Buffer;", "outputBuffer", "maxInputCount", "", "finalizeTo", "", "TransformedSource", "TransformedSink", "cryptography-provider-base"})
@SourceDebugExtension(value={"SMAP\nBaseCipherFunction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseCipherFunction.kt\ndev/whyoleg/cryptography/providers/base/operations/BaseCipherFunction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 UnsafeBufferOperations.kt\nkotlinx/io/unsafe/UnsafeBufferOperations\n*L\n1#1,268:1\n1#2:269\n1#2:271\n99#3:270\n100#3,2:272\n195#3,28:274\n102#3,6:302\n195#3,28:308\n*S KotlinDebug\n*F\n+ 1 BaseCipherFunction.kt\ndev/whyoleg/cryptography/providers/base/operations/BaseCipherFunction\n*L\n110#1:271\n110#1:270\n110#1:272,2\n132#1:274,28\n110#1:302,6\n153#1:308,28\n*E\n"})
public abstract class BaseCipherFunction
implements CipherFunction,
AutoCloseable {
    protected abstract int getBlockSize();

    protected abstract int maxOutputSize(int var1);

    protected int maxInputSize(int initialMaxInputSize, int expectedMaxOutputSize) {
        if (!(initialMaxInputSize >= 0)) {
            boolean $i$a$-check-BaseCipherFunction$maxInputSize$32 = false;
            String $i$a$-check-BaseCipherFunction$maxInputSize$32 = "initialMaxInputSize must be >= 0, but was " + initialMaxInputSize;
            throw new IllegalStateException($i$a$-check-BaseCipherFunction$maxInputSize$32.toString());
        }
        if (!(expectedMaxOutputSize >= 0)) {
            boolean $i$a$-check-BaseCipherFunction$maxInputSize$42 = false;
            String $i$a$-check-BaseCipherFunction$maxInputSize$42 = "expectedMaxOutputSize must be >= 0, but was " + expectedMaxOutputSize;
            throw new IllegalStateException($i$a$-check-BaseCipherFunction$maxInputSize$42.toString());
        }
        if (this.maxOutputSize(initialMaxInputSize) <= expectedMaxOutputSize) {
            return initialMaxInputSize;
        }
        if (this.maxOutputSize(0) > expectedMaxOutputSize) {
            return -1;
        }
        int stepSize = this.getBlockSize() != 0 ? this.getBlockSize() : 16;
        for (int inputSize = initialMaxInputSize - stepSize; inputSize > 0; inputSize -= stepSize) {
            int outputSize = this.maxOutputSize(inputSize);
            if (outputSize > expectedMaxOutputSize) continue;
            return inputSize;
        }
        return -1;
    }

    @NotNull
    protected byte[] transformToByteArray(@NotNull byte[] source, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        int maxOutputSize = this.maxOutputSize(endIndex - startIndex);
        byte[] output = new byte[maxOutputSize];
        int outputSize = this.transformIntoByteArray(source, output, 0, startIndex, endIndex);
        return BytesKt.ensureSizeExactly(output, outputSize);
    }

    public static /* synthetic */ byte[] transformToByteArray$default(BaseCipherFunction baseCipherFunction, byte[] byArray, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: transformToByteArray");
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        return baseCipherFunction.transformToByteArray(byArray, n, n2);
    }

    protected abstract int transformIntoByteArray(@NotNull byte[] var1, @NotNull byte[] var2, int var3, int var4, int var5);

    public static /* synthetic */ int transformIntoByteArray$default(BaseCipherFunction baseCipherFunction, byte[] byArray, byte[] byArray2, int n, int n2, int n3, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: transformIntoByteArray");
        }
        if ((n4 & 4) != 0) {
            n = 0;
        }
        if ((n4 & 8) != 0) {
            n2 = 0;
        }
        if ((n4 & 0x10) != 0) {
            n3 = byArray.length;
        }
        return baseCipherFunction.transformIntoByteArray(byArray, byArray2, n, n2, n3);
    }

    @NotNull
    protected byte[] finalizeToByteArray() {
        int maxOutputSize = this.maxOutputSize(0);
        byte[] output = new byte[maxOutputSize];
        int outputSize = BaseCipherFunction.finalizeIntoByteArray$default(this, output, 0, 2, null);
        return BytesKt.ensureSizeExactly(output, outputSize);
    }

    protected abstract int finalizeIntoByteArray(@NotNull byte[] var1, int var2);

    public static /* synthetic */ int finalizeIntoByteArray$default(BaseCipherFunction baseCipherFunction, byte[] byArray, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: finalizeIntoByteArray");
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return baseCipherFunction.finalizeIntoByteArray(byArray, n);
    }

    @NotNull
    protected byte[] transformAndFinalizeToByteArray(@NotNull byte[] source, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        int maxOutputSize = this.maxOutputSize(endIndex - startIndex);
        byte[] output = new byte[maxOutputSize];
        int outputSize = this.transformAndFinalizeIntoByteArray(source, output, 0, startIndex, endIndex);
        return BytesKt.ensureSizeExactly(output, outputSize);
    }

    public static /* synthetic */ byte[] transformAndFinalizeToByteArray$default(BaseCipherFunction baseCipherFunction, byte[] byArray, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: transformAndFinalizeToByteArray");
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        return baseCipherFunction.transformAndFinalizeToByteArray(byArray, n, n2);
    }

    protected int transformAndFinalizeIntoByteArray(@NotNull byte[] source, @NotNull byte[] destination, int destinationOffset, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        BytesKt.checkBounds(source.length, startIndex, endIndex);
        BytesKt.checkBounds(destination.length, destinationOffset, destinationOffset + this.maxOutputSize(endIndex - startIndex));
        int transformedToDestination = this.transformIntoByteArray(source, destination, destinationOffset, startIndex, endIndex);
        int finalizedToDestination = this.finalizeIntoByteArray(destination, destinationOffset + transformedToDestination);
        return transformedToDestination + finalizedToDestination;
    }

    public static /* synthetic */ int transformAndFinalizeIntoByteArray$default(BaseCipherFunction baseCipherFunction, byte[] byArray, byte[] byArray2, int n, int n2, int n3, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: transformAndFinalizeIntoByteArray");
        }
        if ((n4 & 4) != 0) {
            n = 0;
        }
        if ((n4 & 8) != 0) {
            n2 = 0;
        }
        if ((n4 & 0x10) != 0) {
            n3 = byArray.length;
        }
        return baseCipherFunction.transformAndFinalizeIntoByteArray(byArray, byArray2, n, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public byte[] transform(@NotNull byte[] source, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        AutoCloseable autoCloseable = this;
        Throwable throwable = null;
        try {
            BaseCipherFunction it = (BaseCipherFunction)autoCloseable;
            boolean bl = false;
            byte[] byArray = this.transformAndFinalizeToByteArray(source, startIndex, endIndex);
            return byArray;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    @NotNull
    public RawSource transformedSource(@NotNull RawSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return new TransformedSource(source);
    }

    @Override
    @NotNull
    public RawSink transformedSink(@NotNull RawSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        return new TransformedSink(sink);
    }

    /*
     * WARNING - void declaration
     */
    private final int transformTo(Buffer inputBuffer, Buffer outputBuffer, long maxInputCount) {
        int n;
        void inputStartIndex;
        void inputEndIndex;
        UnsafeBufferOperations unsafeBufferOperations = UnsafeBufferOperations.INSTANCE;
        Buffer buffer$iv = inputBuffer;
        boolean $i$f$readFromHead = false;
        if (!(!buffer$iv.exhausted())) {
            boolean $i$a$-require-UnsafeBufferOperations$readFromHead$1$iv22 = false;
            String $i$a$-require-UnsafeBufferOperations$readFromHead$1$iv22 = "Buffer is empty";
            throw new IllegalArgumentException($i$a$-require-UnsafeBufferOperations$readFromHead$1$iv22.toString());
        }
        Segment segment = buffer$iv.getHead();
        Intrinsics.checkNotNull((Object)segment);
        Segment head$iv = segment;
        int n2 = head$iv.getLimit();
        int n3 = head$iv.getPos();
        byte[] input = head$iv.dataAsByteArray(true);
        boolean bl = false;
        int maxInputSize = (int)Math.min(maxInputCount, (long)(inputEndIndex - inputStartIndex));
        int maxOutputSize = this.maxOutputSize(maxInputSize);
        int inputSize = 0;
        int outputSize = 0;
        if (maxOutputSize == -1) {
            outputSize = -1;
            inputSize = -1;
        } else if (maxOutputSize <= UnsafeBufferOperations.INSTANCE.getMaxSafeWriteCapacity()) {
            outputSize = maxOutputSize;
            inputSize = maxInputSize;
        } else {
            outputSize = UnsafeBufferOperations.INSTANCE.getMaxSafeWriteCapacity();
            inputSize = this.maxInputSize(maxInputSize, outputSize);
        }
        if (inputSize == -1 || outputSize == -1 || outputSize == 0) {
            Sink.write$default((Sink)((Sink)outputBuffer), (byte[])this.transformToByteArray(input, (int)inputStartIndex, (int)(inputStartIndex + maxInputSize)), (int)0, (int)0, (int)6, null);
            n = maxInputSize;
        } else {
            void outputStartIndex;
            void buffer$iv2;
            UnsafeBufferOperations unsafeBufferOperations2 = UnsafeBufferOperations.INSTANCE;
            Buffer buffer = outputBuffer;
            int minimumCapacity$iv = outputSize;
            boolean $i$f$writeToTail = false;
            Segment tail$iv = buffer$iv2.writableSegment(minimumCapacity$iv);
            byte[] data$iv = tail$iv.dataAsByteArray(false);
            int cfr_ignored_0 = data$iv.length;
            int n4 = tail$iv.getLimit();
            byte[] output = data$iv;
            boolean bl2 = false;
            int bytesWritten$iv = this.transformIntoByteArray(input, output, (int)outputStartIndex, (int)inputStartIndex, (int)(inputStartIndex + inputSize));
            if (bytesWritten$iv == minimumCapacity$iv) {
                tail$iv.writeBackData(data$iv, bytesWritten$iv);
                tail$iv.setLimit(tail$iv.getLimit() + bytesWritten$iv);
                buffer$iv2.setSizeMut(buffer$iv2.getSizeMut() + (long)bytesWritten$iv);
            } else {
                if (!(0 <= bytesWritten$iv ? bytesWritten$iv <= tail$iv.getRemainingCapacity() : false)) {
                    boolean bl3 = false;
                    String string = "Invalid number of bytes written: " + bytesWritten$iv + ". Should be in 0.." + tail$iv.getRemainingCapacity();
                    throw new IllegalStateException(string.toString());
                }
                if (bytesWritten$iv != 0) {
                    tail$iv.writeBackData(data$iv, bytesWritten$iv);
                    tail$iv.setLimit(tail$iv.getLimit() + bytesWritten$iv);
                    buffer$iv2.setSizeMut(buffer$iv2.getSizeMut() + (long)bytesWritten$iv);
                } else if (SegmentKt.isEmpty((Segment)tail$iv)) {
                    buffer$iv2.recycleTail();
                }
            }
            n = inputSize;
        }
        int bytesRead$iv = n;
        if (bytesRead$iv != 0) {
            if (bytesRead$iv < 0) {
                throw new IllegalStateException("Returned negative read bytes count");
            }
            if (bytesRead$iv > head$iv.getSize()) {
                throw new IllegalStateException("Returned too many bytes");
            }
            buffer$iv.skip((long)bytesRead$iv);
        }
        return bytesRead$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final void finalizeTo(Buffer outputBuffer) {
        int maxOutputSize = this.maxOutputSize(0);
        if (maxOutputSize == 0) {
            return;
        }
        if (maxOutputSize == -1 || maxOutputSize > UnsafeBufferOperations.INSTANCE.getMaxSafeWriteCapacity()) {
            Sink.write$default((Sink)((Sink)outputBuffer), (byte[])this.finalizeToByteArray(), (int)0, (int)0, (int)6, null);
        } else {
            int n;
            void outputStartIndex;
            void buffer$iv;
            UnsafeBufferOperations unsafeBufferOperations = UnsafeBufferOperations.INSTANCE;
            Buffer buffer = outputBuffer;
            int minimumCapacity$iv = maxOutputSize;
            boolean $i$f$writeToTail = false;
            Segment tail$iv = buffer$iv.writableSegment(minimumCapacity$iv);
            byte[] data$iv = tail$iv.dataAsByteArray(false);
            int cfr_ignored_0 = data$iv.length;
            int n2 = tail$iv.getLimit();
            byte[] output = data$iv;
            boolean bl = false;
            int bytesWritten$iv = this.finalizeIntoByteArray(output, (int)outputStartIndex);
            if (bytesWritten$iv == minimumCapacity$iv) {
                tail$iv.writeBackData(data$iv, bytesWritten$iv);
                tail$iv.setLimit(tail$iv.getLimit() + bytesWritten$iv);
                buffer$iv.setSizeMut(buffer$iv.getSizeMut() + (long)bytesWritten$iv);
                n = bytesWritten$iv;
            } else {
                if (!(0 <= bytesWritten$iv ? bytesWritten$iv <= tail$iv.getRemainingCapacity() : false)) {
                    boolean bl2 = false;
                    String string = "Invalid number of bytes written: " + bytesWritten$iv + ". Should be in 0.." + tail$iv.getRemainingCapacity();
                    throw new IllegalStateException(string.toString());
                }
                if (bytesWritten$iv != 0) {
                    tail$iv.writeBackData(data$iv, bytesWritten$iv);
                    tail$iv.setLimit(tail$iv.getLimit() + bytesWritten$iv);
                    buffer$iv.setSizeMut(buffer$iv.getSizeMut() + (long)bytesWritten$iv);
                    n = bytesWritten$iv;
                } else {
                    if (SegmentKt.isEmpty((Segment)tail$iv)) {
                        buffer$iv.recycleTail();
                    }
                    n = bytesWritten$iv;
                }
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\nH\u0016J\b\u0010\u000f\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ldev/whyoleg/cryptography/providers/base/operations/BaseCipherFunction$TransformedSink;", "Lkotlinx/io/RawSink;", "sink", "<init>", "(Ldev/whyoleg/cryptography/providers/base/operations/BaseCipherFunction;Lkotlinx/io/RawSink;)V", "isClosed", "", "outputBuffer", "Lkotlinx/io/Buffer;", "write", "", "source", "byteCount", "", "flush", "close", "cryptography-provider-base"})
    @SourceDebugExtension(value={"SMAP\nBaseCipherFunction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseCipherFunction.kt\ndev/whyoleg/cryptography/providers/base/operations/BaseCipherFunction$TransformedSink\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,268:1\n1#2:269\n*E\n"})
    private final class TransformedSink
    implements RawSink {
        @NotNull
        private final RawSink sink;
        private boolean isClosed;
        @NotNull
        private final Buffer outputBuffer;

        public TransformedSink(RawSink sink) {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            this.sink = sink;
            this.outputBuffer = new Buffer();
        }

        public void write(@NotNull Buffer source, long byteCount) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            if (!(byteCount >= 0L)) {
                boolean $i$a$-require-BaseCipherFunction$TransformedSink$write$22 = false;
                String $i$a$-require-BaseCipherFunction$TransformedSink$write$22 = "byteCount[" + byteCount + "] < 0";
                throw new IllegalArgumentException($i$a$-require-BaseCipherFunction$TransformedSink$write$22.toString());
            }
            if (!(!this.isClosed)) {
                boolean bl = false;
                String string = "Already closed";
                throw new IllegalStateException(string.toString());
            }
            for (long remaining = byteCount; remaining > 0L; remaining -= (long)BaseCipherFunction.this.transformTo(source, this.outputBuffer, remaining)) {
            }
            this.outputBuffer.transferTo(this.sink);
        }

        public void flush() {
            this.sink.flush();
        }

        public void close() {
            Throwable throwable;
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            try {
                BaseCipherFunction.this.finalizeTo(this.outputBuffer);
                this.outputBuffer.transferTo(this.sink);
                throwable = null;
            }
            catch (Throwable cause) {
                throwable = cause;
            }
            Throwable thrown = throwable;
            this.outputBuffer.clear();
            try {
                this.sink.close();
            }
            catch (Throwable cause) {
                if (thrown == null) {
                    thrown = cause;
                }
                ExceptionsKt.addSuppressed((Throwable)thrown, (Throwable)cause);
            }
            try {
                BaseCipherFunction.this.close();
            }
            catch (Throwable cause) {
                if (thrown == null) {
                    thrown = cause;
                }
                ExceptionsKt.addSuppressed((Throwable)thrown, (Throwable)cause);
            }
            Throwable throwable2 = thrown;
            if (throwable2 != null) {
                throw throwable2;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\fH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ldev/whyoleg/cryptography/providers/base/operations/BaseCipherFunction$TransformedSource;", "Lkotlinx/io/RawSource;", "source", "<init>", "(Ldev/whyoleg/cryptography/providers/base/operations/BaseCipherFunction;Lkotlinx/io/RawSource;)V", "isFinalized", "", "isClosed", "inputBuffer", "Lkotlinx/io/Buffer;", "outputBuffer", "readAtMostTo", "", "sink", "byteCount", "close", "", "cryptography-provider-base"})
    @SourceDebugExtension(value={"SMAP\nBaseCipherFunction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseCipherFunction.kt\ndev/whyoleg/cryptography/providers/base/operations/BaseCipherFunction$TransformedSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,268:1\n1#2:269\n*E\n"})
    private final class TransformedSource
    implements RawSource {
        @NotNull
        private final RawSource source;
        private boolean isFinalized;
        private boolean isClosed;
        @NotNull
        private final Buffer inputBuffer;
        @NotNull
        private final Buffer outputBuffer;

        public TransformedSource(RawSource source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            this.source = source;
            this.inputBuffer = new Buffer();
            this.outputBuffer = new Buffer();
        }

        public long readAtMostTo(@NotNull Buffer sink, long byteCount) {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            if (!(byteCount >= 0L)) {
                boolean $i$a$-require-BaseCipherFunction$TransformedSource$readAtMostTo$22 = false;
                String $i$a$-require-BaseCipherFunction$TransformedSource$readAtMostTo$22 = "byteCount[" + byteCount + "] < 0";
                throw new IllegalArgumentException($i$a$-require-BaseCipherFunction$TransformedSource$readAtMostTo$22.toString());
            }
            if (!(!this.isClosed)) {
                boolean bl = false;
                String string = "Already closed";
                throw new IllegalStateException(string.toString());
            }
            if (byteCount == 0L) {
                return 0L;
            }
            while (this.outputBuffer.getSize() == 0L && !this.isFinalized) {
                long bytesRead = this.source.readAtMostTo(this.inputBuffer, (long)UnsafeBufferOperations.INSTANCE.getMaxSafeWriteCapacity());
                if (bytesRead == -1L) {
                    this.isFinalized = true;
                    while (this.inputBuffer.getSize() != 0L) {
                        BaseCipherFunction.this.transformTo(this.inputBuffer, this.outputBuffer, Long.MAX_VALUE);
                    }
                    BaseCipherFunction.this.finalizeTo(this.outputBuffer);
                    continue;
                }
                BaseCipherFunction.this.transformTo(this.inputBuffer, this.outputBuffer, Long.MAX_VALUE);
            }
            return this.outputBuffer.readAtMostTo(sink, byteCount);
        }

        public void close() {
            Throwable throwable;
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            this.inputBuffer.clear();
            this.outputBuffer.clear();
            try {
                this.source.close();
                throwable = null;
            }
            catch (Throwable cause) {
                throwable = cause;
            }
            Throwable thrown = throwable;
            try {
                BaseCipherFunction.this.close();
            }
            catch (Throwable cause) {
                if (thrown == null) {
                    thrown = cause;
                }
                ExceptionsKt.addSuppressed((Throwable)thrown, (Throwable)cause);
            }
            Throwable throwable2 = thrown;
            if (throwable2 != null) {
                throw throwable2;
            }
        }
    }
}

