/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.base.operations;

import dev.whyoleg.cryptography.CryptographyProviderApi;
import dev.whyoleg.cryptography.operations.AuthenticatedEncryptor;
import dev.whyoleg.cryptography.providers.base.operations.BaseEncryptor;
import dev.whyoleg.cryptography.providers.base.operations.CipherFunction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.io.RawSink;
import kotlinx.io.RawSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CryptographyProviderApi
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bg\u0018\u00002\u00020\u00012\u00020\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H&J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\u001a\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\n2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000e\u00c0\u0006\u0001"}, d2={"Ldev/whyoleg/cryptography/providers/base/operations/BaseAuthenticatedEncryptor;", "Ldev/whyoleg/cryptography/operations/AuthenticatedEncryptor;", "Ldev/whyoleg/cryptography/providers/base/operations/BaseEncryptor;", "createEncryptFunction", "Ldev/whyoleg/cryptography/providers/base/operations/CipherFunction;", "associatedData", "", "encryptBlocking", "plaintext", "encryptingSource", "Lkotlinx/io/RawSource;", "encryptingSink", "Lkotlinx/io/RawSink;", "ciphertext", "cryptography-provider-base"})
public interface BaseAuthenticatedEncryptor
extends AuthenticatedEncryptor,
BaseEncryptor {
    @NotNull
    public CipherFunction createEncryptFunction(@Nullable byte[] var1);

    @Override
    @NotNull
    default public CipherFunction createEncryptFunction() {
        return this.createEncryptFunction(null);
    }

    @Override
    @NotNull
    default public byte[] encryptBlocking(@NotNull byte[] plaintext) {
        Intrinsics.checkNotNullParameter((Object)plaintext, (String)"plaintext");
        return super.encryptBlocking(plaintext);
    }

    @Override
    @NotNull
    default public RawSource encryptingSource(@NotNull RawSource plaintext) {
        Intrinsics.checkNotNullParameter((Object)plaintext, (String)"plaintext");
        return super.encryptingSource(plaintext);
    }

    @Override
    @NotNull
    default public RawSink encryptingSink(@NotNull RawSink ciphertext) {
        Intrinsics.checkNotNullParameter((Object)ciphertext, (String)"ciphertext");
        return super.encryptingSink(ciphertext);
    }

    @NotNull
    default public byte[] encryptBlocking(@NotNull byte[] plaintext, @Nullable byte[] associatedData) {
        Intrinsics.checkNotNullParameter((Object)plaintext, (String)"plaintext");
        return CipherFunction.transform$default(this.createEncryptFunction(associatedData), plaintext, 0, 0, 6, null);
    }

    @NotNull
    default public RawSource encryptingSource(@NotNull RawSource plaintext, @Nullable byte[] associatedData) {
        Intrinsics.checkNotNullParameter((Object)plaintext, (String)"plaintext");
        return this.createEncryptFunction(associatedData).transformedSource(plaintext);
    }

    @NotNull
    default public RawSink encryptingSink(@NotNull RawSink ciphertext, @Nullable byte[] associatedData) {
        Intrinsics.checkNotNullParameter((Object)ciphertext, (String)"ciphertext");
        return this.createEncryptFunction(associatedData).transformedSink(ciphertext);
    }
}

