/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.base.operations;

import dev.whyoleg.cryptography.CryptographyProviderApi;
import dev.whyoleg.cryptography.providers.base.BytesKt;
import dev.whyoleg.cryptography.providers.base.operations.BaseCipherFunction;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@CryptographyProviderApi
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0012\b\u0007\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0002J \u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0010H\u0014J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0010H\u0014J \u0010\u001a\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0014J0\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0014J\b\u0010\u001e\u001a\u00020\u0004H\u0014J\u0018\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0010H\u0014J \u0010 \u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0014J0\u0010!\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0014R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00108TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\""}, d2={"Ldev/whyoleg/cryptography/providers/base/operations/AccumulatingCipherFunction;", "Ldev/whyoleg/cryptography/providers/base/operations/BaseCipherFunction;", "finalize", "Lkotlin/Function1;", "", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "isClosed", "", "accumulator", "close", "", "ensureNotClosed", "accumulate", "source", "startIndex", "", "endIndex", "blockSize", "getBlockSize", "()I", "maxOutputSize", "inputSize", "maxInputSize", "initialMaxInputSize", "expectedMaxOutputSize", "transformToByteArray", "transformIntoByteArray", "destination", "destinationOffset", "finalizeToByteArray", "finalizeIntoByteArray", "transformAndFinalizeToByteArray", "transformAndFinalizeIntoByteArray", "cryptography-provider-base"})
@SourceDebugExtension(value={"SMAP\nAccumulatingCipherFunction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccumulatingCipherFunction.kt\ndev/whyoleg/cryptography/providers/base/operations/AccumulatingCipherFunction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n1#2:80\n*E\n"})
public final class AccumulatingCipherFunction
extends BaseCipherFunction {
    @NotNull
    private final Function1<byte[], byte[]> finalize;
    private boolean isClosed;
    @NotNull
    private byte[] accumulator;

    public AccumulatingCipherFunction(@NotNull Function1<? super byte[], byte[]> finalize) {
        Intrinsics.checkNotNullParameter(finalize, (String)"finalize");
        this.finalize = finalize;
        this.accumulator = BytesKt.getEmptyByteArray();
    }

    @Override
    public void close() {
        this.isClosed = true;
        this.accumulator = BytesKt.getEmptyByteArray();
    }

    private final void ensureNotClosed() {
        if (!(!this.isClosed)) {
            boolean bl = false;
            String string = "Already closed";
            throw new IllegalStateException(string.toString());
        }
    }

    private final void accumulate(byte[] source, int startIndex, int endIndex) {
        this.ensureNotClosed();
        BytesKt.checkBounds(source.length, startIndex, endIndex);
        this.accumulator = ArraysKt.plus((byte[])this.accumulator, (byte[])ArraysKt.copyOfRange((byte[])source, (int)startIndex, (int)endIndex));
    }

    @Override
    protected int getBlockSize() {
        return 0;
    }

    @Override
    protected int maxOutputSize(int inputSize) {
        return -1;
    }

    @Override
    protected int maxInputSize(int initialMaxInputSize, int expectedMaxOutputSize) {
        return Integer.MAX_VALUE;
    }

    @Override
    @NotNull
    protected byte[] transformToByteArray(@NotNull byte[] source, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.accumulate(source, startIndex, endIndex);
        return BytesKt.getEmptyByteArray();
    }

    @Override
    protected int transformIntoByteArray(@NotNull byte[] source, @NotNull byte[] destination, int destinationOffset, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        this.accumulate(source, startIndex, endIndex);
        return 0;
    }

    @Override
    @NotNull
    protected byte[] finalizeToByteArray() {
        this.ensureNotClosed();
        return (byte[])this.finalize.invoke((Object)this.accumulator);
    }

    @Override
    protected int finalizeIntoByteArray(@NotNull byte[] destination, int destinationOffset) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        byte[] result = this.finalizeToByteArray();
        ArraysKt.copyInto$default((byte[])result, (byte[])destination, (int)destinationOffset, (int)0, (int)0, (int)12, null);
        return result.length;
    }

    @Override
    @NotNull
    protected byte[] transformAndFinalizeToByteArray(@NotNull byte[] source, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.accumulate(source, startIndex, endIndex);
        return this.finalizeToByteArray();
    }

    @Override
    protected int transformAndFinalizeIntoByteArray(@NotNull byte[] source, @NotNull byte[] destination, int destinationOffset, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        this.accumulate(source, startIndex, endIndex);
        return this.finalizeIntoByteArray(destination, destinationOffset);
    }
}

