/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.base.materials;

import dev.whyoleg.cryptography.CryptographyProviderApi;
import dev.whyoleg.cryptography.serialization.asn1.BitArray;
import dev.whyoleg.cryptography.serialization.asn1.Der;
import dev.whyoleg.cryptography.serialization.asn1.ObjectIdentifier;
import dev.whyoleg.cryptography.serialization.asn1.modules.KeyAlgorithmIdentifier;
import dev.whyoleg.cryptography.serialization.asn1.modules.PrivateKeyInfo;
import dev.whyoleg.cryptography.serialization.asn1.modules.SubjectPublicKeyInfo;
import dev.whyoleg.cryptography.serialization.pem.Pem;
import dev.whyoleg.cryptography.serialization.pem.PemContent;
import dev.whyoleg.cryptography.serialization.pem.PemContentKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\u001a\u001f\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006\u001a\u001f\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001H\u0007\u00a2\u0006\u0004\b\b\u0010\u0006\u001a\u001f\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0001H\u0007\u00a2\u0006\u0004\b\f\u0010\u0006\u001a\u0018\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u0001H\u0007\u001a\u001f\u0010\u0010\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0001H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0006\u001a \u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u0001H\u0007\u00a8\u0006\u0015"}, d2={"unwrapPem", "", "label", "Ldev/whyoleg/cryptography/serialization/pem/PemLabel;", "key", "unwrapPem-unSj4pc", "(Ljava/lang/String;[B)[B", "wrapPem", "wrapPem-unSj4pc", "unwrapSubjectPublicKeyInfo", "algorithm", "Ldev/whyoleg/cryptography/serialization/asn1/ObjectIdentifier;", "unwrapSubjectPublicKeyInfo-4RESAxk", "wrapSubjectPublicKeyInfo", "identifier", "Ldev/whyoleg/cryptography/serialization/asn1/modules/KeyAlgorithmIdentifier;", "unwrapPrivateKeyInfo", "unwrapPrivateKeyInfo-4RESAxk", "wrapPrivateKeyInfo", "version", "", "cryptography-provider-base"})
@SourceDebugExtension(value={"SMAP\nkeys.kt\nKotlin\n*S Kotlin\n*F\n+ 1 keys.kt\ndev/whyoleg/cryptography/providers/base/materials/KeysKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,51:1\n1#2:52\n*E\n"})
public final class KeysKt {
    @CryptographyProviderApi
    @NotNull
    public static final byte[] unwrapPem-unSj4pc(@NotNull String label, @NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return PemContentKt.ensurePemLabel-fi-TaOo((PemContent)Pem.INSTANCE.decode(key), (String)label).getBytes();
    }

    @CryptographyProviderApi
    @NotNull
    public static final byte[] wrapPem-unSj4pc(@NotNull String label, @NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return Pem.INSTANCE.encodeToByteArray(new PemContent(label, key, null));
    }

    @CryptographyProviderApi
    @NotNull
    public static final byte[] unwrapSubjectPublicKeyInfo-4RESAxk(@NotNull String algorithm, @NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object object = Der.Default.decodeFromByteArray((DeserializationStrategy)SubjectPublicKeyInfo.Companion.serializer(), key);
        SubjectPublicKeyInfo it = (SubjectPublicKeyInfo)object;
        boolean bl = false;
        if (!ObjectIdentifier.equals-impl0((String)it.getAlgorithm().getAlgorithm-STa95mE(), (String)algorithm)) {
            boolean bl2 = false;
            String string = "Expected algorithm '" + algorithm + "', received: '" + ObjectIdentifier.toString-impl((String)it.getAlgorithm().getAlgorithm-STa95mE()) + '\'';
            throw new IllegalStateException(string.toString());
        }
        return ((SubjectPublicKeyInfo)object).getSubjectPublicKey().getByteArray();
    }

    @CryptographyProviderApi
    @NotNull
    public static final byte[] wrapSubjectPublicKeyInfo(@NotNull KeyAlgorithmIdentifier identifier, @NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return Der.Default.encodeToByteArray((SerializationStrategy)SubjectPublicKeyInfo.Companion.serializer(), (Object)new SubjectPublicKeyInfo(identifier, new BitArray(0, key)));
    }

    @CryptographyProviderApi
    @NotNull
    public static final byte[] unwrapPrivateKeyInfo-4RESAxk(@NotNull String algorithm, @NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object object = Der.Default.decodeFromByteArray((DeserializationStrategy)PrivateKeyInfo.Companion.serializer(), key);
        PrivateKeyInfo it = (PrivateKeyInfo)object;
        boolean bl = false;
        if (!ObjectIdentifier.equals-impl0((String)it.getPrivateKeyAlgorithm().getAlgorithm-STa95mE(), (String)algorithm)) {
            boolean bl2 = false;
            String string = "Expected algorithm '" + algorithm + "', received: '" + ObjectIdentifier.toString-impl((String)it.getPrivateKeyAlgorithm().getAlgorithm-STa95mE()) + '\'';
            throw new IllegalStateException(string.toString());
        }
        return ((PrivateKeyInfo)object).getPrivateKey();
    }

    @CryptographyProviderApi
    @NotNull
    public static final byte[] wrapPrivateKeyInfo(int version, @NotNull KeyAlgorithmIdentifier identifier, @NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return Der.Default.encodeToByteArray((SerializationStrategy)PrivateKeyInfo.Companion.serializer(), (Object)new PrivateKeyInfo(version, identifier, key));
    }
}

