/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.base.algorithms;

import dev.whyoleg.cryptography.CryptographyProviderApi;
import dev.whyoleg.cryptography.serialization.asn1.Der;
import dev.whyoleg.cryptography.serialization.asn1.ObjectIdentifier;
import dev.whyoleg.cryptography.serialization.asn1.modules.ECKt;
import dev.whyoleg.cryptography.serialization.asn1.modules.EcKeyAlgorithmIdentifier;
import dev.whyoleg.cryptography.serialization.asn1.modules.EcParameters;
import dev.whyoleg.cryptography.serialization.asn1.modules.EcPrivateKey;
import dev.whyoleg.cryptography.serialization.asn1.modules.KeyAlgorithmIdentifier;
import dev.whyoleg.cryptography.serialization.asn1.modules.PrivateKeyInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0007\u001a\u0010\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0007\u00a8\u0006\u0004"}, d2={"convertEcPrivateKeyFromPkcs8ToSec1", "", "input", "convertEcPrivateKeyFromSec1ToPkcs8", "cryptography-provider-base"})
@SourceDebugExtension(value={"SMAP\nEc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Ec.kt\ndev/whyoleg/cryptography/providers/base/algorithms/EcKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,46:1\n1#2:47\n*E\n"})
public final class EcKt {
    @CryptographyProviderApi
    @NotNull
    public static final byte[] convertEcPrivateKeyFromPkcs8ToSec1(@NotNull byte[] input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        PrivateKeyInfo privateKeyInfo = (PrivateKeyInfo)Der.Default.decodeFromByteArray((DeserializationStrategy)PrivateKeyInfo.Companion.serializer(), input);
        KeyAlgorithmIdentifier privateKeyAlgorithm = privateKeyInfo.getPrivateKeyAlgorithm();
        if (!(privateKeyAlgorithm instanceof EcKeyAlgorithmIdentifier)) {
            boolean $i$a$-check-EcKt$convertEcPrivateKeyFromPkcs8ToSec1$22 = false;
            String $i$a$-check-EcKt$convertEcPrivateKeyFromPkcs8ToSec1$22 = "Expected algorithm '" + ObjectIdentifier.toString-impl((String)ECKt.getEC((ObjectIdentifier.Companion)ObjectIdentifier.Companion)) + "', received: '" + ObjectIdentifier.toString-impl((String)privateKeyAlgorithm.getAlgorithm-STa95mE()) + '\'';
            throw new IllegalStateException($i$a$-check-EcKt$convertEcPrivateKeyFromPkcs8ToSec1$22.toString());
        }
        EcPrivateKey ecPrivateKey = (EcPrivateKey)Der.Default.decodeFromByteArray((DeserializationStrategy)EcPrivateKey.Companion.serializer(), privateKeyInfo.getPrivateKey());
        if (ecPrivateKey.getParameters-g4m2kjQ() != null) {
            return privateKeyInfo.getPrivateKey();
        }
        EcPrivateKey enhancedEcPrivateKey = new EcPrivateKey(ecPrivateKey.getVersion(), ecPrivateKey.getPrivateKey(), ((EcKeyAlgorithmIdentifier)privateKeyAlgorithm).getParameters-g4m2kjQ(), ecPrivateKey.getPublicKey(), null);
        return Der.Default.encodeToByteArray((SerializationStrategy)EcPrivateKey.Companion.serializer(), (Object)enhancedEcPrivateKey);
    }

    @CryptographyProviderApi
    @NotNull
    public static final byte[] convertEcPrivateKeyFromSec1ToPkcs8(@NotNull byte[] input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        EcPrivateKey ecPrivateKey = (EcPrivateKey)Der.Default.decodeFromByteArray((DeserializationStrategy)EcPrivateKey.Companion.serializer(), input);
        String string = ecPrivateKey.getParameters-g4m2kjQ();
        if ((string != null ? EcParameters.box-impl((String)string) : null) == null) {
            boolean bl = false;
            String string2 = "EC Parameters are not present in the key";
            throw new IllegalStateException(string2.toString());
        }
        PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(0, (KeyAlgorithmIdentifier)new EcKeyAlgorithmIdentifier(ecPrivateKey.getParameters-g4m2kjQ(), null), input);
        return Der.Default.encodeToByteArray((SerializationStrategy)PrivateKeyInfo.Companion.serializer(), (Object)privateKeyInfo);
    }
}

