/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.base.algorithms;

import dev.whyoleg.cryptography.BinarySize;
import dev.whyoleg.cryptography.CryptographyAlgorithmId;
import dev.whyoleg.cryptography.CryptographyProvider;
import dev.whyoleg.cryptography.CryptographyProviderApi;
import dev.whyoleg.cryptography.algorithms.Digest;
import dev.whyoleg.cryptography.algorithms.HKDF;
import dev.whyoleg.cryptography.algorithms.HMAC;
import dev.whyoleg.cryptography.materials.key.KeyDecoder;
import dev.whyoleg.cryptography.materials.key.KeyFormat;
import dev.whyoleg.cryptography.operations.SecretDerivation;
import dev.whyoleg.cryptography.operations.SignFunction;
import dev.whyoleg.cryptography.operations.UpdateFunction;
import dev.whyoleg.cryptography.providers.base.BytesKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@CryptographyProviderApi
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J9\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0016\u0010\u0014\u001a\u00020\u00152\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH$R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ldev/whyoleg/cryptography/providers/base/algorithms/BaseHkdf;", "Ldev/whyoleg/cryptography/algorithms/HKDF;", "provider", "Ldev/whyoleg/cryptography/CryptographyProvider;", "<init>", "(Ldev/whyoleg/cryptography/CryptographyProvider;)V", "hmac", "Ldev/whyoleg/cryptography/algorithms/HMAC;", "secretDerivation", "Ldev/whyoleg/cryptography/operations/SecretDerivation;", "digest", "Ldev/whyoleg/cryptography/CryptographyAlgorithmId;", "Ldev/whyoleg/cryptography/algorithms/Digest;", "outputSize", "Ldev/whyoleg/cryptography/BinarySize;", "salt", "", "info", "secretDerivation-nkIq3jI", "(Ldev/whyoleg/cryptography/CryptographyAlgorithmId;I[B[B)Ldev/whyoleg/cryptography/operations/SecretDerivation;", "digestSize", "", "HkdfSecretDerivation", "cryptography-provider-base"})
@SourceDebugExtension(value={"SMAP\nBaseHkdf.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseHkdf.kt\ndev/whyoleg/cryptography/providers/base/algorithms/BaseHkdf\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n1#2:89\n*E\n"})
public abstract class BaseHkdf
implements HKDF {
    @NotNull
    private final HMAC hmac;

    public BaseHkdf(@NotNull CryptographyProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.hmac = (HMAC)provider.get((CryptographyAlgorithmId)HMAC.Companion);
    }

    @NotNull
    public SecretDerivation secretDerivation-nkIq3jI(@NotNull CryptographyAlgorithmId<Digest> digest, int outputSize, @Nullable byte[] salt, @Nullable byte[] info) {
        byte[] byArray;
        byte[] byArray2;
        int n;
        int n2;
        KeyDecoder keyDecoder;
        block9: {
            block8: {
                byte[] p0;
                KeyDecoder keyDecoder2;
                int n3;
                int n4;
                byte[] byArray3;
                block7: {
                    int digestSize;
                    block6: {
                        Intrinsics.checkNotNullParameter(digest, (String)"digest");
                        digestSize = this.digestSize(digest);
                        keyDecoder = this.hmac.keyDecoder(digest);
                        n2 = digestSize;
                        n = outputSize;
                        byArray2 = salt;
                        if (salt == null) break block6;
                        byte[] byArray4 = byArray3 = byArray2;
                        n4 = n;
                        n3 = n2;
                        keyDecoder2 = keyDecoder;
                        boolean bl = false;
                        boolean bl2 = !(p0.length == 0);
                        keyDecoder = keyDecoder2;
                        n2 = n3;
                        n = n4;
                        byArray2 = (byte[])(bl2 ? byArray3 : null);
                        if (byArray2 != null) break block7;
                    }
                    byArray2 = new byte[digestSize];
                }
                byArray = info;
                if (info == null) break block8;
                p0 = byArray3 = byArray;
                byte[] byArray5 = byArray2;
                n4 = n;
                n3 = n2;
                keyDecoder2 = keyDecoder;
                boolean bl = false;
                boolean bl3 = !(p0.length == 0);
                keyDecoder = keyDecoder2;
                n2 = n3;
                n = n4;
                byArray2 = byArray5;
                byArray = (byte[])(bl3 ? byArray3 : null);
                if (byArray != null) break block9;
            }
            byArray = BytesKt.getEmptyByteArray();
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        byte[] byArray6 = byArray;
        byte[] byArray7 = byArray2;
        int n5 = n;
        int n6 = n2;
        KeyDecoder keyDecoder3 = keyDecoder;
        return new HkdfSecretDerivation(keyDecoder3, n6, n5, byArray7, byArray6, defaultConstructorMarker);
    }

    protected abstract int digestSize(@NotNull CryptographyAlgorithmId<Digest> var1);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B;\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000bH\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldev/whyoleg/cryptography/providers/base/algorithms/BaseHkdf$HkdfSecretDerivation;", "Ldev/whyoleg/cryptography/operations/SecretDerivation;", "decoder", "Ldev/whyoleg/cryptography/materials/key/KeyDecoder;", "Ldev/whyoleg/cryptography/algorithms/HMAC$Key$Format;", "Ldev/whyoleg/cryptography/algorithms/HMAC$Key;", "digestSize", "", "outputSize", "Ldev/whyoleg/cryptography/BinarySize;", "salt", "", "info", "<init>", "(Ldev/whyoleg/cryptography/materials/key/KeyDecoder;II[B[BLkotlin/jvm/internal/DefaultConstructorMarker;)V", "I", "deriveSecretToByteArrayBlocking", "input", "cryptography-provider-base"})
    @SourceDebugExtension(value={"SMAP\nBaseHkdf.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseHkdf.kt\ndev/whyoleg/cryptography/providers/base/algorithms/BaseHkdf$HkdfSecretDerivation\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n1#2:89\n*E\n"})
    private static final class HkdfSecretDerivation
    implements SecretDerivation {
        @NotNull
        private final KeyDecoder<HMAC.Key.Format, HMAC.Key> decoder;
        private final int digestSize;
        private final int outputSize;
        @NotNull
        private final byte[] salt;
        @NotNull
        private final byte[] info;

        private HkdfSecretDerivation(KeyDecoder<HMAC.Key.Format, HMAC.Key> decoder, int digestSize, int outputSize, byte[] salt, byte[] info) {
            Intrinsics.checkNotNullParameter(decoder, (String)"decoder");
            Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            this.decoder = decoder;
            this.digestSize = digestSize;
            this.outputSize = outputSize;
            this.salt = salt;
            this.info = info;
        }

        @NotNull
        public byte[] deriveSecretToByteArrayBlocking(@NotNull byte[] input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            int iterations = (int)Math.ceil((double)BinarySize.getInBytes-impl((int)this.outputSize) / (double)this.digestSize);
            if (!(iterations <= 255)) {
                boolean $i$a$-require-BaseHkdf$HkdfSecretDerivation$deriveSecretToByteArrayBlocking$22 = false;
                String $i$a$-require-BaseHkdf$HkdfSecretDerivation$deriveSecretToByteArrayBlocking$22 = "out length must be maximal 255 * hash-length; requested: " + BinarySize.toString-impl((int)this.outputSize);
                throw new IllegalArgumentException($i$a$-require-BaseHkdf$HkdfSecretDerivation$deriveSecretToByteArrayBlocking$22.toString());
            }
            byte[] pseudoRandomKey = ((HMAC.Key)this.decoder.decodeFromByteArrayBlocking((KeyFormat)HMAC.Key.Format.RAW, this.salt)).signatureGenerator().generateSignatureBlocking(input);
            SignFunction function = ((HMAC.Key)this.decoder.decodeFromByteArrayBlocking((KeyFormat)HMAC.Key.Format.RAW, pseudoRandomKey)).signatureGenerator().createSignFunction();
            byte[] output = null;
            output = BytesKt.getEmptyByteArray();
            byte[] t = null;
            t = BytesKt.getEmptyByteArray();
            byte[] iterationArray = new byte[1];
            int n = 0;
            while (n < iterations) {
                int iteration = n++;
                boolean bl = false;
                UpdateFunction.update$default((UpdateFunction)((UpdateFunction)function), (byte[])t, (int)0, (int)0, (int)6, null);
                UpdateFunction.update$default((UpdateFunction)((UpdateFunction)function), (byte[])this.info, (int)0, (int)0, (int)6, null);
                iterationArray[0] = (byte)(iteration + 1);
                UpdateFunction.update$default((UpdateFunction)((UpdateFunction)function), (byte[])iterationArray, (int)0, (int)0, (int)6, null);
                t = function.signToByteArray();
                output = ArraysKt.plus((byte[])output, (byte[])t);
            }
            return BytesKt.ensureSizeExactly(output, BinarySize.getInBytes-impl((int)this.outputSize));
        }

        public /* synthetic */ HkdfSecretDerivation(KeyDecoder decoder, int digestSize, int outputSize, byte[] salt, byte[] info, DefaultConstructorMarker $constructor_marker) {
            this((KeyDecoder<HMAC.Key.Format, HMAC.Key>)decoder, digestSize, outputSize, salt, info);
        }
    }
}

