/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.base.algorithms;

import dev.whyoleg.cryptography.CryptographyProviderApi;
import dev.whyoleg.cryptography.DelicateCryptographyApi;
import dev.whyoleg.cryptography.algorithms.AES;
import dev.whyoleg.cryptography.providers.base.operations.BaseDecryptor;
import dev.whyoleg.cryptography.providers.base.operations.CipherFunction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.io.RawSink;
import kotlinx.io.RawSource;
import org.jetbrains.annotations.NotNull;

@CryptographyProviderApi
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bg\u0018\u00002\u00020\u00012\u00020\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&J\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0017J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\nH\u0017J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\fH\u0017\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000e\u00c0\u0006\u0001"}, d2={"Ldev/whyoleg/cryptography/providers/base/algorithms/BaseAesIvDecryptor;", "Ldev/whyoleg/cryptography/algorithms/AES$IvDecryptor;", "Ldev/whyoleg/cryptography/providers/base/operations/BaseDecryptor;", "createDecryptFunctionWithIv", "Ldev/whyoleg/cryptography/providers/base/operations/CipherFunction;", "iv", "", "decryptWithIvBlocking", "ciphertext", "decryptingSourceWithIv", "Lkotlinx/io/RawSource;", "decryptingSinkWithIv", "Lkotlinx/io/RawSink;", "plaintext", "cryptography-provider-base"})
public interface BaseAesIvDecryptor
extends AES.IvDecryptor,
BaseDecryptor {
    @NotNull
    public CipherFunction createDecryptFunctionWithIv(@NotNull byte[] var1);

    @DelicateCryptographyApi
    @NotNull
    default public byte[] decryptWithIvBlocking(@NotNull byte[] iv, @NotNull byte[] ciphertext) {
        Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
        Intrinsics.checkNotNullParameter((Object)ciphertext, (String)"ciphertext");
        return CipherFunction.transform$default(this.createDecryptFunctionWithIv(iv), ciphertext, 0, 0, 6, null);
    }

    @DelicateCryptographyApi
    @NotNull
    default public RawSource decryptingSourceWithIv(@NotNull byte[] iv, @NotNull RawSource ciphertext) {
        Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
        Intrinsics.checkNotNullParameter((Object)ciphertext, (String)"ciphertext");
        return this.createDecryptFunctionWithIv(iv).transformedSource(ciphertext);
    }

    @DelicateCryptographyApi
    @NotNull
    default public RawSink decryptingSinkWithIv(@NotNull byte[] iv, @NotNull RawSink plaintext) {
        Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
        Intrinsics.checkNotNullParameter((Object)plaintext, (String)"plaintext");
        return this.createDecryptFunctionWithIv(iv).transformedSink(plaintext);
    }
}

