/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.base.algorithms;

import dev.whyoleg.cryptography.CryptographyProviderApi;
import dev.whyoleg.cryptography.DelicateCryptographyApi;
import dev.whyoleg.cryptography.algorithms.AES;
import dev.whyoleg.cryptography.providers.base.operations.BaseAuthenticatedEncryptor;
import dev.whyoleg.cryptography.providers.base.operations.CipherFunction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.io.RawSink;
import kotlinx.io.RawSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CryptographyProviderApi
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bg\u0018\u00002\u00020\u00012\u00020\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H&J\"\u0010\b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0017J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u000b2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0017J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\r2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0017\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Ldev/whyoleg/cryptography/providers/base/algorithms/BaseAesIvAuthenticatedEncryptor;", "Ldev/whyoleg/cryptography/algorithms/AES$IvAuthenticatedEncryptor;", "Ldev/whyoleg/cryptography/providers/base/operations/BaseAuthenticatedEncryptor;", "createEncryptFunctionWithIv", "Ldev/whyoleg/cryptography/providers/base/operations/CipherFunction;", "iv", "", "associatedData", "encryptWithIvBlocking", "plaintext", "encryptingSourceWithIv", "Lkotlinx/io/RawSource;", "encryptingSinkWithIv", "Lkotlinx/io/RawSink;", "ciphertext", "cryptography-provider-base"})
public interface BaseAesIvAuthenticatedEncryptor
extends AES.IvAuthenticatedEncryptor,
BaseAuthenticatedEncryptor {
    @NotNull
    public CipherFunction createEncryptFunctionWithIv(@NotNull byte[] var1, @Nullable byte[] var2);

    @DelicateCryptographyApi
    @NotNull
    default public byte[] encryptWithIvBlocking(@NotNull byte[] iv, @NotNull byte[] plaintext, @Nullable byte[] associatedData) {
        Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
        Intrinsics.checkNotNullParameter((Object)plaintext, (String)"plaintext");
        return CipherFunction.transform$default(this.createEncryptFunctionWithIv(iv, associatedData), plaintext, 0, 0, 6, null);
    }

    @DelicateCryptographyApi
    @NotNull
    default public RawSource encryptingSourceWithIv(@NotNull byte[] iv, @NotNull RawSource plaintext, @Nullable byte[] associatedData) {
        Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
        Intrinsics.checkNotNullParameter((Object)plaintext, (String)"plaintext");
        return this.createEncryptFunctionWithIv(iv, associatedData).transformedSource(plaintext);
    }

    @DelicateCryptographyApi
    @NotNull
    default public RawSink encryptingSinkWithIv(@NotNull byte[] iv, @NotNull RawSink ciphertext, @Nullable byte[] associatedData) {
        Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
        Intrinsics.checkNotNullParameter((Object)ciphertext, (String)"ciphertext");
        return this.createEncryptFunctionWithIv(iv, associatedData).transformedSink(ciphertext);
    }
}

