/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.base.algorithms;

import dev.whyoleg.cryptography.CryptographyProviderApi;
import dev.whyoleg.cryptography.DelicateCryptographyApi;
import dev.whyoleg.cryptography.algorithms.AES;
import dev.whyoleg.cryptography.providers.base.operations.BaseAuthenticatedDecryptor;
import dev.whyoleg.cryptography.providers.base.operations.CipherFunction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.io.RawSink;
import kotlinx.io.RawSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CryptographyProviderApi
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bg\u0018\u00002\u00020\u00012\u00020\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H&J\"\u0010\b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0017J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0017J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u000e2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0017\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Ldev/whyoleg/cryptography/providers/base/algorithms/BaseAesIvAuthenticatedDecryptor;", "Ldev/whyoleg/cryptography/algorithms/AES$IvAuthenticatedDecryptor;", "Ldev/whyoleg/cryptography/providers/base/operations/BaseAuthenticatedDecryptor;", "createDecryptFunctionWithIv", "Ldev/whyoleg/cryptography/providers/base/operations/CipherFunction;", "iv", "", "associatedData", "decryptWithIvBlocking", "ciphertext", "decryptingSourceWithIv", "Lkotlinx/io/RawSource;", "plaintext", "decryptingSinkWithIv", "Lkotlinx/io/RawSink;", "cryptography-provider-base"})
public interface BaseAesIvAuthenticatedDecryptor
extends AES.IvAuthenticatedDecryptor,
BaseAuthenticatedDecryptor {
    @NotNull
    public CipherFunction createDecryptFunctionWithIv(@NotNull byte[] var1, @Nullable byte[] var2);

    @DelicateCryptographyApi
    @NotNull
    default public byte[] decryptWithIvBlocking(@NotNull byte[] iv, @NotNull byte[] ciphertext, @Nullable byte[] associatedData) {
        Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
        Intrinsics.checkNotNullParameter((Object)ciphertext, (String)"ciphertext");
        return CipherFunction.transform$default(this.createDecryptFunctionWithIv(iv, associatedData), ciphertext, 0, 0, 6, null);
    }

    @DelicateCryptographyApi
    @NotNull
    default public RawSource decryptingSourceWithIv(@NotNull byte[] iv, @NotNull RawSource plaintext, @Nullable byte[] associatedData) {
        Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
        Intrinsics.checkNotNullParameter((Object)plaintext, (String)"plaintext");
        return this.createDecryptFunctionWithIv(iv, associatedData).transformedSource(plaintext);
    }

    @DelicateCryptographyApi
    @NotNull
    default public RawSink decryptingSinkWithIv(@NotNull byte[] iv, @NotNull RawSink ciphertext, @Nullable byte[] associatedData) {
        Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
        Intrinsics.checkNotNullParameter((Object)ciphertext, (String)"ciphertext");
        return this.createDecryptFunctionWithIv(iv, associatedData).transformedSink(ciphertext);
    }
}

