/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.base.algorithms;

import dev.whyoleg.cryptography.CryptographyProviderApi;
import dev.whyoleg.cryptography.providers.base.operations.CipherFunction;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Buffer;
import kotlinx.io.RawSink;
import kotlinx.io.RawSource;
import kotlinx.io.Sink;
import org.jetbrains.annotations.NotNull;

@CryptographyProviderApi
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0002\u0011\u0012B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ldev/whyoleg/cryptography/providers/base/algorithms/BaseAesImplicitIvEncryptFunction;", "Ldev/whyoleg/cryptography/providers/base/operations/CipherFunction;", "iv", "", "cipherFunction", "<init>", "([BLdev/whyoleg/cryptography/providers/base/operations/CipherFunction;)V", "transform", "source", "startIndex", "", "endIndex", "transformedSource", "Lkotlinx/io/RawSource;", "transformedSink", "Lkotlinx/io/RawSink;", "sink", "ImplicitIvSource", "ImplicitIvSink", "cryptography-provider-base"})
public final class BaseAesImplicitIvEncryptFunction
implements CipherFunction {
    @NotNull
    private final byte[] iv;
    @NotNull
    private final CipherFunction cipherFunction;

    public BaseAesImplicitIvEncryptFunction(@NotNull byte[] iv, @NotNull CipherFunction cipherFunction) {
        Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
        Intrinsics.checkNotNullParameter((Object)cipherFunction, (String)"cipherFunction");
        this.iv = iv;
        this.cipherFunction = cipherFunction;
    }

    @Override
    @NotNull
    public byte[] transform(@NotNull byte[] source, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return ArraysKt.plus((byte[])this.iv, (byte[])this.cipherFunction.transform(source, startIndex, endIndex));
    }

    @Override
    @NotNull
    public RawSource transformedSource(@NotNull RawSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return new ImplicitIvSource(this.iv, this.cipherFunction.transformedSource(source));
    }

    @Override
    @NotNull
    public RawSink transformedSink(@NotNull RawSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        return this.cipherFunction.transformedSink(new ImplicitIvSink(this.iv, sink));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\tH\u0016J\b\u0010\u000e\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ldev/whyoleg/cryptography/providers/base/algorithms/BaseAesImplicitIvEncryptFunction$ImplicitIvSink;", "Lkotlinx/io/RawSink;", "iv", "", "originalSink", "<init>", "([BLkotlinx/io/RawSink;)V", "Lkotlinx/io/Buffer;", "write", "", "source", "byteCount", "", "flush", "close", "cryptography-provider-base"})
    @SourceDebugExtension(value={"SMAP\nBaseAesImplicitIvFunctions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseAesImplicitIvFunctions.kt\ndev/whyoleg/cryptography/providers/base/algorithms/BaseAesImplicitIvEncryptFunction$ImplicitIvSink\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,173:1\n1#2:174\n*E\n"})
    private static final class ImplicitIvSink
    implements RawSink {
        @NotNull
        private final RawSink originalSink;
        @NotNull
        private final Buffer iv;

        /*
         * WARNING - void declaration
         */
        public ImplicitIvSink(@NotNull byte[] iv, @NotNull RawSink originalSink) {
            void $this$iv_u24lambda_u240;
            Buffer buffer;
            Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
            Intrinsics.checkNotNullParameter((Object)originalSink, (String)"originalSink");
            this.originalSink = originalSink;
            Buffer buffer2 = buffer = new Buffer();
            ImplicitIvSink implicitIvSink = this;
            boolean bl = false;
            Sink.write$default((Sink)((Sink)$this$iv_u24lambda_u240), (byte[])iv, (int)0, (int)0, (int)6, null);
            implicitIvSink.iv = buffer;
        }

        public void write(@NotNull Buffer source, long byteCount) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            source.require(byteCount);
            if (byteCount == 0L) {
                return;
            }
            if (this.iv.getSize() != 0L) {
                this.originalSink.write(this.iv, this.iv.getSize());
            }
            this.originalSink.write(source, byteCount);
        }

        public void flush() {
            this.originalSink.flush();
        }

        public void close() {
            Throwable throwable;
            try {
                if (this.iv.getSize() != 0L) {
                    this.originalSink.write(this.iv, this.iv.getSize());
                }
                throwable = null;
            }
            catch (Throwable cause) {
                throwable = cause;
            }
            Throwable thrown = throwable;
            try {
                this.originalSink.close();
            }
            catch (Throwable cause) {
                if (thrown == null) {
                    thrown = cause;
                }
                ExceptionsKt.addSuppressed((Throwable)thrown, (Throwable)cause);
            }
            Throwable throwable2 = thrown;
            if (throwable2 != null) {
                throw throwable2;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\tH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ldev/whyoleg/cryptography/providers/base/algorithms/BaseAesImplicitIvEncryptFunction$ImplicitIvSource;", "Lkotlinx/io/RawSource;", "iv", "", "transformedSource", "<init>", "([BLkotlinx/io/RawSource;)V", "Lkotlinx/io/Buffer;", "readAtMostTo", "", "sink", "byteCount", "close", "", "cryptography-provider-base"})
    @SourceDebugExtension(value={"SMAP\nBaseAesImplicitIvFunctions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseAesImplicitIvFunctions.kt\ndev/whyoleg/cryptography/providers/base/algorithms/BaseAesImplicitIvEncryptFunction$ImplicitIvSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,173:1\n1#2:174\n*E\n"})
    private static final class ImplicitIvSource
    implements RawSource {
        @NotNull
        private final RawSource transformedSource;
        @NotNull
        private final Buffer iv;

        /*
         * WARNING - void declaration
         */
        public ImplicitIvSource(@NotNull byte[] iv, @NotNull RawSource transformedSource) {
            void $this$iv_u24lambda_u240;
            Buffer buffer;
            Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
            Intrinsics.checkNotNullParameter((Object)transformedSource, (String)"transformedSource");
            this.transformedSource = transformedSource;
            Buffer buffer2 = buffer = new Buffer();
            ImplicitIvSource implicitIvSource = this;
            boolean bl = false;
            Sink.write$default((Sink)((Sink)$this$iv_u24lambda_u240), (byte[])iv, (int)0, (int)0, (int)6, null);
            implicitIvSource.iv = buffer;
        }

        public long readAtMostTo(@NotNull Buffer sink, long byteCount) {
            long l;
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            if (!(byteCount >= 0L)) {
                boolean bl = false;
                String string = "byteCount < 0: " + byteCount;
                throw new IllegalArgumentException(string.toString());
            }
            if (byteCount == 0L) {
                return 0L;
            }
            if (this.iv.getSize() != 0L) {
                long bytesWritten = this.iv.readAtMostTo(sink, byteCount);
                if (this.iv.getSize() != 0L) {
                    return bytesWritten;
                }
                l = byteCount - bytesWritten;
            } else {
                l = byteCount;
            }
            long remaining = l;
            return this.transformedSource.readAtMostTo(sink, remaining);
        }

        public void close() {
            this.transformedSource.close();
        }
    }
}

