/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.base.algorithms;

import dev.whyoleg.cryptography.CryptographyProviderApi;
import dev.whyoleg.cryptography.providers.base.BytesKt;
import dev.whyoleg.cryptography.providers.base.operations.CipherFunction;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Buffer;
import kotlinx.io.RawSink;
import kotlinx.io.RawSource;
import kotlinx.io.Source;
import kotlinx.io.SourcesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CryptographyProviderApi
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0002\u0015\u0016BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00126\u0010\u0004\u001a2\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\u0004\b\u000b\u0010\fJ \u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u0004\u001a2\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ldev/whyoleg/cryptography/providers/base/algorithms/BaseAesImplicitIvDecryptFunction;", "Ldev/whyoleg/cryptography/providers/base/operations/CipherFunction;", "ivSize", "", "initialize", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "iv", "startIndex", "<init>", "(ILkotlin/jvm/functions/Function2;)V", "transform", "source", "endIndex", "transformedSource", "Lkotlinx/io/RawSource;", "transformedSink", "Lkotlinx/io/RawSink;", "sink", "ImplicitIvSource", "ImplicitIvSink", "cryptography-provider-base"})
@SourceDebugExtension(value={"SMAP\nBaseAesImplicitIvFunctions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseAesImplicitIvFunctions.kt\ndev/whyoleg/cryptography/providers/base/algorithms/BaseAesImplicitIvDecryptFunction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,173:1\n1#2:174\n*E\n"})
public final class BaseAesImplicitIvDecryptFunction
implements CipherFunction {
    private final int ivSize;
    @NotNull
    private final Function2<byte[], Integer, CipherFunction> initialize;

    public BaseAesImplicitIvDecryptFunction(int ivSize, @NotNull Function2<? super byte[], ? super Integer, ? extends CipherFunction> initialize) {
        Intrinsics.checkNotNullParameter(initialize, (String)"initialize");
        this.ivSize = ivSize;
        this.initialize = initialize;
    }

    @Override
    @NotNull
    public byte[] transform(@NotNull byte[] source, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        BytesKt.checkBounds(source.length, startIndex, endIndex);
        if (!(endIndex - startIndex >= this.ivSize)) {
            boolean bl = false;
            String string = "Not enough data to read iv (expected " + this.ivSize + ", got " + (endIndex - startIndex) + ')';
            throw new IllegalArgumentException(string.toString());
        }
        return ((CipherFunction)this.initialize.invoke((Object)source, (Object)startIndex)).transform(source, startIndex + this.ivSize, endIndex);
    }

    @Override
    @NotNull
    public RawSource transformedSource(@NotNull RawSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return new ImplicitIvSource(source);
    }

    @Override
    @NotNull
    public RawSink transformedSink(@NotNull RawSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        return new ImplicitIvSink(sink);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\tH\u0016J\b\u0010\u000e\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ldev/whyoleg/cryptography/providers/base/algorithms/BaseAesImplicitIvDecryptFunction$ImplicitIvSink;", "Lkotlinx/io/RawSink;", "originalSink", "<init>", "(Ldev/whyoleg/cryptography/providers/base/algorithms/BaseAesImplicitIvDecryptFunction;Lkotlinx/io/RawSink;)V", "transformedSink", "ivBuffer", "Lkotlinx/io/Buffer;", "write", "", "source", "byteCount", "", "flush", "close", "cryptography-provider-base"})
    private final class ImplicitIvSink
    implements RawSink {
        @NotNull
        private final RawSink originalSink;
        @Nullable
        private RawSink transformedSink;
        @NotNull
        private final Buffer ivBuffer;

        public ImplicitIvSink(RawSink originalSink) {
            Intrinsics.checkNotNullParameter((Object)originalSink, (String)"originalSink");
            this.originalSink = originalSink;
            this.ivBuffer = new Buffer();
        }

        public void write(@NotNull Buffer source, long byteCount) {
            long l;
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            source.require(byteCount);
            if (byteCount == 0L) {
                return;
            }
            if (this.transformedSink == null) {
                long bytesWritten = source.readAtMostTo(this.ivBuffer, Math.min(byteCount, (long)BaseAesImplicitIvDecryptFunction.this.ivSize - this.ivBuffer.getSize()));
                if (this.ivBuffer.getSize() != (long)BaseAesImplicitIvDecryptFunction.this.ivSize) {
                    return;
                }
                this.transformedSink = ((CipherFunction)BaseAesImplicitIvDecryptFunction.this.initialize.invoke((Object)SourcesKt.readByteArray((Source)((Source)this.ivBuffer)), (Object)0)).transformedSink(this.originalSink);
                l = byteCount - bytesWritten;
            } else {
                l = byteCount;
            }
            long remaining = l;
            RawSink rawSink = this.transformedSink;
            Intrinsics.checkNotNull((Object)rawSink);
            rawSink.write(source, remaining);
        }

        public void flush() {
            block0: {
                RawSink rawSink = this.transformedSink;
                if (rawSink == null) break block0;
                rawSink.flush();
            }
        }

        public void close() {
            RawSink rawSink = this.transformedSink;
            if (rawSink != null) {
                rawSink.close();
            } else {
                this.originalSink.close();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ldev/whyoleg/cryptography/providers/base/algorithms/BaseAesImplicitIvDecryptFunction$ImplicitIvSource;", "Lkotlinx/io/RawSource;", "originalSource", "<init>", "(Ldev/whyoleg/cryptography/providers/base/algorithms/BaseAesImplicitIvDecryptFunction;Lkotlinx/io/RawSource;)V", "transformedSource", "readAtMostTo", "", "sink", "Lkotlinx/io/Buffer;", "byteCount", "close", "", "cryptography-provider-base"})
    @SourceDebugExtension(value={"SMAP\nBaseAesImplicitIvFunctions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseAesImplicitIvFunctions.kt\ndev/whyoleg/cryptography/providers/base/algorithms/BaseAesImplicitIvDecryptFunction$ImplicitIvSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,173:1\n1#2:174\n*E\n"})
    private final class ImplicitIvSource
    implements RawSource {
        @NotNull
        private final RawSource originalSource;
        @Nullable
        private RawSource transformedSource;

        public ImplicitIvSource(RawSource originalSource) {
            Intrinsics.checkNotNullParameter((Object)originalSource, (String)"originalSource");
            this.originalSource = originalSource;
        }

        public long readAtMostTo(@NotNull Buffer sink, long byteCount) {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            if (!(byteCount >= 0L)) {
                boolean bl = false;
                String string = "byteCount < 0: " + byteCount;
                throw new IllegalArgumentException(string.toString());
            }
            if (byteCount == 0L) {
                return 0L;
            }
            if (this.transformedSource == null) {
                Buffer ivBuffer = new Buffer();
                ivBuffer.write(this.originalSource, (long)BaseAesImplicitIvDecryptFunction.this.ivSize);
                this.transformedSource = ((CipherFunction)BaseAesImplicitIvDecryptFunction.this.initialize.invoke((Object)SourcesKt.readByteArray((Source)((Source)ivBuffer)), (Object)0)).transformedSource(this.originalSource);
            }
            RawSource rawSource = this.transformedSource;
            Intrinsics.checkNotNull((Object)rawSource);
            return rawSource.readAtMostTo(sink, byteCount);
        }

        public void close() {
            RawSource rawSource = this.transformedSource;
            if (rawSource != null) {
                rawSource.close();
            } else {
                this.originalSource.close();
            }
        }
    }
}

