/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.base;

import dev.whyoleg.cryptography.CryptographyProviderApi;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u001a \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0007\u001a\u0014\u0010\f\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\r\u001a\u00020\tH\u0007\"\u001c\u0010\u0000\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0002\u0010\u0003\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u000e"}, d2={"EmptyByteArray", "", "getEmptyByteArray$annotations", "()V", "getEmptyByteArray", "()[B", "checkBounds", "", "size", "", "startIndex", "endIndex", "ensureSizeExactly", "expectedSize", "cryptography-provider-base"})
public final class BytesKt {
    @NotNull
    private static final byte[] EmptyByteArray = new byte[0];

    @NotNull
    public static final byte[] getEmptyByteArray() {
        return EmptyByteArray;
    }

    @CryptographyProviderApi
    public static /* synthetic */ void getEmptyByteArray$annotations() {
    }

    @CryptographyProviderApi
    public static final void checkBounds(int size, int startIndex, int endIndex) {
        if (startIndex < 0 || endIndex > size) {
            throw new IndexOutOfBoundsException("startIndex (" + startIndex + ") and endIndex (" + endIndex + ") are not within the range [0..size(" + size + "))");
        }
        if (startIndex > endIndex) {
            throw new IllegalArgumentException("startIndex (" + startIndex + ") > endIndex (" + endIndex + ')');
        }
    }

    @CryptographyProviderApi
    @NotNull
    public static final byte[] ensureSizeExactly(@NotNull byte[] $this$ensureSizeExactly, int expectedSize) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)$this$ensureSizeExactly, (String)"<this>");
        if ($this$ensureSizeExactly.length == expectedSize) {
            byArray = $this$ensureSizeExactly;
        } else {
            byte[] byArray2 = Arrays.copyOf($this$ensureSizeExactly, expectedSize);
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(...)");
        }
        return byArray;
    }
}

