/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography;

import dev.whyoleg.cryptography.CryptographyAlgorithm;
import dev.whyoleg.cryptography.CryptographyAlgorithmId;
import dev.whyoleg.cryptography.CryptographyProvider;
import dev.whyoleg.cryptography.CryptographySystemImpl;
import dev.whyoleg.cryptography.random.CryptographyRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0010\u001a\u00020\bJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\bJ\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\nJ\u001c\u0010\u0015\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0016\u001a\u00020\u0006J\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u000eJ\u0006\u0010\u0019\u001a\u00020\u000eR \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ldev/whyoleg/cryptography/CryptographySystemImpl;", "", "<init>", "()V", "registeredProviders", "", "", "Lkotlin/Lazy;", "Ldev/whyoleg/cryptography/CryptographyProvider;", "lazyRegisteredProviders", "", "defaultProvider", "lazyDefaultProvider", "defaultRandom", "Ldev/whyoleg/cryptography/random/CryptographyRandom;", "lazyDefaultRandom", "getDefaultProvider", "setDefaultProvider", "", "provider", "getRegisteredProviders", "registerProvider", "priority", "setDefaultRandom", "random", "getDefaultRandom", "CompositeProvider", "cryptography-core"})
@SourceDebugExtension(value={"SMAP\nCryptographySystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CryptographySystem.kt\ndev/whyoleg/cryptography/CryptographySystemImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,106:1\n1#2:107\n1056#3:108\n1563#3:109\n1634#3,3:110\n*S KotlinDebug\n*F\n+ 1 CryptographySystem.kt\ndev/whyoleg/cryptography/CryptographySystemImpl\n*L\n34#1:108\n34#1:109\n34#1:110,3\n*E\n"})
public final class CryptographySystemImpl {
    @NotNull
    private final Map<Integer, Lazy<CryptographyProvider>> registeredProviders = new LinkedHashMap();
    @NotNull
    private final Lazy<List<CryptographyProvider>> lazyRegisteredProviders = LazyKt.lazy(() -> CryptographySystemImpl.lazyRegisteredProviders$lambda$2(this));
    @Nullable
    private CryptographyProvider defaultProvider;
    @NotNull
    private final Lazy<CryptographyProvider> lazyDefaultProvider = LazyKt.lazy(() -> CryptographySystemImpl.lazyDefaultProvider$lambda$4(this));
    @Nullable
    private CryptographyRandom defaultRandom;
    @NotNull
    private final Lazy<CryptographyRandom> lazyDefaultRandom = LazyKt.lazy(() -> CryptographySystemImpl.lazyDefaultRandom$lambda$5(this));

    @NotNull
    public final CryptographyProvider getDefaultProvider() {
        return (CryptographyProvider)this.lazyDefaultProvider.getValue();
    }

    public final void setDefaultProvider(@NotNull CryptographyProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        if (!(!this.lazyDefaultProvider.isInitialized())) {
            boolean $i$a$-check-CryptographySystemImpl$setDefaultProvider$32 = false;
            String $i$a$-check-CryptographySystemImpl$setDefaultProvider$32 = "Cannot set default provider after `getDefaultProvider` was called";
            throw new IllegalStateException($i$a$-check-CryptographySystemImpl$setDefaultProvider$32.toString());
        }
        if (!(this.defaultProvider == null)) {
            boolean bl = false;
            String string = "Default provider already set";
            throw new IllegalStateException(string.toString());
        }
        this.defaultProvider = provider;
    }

    @NotNull
    public final List<CryptographyProvider> getRegisteredProviders() {
        return (List)this.lazyRegisteredProviders.getValue();
    }

    public final void registerProvider(@NotNull Lazy<? extends CryptographyProvider> provider, int priority) {
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        if (!(priority >= 0)) {
            boolean $i$a$-require-CryptographySystemImpl$registerProvider$32 = false;
            String $i$a$-require-CryptographySystemImpl$registerProvider$32 = "Priority must be greater or equal to 0";
            throw new IllegalArgumentException($i$a$-require-CryptographySystemImpl$registerProvider$32.toString());
        }
        if (!(!this.registeredProviders.containsKey(priority))) {
            boolean $i$a$-require-CryptographySystemImpl$registerProvider$42 = false;
            String $i$a$-require-CryptographySystemImpl$registerProvider$42 = "Provider with priority " + priority + " already registered. Every registered provider should have unique priority.";
            throw new IllegalArgumentException($i$a$-require-CryptographySystemImpl$registerProvider$42.toString());
        }
        if (!(!this.lazyRegisteredProviders.isInitialized())) {
            boolean bl = false;
            String string = "Cannot register provider after `getRegisteredProviders` was called";
            throw new IllegalStateException(string.toString());
        }
        this.registeredProviders.put(priority, provider);
    }

    public final void setDefaultRandom(@NotNull CryptographyRandom random) {
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        if (!(!this.lazyDefaultRandom.isInitialized())) {
            boolean $i$a$-check-CryptographySystemImpl$setDefaultRandom$32 = false;
            String $i$a$-check-CryptographySystemImpl$setDefaultRandom$32 = "Cannot set default random after `getDefaultRandom` was called";
            throw new IllegalStateException($i$a$-check-CryptographySystemImpl$setDefaultRandom$32.toString());
        }
        if (!(this.defaultRandom == null)) {
            boolean bl = false;
            String string = "Default random already set";
            throw new IllegalStateException(string.toString());
        }
        this.defaultRandom = random;
    }

    @NotNull
    public final CryptographyRandom getDefaultRandom() {
        return (CryptographyRandom)this.lazyDefaultRandom.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private static final List lazyRegisteredProviders$lambda$2(CryptographySystemImpl this$0) {
        void $this$mapTo$iv$iv;
        Iterable $this$sortedBy$iv = this$0.registeredProviders.entrySet();
        boolean $i$f$sortedBy = false;
        Iterable $this$map$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Integer)it.getKey();
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getKey()));
            }
        });
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((CryptographyProvider)((Lazy)it.getValue()).getValue());
        }
        return (List)destination$iv$iv;
    }

    private static final CryptographyProvider lazyDefaultProvider$lambda$4(CryptographySystemImpl this$0) {
        CryptographyProvider cryptographyProvider = this$0.defaultProvider;
        if (cryptographyProvider == null) {
            List it = (List)this$0.lazyRegisteredProviders.getValue();
            boolean bl = false;
            switch (it.size()) {
                case 0: {
                    throw new IllegalStateException("No providers registered. Please provide a dependency or register provider explicitly".toString());
                }
                case 1: {
                    cryptographyProvider = (CryptographyProvider)CollectionsKt.first((List)it);
                    break;
                }
                default: {
                    cryptographyProvider = new CompositeProvider(it);
                }
            }
        }
        return cryptographyProvider;
    }

    private static final CryptographyRandom lazyDefaultRandom$lambda$5(CryptographySystemImpl this$0) {
        CryptographyRandom cryptographyRandom = this$0.defaultRandom;
        if (cryptographyRandom == null) {
            cryptographyRandom = (CryptographyRandom)CryptographyRandom.Default;
        }
        return cryptographyRandom;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\n\u001a\u0004\u0018\u0001H\u000b\"\b\b\u0000\u0010\u000b*\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Ldev/whyoleg/cryptography/CryptographySystemImpl$CompositeProvider;", "Ldev/whyoleg/cryptography/CryptographyProvider;", "providers", "", "<init>", "(Ljava/util/List;)V", "name", "", "getName", "()Ljava/lang/String;", "getOrNull", "A", "Ldev/whyoleg/cryptography/CryptographyAlgorithm;", "identifier", "Ldev/whyoleg/cryptography/CryptographyAlgorithmId;", "(Ldev/whyoleg/cryptography/CryptographyAlgorithmId;)Ldev/whyoleg/cryptography/CryptographyAlgorithm;", "cryptography-core"})
    @SourceDebugExtension(value={"SMAP\nCryptographySystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CryptographySystem.kt\ndev/whyoleg/cryptography/CryptographySystemImpl$CompositeProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n1#2:107\n*E\n"})
    private static final class CompositeProvider
    extends CryptographyProvider {
        @NotNull
        private final List<CryptographyProvider> providers;

        public CompositeProvider(@NotNull List<? extends CryptographyProvider> providers) {
            Intrinsics.checkNotNullParameter(providers, (String)"providers");
            this.providers = providers;
        }

        @Override
        @NotNull
        public String getName() {
            return CollectionsKt.joinToString$default((Iterable)this.providers, (CharSequence)",", (CharSequence)"Composite(", (CharSequence)")", (int)0, null, (Function1)((Function1)name.1.INSTANCE), (int)24, null);
        }

        @Override
        @Nullable
        public <A extends CryptographyAlgorithm> A getOrNull(@NotNull CryptographyAlgorithmId<A> identifier) {
            A a;
            block1: {
                Intrinsics.checkNotNullParameter(identifier, (String)"identifier");
                for (CryptographyProvider it : (Iterable)this.providers) {
                    boolean bl = false;
                    A a2 = it.getOrNull(identifier);
                    if (a2 == null) continue;
                    a = a2;
                    break block1;
                }
                a = null;
            }
            return a;
        }
    }
}

