/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography;

import dev.whyoleg.cryptography.CryptographyAlgorithm;
import dev.whyoleg.cryptography.CryptographyAlgorithmId;
import dev.whyoleg.cryptography.CryptographyProviderApi;
import dev.whyoleg.cryptography.CryptographySystem;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.SubclassOptInRequired;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b'\u0018\u0000 \u00102\u00020\u0001:\u0002\u000f\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\b\u001a\u0004\u0018\u0001H\t\"\b\b\u0000\u0010\t*\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\fH&\u00a2\u0006\u0002\u0010\rJ%\u0010\u000e\u001a\u0002H\t\"\b\b\u0000\u0010\t*\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\fH\u0016\u00a2\u0006\u0002\u0010\rR\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Ldev/whyoleg/cryptography/CryptographyProvider;", "", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "getOrNull", "A", "Ldev/whyoleg/cryptography/CryptographyAlgorithm;", "identifier", "Ldev/whyoleg/cryptography/CryptographyAlgorithmId;", "(Ldev/whyoleg/cryptography/CryptographyAlgorithmId;)Ldev/whyoleg/cryptography/CryptographyAlgorithm;", "get", "Registry", "Companion", "cryptography-core"})
@SubclassOptInRequired(markerClass={CryptographyProviderApi.class})
public abstract class CryptographyProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public abstract String getName();

    @Nullable
    public abstract <A extends CryptographyAlgorithm> A getOrNull(@NotNull CryptographyAlgorithmId<A> var1);

    @NotNull
    public <A extends CryptographyAlgorithm> A get(@NotNull CryptographyAlgorithmId<A> identifier) {
        Intrinsics.checkNotNullParameter(identifier, (String)"identifier");
        A a = this.getOrNull(identifier);
        if (a == null) {
            throw new IllegalStateException("Algorithm not found: " + identifier);
        }
        return a;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Ldev/whyoleg/cryptography/CryptographyProvider$Companion;", "", "<init>", "()V", "Default", "Ldev/whyoleg/cryptography/CryptographyProvider;", "getDefault", "()Ldev/whyoleg/cryptography/CryptographyProvider;", "cryptography-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CryptographyProvider getDefault() {
            return CryptographySystem.INSTANCE.getDefaultProvider();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Deprecated(message="Replaced by CryptographySystem", level=DeprecationLevel.ERROR)
    @CryptographyProviderApi
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0007J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\rH\u0007R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Ldev/whyoleg/cryptography/CryptographyProvider$Registry;", "", "<init>", "()V", "registeredProviders", "Lkotlin/sequences/Sequence;", "Ldev/whyoleg/cryptography/CryptographyProvider;", "getRegisteredProviders$annotations", "getRegisteredProviders", "()Lkotlin/sequences/Sequence;", "registerProvider", "", "provider", "Lkotlin/Lazy;", "cryptography-core"})
    public static final class Registry {
        @NotNull
        public static final Registry INSTANCE = new Registry();

        private Registry() {
        }

        @NotNull
        public final Sequence<CryptographyProvider> getRegisteredProviders() {
            return CollectionsKt.asSequence((Iterable)CryptographySystem.INSTANCE.getRegisteredProviders());
        }

        @Deprecated(message="Use CryptographySystem::getRegisteredProviders", replaceWith=@ReplaceWith(expression="CryptographySystem.getRegisteredProviders().asSequence()", imports={"dev.whyoleg.cryptography.CryptographySystem"}), level=DeprecationLevel.ERROR)
        public static /* synthetic */ void getRegisteredProviders$annotations() {
        }

        @Deprecated(message="Use CryptographySystem::registerProvider", replaceWith=@ReplaceWith(expression="CryptographySystem.registerProvider(lazyOf(provider), 0)", imports={"dev.whyoleg.cryptography.CryptographySystem"}), level=DeprecationLevel.ERROR)
        public final void registerProvider(@NotNull CryptographyProvider provider) {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            CryptographySystem.INSTANCE.registerProvider((Lazy<? extends CryptographyProvider>)LazyKt.lazyOf((Object)provider), 0);
        }

        @Deprecated(message="Use CryptographySystem::registerProvider", replaceWith=@ReplaceWith(expression="CryptographySystem.registerProvider(provider, 0)", imports={"dev.whyoleg.cryptography.CryptographySystem"}), level=DeprecationLevel.ERROR)
        public final void registerProvider(@NotNull Lazy<? extends CryptographyProvider> provider) {
            Intrinsics.checkNotNullParameter(provider, (String)"provider");
            CryptographySystem.INSTANCE.registerProvider(provider, 0);
        }
    }
}

