/*
 * Decompiled with CFR 0.152.
 */
package com.mohamedrejeb.richeditor.parser.markdown;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.SpanStyle;
import androidx.compose.ui.text.font.FontStyle;
import androidx.compose.ui.text.font.FontWeight;
import androidx.compose.ui.text.style.TextDecoration;
import androidx.compose.ui.unit.TextUnit;
import androidx.compose.ui.unit.TextUnitKt;
import com.mohamedrejeb.richeditor.model.RichSpan;
import com.mohamedrejeb.richeditor.model.RichSpanStyle;
import com.mohamedrejeb.richeditor.model.RichTextState;
import com.mohamedrejeb.richeditor.paragraph.RichParagraph;
import com.mohamedrejeb.richeditor.paragraph.type.ConfigurableListLevel;
import com.mohamedrejeb.richeditor.paragraph.type.DefaultParagraph;
import com.mohamedrejeb.richeditor.paragraph.type.OrderedList;
import com.mohamedrejeb.richeditor.paragraph.type.ParagraphType;
import com.mohamedrejeb.richeditor.paragraph.type.UnorderedList;
import com.mohamedrejeb.richeditor.parser.RichTextStateParser;
import com.mohamedrejeb.richeditor.parser.html.RichTextStateHtmlParser;
import com.mohamedrejeb.richeditor.parser.html.RichTextStateHtmlParserKt;
import com.mohamedrejeb.richeditor.parser.markdown.MarkdownUtilsKt;
import com.mohamedrejeb.richeditor.parser.utils.ElementsSpanStyleKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.flavours.gfm.GFMElementTypes;
import org.intellij.markdown.flavours.gfm.GFMTokenTypes;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0000\b\u00c1\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u0018\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u0010*\u00060\u0011j\u0002`\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0002H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010 \u001a\u00020\u00022\u0006\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020\u001aH\u0002J\u0010\u0010#\u001a\u00020\u00022\u0006\u0010$\u001a\u00020\fH\u0002R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00170&X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/mohamedrejeb/richeditor/parser/markdown/RichTextStateMarkdownParser;", "Lcom/mohamedrejeb/richeditor/parser/RichTextStateParser;", "", "<init>", "()V", "encode", "Lcom/mohamedrejeb/richeditor/model/RichTextState;", "input", "decode", "richTextState", "decodeRichSpanToMarkdown", "richSpan", "Lcom/mohamedrejeb/richeditor/model/RichSpan;", "isHeading", "", "appendParagraphStartText", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "paragraph", "Lcom/mohamedrejeb/richeditor/paragraph/RichParagraph;", "markdownElementsSpanStyleEncodeMap", "", "Lorg/intellij/markdown/IElementType;", "Landroidx/compose/ui/text/SpanStyle;", "encodeMarkdownElementToRichSpanStyle", "Lcom/mohamedrejeb/richeditor/model/RichSpanStyle;", "node", "Lorg/intellij/markdown/ast/ASTNode;", "markdown", "encodeRichParagraphTypeFromMarkdownElement", "Lcom/mohamedrejeb/richeditor/paragraph/type/ParagraphType;", "decodeMarkdownElementFromRichSpan", "text", "richSpanStyle", "getMarkdownLineStartTextFromFirstRichSpan", "firstRichSpan", "markdownBlockElements", "", "richeditor-compose"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nRichTextStateMarkdownParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RichTextStateMarkdownParser.kt\ncom/mohamedrejeb/richeditor/parser/markdown/RichTextStateMarkdownParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 4 TextUnit.kt\nandroidx/compose/ui/unit/TextUnit\n*L\n1#1,618:1\n1878#2,3:619\n1869#2,2:622\n71#3,3:624\n35#3,5:627\n75#3:632\n35#3,5:633\n182#4,2:638\n182#4,2:640\n182#4,2:642\n182#4,2:644\n182#4,2:646\n182#4,2:648\n*S KotlinDebug\n*F\n+ 1 RichTextStateMarkdownParser.kt\ncom/mohamedrejeb/richeditor/parser/markdown/RichTextStateMarkdownParser\n*L\n338#1:619,3\n359#1:622,2\n373#1:624,3\n389#1:627,5\n373#1:632\n459#1:633,5\n580#1:638,2\n581#1:640,2\n582#1:642,2\n583#1:644,2\n584#1:646,2\n585#1:648,2\n*E\n"})
public final class RichTextStateMarkdownParser
implements RichTextStateParser<String> {
    @NotNull
    public static final RichTextStateMarkdownParser INSTANCE = new RichTextStateMarkdownParser();
    @NotNull
    private static final Map<IElementType, SpanStyle> markdownElementsSpanStyleEncodeMap;
    @NotNull
    private static final Set<IElementType> markdownBlockElements;
    public static final int $stable;

    private RichTextStateMarkdownParser() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public RichTextState encode(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        List openedNodes = new ArrayList();
        List openedHtmlTags = new ArrayList();
        Object[] objectArray = new RichParagraph[]{new RichParagraph(0, null, null, null, 15, null)};
        List richParagraphList = CollectionsKt.mutableListOf((Object[])objectArray);
        Ref.ObjectRef brParagraphIndices = new Ref.ObjectRef();
        brParagraphIndices.element = new ArrayList();
        Ref.ObjectRef currentRichSpan = new Ref.ObjectRef();
        Ref.ObjectRef currentRichParagraphType = new Ref.ObjectRef();
        currentRichParagraphType.element = new DefaultParagraph();
        Ref.IntRef currentListLevel = new Ref.IntRef();
        MarkdownUtilsKt.encodeMarkdownToRichText(input, (Function1<? super ASTNode, Unit>)((Function1)arg_0 -> RichTextStateMarkdownParser.encode$lambda$0(openedNodes, currentListLevel, richParagraphList, currentRichParagraphType, currentRichSpan, input, arg_0)), (Function1<? super ASTNode, Unit>)((Function1)arg_0 -> RichTextStateMarkdownParser.encode$lambda$2(openedNodes, currentListLevel, currentRichSpan, richParagraphList, brParagraphIndices, currentRichParagraphType, arg_0)), (Function1<? super String, Unit>)((Function1)arg_0 -> RichTextStateMarkdownParser.encode$lambda$3(richParagraphList, currentRichSpan, openedNodes, arg_0)), (Function1<? super String, Unit>)((Function1)arg_0 -> RichTextStateMarkdownParser.encode$lambda$4(openedHtmlTags, currentRichSpan, richParagraphList, brParagraphIndices, arg_0)), (Function1<? super String, Unit>)((Function1)arg_0 -> RichTextStateMarkdownParser.encode$lambda$5(richParagraphList, brParagraphIndices, currentRichSpan, arg_0)));
        List toDeleteParagraphIndices = new ArrayList();
        int lastNonEmptyParagraphIndex = 0;
        lastNonEmptyParagraphIndex = -1;
        int lastBrParagraphIndex = 0;
        lastBrParagraphIndex = -1;
        Iterable $this$forEachIndexed$iv = richParagraphList;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            IntRange range;
            void paragraph;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            RichParagraph richParagraph = (RichParagraph)item$iv;
            int i = n;
            boolean bl = false;
            paragraph.trim();
            boolean isEmpty = RichParagraph.isEmpty$default((RichParagraph)paragraph, false, 1, null);
            boolean isBr = ((List)brParagraphIndices.element).contains(i);
            if (isBr && lastNonEmptyParagraphIndex < lastBrParagraphIndex && !(range = new IntRange(lastBrParagraphIndex + 1, i - 1)).isEmpty()) {
                CollectionsKt.addAll((Collection)toDeleteParagraphIndices, (Iterable)((Iterable)range));
            }
            if (!isEmpty) {
                lastNonEmptyParagraphIndex = i;
            }
            if (!isBr) continue;
            lastBrParagraphIndex = i;
        }
        Iterable $this$forEach$iv = CollectionsKt.reversed((Iterable)toDeleteParagraphIndices);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int i = ((Number)element$iv).intValue();
            boolean bl = false;
            richParagraphList.remove(i);
        }
        return new RichTextState(richParagraphList);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String decode(@NotNull RichTextState richTextState) {
        Intrinsics.checkNotNullParameter((Object)richTextState, (String)"richTextState");
        StringBuilder builder = new StringBuilder();
        boolean useLineBreak = false;
        List $this$fastForEachIndexed$iv = (List)richTextState.getRichParagraphList$richeditor_compose();
        boolean $i$f$fastForEachIndexed = false;
        int n = ((Collection)$this$fastForEachIndexed$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            void richParagraph;
            Object item$iv = $this$fastForEachIndexed$iv.get(index$iv);
            RichParagraph richParagraph2 = (RichParagraph)item$iv;
            int index = index$iv;
            boolean bl = false;
            INSTANCE.appendParagraphStartText(builder, (RichParagraph)richParagraph);
            boolean isHeading = false;
            if (RichParagraph.getFirstNonEmptyChild$default((RichParagraph)richParagraph, 0, 1, null) != null) {
                RichSpan firstNonEmptyChild;
                boolean bl2 = false;
                if (((CharSequence)firstNonEmptyChild.getText()).length() > 0) {
                    String lineStartText = INSTANCE.getMarkdownLineStartTextFromFirstRichSpan(firstNonEmptyChild);
                    builder.append(lineStartText);
                    isHeading = StringsKt.startsWith$default((CharSequence)lineStartText, (char)'#', (boolean)false, (int)2, null);
                }
            }
            List<RichSpan> $this$fastForEach$iv = richParagraph.getChildren();
            boolean $i$f$fastForEach = false;
            int n2 = ((Collection)$this$fastForEach$iv).size();
            for (int index$iv2 = 0; index$iv2 < n2; ++index$iv2) {
                RichSpan item$iv2;
                RichSpan richSpan = item$iv2 = $this$fastForEach$iv.get(index$iv2);
                boolean bl3 = false;
                builder.append(INSTANCE.decodeRichSpanToMarkdown(richSpan, isHeading));
            }
            boolean isBlank = RichParagraph.isBlank$default((RichParagraph)richParagraph, false, 1, null);
            if (useLineBreak && isBlank) {
                builder.append("<br>");
            }
            useLineBreak = isBlank;
            if (index >= CollectionsKt.getLastIndex((List)((List)richTextState.getRichParagraphList$richeditor_compose()))) continue;
            builder.append('\n');
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return MarkdownUtilsKt.correctMarkdownText(string);
    }

    private final String decodeRichSpanToMarkdown(RichSpan richSpan, boolean isHeading) {
        StringBuilder stringBuilder = new StringBuilder();
        if (richSpan.isEmpty()) {
            return "";
        }
        boolean isBlank = richSpan.isBlank();
        List markdownOpen = new ArrayList();
        List markdownClose = new ArrayList();
        FontWeight fontWeight = richSpan.getSpanStyle().getFontWeight();
        if ((fontWeight != null ? fontWeight.getWeight() : 400) > 400 && !isHeading) {
            ((Collection)markdownOpen).add("**");
            ((Collection)markdownClose).add("**");
        }
        FontStyle fontStyle = richSpan.getSpanStyle().getFontStyle-4Lr2A7w();
        int n = FontStyle.Companion.getItalic-_-LCdwA();
        FontStyle fontStyle2 = fontStyle;
        if (fontStyle2 == null ? false : FontStyle.equals-impl0((int)fontStyle2.unbox-impl(), (int)n)) {
            ((Collection)markdownOpen).add("*");
            ((Collection)markdownClose).add("*");
        }
        TextDecoration textDecoration = richSpan.getSpanStyle().getTextDecoration();
        boolean bl = textDecoration != null ? textDecoration.contains(TextDecoration.Companion.getLineThrough()) : false;
        if (bl) {
            ((Collection)markdownOpen).add("~~");
            ((Collection)markdownClose).add("~~");
        }
        TextDecoration textDecoration2 = richSpan.getSpanStyle().getTextDecoration();
        boolean bl2 = textDecoration2 != null ? textDecoration2.contains(TextDecoration.Companion.getUnderline()) : false;
        if (bl2) {
            ((Collection)markdownOpen).add("<u>");
            ((Collection)markdownClose).add("</u>");
        }
        if (!isBlank && !((Collection)markdownOpen).isEmpty()) {
            stringBuilder.append(CollectionsKt.joinToString$default((Iterable)markdownOpen, (CharSequence)"", null, null, (int)0, null, null, (int)62, null));
        }
        String spanMarkdown = this.decodeMarkdownElementFromRichSpan(richSpan.getText(), richSpan.getRichSpanStyle());
        stringBuilder.append(spanMarkdown);
        List<RichSpan> $this$fastForEach$iv = richSpan.getChildren();
        boolean $i$f$fastForEach = false;
        int n2 = ((Collection)$this$fastForEach$iv).size();
        for (int index$iv = 0; index$iv < n2; ++index$iv) {
            RichSpan item$iv;
            RichSpan child = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl3 = false;
            stringBuilder.append(INSTANCE.decodeRichSpanToMarkdown(child, isHeading));
        }
        if (!isBlank && !((Collection)markdownClose).isEmpty()) {
            stringBuilder.append(CollectionsKt.joinToString$default((Iterable)CollectionsKt.reversed((Iterable)markdownClose), (CharSequence)"", null, null, (int)0, null, null, (int)62, null));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void appendParagraphStartText(StringBuilder $this$appendParagraphStartText, RichParagraph paragraph) {
        ParagraphType type = paragraph.getType();
        Object object = type instanceof OrderedList ? $this$appendParagraphStartText.append(StringsKt.repeat((CharSequence)"  ", (int)(((OrderedList)type).getLevel() - 1)) + ((OrderedList)type).getNumber() + ". ") : (type instanceof UnorderedList ? $this$appendParagraphStartText.append(StringsKt.repeat((CharSequence)"  ", (int)(((UnorderedList)type).getLevel() - 1)) + "- ") : Unit.INSTANCE);
    }

    private final RichSpanStyle encodeMarkdownElementToRichSpanStyle(ASTNode node, String markdown) {
        RichSpanStyle richSpanStyle;
        ASTNode aSTNode = node.getParent();
        boolean isImage = Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getType() : null), (Object)MarkdownElementTypes.IMAGE);
        IElementType iElementType = node.getType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)GFMTokenTypes.GFM_AUTOLINK)) {
            String destination = ((Object)ASTUtilKt.getTextInNode((ASTNode)node, (CharSequence)markdown)).toString();
            richSpanStyle = new RichSpanStyle.Link(destination);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.INLINE_LINK)) {
            String destination;
            CharSequence charSequence;
            ASTNode aSTNode2 = ASTUtilKt.findChildOfType((ASTNode)node, (IElementType)MarkdownElementTypes.LINK_DESTINATION);
            String string = aSTNode2 != null && (charSequence = ASTUtilKt.getTextInNode((ASTNode)aSTNode2, (CharSequence)markdown)) != null ? ((Object)charSequence).toString() : null;
            if (string == null) {
                string = destination = "";
            }
            richSpanStyle = isImage ? (RichSpanStyle)new RichSpanStyle.Image(destination, TextUnitKt.getSp((int)0), TextUnitKt.getSp((int)0), null, 8, null) : (RichSpanStyle)new RichSpanStyle.Link(destination);
        } else {
            richSpanStyle = Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.CODE_SPAN) ? (RichSpanStyle)new RichSpanStyle.Code(0L, 0L, null, 7, null) : (RichSpanStyle)RichSpanStyle.Default.INSTANCE;
        }
        return richSpanStyle;
    }

    private final ParagraphType encodeRichParagraphTypeFromMarkdownElement(ASTNode node) {
        IElementType iElementType = node.getType();
        return Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.UNORDERED_LIST) ? (ParagraphType)new UnorderedList(0, 1, null) : (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ORDERED_LIST) ? (ParagraphType)new OrderedList(0, 0, 2, null) : (ParagraphType)new DefaultParagraph());
    }

    private final String decodeMarkdownElementFromRichSpan(String text, RichSpanStyle richSpanStyle) {
        RichSpanStyle richSpanStyle2 = richSpanStyle;
        return richSpanStyle2 instanceof RichSpanStyle.Link ? "[" + text + "](" + ((RichSpanStyle.Link)richSpanStyle).getUrl() + ")" : (richSpanStyle2 instanceof RichSpanStyle.Code ? "`" + text + "`" : text);
    }

    private final String getMarkdownLineStartTextFromFirstRichSpan(RichSpan firstRichSpan) {
        String string;
        FontWeight fontWeight = firstRichSpan.getSpanStyle().getFontWeight();
        if ((fontWeight != null ? fontWeight.getWeight() : 400) <= 400) {
            return "";
        }
        long fontSize = firstRichSpan.getSpanStyle().getFontSize-XSAIIZE();
        if (TextUnit.isEm-impl((long)fontSize)) {
            long other$iv = ElementsSpanStyleKt.getH1SpanStyle().getFontSize-XSAIIZE();
            boolean bl = false;
            TextUnitKt.checkArithmetic-NB67dxo((long)fontSize, (long)other$iv);
            if (Float.compare(TextUnit.getValue-impl((long)fontSize), TextUnit.getValue-impl((long)other$iv)) >= 0) {
                string = "# ";
            } else {
                other$iv = ElementsSpanStyleKt.getH2SpanStyle().getFontSize-XSAIIZE();
                bl = false;
                TextUnitKt.checkArithmetic-NB67dxo((long)fontSize, (long)other$iv);
                if (Float.compare(TextUnit.getValue-impl((long)fontSize), TextUnit.getValue-impl((long)other$iv)) >= 0) {
                    string = "## ";
                } else {
                    other$iv = ElementsSpanStyleKt.getH3SpanStyle().getFontSize-XSAIIZE();
                    bl = false;
                    TextUnitKt.checkArithmetic-NB67dxo((long)fontSize, (long)other$iv);
                    if (Float.compare(TextUnit.getValue-impl((long)fontSize), TextUnit.getValue-impl((long)other$iv)) >= 0) {
                        string = "### ";
                    } else {
                        other$iv = ElementsSpanStyleKt.getH4SpanStyle().getFontSize-XSAIIZE();
                        bl = false;
                        TextUnitKt.checkArithmetic-NB67dxo((long)fontSize, (long)other$iv);
                        if (Float.compare(TextUnit.getValue-impl((long)fontSize), TextUnit.getValue-impl((long)other$iv)) >= 0) {
                            string = "#### ";
                        } else {
                            other$iv = ElementsSpanStyleKt.getH5SpanStyle().getFontSize-XSAIIZE();
                            bl = false;
                            TextUnitKt.checkArithmetic-NB67dxo((long)fontSize, (long)other$iv);
                            if (Float.compare(TextUnit.getValue-impl((long)fontSize), TextUnit.getValue-impl((long)other$iv)) >= 0) {
                                string = "##### ";
                            } else {
                                other$iv = ElementsSpanStyleKt.getH6SpanStyle().getFontSize-XSAIIZE();
                                bl = false;
                                TextUnitKt.checkArithmetic-NB67dxo((long)fontSize, (long)other$iv);
                                string = Float.compare(TextUnit.getValue-impl((long)fontSize), TextUnit.getValue-impl((long)other$iv)) >= 0 ? "###### " : "";
                            }
                        }
                    }
                }
            }
        } else {
            string = TextUnit.getValue-impl((long)fontSize) >= TextUnit.getValue-impl((long)ElementsSpanStyleKt.getH1SpanStyle().getFontSize-XSAIIZE()) * (float)16 ? "# " : (TextUnit.getValue-impl((long)fontSize) >= TextUnit.getValue-impl((long)ElementsSpanStyleKt.getH2SpanStyle().getFontSize-XSAIIZE()) * (float)16 ? "## " : (TextUnit.getValue-impl((long)fontSize) >= TextUnit.getValue-impl((long)ElementsSpanStyleKt.getH3SpanStyle().getFontSize-XSAIIZE()) * (float)16 ? "### " : (TextUnit.getValue-impl((long)fontSize) >= TextUnit.getValue-impl((long)ElementsSpanStyleKt.getH4SpanStyle().getFontSize-XSAIIZE()) * (float)16 ? "#### " : (TextUnit.getValue-impl((long)fontSize) >= TextUnit.getValue-impl((long)ElementsSpanStyleKt.getH5SpanStyle().getFontSize-XSAIIZE()) * (float)16 ? "##### " : (TextUnit.getValue-impl((long)fontSize) >= TextUnit.getValue-impl((long)ElementsSpanStyleKt.getH6SpanStyle().getFontSize-XSAIIZE()) * (float)16 ? "###### " : "")))));
        }
        return string;
    }

    private static final void encode$onAddLineBreak(List<RichParagraph> richParagraphList, Ref.ObjectRef<List<Integer>> brParagraphIndices, Ref.ObjectRef<RichSpan> currentRichSpan) {
        block4: {
            block3: {
                RichParagraph lastParagraph = (RichParagraph)CollectionsKt.lastOrNull(richParagraphList);
                RichParagraph beforeLastParagraph = (RichParagraph)CollectionsKt.getOrNull(richParagraphList, (int)(CollectionsKt.getLastIndex(richParagraphList) - 1));
                Integer lastBrIndex = (Integer)CollectionsKt.lastOrNull((List)((List)brParagraphIndices.element));
                Integer beforeLastBrIndex = (Integer)CollectionsKt.getOrNull((List)((List)brParagraphIndices.element), (int)(CollectionsKt.getLastIndex((List)((List)brParagraphIndices.element)) - 1));
                RichParagraph richParagraph = lastParagraph;
                boolean bl = richParagraph != null ? RichParagraph.isEmpty$default(richParagraph, false, 1, null) : false;
                if (!bl) break block3;
                RichParagraph richParagraph2 = beforeLastParagraph;
                boolean bl2 = richParagraph2 != null ? RichParagraph.isEmpty$default(richParagraph2, false, 1, null) : false;
                if (!bl2) break block3;
                Integer n = lastBrIndex;
                int n2 = CollectionsKt.getLastIndex(richParagraphList);
                if (n != null && n == n2) break block3;
                Integer n3 = beforeLastBrIndex;
                n2 = CollectionsKt.getLastIndex(richParagraphList) - 1;
                if (n3 == null || n3 != n2) break block4;
            }
            richParagraphList.add(new RichParagraph(0, null, null, null, 15, null));
        }
        ((List)brParagraphIndices.element).add(CollectionsKt.getLastIndex(richParagraphList));
        currentRichSpan.element = null;
    }

    private static final void encode$onText(List<RichParagraph> richParagraphList, Ref.ObjectRef<RichSpan> currentRichSpan, List<ASTNode> openedNodes, String text) {
        block10: {
            ASTNode lastOpenedNode;
            RichSpan safeCurrentRichSpan;
            String text2 = StringsKt.replace$default((String)text, (char)'\n', (char)' ', (boolean)false, (int)4, null);
            if (((CharSequence)text2).length() == 0) {
                return;
            }
            if (richParagraphList.isEmpty()) {
                richParagraphList.add(new RichParagraph(0, null, null, null, 15, null));
            }
            RichParagraph currentRichParagraph = (RichParagraph)CollectionsKt.last(richParagraphList);
            RichSpan richSpan = (RichSpan)currentRichSpan.element;
            if (richSpan == null) {
                richSpan = new RichSpan(null, null, currentRichParagraph, null, null, 0L, null, null, 251, null);
            }
            if ((safeCurrentRichSpan = richSpan).getChildren().isEmpty()) {
                safeCurrentRichSpan.setText(safeCurrentRichSpan.getText() + text2);
            } else {
                RichSpan newRichSpan = new RichSpan(null, null, currentRichParagraph, safeCurrentRichSpan, null, 0L, null, null, 243, null);
                newRichSpan.setText(text2);
                safeCurrentRichSpan.getChildren().add(newRichSpan);
            }
            if (currentRichSpan.element == null) {
                currentRichSpan.element = safeCurrentRichSpan;
                currentRichParagraph.getChildren().add(safeCurrentRichSpan);
            }
            RichSpan richSpan2 = (RichSpan)currentRichSpan.element;
            RichSpanStyle currentRichSpanRichSpanStyle = richSpan2 != null ? richSpan2.getRichSpanStyle() : null;
            ASTNode aSTNode = lastOpenedNode = (ASTNode)CollectionsKt.lastOrNull(openedNodes);
            if (Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getType() : null), (Object)MarkdownElementTypes.IMAGE) && Intrinsics.areEqual((Object)text2, (Object)"!")) {
                RichSpan richSpan3 = (RichSpan)currentRichSpan.element;
                if (richSpan3 != null) {
                    richSpan3.setText("");
                }
            }
            if (!(currentRichSpanRichSpanStyle instanceof RichSpanStyle.Image)) break block10;
            RichSpan richSpan4 = (RichSpan)currentRichSpan.element;
            if (richSpan4 != null) {
                richSpan4.setRichSpanStyle(new RichSpanStyle.Image(((RichSpanStyle.Image)currentRichSpanRichSpanStyle).getModel(), ((RichSpanStyle.Image)currentRichSpanRichSpanStyle).getWidth-XSAIIZE(), ((RichSpanStyle.Image)currentRichSpanRichSpanStyle).getHeight-XSAIIZE(), text2, null));
            }
            RichSpan richSpan5 = (RichSpan)currentRichSpan.element;
            if (richSpan5 != null) {
                richSpan5.setText("");
            }
        }
    }

    private static final Unit encode$lambda$0(List $openedNodes, Ref.IntRef $currentListLevel, List $richParagraphList, Ref.ObjectRef $currentRichParagraphType, Ref.ObjectRef $currentRichSpan, String $input, ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        $openedNodes.add(node);
        if (Intrinsics.areEqual((Object)node.getType(), (Object)MarkdownElementTypes.LIST_ITEM)) {
            int n = $currentListLevel.element;
            $currentListLevel.element = n + 1;
        }
        SpanStyle tagSpanStyle = markdownElementsSpanStyleEncodeMap.get(node.getType());
        if (markdownBlockElements.contains(node.getType())) {
            RichParagraph currentRichParagraph = (RichParagraph)CollectionsKt.last((List)$richParagraphList);
            if ($currentRichParagraphType.element instanceof DefaultParagraph) {
                ParagraphType paragraphType = INSTANCE.encodeRichParagraphTypeFromMarkdownElement(node);
                $currentRichParagraphType.element = paragraphType;
            }
            if (Intrinsics.areEqual((Object)node.getType(), (Object)MarkdownElementTypes.LIST_ITEM)) {
                $currentRichParagraphType.element = ((ParagraphType)$currentRichParagraphType.element).getNextParagraphType();
                if ($currentRichParagraphType.element instanceof ConfigurableListLevel) {
                    Object object = $currentRichParagraphType.element;
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.mohamedrejeb.richeditor.paragraph.type.ConfigurableListLevel");
                    ((ConfigurableListLevel)object).setLevel($currentListLevel.element);
                }
                currentRichParagraph.setType((ParagraphType)$currentRichParagraphType.element);
            }
            RichSpan newRichSpan = new RichSpan(null, null, currentRichParagraph, null, null, 0L, null, null, 251, null);
            SpanStyle spanStyle = tagSpanStyle;
            if (spanStyle == null) {
                spanStyle = new SpanStyle(0L, 0L, null, null, null, null, null, 0L, null, null, null, 0L, null, null, null, null, 65535, null);
            }
            newRichSpan.setSpanStyle(spanStyle);
            if (!Intrinsics.areEqual((Object)newRichSpan.getSpanStyle(), (Object)new SpanStyle(0L, 0L, null, null, null, null, null, 0L, null, null, null, 0L, null, null, null, null, 65535, null))) {
                $currentRichSpan.element = newRichSpan;
                currentRichParagraph.getChildren().add(newRichSpan);
            } else {
                $currentRichSpan.element = null;
            }
        } else if (!Intrinsics.areEqual((Object)node.getType(), (Object)MarkdownTokenTypes.EOL)) {
            RichSpan newRichSpanParent;
            RichSpan richSpan;
            RichSpanStyle richSpanStyle = INSTANCE.encodeMarkdownElementToRichSpanStyle(node, $input);
            if ($richParagraphList.isEmpty()) {
                $richParagraphList.add(new RichParagraph(0, null, null, null, 15, null));
            }
            RichParagraph currentRichParagraph = (RichParagraph)CollectionsKt.last((List)$richParagraphList);
            RichSpan newRichSpan = new RichSpan(null, null, currentRichParagraph, null, null, 0L, null, null, 251, null);
            SpanStyle spanStyle = tagSpanStyle;
            if (spanStyle == null) {
                spanStyle = new SpanStyle(0L, 0L, null, null, null, null, null, 0L, null, null, null, 0L, null, null, null, null, 65535, null);
            }
            newRichSpan.setSpanStyle(spanStyle);
            newRichSpan.setRichSpanStyle(richSpanStyle);
            RichSpan richSpan2 = (RichSpan)$currentRichSpan.element;
            RichSpan currentRichSpanParent = richSpan2 != null ? richSpan2.getParent() : null;
            RichSpan richSpan3 = (RichSpan)$currentRichSpan.element;
            if (Intrinsics.areEqual((Object)(richSpan3 != null ? richSpan3.getFullSpanStyle() : null), (Object)new SpanStyle(0L, 0L, null, null, null, null, null, 0L, null, null, null, 0L, null, null, null, null, 65535, null))) {
                RichSpan richSpan4 = (RichSpan)$currentRichSpan.element;
                if ((richSpan4 != null ? richSpan4.getFullStyle() : null) instanceof RichSpanStyle.Default) {
                    RichSpan richSpan5 = (RichSpan)$currentRichSpan.element;
                    boolean bl = richSpan5 != null ? richSpan5.isEmpty() : false;
                    if (bl) {
                        RichSpan richSpan6 = currentRichSpanParent != null ? currentRichSpanParent.getChildren().remove(CollectionsKt.getLastIndex(currentRichSpanParent.getChildren())) : currentRichParagraph.getChildren().remove(CollectionsKt.getLastIndex(currentRichParagraph.getChildren()));
                    }
                    $currentRichSpan.element = null;
                }
            }
            if ((richSpan = (RichSpan)$currentRichSpan.element) == null) {
                richSpan = currentRichSpanParent;
            }
            if ((newRichSpanParent = richSpan) != null) {
                newRichSpan.setParent(newRichSpanParent);
                newRichSpanParent.getChildren().add(newRichSpan);
                $currentRichSpan.element = newRichSpan;
            } else {
                currentRichParagraph.getChildren().add(newRichSpan);
                $currentRichSpan.element = newRichSpan;
            }
            ASTNode aSTNode = (ASTNode)CollectionsKt.getOrNull((List)$openedNodes, (int)(CollectionsKt.getLastIndex((List)$openedNodes) - 1));
            if (!Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getType() : null), (Object)GFMElementTypes.INLINE_MATH) && Intrinsics.areEqual((Object)node.getType(), (Object)GFMTokenTypes.DOLLAR)) {
                newRichSpan.setText(StringsKt.repeat((CharSequence)"$", (int)(node.getEndOffset() - node.getStartOffset())));
            }
        }
        if (Intrinsics.areEqual((Object)node.getType(), (Object)GFMTokenTypes.GFM_AUTOLINK) || Intrinsics.areEqual((Object)node.getType(), (Object)MarkdownTokenTypes.CODE_LINE)) {
            RichTextStateMarkdownParser.encode$onText($richParagraphList, (Ref.ObjectRef<RichSpan>)$currentRichSpan, $openedNodes, ((Object)ASTUtilKt.getTextInNode((ASTNode)node, (CharSequence)$input)).toString());
        }
        return Unit.INSTANCE;
    }

    private static final Unit encode$lambda$2(List $openedNodes, Ref.IntRef $currentListLevel, Ref.ObjectRef $currentRichSpan, List $richParagraphList, Ref.ObjectRef $brParagraphIndices, Ref.ObjectRef $currentRichParagraphType, ASTNode node) {
        boolean isLastList;
        block22: {
            block24: {
                block23: {
                    Object object;
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    CollectionsKt.removeLastOrNull((List)$openedNodes);
                    if (Intrinsics.areEqual((Object)node.getType(), (Object)MarkdownElementTypes.LIST_ITEM)) {
                        int n = $currentListLevel.element;
                        $currentListLevel.element = n + -1;
                    }
                    RichSpan richSpan = (RichSpan)$currentRichSpan.element;
                    boolean bl = richSpan != null ? richSpan.isEmpty() : false;
                    if (bl) {
                        Collection collection;
                        RichSpan parent;
                        RichSpan richSpan2 = (RichSpan)$currentRichSpan.element;
                        RichSpan richSpan3 = parent = richSpan2 != null ? richSpan2.getParent() : null;
                        if (parent != null) {
                            Object object2 = (RichSpan)$currentRichSpan.element;
                            if (object2 != null && (object2 = ((RichSpan)object2).getParent()) != null && (object2 = ((RichSpan)object2).getChildren()) != null) {
                                collection = (Collection)object2;
                                Object object3 = $currentRichSpan.element;
                                TypeIntrinsics.asMutableCollection((Object)collection).remove(object3);
                            }
                        } else {
                            Object object4 = (RichSpan)$currentRichSpan.element;
                            if (object4 != null && (object4 = ((RichSpan)object4).getParagraph()) != null && (object4 = ((RichParagraph)object4).getChildren()) != null) {
                                collection = (Collection)object4;
                                Object object5 = $currentRichSpan.element;
                                TypeIntrinsics.asMutableCollection((Object)collection).remove(object5);
                            }
                        }
                    }
                    boolean bl2 = (object = (RichSpan)$currentRichSpan.element) != null && (object = ((RichSpan)object).getText()) != null ? ((CharSequence)object).length() == 0 : false;
                    if (bl2) {
                        Object object6 = (RichSpan)$currentRichSpan.element;
                        boolean bl3 = object6 != null && (object6 = ((RichSpan)object6).getChildren()) != null ? object6.size() == 1 : false;
                        if (bl3) {
                            Object object7 = (RichSpan)$currentRichSpan.element;
                            if (object7 != null && (object7 = ((RichSpan)object7).getChildren()) != null && (object7 = (RichSpan)CollectionsKt.firstOrNull((List)object7)) != null) {
                                Object object8;
                                Object object9;
                                Object child = object7;
                                boolean bl4 = false;
                                RichSpan richSpan4 = (RichSpan)$currentRichSpan.element;
                                if (richSpan4 != null) {
                                    richSpan4.setText(((RichSpan)child).getText());
                                }
                                RichSpan richSpan5 = (RichSpan)$currentRichSpan.element;
                                if (richSpan5 != null) {
                                    RichSpan richSpan6 = (RichSpan)$currentRichSpan.element;
                                    if (richSpan6 == null || (richSpan6 = richSpan6.getSpanStyle()) == null || (richSpan6 = richSpan6.merge(((RichSpan)child).getSpanStyle())) == null) {
                                        richSpan6 = ((RichSpan)child).getSpanStyle();
                                    }
                                    richSpan5.setSpanStyle((SpanStyle)richSpan6);
                                }
                                RichSpan richSpan7 = (RichSpan)$currentRichSpan.element;
                                if (richSpan7 != null) {
                                    richSpan7.setRichSpanStyle(((RichSpan)child).getRichSpanStyle());
                                }
                                if ((object9 = (RichSpan)$currentRichSpan.element) != null && (object9 = ((RichSpan)object9).getChildren()) != null) {
                                    object9.clear();
                                }
                                if ((object8 = (RichSpan)$currentRichSpan.element) != null && (object8 = ((RichSpan)object8).getChildren()) != null) {
                                    object8.addAll((Collection)((RichSpan)child).getChildren());
                                }
                            }
                        }
                    }
                    if (!Intrinsics.areEqual((Object)node.getType(), (Object)MarkdownTokenTypes.EOL)) break block22;
                    RichParagraph lastParagraph = (RichParagraph)CollectionsKt.lastOrNull((List)$richParagraphList);
                    RichParagraph beforeLastParagraph = (RichParagraph)CollectionsKt.getOrNull((List)$richParagraphList, (int)(CollectionsKt.getLastIndex((List)$richParagraphList) - 1));
                    Integer lastBrParagraphIndex = (Integer)CollectionsKt.lastOrNull((List)((List)$brParagraphIndices.element));
                    Integer beforeLastBrParagraphIndex = (Integer)CollectionsKt.getOrNull((List)((List)$brParagraphIndices.element), (int)(CollectionsKt.getLastIndex((List)((List)$brParagraphIndices.element)) - 1));
                    RichParagraph richParagraph = lastParagraph;
                    if (richParagraph != null ? RichParagraph.isNotEmpty$default(richParagraph, false, 1, null) : false) break block23;
                    RichParagraph richParagraph2 = beforeLastParagraph;
                    if (richParagraph2 != null ? RichParagraph.isNotEmpty$default(richParagraph2, false, 1, null) : false) break block23;
                    Integer n = lastBrParagraphIndex;
                    int n2 = CollectionsKt.getLastIndex((List)$richParagraphList);
                    if (n != null && n == n2) break block23;
                    Integer n3 = beforeLastBrParagraphIndex;
                    n2 = CollectionsKt.getLastIndex((List)$richParagraphList) - 1;
                    if (n3 == null || n3 != n2) break block24;
                }
                $richParagraphList.add(new RichParagraph(0, null, null, null, 15, null));
            }
            $currentRichSpan.element = null;
        }
        ASTNode lastOpenedNodes = (ASTNode)CollectionsKt.lastOrNull((List)$openedNodes);
        boolean isList = Intrinsics.areEqual((Object)node.getType(), (Object)MarkdownElementTypes.ORDERED_LIST) || Intrinsics.areEqual((Object)node.getType(), (Object)MarkdownElementTypes.UNORDERED_LIST);
        boolean bl = isLastList = lastOpenedNodes != null && (Intrinsics.areEqual((Object)lastOpenedNodes.getType(), (Object)MarkdownElementTypes.ORDERED_LIST) || Intrinsics.areEqual((Object)lastOpenedNodes.getType(), (Object)MarkdownElementTypes.UNORDERED_LIST) || Intrinsics.areEqual((Object)lastOpenedNodes.getType(), (Object)MarkdownElementTypes.LIST_ITEM));
        if (isList && !isLastList) {
            $currentRichParagraphType.element = new DefaultParagraph();
        }
        RichSpan richSpan = (RichSpan)$currentRichSpan.element;
        $currentRichSpan.element = richSpan != null ? richSpan.getParent() : null;
        return Unit.INSTANCE;
    }

    private static final Unit encode$lambda$3(List $richParagraphList, Ref.ObjectRef $currentRichSpan, List $openedNodes, String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        RichTextStateMarkdownParser.encode$onText($richParagraphList, (Ref.ObjectRef<RichSpan>)$currentRichSpan, $openedNodes, text);
        return Unit.INSTANCE;
    }

    private static final Unit encode$lambda$4(List $openedHtmlTags, Ref.ObjectRef $currentRichSpan, List $richParagraphList, Ref.ObjectRef $brParagraphIndices, String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        String string = ((Object)StringsKt.trim((CharSequence)StringsKt.substringBefore$default((String)StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)StringsKt.substringAfter$default((String)tag, (String)"</", null, (int)2, null), (String)"<", null, (int)2, null), (String)">", null, (int)2, null), (String)" ", null, (int)2, null))).toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String tagName = string;
        boolean isClosingTag = StringsKt.startsWith$default((String)tag, (String)"</", (boolean)false, (int)2, null);
        if (isClosingTag) {
            CollectionsKt.removeLastOrNull((List)$openedHtmlTags);
            if (!Intrinsics.areEqual((Object)tagName, (Object)"br")) {
                RichSpan richSpan = (RichSpan)$currentRichSpan.element;
                $currentRichSpan.element = richSpan != null ? richSpan.getParent() : null;
            }
        } else {
            $openedHtmlTags.add(tag);
            SpanStyle tagSpanStyle = RichTextStateHtmlParserKt.getHtmlElementsSpanStyleEncodeMap().get(tagName);
            if (!Intrinsics.areEqual((Object)tagName, (Object)"br")) {
                RichParagraph currentRichParagraph = (RichParagraph)CollectionsKt.last((List)$richParagraphList);
                RichSpan newRichSpan = new RichSpan(null, null, currentRichParagraph, null, null, 0L, null, null, 251, null);
                SpanStyle spanStyle = tagSpanStyle;
                if (spanStyle == null) {
                    spanStyle = new SpanStyle(0L, 0L, null, null, null, null, null, 0L, null, null, null, 0L, null, null, null, null, 65535, null);
                }
                newRichSpan.setSpanStyle(spanStyle);
                if ($currentRichSpan.element != null) {
                    newRichSpan.setParent((RichSpan)$currentRichSpan.element);
                    Object object = (RichSpan)$currentRichSpan.element;
                    if (object != null && (object = ((RichSpan)object).getChildren()) != null) {
                        object.add(newRichSpan);
                    }
                } else {
                    currentRichParagraph.getChildren().add(newRichSpan);
                }
                $currentRichSpan.element = newRichSpan;
            } else {
                RichTextStateMarkdownParser.encode$onAddLineBreak($richParagraphList, (Ref.ObjectRef<List<Integer>>)$brParagraphIndices, (Ref.ObjectRef<RichSpan>)$currentRichSpan);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit encode$lambda$5(List $richParagraphList, Ref.ObjectRef $brParagraphIndices, Ref.ObjectRef $currentRichSpan, String it) {
        int brIndex;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String html = it;
        while ((brIndex = StringsKt.indexOf$default((CharSequence)html, (String)"<br>", (int)0, (boolean)false, (int)6, null)) != -1) {
            Intrinsics.checkNotNullExpressionValue((Object)html.substring(brIndex + 4), (String)"substring(...)");
            RichTextStateMarkdownParser.encode$onAddLineBreak($richParagraphList, (Ref.ObjectRef<List<Integer>>)$brParagraphIndices, (Ref.ObjectRef<RichSpan>)$currentRichSpan);
        }
        if (!StringsKt.isBlank((CharSequence)html)) {
            $richParagraphList.addAll((Collection)RichTextStateHtmlParser.INSTANCE.encode(html).getRichParagraphList$richeditor_compose());
        }
        return Unit.INSTANCE;
    }

    static {
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)MarkdownElementTypes.STRONG, (Object)ElementsSpanStyleKt.getBoldSpanStyle()), TuplesKt.to((Object)MarkdownElementTypes.EMPH, (Object)ElementsSpanStyleKt.getItalicSpanStyle()), TuplesKt.to((Object)GFMElementTypes.STRIKETHROUGH, (Object)ElementsSpanStyleKt.getStrikethroughSpanStyle()), TuplesKt.to((Object)MarkdownElementTypes.ATX_1, (Object)ElementsSpanStyleKt.getH1SpanStyle()), TuplesKt.to((Object)MarkdownElementTypes.ATX_2, (Object)ElementsSpanStyleKt.getH2SpanStyle()), TuplesKt.to((Object)MarkdownElementTypes.ATX_3, (Object)ElementsSpanStyleKt.getH3SpanStyle()), TuplesKt.to((Object)MarkdownElementTypes.ATX_4, (Object)ElementsSpanStyleKt.getH4SpanStyle()), TuplesKt.to((Object)MarkdownElementTypes.ATX_5, (Object)ElementsSpanStyleKt.getH5SpanStyle()), TuplesKt.to((Object)MarkdownElementTypes.ATX_6, (Object)ElementsSpanStyleKt.getH6SpanStyle())};
        markdownElementsSpanStyleEncodeMap = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new IElementType[]{MarkdownElementTypes.ATX_1, MarkdownElementTypes.ATX_2, MarkdownElementTypes.ATX_3, MarkdownElementTypes.ATX_4, MarkdownElementTypes.ATX_5, MarkdownElementTypes.ATX_6, MarkdownElementTypes.ORDERED_LIST, MarkdownElementTypes.UNORDERED_LIST, MarkdownElementTypes.LIST_ITEM};
        markdownBlockElements = SetsKt.setOf((Object[])objectArray);
        $stable = 8;
    }
}

