/*
 * Decompiled with CFR 0.152.
 */
package com.mohamedrejeb.richeditor.paragraph.type;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\f\bf\u0018\u0000 \u00102\u00020\u0001:\t\b\t\n\u000b\f\r\u000e\u000f\u0010J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/mohamedrejeb/richeditor/paragraph/type/OrderedListStyleType;", "", "format", "", "number", "", "listLevel", "getSuffix", "Decimal", "ArabicIndic", "Arabic", "LowerAlpha", "UpperAlpha", "LowerRoman", "UpperRoman", "Multiple", "Companion", "richeditor-compose"})
public interface OrderedListStyleType {
    public static final /* synthetic */ Companion Companion;

    @NotNull
    public String format(int var1, int var2);

    @NotNull
    public String getSuffix(int var1);

    static {
        Companion = com.mohamedrejeb.richeditor.paragraph.type.OrderedListStyleType$Companion.$$INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcom/mohamedrejeb/richeditor/paragraph/type/OrderedListStyleType$Arabic;", "Lcom/mohamedrejeb/richeditor/paragraph/type/OrderedListStyleType;", "<init>", "()V", "arabicLetters", "", "getArabicLetters$richeditor_compose", "()[C", "format", "", "number", "", "listLevel", "richeditor-compose"})
    @StabilityInferred(parameters=0)
    public static final class Arabic
    implements OrderedListStyleType {
        @NotNull
        public static final Arabic INSTANCE = new Arabic();
        @NotNull
        private static final char[] arabicLetters;
        public static final int $stable;

        private Arabic() {
        }

        @NotNull
        public final char[] getArabicLetters$richeditor_compose() {
            return arabicLetters;
        }

        @Override
        @NotNull
        public String format(int number, int listLevel) {
            return Companion.formatToArabic(number);
        }

        @Override
        @NotNull
        public String getSuffix(int listLevel) {
            return DefaultImpls.getSuffix(this, listLevel);
        }

        static {
            char[] cArray = new char[]{'\u0623', '\u0628', '\u062c', '\u062f', '\u0647', '\u0648', '\u0632', '\u062d', '\u0637', '\u064a', '\u0643', '\u0644', '\u0645', '\u0646', '\u0633', '\u0639', '\u0641', '\u0635', '\u0642', '\u0631', '\u0634', '\u062a', '\u062b', '\u062e', '\u0630', '\u0636', '\u0638', '\u063a'};
            arabicLetters = cArray;
            $stable = 8;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/mohamedrejeb/richeditor/paragraph/type/OrderedListStyleType$ArabicIndic;", "Lcom/mohamedrejeb/richeditor/paragraph/type/OrderedListStyleType;", "<init>", "()V", "format", "", "number", "", "listLevel", "richeditor-compose"})
    @StabilityInferred(parameters=1)
    @SourceDebugExtension(value={"SMAP\nOrderedListStyleType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OrderedListStyleType.kt\ncom/mohamedrejeb/richeditor/paragraph/type/OrderedListStyleType$ArabicIndic\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,249:1\n975#2:250\n1046#2,3:251\n*S KotlinDebug\n*F\n+ 1 OrderedListStyleType.kt\ncom/mohamedrejeb/richeditor/paragraph/type/OrderedListStyleType$ArabicIndic\n*L\n61#1:250\n61#1:251,3\n*E\n"})
    public static final class ArabicIndic
    implements OrderedListStyleType {
        @NotNull
        public static final ArabicIndic INSTANCE = new ArabicIndic();
        public static final int $stable;

        private ArabicIndic() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String format(int number, int listLevel) {
            void $this$mapTo$iv$iv;
            CharSequence $this$map$iv = String.valueOf(number);
            boolean $i$f$map = false;
            CharSequence charSequence = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length());
            boolean $i$f$mapTo = false;
            for (int i = 0; i < $this$mapTo$iv$iv.length(); ++i) {
                char c;
                void ch;
                char item$iv$iv;
                char c2 = item$iv$iv = $this$mapTo$iv$iv.charAt(i);
                Collection collection = destination$iv$iv;
                boolean bl = false;
                switch (ch) {
                    case 48: {
                        c = '\u0660';
                        break;
                    }
                    case 49: {
                        c = '\u0661';
                        break;
                    }
                    case 50: {
                        c = '\u0662';
                        break;
                    }
                    case 51: {
                        c = '\u0663';
                        break;
                    }
                    case 52: {
                        c = '\u0664';
                        break;
                    }
                    case 53: {
                        c = '\u0665';
                        break;
                    }
                    case 54: {
                        c = '\u0666';
                        break;
                    }
                    case 55: {
                        c = '\u0667';
                        break;
                    }
                    case 56: {
                        c = '\u0668';
                        break;
                    }
                    case 57: {
                        c = '\u0669';
                        break;
                    }
                    default: {
                        c = ch;
                    }
                }
                collection.add(Character.valueOf(c));
            }
            return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        }

        @Override
        @NotNull
        public String getSuffix(int listLevel) {
            return DefaultImpls.getSuffix(this, listLevel);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J7\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0018\u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00070\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/mohamedrejeb/richeditor/paragraph/type/OrderedListStyleType$Companion;", "", "<init>", "()V", "formatToArabic", "", "number", "", "formatToAlpha", "base", "", "formatToRomanNumber", "romanNumerals", "", "Lkotlin/Pair;", "defaultValue", "(I[Lkotlin/Pair;Ljava/lang/String;)Ljava/lang/String;", "richeditor-compose"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        private final String formatToArabic(int number) {
            if (number <= 0) {
                return String.valueOf(ArraysKt.first((char[])Arabic.INSTANCE.getArabicLetters$richeditor_compose()));
            }
            StringBuilder result = new StringBuilder();
            int n = number;
            while (n > 0) {
                int remainder = (n - 1) % 28;
                result.insert(0, Arabic.INSTANCE.getArabicLetters$richeditor_compose()[remainder]);
                n = (n - 1) / 28;
            }
            String string = result.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private final String formatToAlpha(int number, char base) {
            if (number <= 0) {
                return String.valueOf(base);
            }
            int baseCode = base - '\u0001';
            StringBuilder result = new StringBuilder();
            int n = number;
            while (n > 0) {
                int remainder = (n - 1) % 26 + 1;
                result.insert(0, (char)(baseCode + remainder));
                n = (n - 1) / 26;
            }
            String string = result.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private final String formatToRomanNumber(int number, Pair<String, Integer>[] romanNumerals, String defaultValue) {
            if (number <= 0) {
                return defaultValue;
            }
            int n = number;
            StringBuilder result = new StringBuilder();
            for (Pair<String, Integer> pair : romanNumerals) {
                String roman = (String)pair.component1();
                int value = ((Number)pair.component2()).intValue();
                while (n >= value) {
                    result.append(roman);
                    n -= value;
                }
            }
            String string = result.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/mohamedrejeb/richeditor/paragraph/type/OrderedListStyleType$Decimal;", "Lcom/mohamedrejeb/richeditor/paragraph/type/OrderedListStyleType;", "<init>", "()V", "format", "", "number", "", "listLevel", "richeditor-compose"})
    @StabilityInferred(parameters=1)
    public static final class Decimal
    implements OrderedListStyleType {
        @NotNull
        public static final Decimal INSTANCE = new Decimal();
        public static final int $stable;

        private Decimal() {
        }

        @Override
        @NotNull
        public String format(int number, int listLevel) {
            return String.valueOf(number);
        }

        @Override
        @NotNull
        public String getSuffix(int listLevel) {
            return DefaultImpls.getSuffix(this, listLevel);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static String format(@NotNull OrderedListStyleType $this, int number, int listLevel) {
            return String.valueOf(number);
        }

        @NotNull
        public static String getSuffix(@NotNull OrderedListStyleType $this, int listLevel) {
            return ". ";
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/mohamedrejeb/richeditor/paragraph/type/OrderedListStyleType$LowerAlpha;", "Lcom/mohamedrejeb/richeditor/paragraph/type/OrderedListStyleType;", "<init>", "()V", "format", "", "number", "", "listLevel", "richeditor-compose"})
    @StabilityInferred(parameters=1)
    public static final class LowerAlpha
    implements OrderedListStyleType {
        @NotNull
        public static final LowerAlpha INSTANCE = new LowerAlpha();
        public static final int $stable;

        private LowerAlpha() {
        }

        @Override
        @NotNull
        public String format(int number, int listLevel) {
            return Companion.formatToAlpha(number, 'a');
        }

        @Override
        @NotNull
        public String getSuffix(int listLevel) {
            return DefaultImpls.getSuffix(this, listLevel);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bH\u0016R\"\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\r"}, d2={"Lcom/mohamedrejeb/richeditor/paragraph/type/OrderedListStyleType$LowerRoman;", "Lcom/mohamedrejeb/richeditor/paragraph/type/OrderedListStyleType;", "<init>", "()V", "romanNumerals", "", "Lkotlin/Pair;", "", "", "[Lkotlin/Pair;", "format", "number", "listLevel", "richeditor-compose"})
    @StabilityInferred(parameters=0)
    public static final class LowerRoman
    implements OrderedListStyleType {
        @NotNull
        public static final LowerRoman INSTANCE = new LowerRoman();
        @NotNull
        private static final Pair<String, Integer>[] romanNumerals;
        public static final int $stable;

        private LowerRoman() {
        }

        @Override
        @NotNull
        public String format(int number, int listLevel) {
            return Companion.formatToRomanNumber(number, LowerRoman.romanNumerals, "i");
        }

        @Override
        @NotNull
        public String getSuffix(int listLevel) {
            return DefaultImpls.getSuffix(this, listLevel);
        }

        static {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"m", (Object)1000), TuplesKt.to((Object)"cm", (Object)900), TuplesKt.to((Object)"d", (Object)500), TuplesKt.to((Object)"cd", (Object)400), TuplesKt.to((Object)"c", (Object)100), TuplesKt.to((Object)"xc", (Object)90), TuplesKt.to((Object)"l", (Object)50), TuplesKt.to((Object)"xl", (Object)40), TuplesKt.to((Object)"x", (Object)10), TuplesKt.to((Object)"ix", (Object)9), TuplesKt.to((Object)"v", (Object)5), TuplesKt.to((Object)"iv", (Object)4), TuplesKt.to((Object)"i", (Object)1)};
            romanNumerals = pairArray;
            $stable = 8;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003\"\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0016R\u001b\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/mohamedrejeb/richeditor/paragraph/type/OrderedListStyleType$Multiple;", "Lcom/mohamedrejeb/richeditor/paragraph/type/OrderedListStyleType;", "styles", "", "<init>", "([Lcom/mohamedrejeb/richeditor/paragraph/type/OrderedListStyleType;)V", "getStyles", "()[Lcom/mohamedrejeb/richeditor/paragraph/type/OrderedListStyleType;", "[Lcom/mohamedrejeb/richeditor/paragraph/type/OrderedListStyleType;", "format", "", "number", "", "listLevel", "getSuffix", "richeditor-compose"})
    @StabilityInferred(parameters=0)
    public static final class Multiple
    implements OrderedListStyleType {
        @NotNull
        private final OrderedListStyleType[] styles;
        public static final int $stable = 8;

        public Multiple(OrderedListStyleType ... styles) {
            Intrinsics.checkNotNullParameter((Object)styles, (String)"styles");
            this.styles = styles;
        }

        @NotNull
        public final OrderedListStyleType[] getStyles() {
            return this.styles;
        }

        @Override
        @NotNull
        public String format(int number, int listLevel) {
            if (this.styles.length == 0) {
                return Decimal.INSTANCE.format(number, listLevel);
            }
            OrderedListStyleType style = this.styles[RangesKt.coerceIn((int)(listLevel - 1), (ClosedRange)((ClosedRange)ArraysKt.getIndices((Object[])this.styles)))];
            return style.format(number, listLevel);
        }

        @Override
        @NotNull
        public String getSuffix(int listLevel) {
            if (this.styles.length == 0) {
                return Decimal.INSTANCE.getSuffix(listLevel);
            }
            OrderedListStyleType style = this.styles[RangesKt.coerceIn((int)(listLevel - 1), (ClosedRange)((ClosedRange)ArraysKt.getIndices((Object[])this.styles)))];
            return style.getSuffix(listLevel);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/mohamedrejeb/richeditor/paragraph/type/OrderedListStyleType$UpperAlpha;", "Lcom/mohamedrejeb/richeditor/paragraph/type/OrderedListStyleType;", "<init>", "()V", "format", "", "number", "", "listLevel", "richeditor-compose"})
    @StabilityInferred(parameters=1)
    public static final class UpperAlpha
    implements OrderedListStyleType {
        @NotNull
        public static final UpperAlpha INSTANCE = new UpperAlpha();
        public static final int $stable;

        private UpperAlpha() {
        }

        @Override
        @NotNull
        public String format(int number, int listLevel) {
            return Companion.formatToAlpha(number, 'A');
        }

        @Override
        @NotNull
        public String getSuffix(int listLevel) {
            return DefaultImpls.getSuffix(this, listLevel);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bH\u0016R\"\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\r"}, d2={"Lcom/mohamedrejeb/richeditor/paragraph/type/OrderedListStyleType$UpperRoman;", "Lcom/mohamedrejeb/richeditor/paragraph/type/OrderedListStyleType;", "<init>", "()V", "romanNumerals", "", "Lkotlin/Pair;", "", "", "[Lkotlin/Pair;", "format", "number", "listLevel", "richeditor-compose"})
    @StabilityInferred(parameters=0)
    public static final class UpperRoman
    implements OrderedListStyleType {
        @NotNull
        public static final UpperRoman INSTANCE = new UpperRoman();
        @NotNull
        private static final Pair<String, Integer>[] romanNumerals;
        public static final int $stable;

        private UpperRoman() {
        }

        @Override
        @NotNull
        public String format(int number, int listLevel) {
            return Companion.formatToRomanNumber(number, UpperRoman.romanNumerals, "I");
        }

        @Override
        @NotNull
        public String getSuffix(int listLevel) {
            return DefaultImpls.getSuffix(this, listLevel);
        }

        static {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"M", (Object)1000), TuplesKt.to((Object)"CM", (Object)900), TuplesKt.to((Object)"D", (Object)500), TuplesKt.to((Object)"CD", (Object)400), TuplesKt.to((Object)"C", (Object)100), TuplesKt.to((Object)"XC", (Object)90), TuplesKt.to((Object)"L", (Object)50), TuplesKt.to((Object)"XL", (Object)40), TuplesKt.to((Object)"X", (Object)10), TuplesKt.to((Object)"IX", (Object)9), TuplesKt.to((Object)"V", (Object)5), TuplesKt.to((Object)"IV", (Object)4), TuplesKt.to((Object)"I", (Object)1)};
            romanNumerals = pairArray;
            $stable = 8;
        }
    }
}

