/*
 * Decompiled with CFR 0.152.
 */
package com.fleeksoft.ksoup.select;

import com.fleeksoft.ksoup.helper.Validate;
import com.fleeksoft.ksoup.nodes.Element;
import com.fleeksoft.ksoup.nodes.Node;
import com.fleeksoft.ksoup.parser.TokenQueue;
import com.fleeksoft.ksoup.select.Collector;
import com.fleeksoft.ksoup.select.Elements;
import com.fleeksoft.ksoup.select.Evaluator;
import com.fleeksoft.ksoup.select.QueryParser;
import java.util.Collection;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tJ\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tJ\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000fJ$\u0010\u0010\u001a\u00020\u00052\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u00122\u000e\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0012J\u0018\u0010\u0014\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\u0014\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0015\u001a\u00020\u00072\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000fJ\u000e\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007J\u000e\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007J\u000e\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u0007\u00a8\u0006\u001c"}, d2={"Lcom/fleeksoft/ksoup/select/Selector;", "", "<init>", "()V", "select", "Lcom/fleeksoft/ksoup/select/Elements;", "query", "", "root", "Lcom/fleeksoft/ksoup/nodes/Element;", "evaluator", "Lcom/fleeksoft/ksoup/select/Evaluator;", "selectStream", "Lkotlin/sequences/Sequence;", "roots", "", "filterOut", "elements", "", "outs", "selectFirst", "cssQuery", "escapeCssIdentifier", "input", "unescapeCssIdentifier", "evaluatorOf", "css", "SelectorParseException", "ksoup"})
@SourceDebugExtension(value={"SMAP\nSelector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Selector.kt\ncom/fleeksoft/ksoup/select/Selector\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,271:1\n1321#2,2:272\n*S KotlinDebug\n*F\n+ 1 Selector.kt\ncom/fleeksoft/ksoup/select/Selector\n*L\n176#1:272,2\n*E\n"})
public final class Selector {
    @NotNull
    public static final Selector INSTANCE = new Selector();

    private Selector() {
    }

    @NotNull
    public final Elements select(@NotNull String query, @NotNull Element root) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Validate.INSTANCE.notEmpty(query);
        return this.select(this.evaluatorOf(query), root);
    }

    @NotNull
    public final Elements select(@NotNull Evaluator evaluator, @NotNull Element root) {
        Intrinsics.checkNotNullParameter((Object)evaluator, (String)"evaluator");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        return Collector.INSTANCE.collect(evaluator, root);
    }

    @NotNull
    public final Sequence<Element> selectStream(@NotNull String query, @NotNull Element root) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Validate.INSTANCE.notEmpty(query);
        return this.selectStream(this.evaluatorOf(query), root);
    }

    @NotNull
    public final Sequence<Element> selectStream(@NotNull Evaluator evaluator, @NotNull Element root) {
        Intrinsics.checkNotNullParameter((Object)evaluator, (String)"evaluator");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        return Collector.INSTANCE.stream(evaluator, root);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Elements select(@NotNull String query, @NotNull Iterable<? extends Element> roots) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        Validate.INSTANCE.notEmpty(query);
        Evaluator evaluator = this.evaluatorOf(query);
        Elements elements = new Elements(null, 1, null);
        HashSet seenElements = new HashSet();
        for (Element element : roots) {
            void $this$forEach$iv;
            Sequence sequence = SequencesKt.filter(this.selectStream(evaluator, element), (Function1)((Function1)new Function1<Element, Boolean>(seenElements){

                public final Boolean invoke(Element p0) {
                    return ((HashSet)this.receiver).add(p0);
                }
            }));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Element p0 = (Element)element$iv;
                boolean bl = false;
                elements.add((Node)p0);
            }
        }
        return elements;
    }

    @NotNull
    public final Elements filterOut(@NotNull Collection<? extends Element> elements, @NotNull Collection<? extends Element> outs) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter(outs, (String)"outs");
        Elements output = new Elements(null, 1, null);
        for (Element element : elements) {
            boolean found = false;
            for (Element element2 : outs) {
                if (!element.equals(element2)) continue;
                found = true;
                break;
            }
            if (found) continue;
            output.add((Node)element);
        }
        return output;
    }

    @Nullable
    public final Element selectFirst(@NotNull String cssQuery, @NotNull Element root) {
        Intrinsics.checkNotNullParameter((Object)cssQuery, (String)"cssQuery");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Validate.INSTANCE.notEmpty(cssQuery);
        return Collector.INSTANCE.findFirst(this.evaluatorOf(cssQuery), root);
    }

    @Nullable
    public final Element selectFirst(@NotNull String cssQuery, @NotNull Iterable<? extends Element> roots) {
        Intrinsics.checkNotNullParameter((Object)cssQuery, (String)"cssQuery");
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        Validate.INSTANCE.notEmpty(cssQuery);
        Evaluator evaluator = this.evaluatorOf(cssQuery);
        for (Element element : roots) {
            Element first = Collector.INSTANCE.findFirst(evaluator, element);
            if (first == null) continue;
            return first;
        }
        return null;
    }

    @NotNull
    public final String escapeCssIdentifier(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return TokenQueue.Companion.escapeCssIdentifier(input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String unescapeCssIdentifier(@NotNull String input) {
        String string;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        AutoCloseable autoCloseable = new TokenQueue(input);
        Throwable throwable = null;
        try {
            TokenQueue tq = (TokenQueue)autoCloseable;
            boolean bl = false;
            string = tq.consumeCssIdentifier();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return string;
    }

    @NotNull
    public final Evaluator evaluatorOf(@NotNull String css) {
        Intrinsics.checkNotNullParameter((Object)css, (String)"css");
        return QueryParser.Companion.parse(css);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0013\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u001d\b\u0016\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\t\u00a8\u0006\n"}, d2={"Lcom/fleeksoft/ksoup/select/Selector$SelectorParseException;", "Ljava/lang/IllegalStateException;", "Lkotlin/IllegalStateException;", "msg", "", "<init>", "(Ljava/lang/String;)V", "cause", "", "(Ljava/lang/Throwable;Ljava/lang/String;)V", "ksoup"})
    public static final class SelectorParseException
    extends IllegalStateException {
        public SelectorParseException(@Nullable String msg) {
            super(msg);
        }

        public SelectorParseException(@Nullable Throwable cause, @Nullable String msg) {
            super(msg, cause);
        }
    }
}

