/*
 * Decompiled with CFR 0.152.
 */
package com.fleeksoft.ksoup.select;

import com.fleeksoft.ksoup.helper.Validate;
import com.fleeksoft.ksoup.internal.Normalizer;
import com.fleeksoft.ksoup.internal.StringUtil;
import com.fleeksoft.ksoup.nodes.CDataNode;
import com.fleeksoft.ksoup.nodes.Comment;
import com.fleeksoft.ksoup.nodes.DataNode;
import com.fleeksoft.ksoup.nodes.LeafNode;
import com.fleeksoft.ksoup.nodes.Node;
import com.fleeksoft.ksoup.nodes.TextNode;
import com.fleeksoft.ksoup.parser.TokenQueue;
import com.fleeksoft.ksoup.ported.CoreFunctionsKt;
import com.fleeksoft.ksoup.select.CombiningEvaluator;
import com.fleeksoft.ksoup.select.Evaluator;
import com.fleeksoft.ksoup.select.NodeEvaluator;
import com.fleeksoft.ksoup.select.Selector;
import com.fleeksoft.ksoup.select.StructuralEvaluator;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 02\u00060\u0001j\u0002`\u0002:\u00010B\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\fJ\u0006\u0010\u000e\u001a\u00020\fJ\u0006\u0010\u000f\u001a\u00020\fJ\b\u0010\u0010\u001a\u0004\u0018\u00010\fJ\b\u0010\u0011\u001a\u00020\fH\u0002J\b\u0010\u0012\u001a\u00020\fH\u0002J\b\u0010\u0013\u001a\u00020\fH\u0002J\b\u0010\u0014\u001a\u00020\fH\u0002J\b\u0010\u0015\u001a\u00020\fH\u0002J\b\u0010\u0016\u001a\u00020\fH\u0002J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\bH\u0002J\u0018\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\nH\u0002J\b\u0010\u001c\u001a\u00020\u0004H\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\fH\u0002J\b\u0010 \u001a\u00020\fH\u0002J&\u0010!\u001a\u00020\f2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020$0#2\b\u0010%\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010&\u001a\u00020\f2\u0006\u0010'\u001a\u00020\nH\u0002J\u0010\u0010(\u001a\u00020\f2\u0006\u0010'\u001a\u00020\nH\u0002J\b\u0010)\u001a\u00020\fH\u0002J\u0010\u0010*\u001a\u00020\f2\u0006\u0010'\u001a\u00020\nH\u0002J\u0010\u0010+\u001a\u00020\f2\u0006\u0010'\u001a\u00020\nH\u0002J\t\u0010,\u001a\u00020\fH\u0082\u0002J\b\u0010-\u001a\u00020\u0004H\u0016J\b\u0010.\u001a\u00020/H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/fleeksoft/ksoup/select/QueryParser;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "query", "", "<init>", "(Ljava/lang/String;)V", "tq", "Lcom/fleeksoft/ksoup/parser/TokenQueue;", "inNodeContext", "", "parse", "Lcom/fleeksoft/ksoup/select/Evaluator;", "parseSelectorGroup", "parseSelector", "parseSimpleSequence", "parseSubclass", "parsePseudoSelector", "parseNodeSelector", "byId", "byClass", "byTag", "byAttribute", "evaluatorForAttribute", "cq", "cssNthChild", "last", "ofType", "consumeParens", "consumeIndex", "", "has", "is", "parseNested", "func", "Lkotlin/Function1;", "Lcom/fleeksoft/ksoup/select/StructuralEvaluator;", "err", "contains", "own", "containsWholeText", "containsData", "matches", "matchesWholeText", "not", "toString", "close", "", "Companion", "ksoup"})
@SourceDebugExtension(value={"SMAP\nQueryParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QueryParser.kt\ncom/fleeksoft/ksoup/select/QueryParser\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,472:1\n106#2:473\n78#2,22:474\n106#2:497\n78#2,22:498\n106#2:520\n78#2,22:521\n1#3:496\n*S KotlinDebug\n*F\n+ 1 QueryParser.kt\ncom/fleeksoft/ksoup/select/QueryParser\n*L\n269#1:473\n269#1:474,22\n196#1:497\n196#1:498,22\n323#1:520\n323#1:521,22\n*E\n"})
public final class QueryParser
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TokenQueue tq;
    @NotNull
    private final String query;
    private boolean inNodeContext;
    @NotNull
    private static final char[] Combinators;
    @NotNull
    private static final char[] SequenceEnders;
    @NotNull
    private static final String[] AttributeEvals;
    @NotNull
    private static final Regex NthStepOffset;
    @NotNull
    private static final Regex NthOffset;

    private QueryParser(String query) {
        String trimmedQuery;
        Validate.INSTANCE.notEmpty(query);
        String $this$trim$iv = query;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        this.query = trimmedQuery = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        this.tq = new TokenQueue(trimmedQuery);
    }

    @NotNull
    public final Evaluator parse() {
        Evaluator eval = this.parseSelectorGroup();
        this.tq.consumeWhitespace();
        if (!this.tq.isEmpty()) {
            throw new Selector.SelectorParseException("Could not parse query '" + this.query + "': unexpected token at '" + this.tq.remainder() + "'");
        }
        return eval;
    }

    @NotNull
    public final Evaluator parseSelectorGroup() {
        Evaluator left = this.parseSelector();
        while (this.tq.matchChomp(',')) {
            Evaluator right = this.parseSelector();
            left = Companion.or(left, right);
        }
        return left;
    }

    @NotNull
    public final Evaluator parseSelector() {
        this.tq.consumeWhitespace();
        Evaluator left = null;
        char[] cArray = Combinators;
        left = this.tq.matchesAny(Arrays.copyOf(cArray, cArray.length)) ? (Evaluator)new StructuralEvaluator.Root() : this.parseSimpleSequence();
        while (true) {
            char[] cArray2;
            char combinator = '\u0000';
            if (this.tq.consumeWhitespace()) {
                combinator = ' ';
            }
            if (this.tq.matchesAny(Arrays.copyOf(cArray2 = Combinators, cArray2.length))) {
                combinator = this.tq.consume();
            } else {
                cArray2 = SequenceEnders;
                if (this.tq.matchesAny(Arrays.copyOf(cArray2, cArray2.length))) break;
            }
            if (combinator == '\u0000') break;
            Evaluator right = this.parseSimpleSequence();
            left = Companion.combinator(left, combinator, right);
        }
        return left;
    }

    @NotNull
    public final Evaluator parseSimpleSequence() {
        Evaluator right;
        Evaluator left = null;
        this.tq.consumeWhitespace();
        if (this.tq.matchesWord() || this.tq.matches("*|")) {
            left = this.byTag();
        } else if (this.tq.matchChomp('*')) {
            left = new Evaluator.AllElements();
        }
        while ((right = this.parseSubclass()) != null) {
            left = Companion.and(left, right);
        }
        if (left == null) {
            throw new Selector.SelectorParseException("Could not parse query '" + this.query + "': unexpected token at '" + this.tq.remainder() + "'");
        }
        return left;
    }

    @Nullable
    public final Evaluator parseSubclass() {
        Evaluator evaluator;
        if (this.tq.matchChomp('#')) {
            evaluator = this.byId();
        } else if (this.tq.matchChomp('.')) {
            evaluator = this.byClass();
        } else if (this.tq.matches('[')) {
            evaluator = this.byAttribute();
        } else {
            if (this.tq.matchChomp("::")) {
                return this.parseNodeSelector();
            }
            evaluator = this.tq.matchChomp(':') ? this.parsePseudoSelector() : null;
        }
        return evaluator;
    }

    private final Evaluator parsePseudoSelector() {
        String pseudo;
        return switch (pseudo = this.tq.consumeCssIdentifier()) {
            case "lt" -> new Evaluator.IndexLessThan(this.consumeIndex());
            case "gt" -> new Evaluator.IndexGreaterThan(this.consumeIndex());
            case "eq" -> new Evaluator.IndexEquals(this.consumeIndex());
            case "has" -> this.has();
            case "is" -> this.is();
            case "contains" -> this.contains(false);
            case "containsOwn" -> this.contains(true);
            case "containsWholeText" -> this.containsWholeText(false);
            case "containsWholeOwnText" -> this.containsWholeText(true);
            case "containsData" -> this.containsData();
            case "matches" -> this.matches(false);
            case "matchesOwn" -> this.matches(true);
            case "matchesWholeText" -> this.matchesWholeText(false);
            case "matchesWholeOwnText" -> this.matchesWholeText(true);
            case "not" -> this.not();
            case "nth-child" -> this.cssNthChild(false, false);
            case "nth-last-child" -> this.cssNthChild(true, false);
            case "nth-of-type" -> this.cssNthChild(false, true);
            case "nth-last-of-type" -> this.cssNthChild(true, true);
            case "first-child" -> new Evaluator.IsFirstChild();
            case "last-child" -> new Evaluator.IsLastChild();
            case "first-of-type" -> new Evaluator.IsFirstOfType();
            case "last-of-type" -> new Evaluator.IsLastOfType();
            case "only-child" -> new Evaluator.IsOnlyChild();
            case "only-of-type" -> new Evaluator.IsOnlyOfType();
            case "empty" -> new Evaluator.IsEmpty();
            case "blank" -> new NodeEvaluator.BlankValue();
            case "root" -> new Evaluator.IsRoot();
            case "matchText" -> new Evaluator.MatchText();
            default -> throw new Selector.SelectorParseException("Could not parse query '" + this.query + "': unexpected token at '" + this.tq.remainder() + "'");
        };
    }

    private final Evaluator parseNodeSelector() {
        String pseudo = this.tq.consumeCssIdentifier();
        this.inNodeContext = true;
        Evaluator left = switch (pseudo) {
            case "node" -> new NodeEvaluator.InstanceType((KClass<? extends Node>)Reflection.getOrCreateKotlinClass(Node.class), pseudo);
            case "leafnode" -> new NodeEvaluator.InstanceType((KClass<? extends Node>)Reflection.getOrCreateKotlinClass(LeafNode.class), pseudo);
            case "text" -> new NodeEvaluator.InstanceType((KClass<? extends Node>)Reflection.getOrCreateKotlinClass(TextNode.class), pseudo);
            case "comment" -> new NodeEvaluator.InstanceType((KClass<? extends Node>)Reflection.getOrCreateKotlinClass(Comment.class), pseudo);
            case "data" -> new NodeEvaluator.InstanceType((KClass<? extends Node>)Reflection.getOrCreateKotlinClass(DataNode.class), pseudo);
            case "cdata" -> new NodeEvaluator.InstanceType((KClass<? extends Node>)Reflection.getOrCreateKotlinClass(CDataNode.class), pseudo);
            default -> throw new Selector.SelectorParseException("Could not parse query '" + this.query + "': unknown node type '::" + pseudo + "'");
        };
        Evaluator right = null;
        while (true) {
            Evaluator evaluator;
            Evaluator it = evaluator = this.parseSubclass();
            boolean bl = false;
            right = it;
            if (evaluator == null) break;
            Evaluator evaluator2 = right;
            Intrinsics.checkNotNull((Object)evaluator2);
            left = Companion.and(left, evaluator2);
        }
        this.inNodeContext = false;
        return left;
    }

    private final Evaluator byId() {
        String id = this.tq.consumeCssIdentifier();
        Validate.INSTANCE.notEmpty(id);
        return new Evaluator.Id(id);
    }

    private final Evaluator byClass() {
        String className = this.tq.consumeCssIdentifier();
        Validate.INSTANCE.notEmpty(className);
        String $this$trim$iv = className;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        String string = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        return new Evaluator.Class(string);
    }

    private final Evaluator byTag() {
        String tagName = Normalizer.INSTANCE.normalize(this.tq.consumeElementSelector());
        Validate.INSTANCE.notEmpty(tagName);
        if (StringsKt.startsWith$default((String)tagName, (String)"*|", (boolean)false, (int)2, null)) {
            String string = tagName.substring(2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String plainTag = string;
            Evaluator[] evaluatorArray = new Evaluator[]{new Evaluator.Tag(plainTag), new Evaluator.TagEndsWith(":" + plainTag)};
            return new CombiningEvaluator.Or(evaluatorArray);
        }
        if (StringsKt.endsWith$default((String)tagName, (String)"|*", (boolean)false, (int)2, null)) {
            String string = tagName.substring(0, tagName.length() - 2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String ns = string + ":";
            return new Evaluator.TagStartsWith(ns);
        }
        if (StringsKt.contains$default((CharSequence)tagName, (CharSequence)"|", (boolean)false, (int)2, null)) {
            tagName = StringsKt.replace$default((String)tagName, (String)"|", (String)":", (boolean)false, (int)4, null);
        }
        return new Evaluator.Tag(tagName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Evaluator byAttribute() {
        Evaluator evaluator;
        AutoCloseable autoCloseable = new TokenQueue(this.tq.chompBalanced('[', ']'));
        Throwable throwable = null;
        try {
            TokenQueue cq = (TokenQueue)autoCloseable;
            boolean bl = false;
            evaluator = this.evaluatorForAttribute(cq);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return evaluator;
    }

    private final Evaluator evaluatorForAttribute(TokenQueue cq) {
        String[] stringArray = AttributeEvals;
        String key = cq.consumeToAny(Arrays.copyOf(stringArray, stringArray.length));
        Validate.INSTANCE.notEmpty(key);
        cq.consumeWhitespace();
        Evaluator eval = null;
        if (cq.isEmpty()) {
            Evaluator evaluator;
            if (StringsKt.startsWith$default((String)key, (String)"^", (boolean)false, (int)2, null)) {
                String string = key.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                evaluator = new Evaluator.AttributeStarting(string);
            } else {
                evaluator = Intrinsics.areEqual((Object)key, (Object)"*") ? (Evaluator)new Evaluator.AttributeStarting("") : (Evaluator)new Evaluator.Attribute(key);
            }
            eval = evaluator;
        } else if (cq.matchChomp('=')) {
            eval = new Evaluator.AttributeWithValue(key, cq.remainder());
        } else if (cq.matchChomp("!=")) {
            eval = new Evaluator.AttributeWithValueNot(key, cq.remainder());
        } else if (cq.matchChomp("^=")) {
            eval = new Evaluator.AttributeWithValueStarting(key, cq.remainder());
        } else if (cq.matchChomp("$=")) {
            eval = new Evaluator.AttributeWithValueEnding(key, cq.remainder());
        } else if (cq.matchChomp("*=")) {
            eval = new Evaluator.AttributeWithValueContaining(key, cq.remainder());
        } else if (cq.matchChomp("~=")) {
            eval = new Evaluator.AttributeWithValueMatching(key, CoreFunctionsKt.jsSupportedRegex(cq.remainder()));
        } else {
            throw new Selector.SelectorParseException("Could not parse attribute query '" + this.query + "': unexpected token at '" + cq.remainder() + "'");
        }
        return eval;
    }

    private final Evaluator cssNthChild(boolean last, boolean ofType) {
        Pair pair;
        block10: {
            String arg;
            block12: {
                int n;
                int step;
                String string;
                Object object;
                block11: {
                    block9: {
                        arg = Normalizer.INSTANCE.normalize(this.consumeParens());
                        if (!StringsKt.equals((String)arg, (String)"odd", (boolean)true)) break block9;
                        pair = TuplesKt.to((Object)2, (Object)1);
                        break block10;
                    }
                    if (!StringsKt.equals((String)arg, (String)"even", (boolean)true)) break block11;
                    pair = TuplesKt.to((Object)2, (Object)0);
                    break block10;
                }
                pair = NthStepOffset.matchEntire((CharSequence)arg);
                if (pair == null) break block12;
                Pair m = pair;
                boolean bl = false;
                String signGroup = (String)m.getGroupValues().get(2);
                String digitsGroup = (String)m.getGroupValues().get(3);
                String offsetGroup = (String)m.getGroupValues().get(4);
                if (((CharSequence)digitsGroup).length() > 0) {
                    CharSequence charSequence = (CharSequence)m.getGroupValues().get(1);
                    object = new Regex("^\\+");
                    string = "";
                    v1 = Integer.parseInt(object.replaceFirst(charSequence, string));
                } else {
                    v1 = step = Intrinsics.areEqual((Object)signGroup, (Object)"-") ? -1 : 1;
                }
                if (((CharSequence)offsetGroup).length() > 0) {
                    object = offsetGroup;
                    string = new Regex("^\\+");
                    String string2 = "";
                    n = Integer.parseInt(string.replaceFirst((CharSequence)object, string2));
                } else {
                    n = 0;
                }
                int offset = n;
                Pair pair2 = TuplesKt.to((Object)step, (Object)offset);
                pair = pair2;
                if (pair2 != null) break block10;
            }
            MatchResult matchResult = NthOffset.matchEntire((CharSequence)arg);
            if (matchResult != null) {
                MatchResult m = matchResult;
                boolean bl = false;
                CharSequence charSequence = m.getValue();
                Regex regex = new Regex("^\\+");
                String string = "";
                int off = Integer.parseInt(regex.replaceFirst(charSequence, string));
                pair = TuplesKt.to((Object)0, (Object)off);
            } else {
                throw new Selector.SelectorParseException("Could not parse nth-index '" + arg + "': unexpected format");
            }
        }
        Pair pair3 = pair;
        int step = ((Number)pair3.component1()).intValue();
        int offset = ((Number)pair3.component2()).intValue();
        return ofType && last ? (Evaluator)new Evaluator.IsNthLastOfType(step, offset) : (ofType ? (Evaluator)new Evaluator.IsNthOfType(step, offset) : (last ? (Evaluator)new Evaluator.IsNthLastChild(step, offset) : (Evaluator)new Evaluator.IsNthChild(step, offset)));
    }

    private final String consumeParens() {
        return this.tq.chompBalanced('(', ')');
    }

    private final int consumeIndex() {
        String $this$trim$iv = this.consumeParens();
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        String index = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        Validate.INSTANCE.isTrue(StringUtil.INSTANCE.isNumeric(index), "Index must be numeric");
        return Integer.parseInt(index);
    }

    private final Evaluator has() {
        return this.parseNested((Function1<? super Evaluator, ? extends StructuralEvaluator>)((Function1)QueryParser::has$lambda$7), ":has() must have a selector");
    }

    private final Evaluator is() {
        return this.parseNested((Function1<? super Evaluator, ? extends StructuralEvaluator>)((Function1)QueryParser::is$lambda$8), ":is() must have a selector");
    }

    private final Evaluator parseNested(Function1<? super Evaluator, ? extends StructuralEvaluator> func, String err) {
        Validate.INSTANCE.isTrue(this.tq.matchChomp('('), err);
        Evaluator eval = this.parseSelectorGroup();
        Validate.INSTANCE.isTrue(this.tq.matchChomp(')'), err);
        return (Evaluator)func.invoke((Object)eval);
    }

    private final Evaluator contains(boolean own) {
        String query = own ? ":containsOwn" : ":contains";
        String searchText = TokenQueue.Companion.unescape(this.consumeParens());
        Validate.INSTANCE.notEmpty(searchText, query + "(text) query must not be empty");
        if (this.inNodeContext) {
            return new NodeEvaluator.ContainsValue(searchText);
        }
        return own ? (Evaluator)new Evaluator.ContainsOwnText(searchText) : (Evaluator)new Evaluator.ContainsText(searchText);
    }

    private final Evaluator containsWholeText(boolean own) {
        String query = own ? ":containsWholeOwnText" : ":containsWholeText";
        String searchText = TokenQueue.Companion.unescape(this.consumeParens());
        Validate.INSTANCE.notEmpty(searchText, query + "(text) query must not be empty");
        return own ? (Evaluator)new Evaluator.ContainsWholeOwnText(searchText) : (Evaluator)new Evaluator.ContainsWholeText(searchText);
    }

    private final Evaluator containsData() {
        String searchText = TokenQueue.Companion.unescape(this.consumeParens());
        Validate.INSTANCE.notEmpty(searchText, ":containsData(text) query must not be empty");
        return new Evaluator.ContainsData(searchText);
    }

    private final Evaluator matches(boolean own) {
        String query = own ? ":matchesOwn" : ":matches";
        String regex = this.consumeParens();
        Validate.INSTANCE.notEmpty(regex, query + "(regex) query must not be empty");
        Regex compiled = CoreFunctionsKt.jsSupportedRegex(regex);
        return this.inNodeContext ? (Evaluator)new NodeEvaluator.MatchesValue(compiled) : (own ? (Evaluator)new Evaluator.MatchesOwn(compiled) : (Evaluator)new Evaluator.Matches(compiled));
    }

    private final Evaluator matchesWholeText(boolean own) {
        String query = own ? ":matchesWholeOwnText" : ":matchesWholeText";
        String regex = this.consumeParens();
        Validate.INSTANCE.notEmpty(regex, query + "(regex) query must not be empty");
        return own ? (Evaluator)new Evaluator.MatchesWholeOwnText(CoreFunctionsKt.jsSupportedRegex(regex)) : (Evaluator)new Evaluator.MatchesWholeText(CoreFunctionsKt.jsSupportedRegex(regex));
    }

    private final Evaluator not() {
        String subQuery = this.consumeParens();
        Validate.INSTANCE.notEmpty(subQuery, ":not(selector) subselect must not be empty");
        return new StructuralEvaluator.Not(Companion.parse(subQuery));
    }

    @NotNull
    public String toString() {
        return this.query;
    }

    @Override
    public void close() {
        this.tq.close();
    }

    private static final StructuralEvaluator has$lambda$7(Evaluator it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new StructuralEvaluator.Has(it);
    }

    private static final StructuralEvaluator is$lambda$8(Evaluator it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new StructuralEvaluator.Is(it);
    }

    public /* synthetic */ QueryParser(String query, DefaultConstructorMarker $constructor_marker) {
        this(query);
    }

    static {
        Object[] objectArray = new char[]{'>', '+', '~'};
        Combinators = objectArray;
        objectArray = new char[]{',', ')'};
        SequenceEnders = objectArray;
        objectArray = new String[6];
        objectArray[0] = (char)"=";
        objectArray[1] = (char)"!=";
        objectArray[2] = (char)"^=";
        objectArray[3] = (char)"$=";
        objectArray[4] = (char)"*=";
        objectArray[5] = (char)"~=";
        AttributeEvals = (String[])objectArray;
        NthStepOffset = new Regex("(([+-])?(\\d+)?)n(\\s*([+-])?\\s*\\d+)?", RegexOption.IGNORE_CASE);
        NthOffset = new Regex("([+-])?(\\d+)");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tJ\u001e\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fJ\u0016\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fJ\u0018\u0010\u0013\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/fleeksoft/ksoup/select/QueryParser$Companion;", "", "<init>", "()V", "Combinators", "", "SequenceEnders", "AttributeEvals", "", "", "[Ljava/lang/String;", "parse", "Lcom/fleeksoft/ksoup/select/Evaluator;", "query", "combinator", "left", "", "right", "or", "and", "NthStepOffset", "Lkotlin/text/Regex;", "NthOffset", "ksoup"})
    @SourceDebugExtension(value={"SMAP\nQueryParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QueryParser.kt\ncom/fleeksoft/ksoup/select/QueryParser$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,472:1\n1#2:473\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final Evaluator parse(@NotNull String query) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            try {
                Evaluator evaluator;
                object = new QueryParser(query, null);
                Throwable throwable = null;
                try {
                    QueryParser it = (QueryParser)object;
                    boolean bl = false;
                    evaluator = it.parse();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
                }
                object = evaluator;
            }
            catch (IllegalArgumentException e) {
                throw new Selector.SelectorParseException(e.getMessage());
            }
            return object;
        }

        @NotNull
        public final Evaluator combinator(@NotNull Evaluator left, char combinator, @NotNull Evaluator right) {
            Intrinsics.checkNotNullParameter((Object)left, (String)"left");
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            switch (combinator) {
                case '>': {
                    StructuralEvaluator.ImmediateParentRun immediateParentRun = left instanceof StructuralEvaluator.ImmediateParentRun ? (StructuralEvaluator.ImmediateParentRun)left : null;
                    if (immediateParentRun == null) {
                        immediateParentRun = new StructuralEvaluator.ImmediateParentRun(left);
                    }
                    StructuralEvaluator.ImmediateParentRun run = immediateParentRun;
                    run.add(right);
                    return run;
                }
                case ' ': {
                    return this.and(new StructuralEvaluator.Ancestor(left), right);
                }
                case '+': {
                    return this.and(new StructuralEvaluator.ImmediatePreviousSibling(left), right);
                }
                case '~': {
                    return this.and(new StructuralEvaluator.PreviousSibling(left), right);
                }
            }
            throw new Selector.SelectorParseException("Unknown combinator '" + combinator + "'");
        }

        @NotNull
        public final Evaluator or(@NotNull Evaluator left, @NotNull Evaluator right) {
            Intrinsics.checkNotNullParameter((Object)left, (String)"left");
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            if (left instanceof CombiningEvaluator.Or) {
                ((CombiningEvaluator.Or)left).add(right);
                return left;
            }
            Evaluator[] evaluatorArray = new Evaluator[]{left, right};
            return new CombiningEvaluator.Or(evaluatorArray);
        }

        @NotNull
        public final Evaluator and(@Nullable Evaluator left, @NotNull Evaluator right) {
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            if (left == null) {
                return right;
            }
            if (left instanceof CombiningEvaluator.And) {
                ((CombiningEvaluator.And)left).add(right);
                return left;
            }
            Evaluator[] evaluatorArray = new Evaluator[]{left, right};
            return new CombiningEvaluator.And(evaluatorArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

