/*
 * Decompiled with CFR 0.152.
 */
package com.fleeksoft.ksoup.select;

import com.fleeksoft.ksoup.nodes.Element;
import com.fleeksoft.ksoup.nodes.Node;
import com.fleeksoft.ksoup.select.Elements;
import com.fleeksoft.ksoup.select.NodeFilter;
import com.fleeksoft.ksoup.select.NodeVisitor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\f\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u000f"}, d2={"Lcom/fleeksoft/ksoup/select/NodeTraversor;", "", "<init>", "()V", "traverse", "", "visitor", "Lcom/fleeksoft/ksoup/select/NodeVisitor;", "root", "Lcom/fleeksoft/ksoup/nodes/Node;", "elements", "Lcom/fleeksoft/ksoup/select/Elements;", "filter", "Lcom/fleeksoft/ksoup/select/NodeFilter$FilterResult;", "Lcom/fleeksoft/ksoup/select/NodeFilter;", "ksoup"})
@SourceDebugExtension(value={"SMAP\nNodeTraversor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodeTraversor.kt\ncom/fleeksoft/ksoup/select/NodeTraversor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,158:1\n1869#2,2:159\n1869#2,2:161\n*S KotlinDebug\n*F\n+ 1 NodeTraversor.kt\ncom/fleeksoft/ksoup/select/NodeTraversor\n*L\n93#1:159,2\n153#1:161,2\n*E\n"})
public final class NodeTraversor {
    @NotNull
    public static final NodeTraversor INSTANCE = new NodeTraversor();

    private NodeTraversor() {
    }

    public final void traverse(@NotNull NodeVisitor visitor, @NotNull Node root) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Node node = root;
        int depth = 0;
        while (node != null) {
            Node parent;
            Node node2 = parent = node.parentNode();
            int origSize = node2 != null ? node2.childNodeSize() : 0;
            Node next = node.nextSibling();
            visitor.head(node, depth);
            if (parent != null && !node.hasParent()) {
                if (origSize == parent.childNodeSize()) {
                    node = parent.childNode(node.siblingIndex());
                    continue;
                }
                node = next;
                if (node != null) continue;
                node = parent;
                do {
                    visitor.tail(node, --depth);
                    if (node == root) break;
                    if (node.nextSibling() == null) continue;
                    node = node.nextSibling();
                    break;
                } while ((node = node.parentNode()) != null);
                if (node != root && node != null) continue;
                break;
            }
            if (node.childNodeSize() > 0) {
                node = node.childNode(0);
                ++depth;
                continue;
            }
            while (true) {
                if (node == null) {
                    throw new Exception("as depth > 0, will have parent");
                }
                if (node.nextSibling() != null || depth <= 0) break;
                visitor.tail(node, depth);
                node = node.parentNode();
                --depth;
            }
            visitor.tail(node, depth);
            if (Intrinsics.areEqual((Object)node, (Object)root)) break;
            node = node.nextSibling();
        }
    }

    public final void traverse(@NotNull NodeVisitor visitor, @NotNull Elements elements) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        Iterable $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Element it = (Element)element$iv;
            boolean bl = false;
            INSTANCE.traverse(visitor, it);
        }
    }

    @NotNull
    public final NodeFilter.FilterResult filter(@NotNull NodeFilter filter, @NotNull Node root) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Node node = root;
        int depth = 0;
        while (node != null) {
            Node prev;
            NodeFilter.FilterResult result = filter.head(node, depth);
            if (result == NodeFilter.FilterResult.STOP) {
                return result;
            }
            if (result == NodeFilter.FilterResult.CONTINUE && node.childNodeSize() > 0) {
                node = node.childNode(0);
                ++depth;
                continue;
            }
            while (true) {
                Node node2 = node;
                if ((node2 != null ? node2.nextSibling() : null) != null || depth <= 0) break;
                if ((result == NodeFilter.FilterResult.CONTINUE || result == NodeFilter.FilterResult.SKIP_CHILDREN) && (result = filter.tail(node, depth)) == NodeFilter.FilterResult.STOP) {
                    return result;
                }
                prev = node;
                Node node3 = node;
                node = node3 != null ? node3.parentNode() : null;
                --depth;
                if (result == NodeFilter.FilterResult.REMOVE) {
                    Node node4 = prev;
                    if (node4 != null) {
                        node4.remove();
                    }
                }
                result = NodeFilter.FilterResult.CONTINUE;
            }
            if ((result == NodeFilter.FilterResult.CONTINUE || result == NodeFilter.FilterResult.SKIP_CHILDREN) && (result = filter.tail(node, depth)) == NodeFilter.FilterResult.STOP) {
                return result;
            }
            if (Intrinsics.areEqual((Object)node, (Object)root)) {
                return result;
            }
            prev = node;
            Node node5 = node;
            Node node6 = node = node5 != null ? node5.nextSibling() : null;
            if (result != NodeFilter.FilterResult.REMOVE) continue;
            Node node7 = prev;
            if (node7 == null) continue;
            node7.remove();
        }
        return NodeFilter.FilterResult.CONTINUE;
    }

    public final void filter(@NotNull NodeFilter filter, @NotNull Elements elements) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        Iterable $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Element el = (Element)element$iv;
            boolean bl = false;
            if (INSTANCE.filter(filter, el) != NodeFilter.FilterResult.STOP) continue;
            return;
        }
    }
}

