/*
 * Decompiled with CFR 0.152.
 */
package com.fleeksoft.ksoup.select;

import com.fleeksoft.ksoup.internal.Normalizer;
import com.fleeksoft.ksoup.internal.StringUtil;
import com.fleeksoft.ksoup.nodes.Element;
import com.fleeksoft.ksoup.nodes.LeafNode;
import com.fleeksoft.ksoup.nodes.Node;
import com.fleeksoft.ksoup.select.Evaluator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001:\u0004\u000f\u0010\u0011\u0012B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH$J\b\u0010\u000e\u001a\u00020\u0005H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/fleeksoft/ksoup/select/NodeEvaluator;", "Lcom/fleeksoft/ksoup/select/Evaluator;", "<init>", "()V", "matches", "", "root", "Lcom/fleeksoft/ksoup/nodes/Element;", "element", "leafNode", "Lcom/fleeksoft/ksoup/nodes/LeafNode;", "evaluateMatch", "node", "Lcom/fleeksoft/ksoup/nodes/Node;", "wantsNodes", "InstanceType", "ContainsValue", "BlankValue", "MatchesValue", "ksoup"})
public abstract class NodeEvaluator
extends Evaluator {
    protected NodeEvaluator() {
    }

    @Override
    public boolean matches(@NotNull Element root, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.evaluateMatch(element);
    }

    @Override
    public boolean matches(@NotNull Element root, @NotNull LeafNode leafNode) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)leafNode, (String)"leafNode");
        return this.evaluateMatch(leafNode);
    }

    protected abstract boolean evaluateMatch(@NotNull Node var1);

    @Override
    public boolean wantsNodes() {
        return true;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/fleeksoft/ksoup/select/NodeEvaluator$BlankValue;", "Lcom/fleeksoft/ksoup/select/NodeEvaluator;", "<init>", "()V", "evaluateMatch", "", "node", "Lcom/fleeksoft/ksoup/nodes/Node;", "cost", "", "toString", "", "ksoup"})
    public static final class BlankValue
    extends NodeEvaluator {
        @Override
        protected boolean evaluateMatch(@NotNull Node node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            return StringUtil.INSTANCE.isBlank(node.nodeValue());
        }

        @Override
        public int cost() {
            return 4;
        }

        @NotNull
        public String toString() {
            return ":blank";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/fleeksoft/ksoup/select/NodeEvaluator$ContainsValue;", "Lcom/fleeksoft/ksoup/select/NodeEvaluator;", "searchText", "", "<init>", "(Ljava/lang/String;)V", "evaluateMatch", "", "node", "Lcom/fleeksoft/ksoup/nodes/Node;", "cost", "", "toString", "ksoup"})
    public static final class ContainsValue
    extends NodeEvaluator {
        @NotNull
        private final String searchText;

        public ContainsValue(@NotNull String searchText) {
            Intrinsics.checkNotNullParameter((Object)searchText, (String)"searchText");
            this.searchText = Normalizer.INSTANCE.lowerCase(StringUtil.INSTANCE.normaliseWhitespace(searchText));
        }

        @Override
        protected boolean evaluateMatch(@NotNull Node node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            return StringsKt.contains$default((CharSequence)Normalizer.INSTANCE.lowerCase(node.nodeValue()), (CharSequence)this.searchText, (boolean)false, (int)2, null);
        }

        @Override
        public int cost() {
            return 6;
        }

        @NotNull
        public String toString() {
            return ":contains(" + this.searchText + ")";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0006H\u0016R\u0019\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/fleeksoft/ksoup/select/NodeEvaluator$InstanceType;", "Lcom/fleeksoft/ksoup/select/NodeEvaluator;", "type", "Lkotlin/reflect/KClass;", "Lcom/fleeksoft/ksoup/nodes/Node;", "selector", "", "<init>", "(Lkotlin/reflect/KClass;Ljava/lang/String;)V", "getType", "()Lkotlin/reflect/KClass;", "getSelector", "()Ljava/lang/String;", "evaluateMatch", "", "node", "cost", "", "toString", "ksoup"})
    public static final class InstanceType
    extends NodeEvaluator {
        @NotNull
        private final KClass<? extends Node> type;
        @NotNull
        private final String selector;

        public InstanceType(@NotNull KClass<? extends Node> type, @NotNull String selector) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
            this.type = type;
            this.selector = selector;
        }

        @NotNull
        public final KClass<? extends Node> getType() {
            return this.type;
        }

        @NotNull
        public final String getSelector() {
            return this.selector;
        }

        @Override
        protected boolean evaluateMatch(@NotNull Node node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            return this.type.isInstance((Object)node);
        }

        @Override
        public int cost() {
            return 1;
        }

        @NotNull
        public String toString() {
            return "::" + this.selector;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/fleeksoft/ksoup/select/NodeEvaluator$MatchesValue;", "Lcom/fleeksoft/ksoup/select/NodeEvaluator;", "pattern", "Lkotlin/text/Regex;", "<init>", "(Lkotlin/text/Regex;)V", "evaluateMatch", "", "node", "Lcom/fleeksoft/ksoup/nodes/Node;", "cost", "", "toString", "", "ksoup"})
    public static final class MatchesValue
    extends NodeEvaluator {
        @NotNull
        private final Regex pattern;

        public MatchesValue(@NotNull Regex pattern) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            this.pattern = pattern;
        }

        @Override
        protected boolean evaluateMatch(@NotNull Node node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            return Regex.find$default((Regex)this.pattern, (CharSequence)node.nodeValue(), (int)0, (int)2, null) != null;
        }

        @Override
        public int cost() {
            return 8;
        }

        @NotNull
        public String toString() {
            return ":matches(" + this.pattern.getPattern() + ")";
        }
    }
}

