/*
 * Decompiled with CFR 0.152.
 */
package com.fleeksoft.ksoup.select;

import com.fleeksoft.ksoup.helper.Validate;
import com.fleeksoft.ksoup.internal.Normalizer;
import com.fleeksoft.ksoup.internal.StringUtil;
import com.fleeksoft.ksoup.nodes.Comment;
import com.fleeksoft.ksoup.nodes.Document;
import com.fleeksoft.ksoup.nodes.DocumentType;
import com.fleeksoft.ksoup.nodes.Element;
import com.fleeksoft.ksoup.nodes.LeafNode;
import com.fleeksoft.ksoup.nodes.Node;
import com.fleeksoft.ksoup.nodes.PseudoTextElement;
import com.fleeksoft.ksoup.nodes.TextNode;
import com.fleeksoft.ksoup.nodes.XmlDeclaration;
import com.fleeksoft.ksoup.parser.ParseSettings;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b+\b&\u0018\u00002\u00020\u0001:*\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"#$%&'()*+,-./0123456789:;<=>B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\u0006J\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\u0006J\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H&J\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0007H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006?"}, d2={"Lcom/fleeksoft/ksoup/select/Evaluator;", "", "<init>", "()V", "asPredicate", "Lkotlin/Function1;", "Lcom/fleeksoft/ksoup/nodes/Element;", "", "root", "asNodePredicate", "Lcom/fleeksoft/ksoup/nodes/Node;", "matches", "element", "node", "leafNode", "Lcom/fleeksoft/ksoup/nodes/LeafNode;", "wantsNodes", "reset", "", "cost", "", "Tag", "TagStartsWith", "TagEndsWith", "Id", "Class", "Attribute", "AttributeStarting", "AttributeWithValue", "AttributeWithValueNot", "AttributeWithValueStarting", "AttributeWithValueEnding", "AttributeWithValueContaining", "AttributeWithValueMatching", "AttributeKeyPair", "AllElements", "IndexLessThan", "IndexGreaterThan", "IndexEquals", "IsLastChild", "IsFirstOfType", "IsLastOfType", "CssNthEvaluator", "IsNthChild", "IsNthLastChild", "IsNthOfType", "IsNthLastOfType", "IsFirstChild", "IsRoot", "IsOnlyChild", "IsOnlyOfType", "IsEmpty", "IndexEvaluator", "ContainsText", "ContainsWholeText", "ContainsWholeOwnText", "ContainsData", "ContainsOwnText", "Matches", "MatchesOwn", "MatchesWholeText", "MatchesWholeOwnText", "MatchText", "ksoup"})
public abstract class Evaluator {
    protected Evaluator() {
    }

    @NotNull
    public final Function1<Element, Boolean> asPredicate(@NotNull Element root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        return arg_0 -> Evaluator.asPredicate$lambda$0(this, root, arg_0);
    }

    @NotNull
    public final Function1<Node, Boolean> asNodePredicate(@NotNull Element root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        return arg_0 -> Evaluator.asNodePredicate$lambda$1(this, root, arg_0);
    }

    public abstract boolean matches(@NotNull Element var1, @NotNull Element var2);

    public boolean matches(@NotNull Element root, @NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node instanceof Element) {
            return this.matches(root, (Element)node);
        }
        if (node instanceof LeafNode && this.wantsNodes()) {
            return this.matches(root, (LeafNode)node);
        }
        return false;
    }

    public boolean matches(@NotNull Element root, @NotNull LeafNode leafNode) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)leafNode, (String)"leafNode");
        return false;
    }

    public boolean wantsNodes() {
        return false;
    }

    public void reset() {
    }

    public int cost() {
        return 5;
    }

    private static final boolean asPredicate$lambda$0(Evaluator this$0, Element $root, Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this$0.matches($root, element);
    }

    private static final boolean asNodePredicate$lambda$1(Evaluator this$0, Element $root, Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this$0.matches($root, node);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/fleeksoft/ksoup/select/Evaluator$AllElements;", "Lcom/fleeksoft/ksoup/select/Evaluator;", "<init>", "()V", "matches", "", "root", "Lcom/fleeksoft/ksoup/nodes/Element;", "element", "cost", "", "toString", "", "ksoup"})
    public static final class AllElements
    extends Evaluator {
        @Override
        public boolean matches(@NotNull Element root, @NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return true;
        }

        @Override
        public int cost() {
            return 10;
        }

        @NotNull
        public String toString() {
            return "*";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/fleeksoft/ksoup/select/Evaluator$Attribute;", "Lcom/fleeksoft/ksoup/select/Evaluator;", "key", "", "<init>", "(Ljava/lang/String;)V", "matches", "", "root", "Lcom/fleeksoft/ksoup/nodes/Element;", "element", "cost", "", "toString", "ksoup"})
    public static final class Attribute
    extends Evaluator {
        @NotNull
        private final String key;

        public Attribute(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.key = key;
        }

        @Override
        public boolean matches(@NotNull Element root, @NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return element.hasAttr(this.key);
        }

        @Override
        public int cost() {
            return 2;
        }

        @NotNull
        public String toString() {
            return "[" + this.key + "]";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\b&\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\f\u00a8\u0006\u000f"}, d2={"Lcom/fleeksoft/ksoup/select/Evaluator$AttributeKeyPair;", "Lcom/fleeksoft/ksoup/select/Evaluator;", "key", "", "value", "trimQuoted", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Z)V", "getKey", "()Ljava/lang/String;", "setKey", "(Ljava/lang/String;)V", "getValue", "setValue", "ksoup"})
    public static abstract class AttributeKeyPair
    extends Evaluator {
        @NotNull
        private String key;
        @NotNull
        private String value;

        public AttributeKeyPair(@NotNull String key, @NotNull String value, boolean trimQuoted) {
            boolean quoted;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            String resultValue = value;
            Validate.INSTANCE.notEmpty(key);
            Validate.INSTANCE.notEmpty(resultValue);
            this.key = Normalizer.INSTANCE.normalize(key);
            boolean bl = quoted = StringsKt.startsWith$default((String)resultValue, (String)"'", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)resultValue, (String)"'", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)resultValue, (String)"\"", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)resultValue, (String)"\"", (boolean)false, (int)2, null);
            if (quoted) {
                String string = value.substring(1, resultValue.length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                resultValue = string;
            }
            this.value = trimQuoted || !quoted ? Normalizer.INSTANCE.normalize(resultValue) : Normalizer.INSTANCE.lowerCase(resultValue);
        }

        public /* synthetic */ AttributeKeyPair(String string, String string2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = true;
            }
            this(string, string2, bl);
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        public final void setKey(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.key = string;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        public final void setValue(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.value = string;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/fleeksoft/ksoup/select/Evaluator$AttributeStarting;", "Lcom/fleeksoft/ksoup/select/Evaluator;", "keyPrefix", "", "<init>", "(Ljava/lang/String;)V", "matches", "", "root", "Lcom/fleeksoft/ksoup/nodes/Element;", "element", "cost", "", "toString", "ksoup"})
    public static final class AttributeStarting
    extends Evaluator {
        @NotNull
        private final String keyPrefix;

        public AttributeStarting(@NotNull String keyPrefix) {
            Intrinsics.checkNotNullParameter((Object)keyPrefix, (String)"keyPrefix");
            this.keyPrefix = Normalizer.INSTANCE.lowerCase(keyPrefix);
        }

        @Override
        public boolean matches(@NotNull Element root, @NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            List<com.fleeksoft.ksoup.nodes.Attribute> values = element.attributes().asList();
            for (com.fleeksoft.ksoup.nodes.Attribute attribute : values) {
                if (!StringsKt.startsWith$default((String)Normalizer.INSTANCE.lowerCase(attribute.getKey()), (String)this.keyPrefix, (boolean)false, (int)2, null)) continue;
                return true;
            }
            return false;
        }

        @Override
        public int cost() {
            return 6;
        }

        @NotNull
        public String toString() {
            return "[^" + this.keyPrefix + "]";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/fleeksoft/ksoup/select/Evaluator$AttributeWithValue;", "Lcom/fleeksoft/ksoup/select/Evaluator$AttributeKeyPair;", "key", "", "value", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "matches", "", "root", "Lcom/fleeksoft/ksoup/nodes/Element;", "element", "cost", "", "toString", "ksoup"})
    public static final class AttributeWithValue
    extends AttributeKeyPair {
        public AttributeWithValue(@NotNull String key, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            super(key, value, false, 4, null);
        }

        @Override
        public boolean matches(@NotNull Element root, @NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return element.hasAttr(this.getKey()) && StringsKt.equals((String)this.getValue(), (String)((Object)StringsKt.trim((CharSequence)element.attr(this.getKey()))).toString(), (boolean)true);
        }

        @Override
        public int cost() {
            return 3;
        }

        @NotNull
        public String toString() {
            return "[" + this.getKey() + "=" + this.getValue() + "]";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/fleeksoft/ksoup/select/Evaluator$AttributeWithValueContaining;", "Lcom/fleeksoft/ksoup/select/Evaluator$AttributeKeyPair;", "key", "", "value", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "matches", "", "root", "Lcom/fleeksoft/ksoup/nodes/Element;", "element", "cost", "", "toString", "ksoup"})
    public static final class AttributeWithValueContaining
    extends AttributeKeyPair {
        public AttributeWithValueContaining(@NotNull String key, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            super(key, value, false, 4, null);
        }

        @Override
        public boolean matches(@NotNull Element root, @NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return element.hasAttr(this.getKey()) && StringsKt.contains$default((CharSequence)Normalizer.INSTANCE.lowerCase(element.attr(this.getKey())), (CharSequence)this.getValue(), (boolean)false, (int)2, null);
        }

        @Override
        public int cost() {
            return 6;
        }

        @NotNull
        public String toString() {
            return "[" + this.getKey() + "*=" + this.getValue() + "]";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/fleeksoft/ksoup/select/Evaluator$AttributeWithValueEnding;", "Lcom/fleeksoft/ksoup/select/Evaluator$AttributeKeyPair;", "key", "", "value", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "matches", "", "root", "Lcom/fleeksoft/ksoup/nodes/Element;", "element", "cost", "", "toString", "ksoup"})
    public static final class AttributeWithValueEnding
    extends AttributeKeyPair {
        public AttributeWithValueEnding(@NotNull String key, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            super(key, value, false);
        }

        @Override
        public boolean matches(@NotNull Element root, @NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return element.hasAttr(this.getKey()) && StringsKt.endsWith$default((String)Normalizer.INSTANCE.lowerCase(element.attr(this.getKey())), (String)this.getValue(), (boolean)false, (int)2, null);
        }

        @Override
        public int cost() {
            return 4;
        }

        @NotNull
        public String toString() {
            return "[" + this.getKey() + "$=" + this.getValue() + "]";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0003H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lcom/fleeksoft/ksoup/select/Evaluator$AttributeWithValueMatching;", "Lcom/fleeksoft/ksoup/select/Evaluator;", "key", "", "regex", "Lkotlin/text/Regex;", "<init>", "(Ljava/lang/String;Lkotlin/text/Regex;)V", "getRegex", "()Lkotlin/text/Regex;", "setRegex", "(Lkotlin/text/Regex;)V", "getKey", "()Ljava/lang/String;", "setKey", "(Ljava/lang/String;)V", "matches", "", "root", "Lcom/fleeksoft/ksoup/nodes/Element;", "element", "cost", "", "toString", "ksoup"})
    public static final class AttributeWithValueMatching
    extends Evaluator {
        @NotNull
        private Regex regex;
        @NotNull
        private String key;

        public AttributeWithValueMatching(@Nullable String key, @NotNull Regex regex) {
            Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
            this.regex = regex;
            this.key = Normalizer.INSTANCE.normalize(key);
        }

        @NotNull
        public final Regex getRegex() {
            return this.regex;
        }

        public final void setRegex(@NotNull Regex regex) {
            Intrinsics.checkNotNullParameter((Object)regex, (String)"<set-?>");
            this.regex = regex;
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        public final void setKey(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.key = string;
        }

        @Override
        public boolean matches(@NotNull Element root, @NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return element.hasAttr(this.key) && Regex.find$default((Regex)this.regex, (CharSequence)element.attr(this.key), (int)0, (int)2, null) != null;
        }

        @Override
        public int cost() {
            return 8;
        }

        @NotNull
        public String toString() {
            return "[" + this.key + "~=" + this.regex.getPattern() + "]";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/fleeksoft/ksoup/select/Evaluator$AttributeWithValueNot;", "Lcom/fleeksoft/ksoup/select/Evaluator$AttributeKeyPair;", "key", "", "value", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "matches", "", "root", "Lcom/fleeksoft/ksoup/nodes/Element;", "element", "cost", "", "toString", "ksoup"})
    public static final class AttributeWithValueNot
    extends AttributeKeyPair {
        public AttributeWithValueNot(@NotNull String key, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            super(key, value, false, 4, null);
        }

        @Override
        public boolean matches(@NotNull Element root, @NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return !StringsKt.equals((String)this.getValue(), (String)element.attr(this.getKey()), (boolean)true);
        }

        @Override
        public int cost() {
            return 3;
        }

        @NotNull
        public String toString() {
            return "[" + this.getKey() + "!=" + this.getValue() + "]";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/fleeksoft/ksoup/select/Evaluator$AttributeWithValueStarting;", "Lcom/fleeksoft/ksoup/select/Evaluator$AttributeKeyPair;", "key", "", "value", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "matches", "", "root", "Lcom/fleeksoft/ksoup/nodes/Element;", "element", "cost", "", "toString", "ksoup"})
    public static final class AttributeWithValueStarting
    extends AttributeKeyPair {
        public AttributeWithValueStarting(@NotNull String key, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            super(key, value, false);
        }

        @Override
        public boolean matches(@NotNull Element root, @NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return element.hasAttr(this.getKey()) && StringsKt.startsWith$default((String)Normalizer.INSTANCE.lowerCase(element.attr(this.getKey())), (String)this.getValue(), (boolean)false, (int)2, null);
        }

        @Override
        public int cost() {
            return 4;
        }

        @NotNull
        public String toString() {
            return "[" + this.getKey() + "^=" + this.getValue() + "]";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/fleeksoft/ksoup/select/Evaluator$Class;", "Lcom/fleeksoft/ksoup/select/Evaluator;", "className", "", "<init>", "(Ljava/lang/String;)V", "matches", "", "root", "Lcom/fleeksoft/ksoup/nodes/Element;", "element", "cost", "", "toString", "ksoup"})
    public static final class Class
    extends Evaluator {
        @NotNull
        private final String className;

        public Class(@NotNull String className) {
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            this.className = className;
        }

        @Override
        public boolean matches(@NotNull Element root, @NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return element.hasClass(this.className);
        }

        @Override
        public int cost() {
            return 8;
        }

        @NotNull
        public String toString() {
            return "." + this.className;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/fleeksoft/ksoup/select/Evaluator$ContainsData;", "Lcom/fleeksoft/ksoup/select/Evaluator;", "searchText", "", "<init>", "(Ljava/lang/String;)V", "matches", "", "root", "Lcom/fleeksoft/ksoup/nodes/Element;", "element", "toString", "ksoup"})
    public static final class ContainsData
    extends Evaluator {
        @NotNull
        private final String searchText;

        public ContainsData(@Nullable String searchText) {
            this.searchText = Normalizer.INSTANCE.lowerCase(searchText);
        }

        @Override
        public boolean matches(@NotNull Element root, @NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return StringsKt.contains$default((CharSequence)Normalizer.INSTANCE.lowerCase(element.data()), (CharSequence)this.searchText, (boolean)false, (int)2, null);
        }

        @NotNull
        public String toString() {
            return ":containsData(" + this.searchText + ")";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/fleeksoft/ksoup/select/Evaluator$ContainsOwnText;", "Lcom/fleeksoft/ksoup/select/Evaluator;", "searchText", "", "<init>", "(Ljava/lang/String;)V", "matches", "", "root", "Lcom/fleeksoft/ksoup/nodes/Element;", "element", "toString", "ksoup"})
    public static final class ContainsOwnText
    extends Evaluator {
        @NotNull
        private final String searchText;

        public ContainsOwnText(@NotNull String searchText) {
            Intrinsics.checkNotNullParameter((Object)searchText, (String)"searchText");
            this.searchText = Normalizer.INSTANCE.lowerCase(StringUtil.INSTANCE.normaliseWhitespace(searchText));
        }

        @Override
        public boolean matches(@NotNull Element root, @NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return StringsKt.contains$default((CharSequence)Normalizer.INSTANCE.lowerCase(element.ownText()), (CharSequence)this.searchText, (boolean)false, (int)2, null);
        }

        @NotNull
        public String toString() {
            return ":containsOwn(" + this.searchText + ")";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/fleeksoft/ksoup/select/Evaluator$ContainsText;", "Lcom/fleeksoft/ksoup/select/Evaluator;", "searchText", "", "<init>", "(Ljava/lang/String;)V", "matches", "", "root", "Lcom/fleeksoft/ksoup/nodes/Element;", "element", "cost", "", "toString", "ksoup"})
    public static final class ContainsText
    extends Evaluator {
        @NotNull
        private final String searchText;

        public ContainsText(@NotNull String searchText) {
            Intrinsics.checkNotNullParameter((Object)searchText, (String)"searchText");
            this.searchText = Normalizer.INSTANCE.lowerCase(StringUtil.INSTANCE.normaliseWhitespace(searchText));
        }

        @Override
        public boolean matches(@NotNull Element root, @NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return StringsKt.contains$default((CharSequence)Normalizer.INSTANCE.lowerCase(element.text()), (CharSequence)this.searchText, (boolean)false, (int)2, null);
        }

        @Override
        public int cost() {
            return 10;
        }

        @NotNull
        public String toString() {
            return ":contains(" + this.searchText + ")";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/fleeksoft/ksoup/select/Evaluator$ContainsWholeOwnText;", "Lcom/fleeksoft/ksoup/select/Evaluator;", "searchText", "", "<init>", "(Ljava/lang/String;)V", "matches", "", "root", "Lcom/fleeksoft/ksoup/nodes/Element;", "element", "toString", "ksoup"})
    public static final class ContainsWholeOwnText
    extends Evaluator {
        @NotNull
        private final String searchText;

        public ContainsWholeOwnText(@NotNull String searchText) {
            Intrinsics.checkNotNullParameter((Object)searchText, (String)"searchText");
            this.searchText = searchText;
        }

        @Override
        public boolean matches(@NotNull Element root, @NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return StringsKt.contains$default((CharSequence)element.wholeOwnText(), (CharSequence)this.searchText, (boolean)false, (int)2, null);
        }

        @NotNull
        public String toString() {
            return ":containsWholeOwnText(" + this.searchText + ")";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/fleeksoft/ksoup/select/Evaluator$ContainsWholeText;", "Lcom/fleeksoft/ksoup/select/Evaluator;", "searchText", "", "<init>", "(Ljava/lang/String;)V", "matches", "", "root", "Lcom/fleeksoft/ksoup/nodes/Element;", "element", "cost", "", "toString", "ksoup"})
    public static final class ContainsWholeText
    extends Evaluator {
        @NotNull
        private final String searchText;

        public ContainsWholeText(@NotNull String searchText) {
            Intrinsics.checkNotNullParameter((Object)searchText, (String)"searchText");
            this.searchText = searchText;
        }

        @Override
        public boolean matches(@NotNull Element root, @NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return StringsKt.contains$default((CharSequence)element.wholeText(), (CharSequence)this.searchText, (boolean)false, (int)2, null);
        }

        @Override
        public int cost() {
            return 10;
        }

        @NotNull
        public String toString() {
            return ":containsWholeText(" + this.searchText + ")";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H$J\u0018\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/fleeksoft/ksoup/select/Evaluator$CssNthEvaluator;", "Lcom/fleeksoft/ksoup/select/Evaluator;", "a", "", "b", "<init>", "(II)V", "offset", "(I)V", "getA", "()I", "getB", "matches", "", "root", "Lcom/fleeksoft/ksoup/nodes/Element;", "element", "toString", "", "getPseudoClass", "calculatePosition", "ksoup"})
    public static abstract class CssNthEvaluator
    extends Evaluator {
        private final int a;
        private final int b;

        public CssNthEvaluator(int a, int b) {
            this.a = a;
            this.b = b;
        }

        public final int getA() {
            return this.a;
        }

        public final int getB() {
            return this.b;
        }

        public CssNthEvaluator(int offset) {
            this(0, offset);
        }

        @Override
        public boolean matches(@NotNull Element root, @NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Element element2 = element.parent();
            if (element2 == null) {
                return false;
            }
            Element parent = element2;
            if (parent instanceof Document) {
                return false;
            }
            int pos = this.calculatePosition(root, element);
            return this.a == 0 ? pos == this.b : (pos - this.b) * this.a >= 0 && (pos - this.b) % this.a == 0;
        }

        @NotNull
        public String toString() {
            String string;
            String pseudo = this.getPseudoClass();
            if (this.a == 0) {
                string = ":" + pseudo + "(" + this.b + ")";
            } else if (this.b == 0) {
                string = ":" + pseudo + "(" + this.a + "n)";
            } else {
                Object sign = this.b >= 0 ? "+" + this.b : String.valueOf(this.b);
                string = ":" + pseudo + "(" + this.a + "n" + (String)sign + ")";
            }
            return string;
        }

        @NotNull
        protected abstract String getPseudoClass();

        public abstract int calculatePosition(@NotNull Element var1, @NotNull Element var2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/fleeksoft/ksoup/select/Evaluator$Id;", "Lcom/fleeksoft/ksoup/select/Evaluator;", "id", "", "<init>", "(Ljava/lang/String;)V", "matches", "", "root", "Lcom/fleeksoft/ksoup/nodes/Element;", "element", "cost", "", "toString", "ksoup"})
    public static final class Id
    extends Evaluator {
        @NotNull
        private final String id;

        public Id(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            this.id = id;
        }

        @Override
        public boolean matches(@NotNull Element root, @NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return Intrinsics.areEqual((Object)this.id, (Object)element.id());
        }

        @Override
        public int cost() {
            return 2;
        }

        @NotNull
        public String toString() {
            return "#" + this.id;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/fleeksoft/ksoup/select/Evaluator$IndexEquals;", "Lcom/fleeksoft/ksoup/select/Evaluator$IndexEvaluator;", "index", "", "<init>", "(I)V", "matches", "", "root", "Lcom/fleeksoft/ksoup/nodes/Element;", "element", "toString", "", "ksoup"})
    public static final class IndexEquals
    extends IndexEvaluator {
        public IndexEquals(int index) {
            super(index);
        }

        @Override
        public boolean matches(@NotNull Element root, @NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return element.elementSiblingIndex() == this.getIndex();
        }

        @NotNull
        public String toString() {
            return ":eq(" + this.getIndex() + ")";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\t"}, d2={"Lcom/fleeksoft/ksoup/select/Evaluator$IndexEvaluator;", "Lcom/fleeksoft/ksoup/select/Evaluator;", "index", "", "<init>", "(I)V", "getIndex", "()I", "setIndex", "ksoup"})
    public static abstract class IndexEvaluator
    extends Evaluator {
        private int index;

        public IndexEvaluator(int index) {
            this.index = index;
        }

        public final int getIndex() {
            return this.index;
        }

        public final void setIndex(int n) {
            this.index = n;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/fleeksoft/ksoup/select/Evaluator$IndexGreaterThan;", "Lcom/fleeksoft/ksoup/select/Evaluator$IndexEvaluator;", "index", "", "<init>", "(I)V", "matches", "", "root", "Lcom/fleeksoft/ksoup/nodes/Element;", "element", "toString", "", "ksoup"})
    public static final class IndexGreaterThan
    extends IndexEvaluator {
        public IndexGreaterThan(int index) {
            super(index);
        }

        @Override
        public boolean matches(@NotNull Element root, @NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return element.elementSiblingIndex() > this.getIndex();
        }

        @NotNull
        public String toString() {
            return ":gt(" + this.getIndex() + ")";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/fleeksoft/ksoup/select/Evaluator$IndexLessThan;", "Lcom/fleeksoft/ksoup/select/Evaluator$IndexEvaluator;", "index", "", "<init>", "(I)V", "matches", "", "root", "Lcom/fleeksoft/ksoup/nodes/Element;", "element", "toString", "", "ksoup"})
    public static final class IndexLessThan
    extends IndexEvaluator {
        public IndexLessThan(int index) {
            super(index);
        }

        @Override
        public boolean matches(@NotNull Element root, @NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return !Intrinsics.areEqual((Object)root, (Object)element) && element.elementSiblingIndex() < this.getIndex();
        }

        @NotNull
        public String toString() {
            return ":lt(" + this.getIndex() + ")";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/fleeksoft/ksoup/select/Evaluator$IsEmpty;", "Lcom/fleeksoft/ksoup/select/Evaluator;", "<init>", "()V", "matches", "", "root", "Lcom/fleeksoft/ksoup/nodes/Element;", "element", "toString", "", "ksoup"})
    public static final class IsEmpty
    extends Evaluator {
        @Override
        public boolean matches(@NotNull Element root, @NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Node n = element.firstChild();
            while (n != null) {
                if (n instanceof TextNode ? !((TextNode)n).isBlank() : !(n instanceof Comment) && !(n instanceof XmlDeclaration) && !(n instanceof DocumentType)) {
                    return false;
                }
                n = ((LeafNode)n).nextSibling();
            }
            return true;
        }

        @NotNull
        public String toString() {
            return ":empty";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/fleeksoft/ksoup/select/Evaluator$IsFirstChild;", "Lcom/fleeksoft/ksoup/select/Evaluator;", "<init>", "()V", "matches", "", "root", "Lcom/fleeksoft/ksoup/nodes/Element;", "element", "toString", "", "ksoup"})
    public static final class IsFirstChild
    extends Evaluator {
        @Override
        public boolean matches(@NotNull Element root, @NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Element p = element.parent();
            return p != null && !(p instanceof Document) && element == p.firstElementChild();
        }

        @NotNull
        public String toString() {
            return ":first-child";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/fleeksoft/ksoup/select/Evaluator$IsFirstOfType;", "Lcom/fleeksoft/ksoup/select/Evaluator$IsNthOfType;", "<init>", "()V", "toString", "", "ksoup"})
    public static final class IsFirstOfType
    extends IsNthOfType {
        public IsFirstOfType() {
            super(0, 1);
        }

        @Override
        @NotNull
        public String toString() {
            return ":first-of-type";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/fleeksoft/ksoup/select/Evaluator$IsLastChild;", "Lcom/fleeksoft/ksoup/select/Evaluator;", "<init>", "()V", "matches", "", "root", "Lcom/fleeksoft/ksoup/nodes/Element;", "element", "toString", "", "ksoup"})
    public static final class IsLastChild
    extends Evaluator {
        @Override
        public boolean matches(@NotNull Element root, @NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Element p = element.parent();
            return p != null && !(p instanceof Document) && element == p.lastElementChild();
        }

        @NotNull
        public String toString() {
            return ":last-child";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/fleeksoft/ksoup/select/Evaluator$IsLastOfType;", "Lcom/fleeksoft/ksoup/select/Evaluator$IsNthLastOfType;", "<init>", "()V", "toString", "", "ksoup"})
    public static final class IsLastOfType
    extends IsNthLastOfType {
        public IsLastOfType() {
            super(0, 1);
        }

        @Override
        @NotNull
        public String toString() {
            return ":last-of-type";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0014\u00a8\u0006\r"}, d2={"Lcom/fleeksoft/ksoup/select/Evaluator$IsNthChild;", "Lcom/fleeksoft/ksoup/select/Evaluator$CssNthEvaluator;", "a", "", "b", "<init>", "(II)V", "calculatePosition", "root", "Lcom/fleeksoft/ksoup/nodes/Element;", "element", "getPseudoClass", "", "ksoup"})
    public static final class IsNthChild
    extends CssNthEvaluator {
        public IsNthChild(int a, int b) {
            super(a, b);
        }

        @Override
        public int calculatePosition(@NotNull Element root, @NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return element.elementSiblingIndex() + 1;
        }

        @Override
        @NotNull
        protected String getPseudoClass() {
            return "nth-child";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0014\u00a8\u0006\r"}, d2={"Lcom/fleeksoft/ksoup/select/Evaluator$IsNthLastChild;", "Lcom/fleeksoft/ksoup/select/Evaluator$CssNthEvaluator;", "a", "", "b", "<init>", "(II)V", "calculatePosition", "root", "Lcom/fleeksoft/ksoup/nodes/Element;", "element", "getPseudoClass", "", "ksoup"})
    public static final class IsNthLastChild
    extends CssNthEvaluator {
        public IsNthLastChild(int a, int b) {
            super(a, b);
        }

        @Override
        public int calculatePosition(@NotNull Element root, @NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            if (element.parent() == null) {
                return 0;
            }
            Element element2 = element.parent();
            Intrinsics.checkNotNull((Object)element2);
            return element2.childrenSize() - element.elementSiblingIndex();
        }

        @Override
        @NotNull
        protected String getPseudoClass() {
            return "nth-last-child";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0014\u00a8\u0006\r"}, d2={"Lcom/fleeksoft/ksoup/select/Evaluator$IsNthLastOfType;", "Lcom/fleeksoft/ksoup/select/Evaluator$CssNthEvaluator;", "a", "", "b", "<init>", "(II)V", "calculatePosition", "root", "Lcom/fleeksoft/ksoup/nodes/Element;", "element", "getPseudoClass", "", "ksoup"})
    public static class IsNthLastOfType
    extends CssNthEvaluator {
        public IsNthLastOfType(int a, int b) {
            super(a, b);
        }

        @Override
        public int calculatePosition(@NotNull Element root, @NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Element element2 = element.parent();
            if (element2 == null) {
                return 0;
            }
            Element parent = element2;
            int pos = 0;
            for (Element next = element; next != null; next = next.nextElementSibling()) {
                if (!Intrinsics.areEqual((Object)next.normalName(), (Object)element.normalName())) continue;
                ++pos;
            }
            return pos;
        }

        @Override
        @NotNull
        protected String getPseudoClass() {
            return "nth-last-of-type";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0014\u00a8\u0006\r"}, d2={"Lcom/fleeksoft/ksoup/select/Evaluator$IsNthOfType;", "Lcom/fleeksoft/ksoup/select/Evaluator$CssNthEvaluator;", "a", "", "b", "<init>", "(II)V", "calculatePosition", "root", "Lcom/fleeksoft/ksoup/nodes/Element;", "element", "getPseudoClass", "", "ksoup"})
    public static class IsNthOfType
    extends CssNthEvaluator {
        public IsNthOfType(int a, int b) {
            super(a, b);
        }

        @Override
        public int calculatePosition(@NotNull Element root, @NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Element element2 = element.parent();
            if (element2 == null) {
                return 0;
            }
            Element parent = element2;
            int pos = 0;
            int size = parent.childNodeSize();
            for (int i = 0; i < size; ++i) {
                Node node = parent.childNode(i);
                if (Intrinsics.areEqual((Object)node.normalName(), (Object)element.normalName())) {
                    ++pos;
                }
                if (Intrinsics.areEqual((Object)node, (Object)element)) break;
            }
            return pos;
        }

        @Override
        @NotNull
        protected String getPseudoClass() {
            return "nth-of-type";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/fleeksoft/ksoup/select/Evaluator$IsOnlyChild;", "Lcom/fleeksoft/ksoup/select/Evaluator;", "<init>", "()V", "matches", "", "root", "Lcom/fleeksoft/ksoup/nodes/Element;", "element", "toString", "", "ksoup"})
    public static final class IsOnlyChild
    extends Evaluator {
        @Override
        public boolean matches(@NotNull Element root, @NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Element p = element.parent();
            return p != null && !(p instanceof Document) && element.siblingElements().isEmpty();
        }

        @NotNull
        public String toString() {
            return ":only-child";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/fleeksoft/ksoup/select/Evaluator$IsOnlyOfType;", "Lcom/fleeksoft/ksoup/select/Evaluator;", "<init>", "()V", "matches", "", "root", "Lcom/fleeksoft/ksoup/nodes/Element;", "element", "toString", "", "ksoup"})
    public static final class IsOnlyOfType
    extends Evaluator {
        @Override
        public boolean matches(@NotNull Element root, @NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Element p = element.parent();
            if (p == null || p instanceof Document) {
                return false;
            }
            int pos = 0;
            for (Element next = p.firstElementChild(); next != null; next = next.nextElementSibling()) {
                if (Intrinsics.areEqual((Object)next.normalName(), (Object)element.normalName())) {
                    ++pos;
                }
                if (pos > 1) break;
            }
            return pos == 1;
        }

        @NotNull
        public String toString() {
            return ":only-of-type";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/fleeksoft/ksoup/select/Evaluator$IsRoot;", "Lcom/fleeksoft/ksoup/select/Evaluator;", "<init>", "()V", "matches", "", "root", "Lcom/fleeksoft/ksoup/nodes/Element;", "element", "cost", "", "toString", "", "ksoup"})
    public static final class IsRoot
    extends Evaluator {
        @Override
        public boolean matches(@NotNull Element root, @NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Element r = root instanceof Document ? root.firstElementChild() : root;
            return element == r;
        }

        @Override
        public int cost() {
            return 1;
        }

        @NotNull
        public String toString() {
            return ":root";
        }
    }

    @Deprecated(message="This selector is deprecated and will be removed in a future version. Migrate to <code>::textnode</code> using the <code>Element#selectNodes()</code> method instead.")
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/fleeksoft/ksoup/select/Evaluator$MatchText;", "Lcom/fleeksoft/ksoup/select/Evaluator;", "<init>", "()V", "matches", "", "root", "Lcom/fleeksoft/ksoup/nodes/Element;", "element", "cost", "", "toString", "", "Companion", "ksoup"})
    public static final class MatchText
    extends Evaluator {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private static boolean loggedError;

        public MatchText() {
            if (!loggedError) {
                loggedError = true;
                System.out.println((Object)"WARNING: :matchText selector is deprecated and will be removed in a future version. Use Element#selectNodes(String, Class) with selector ::textnode and class TextNode instead.");
            }
        }

        @Override
        public boolean matches(@NotNull Element root, @NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            if (element instanceof PseudoTextElement) {
                return true;
            }
            List<TextNode> textNodes = element.textNodes();
            for (TextNode textNode : textNodes) {
                PseudoTextElement pel = new PseudoTextElement(com.fleeksoft.ksoup.parser.Tag.Companion.valueOf(element.tagName(), element.tag().namespace(), ParseSettings.Companion.getPreserveCase()), element.baseUri(), element.attributes());
                textNode.replaceWith(pel);
                pel.appendChild(textNode);
            }
            return false;
        }

        @Override
        public int cost() {
            return -1;
        }

        @NotNull
        public String toString() {
            return ":matchText";
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/fleeksoft/ksoup/select/Evaluator$MatchText$Companion;", "", "<init>", "()V", "loggedError", "", "ksoup"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/fleeksoft/ksoup/select/Evaluator$Matches;", "Lcom/fleeksoft/ksoup/select/Evaluator;", "pattern", "Lkotlin/text/Regex;", "<init>", "(Lkotlin/text/Regex;)V", "matches", "", "root", "Lcom/fleeksoft/ksoup/nodes/Element;", "element", "cost", "", "toString", "", "ksoup"})
    public static final class Matches
    extends Evaluator {
        @NotNull
        private final Regex pattern;

        public Matches(@NotNull Regex pattern) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            this.pattern = pattern;
        }

        @Override
        public boolean matches(@NotNull Element root, @NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return this.pattern.containsMatchIn((CharSequence)element.text());
        }

        @Override
        public int cost() {
            return 8;
        }

        @NotNull
        public String toString() {
            return ":matches(" + this.pattern.getPattern() + ")";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/fleeksoft/ksoup/select/Evaluator$MatchesOwn;", "Lcom/fleeksoft/ksoup/select/Evaluator;", "pattern", "Lkotlin/text/Regex;", "<init>", "(Lkotlin/text/Regex;)V", "matches", "", "root", "Lcom/fleeksoft/ksoup/nodes/Element;", "element", "cost", "", "toString", "", "ksoup"})
    public static final class MatchesOwn
    extends Evaluator {
        @NotNull
        private final Regex pattern;

        public MatchesOwn(@NotNull Regex pattern) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            this.pattern = pattern;
        }

        @Override
        public boolean matches(@NotNull Element root, @NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return this.pattern.containsMatchIn((CharSequence)element.ownText());
        }

        @Override
        public int cost() {
            return 7;
        }

        @NotNull
        public String toString() {
            return ":matchesOwn(" + this.pattern.getPattern() + ")";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/fleeksoft/ksoup/select/Evaluator$MatchesWholeOwnText;", "Lcom/fleeksoft/ksoup/select/Evaluator;", "pattern", "Lkotlin/text/Regex;", "<init>", "(Lkotlin/text/Regex;)V", "matches", "", "root", "Lcom/fleeksoft/ksoup/nodes/Element;", "element", "cost", "", "toString", "", "ksoup"})
    public static final class MatchesWholeOwnText
    extends Evaluator {
        @NotNull
        private final Regex pattern;

        public MatchesWholeOwnText(@NotNull Regex pattern) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            this.pattern = pattern;
        }

        @Override
        public boolean matches(@NotNull Element root, @NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return this.pattern.containsMatchIn((CharSequence)element.wholeOwnText());
        }

        @Override
        public int cost() {
            return 7;
        }

        @NotNull
        public String toString() {
            return ":matchesWholeOwnText(" + this.pattern.getPattern() + ")";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/fleeksoft/ksoup/select/Evaluator$MatchesWholeText;", "Lcom/fleeksoft/ksoup/select/Evaluator;", "pattern", "Lkotlin/text/Regex;", "<init>", "(Lkotlin/text/Regex;)V", "matches", "", "root", "Lcom/fleeksoft/ksoup/nodes/Element;", "element", "cost", "", "toString", "", "ksoup"})
    public static final class MatchesWholeText
    extends Evaluator {
        @NotNull
        private final Regex pattern;

        public MatchesWholeText(@NotNull Regex pattern) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            this.pattern = pattern;
        }

        @Override
        public boolean matches(@NotNull Element root, @NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return this.pattern.containsMatchIn((CharSequence)element.wholeText());
        }

        @Override
        public int cost() {
            return 8;
        }

        @NotNull
        public String toString() {
            return ":matchesWholeText(" + this.pattern.getPattern() + ")";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/fleeksoft/ksoup/select/Evaluator$Tag;", "Lcom/fleeksoft/ksoup/select/Evaluator;", "tagName", "", "<init>", "(Ljava/lang/String;)V", "matches", "", "root", "Lcom/fleeksoft/ksoup/nodes/Element;", "element", "cost", "", "toString", "ksoup"})
    public static final class Tag
    extends Evaluator {
        @NotNull
        private final String tagName;

        public Tag(@NotNull String tagName) {
            Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
            this.tagName = tagName;
        }

        @Override
        public boolean matches(@NotNull Element root, @NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return element.nameIs(this.tagName);
        }

        @Override
        public int cost() {
            return 1;
        }

        @NotNull
        public String toString() {
            return this.tagName;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/fleeksoft/ksoup/select/Evaluator$TagEndsWith;", "Lcom/fleeksoft/ksoup/select/Evaluator;", "tagName", "", "<init>", "(Ljava/lang/String;)V", "matches", "", "root", "Lcom/fleeksoft/ksoup/nodes/Element;", "element", "toString", "ksoup"})
    public static final class TagEndsWith
    extends Evaluator {
        @NotNull
        private final String tagName;

        public TagEndsWith(@NotNull String tagName) {
            Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
            this.tagName = tagName;
        }

        @Override
        public boolean matches(@NotNull Element root, @NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return StringsKt.endsWith$default((String)element.normalName(), (String)this.tagName, (boolean)false, (int)2, null);
        }

        @NotNull
        public String toString() {
            return "*|" + this.tagName;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/fleeksoft/ksoup/select/Evaluator$TagStartsWith;", "Lcom/fleeksoft/ksoup/select/Evaluator;", "tagName", "", "<init>", "(Ljava/lang/String;)V", "matches", "", "root", "Lcom/fleeksoft/ksoup/nodes/Element;", "element", "toString", "ksoup"})
    public static final class TagStartsWith
    extends Evaluator {
        @NotNull
        private final String tagName;

        public TagStartsWith(@NotNull String tagName) {
            Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
            this.tagName = tagName;
        }

        @Override
        public boolean matches(@NotNull Element root, @NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return StringsKt.startsWith$default((String)element.normalName(), (String)this.tagName, (boolean)false, (int)2, null);
        }

        @NotNull
        public String toString() {
            return this.tagName + "|*";
        }
    }
}

