/*
 * Decompiled with CFR 0.152.
 */
package com.fleeksoft.ksoup.safety;

import com.fleeksoft.ksoup.helper.Validate;
import com.fleeksoft.ksoup.internal.Normalizer;
import com.fleeksoft.ksoup.nodes.Attribute;
import com.fleeksoft.ksoup.nodes.Attributes;
import com.fleeksoft.ksoup.nodes.Element;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 42\u00020\u0001:\u0006/01234B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0005J\u001f\u0010\u0012\u001a\u00020\u00002\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0014\"\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J\u001f\u0010\u0017\u001a\u00020\u00002\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0014\"\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J'\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u00152\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0014\"\u00020\u0015\u00a2\u0006\u0002\u0010\u001aJ'\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u00152\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0014\"\u00020\u0015\u00a2\u0006\u0002\u0010\u001aJ\u001e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u0015J\u0016\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0015J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0011J\u0006\u0010\u0010\u001a\u00020\u0011J/\u0010!\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00152\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0014\"\u00020\u0015\u00a2\u0006\u0002\u0010\"J/\u0010#\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00152\u0012\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0014\"\u00020\u0015\u00a2\u0006\u0002\u0010\"J\u0010\u0010$\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u0015H\u0016J \u0010%\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016J&\u0010+\u001a\u00020\u00112\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0,H\u0002J\u000e\u0010-\u001a\u00020.2\u0006\u0010&\u001a\u00020\u0015R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00070\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\f\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\r0\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u000e\u001a \u0012\u0004\u0012\u00020\b\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00070\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/fleeksoft/ksoup/safety/Safelist;", "", "<init>", "()V", "copy", "(Lcom/fleeksoft/ksoup/safety/Safelist;)V", "tagNames", "", "Lcom/fleeksoft/ksoup/safety/Safelist$TagName;", "attributes", "", "Lcom/fleeksoft/ksoup/safety/Safelist$AttributeKey;", "enforcedAttributes", "Lcom/fleeksoft/ksoup/safety/Safelist$AttributeValue;", "protocols", "Lcom/fleeksoft/ksoup/safety/Safelist$Protocol;", "preserveRelativeLinks", "", "addTags", "tags", "", "", "([Ljava/lang/String;)Lcom/fleeksoft/ksoup/safety/Safelist;", "removeTags", "addAttributes", "tag", "(Ljava/lang/String;[Ljava/lang/String;)Lcom/fleeksoft/ksoup/safety/Safelist;", "removeAttributes", "addEnforcedAttribute", "attribute", "value", "removeEnforcedAttribute", "preserve", "addProtocols", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lcom/fleeksoft/ksoup/safety/Safelist;", "removeProtocols", "isSafeTag", "isSafeAttribute", "tagName", "el", "Lcom/fleeksoft/ksoup/nodes/Element;", "attr", "Lcom/fleeksoft/ksoup/nodes/Attribute;", "testValidProtocol", "", "getEnforcedAttributes", "Lcom/fleeksoft/ksoup/nodes/Attributes;", "TagName", "AttributeKey", "AttributeValue", "Protocol", "TypedValue", "Companion", "ksoup"})
@SourceDebugExtension(value={"SMAP\nSafelist.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Safelist.kt\ncom/fleeksoft/ksoup/safety/Safelist\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,665:1\n382#2,7:666\n382#2,7:673\n382#2,7:680\n*S KotlinDebug\n*F\n+ 1 Safelist.kt\ncom/fleeksoft/ksoup/safety/Safelist\n*L\n163#1:666,7\n333#1:673,7\n334#1:680,7\n*E\n"})
public class Safelist {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<TagName> tagNames;
    @NotNull
    private final Map<TagName, Set<AttributeKey>> attributes;
    @NotNull
    private final Map<TagName, Map<AttributeKey, AttributeValue>> enforcedAttributes;
    @NotNull
    private final Map<TagName, Map<AttributeKey, Set<Protocol>>> protocols;
    private boolean preserveRelativeLinks;
    @NotNull
    private static final String All = ":all";

    public Safelist() {
        this.tagNames = new HashSet();
        this.attributes = new LinkedHashMap();
        this.enforcedAttributes = new LinkedHashMap();
        this.protocols = new LinkedHashMap();
    }

    public Safelist(@NotNull Safelist copy) {
        Object value;
        TagName key;
        Intrinsics.checkNotNullParameter((Object)copy, (String)"copy");
        this();
        this.tagNames.addAll((Collection<TagName>)copy.tagNames);
        for (Map.Entry<TagName, Set<AttributeKey>> entry : copy.attributes.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            this.attributes.put(key, new HashSet((Collection)value));
        }
        for (Map.Entry<TagName, Object> entry : copy.enforcedAttributes.entrySet()) {
            key = entry.getKey();
            value = (Map)entry.getValue();
            this.enforcedAttributes.put(key, new HashMap(value));
        }
        for (Map.Entry<TagName, Object> entry : copy.protocols.entrySet()) {
            key = entry.getKey();
            value = (Map)entry.getValue();
            Map attributeProtocolsCopy = new LinkedHashMap();
            for (Map.Entry entry2 : value.entrySet()) {
                AttributeKey key1 = (AttributeKey)entry2.getKey();
                Set value1 = (Set)entry2.getValue();
                attributeProtocolsCopy.put(key1, new HashSet(value1));
            }
            this.protocols.put(key, attributeProtocolsCopy);
        }
        this.preserveRelativeLinks = copy.preserveRelativeLinks;
    }

    @NotNull
    public final Safelist addTags(String ... tags) {
        Intrinsics.checkNotNullParameter((Object)tags, (String)"tags");
        for (String tagName : tags) {
            Validate.INSTANCE.notEmpty(tagName);
            Validate.INSTANCE.isFalse(StringsKt.equals((String)tagName, (String)"noscript", (boolean)true), "noscript is unsupported in Safelists, due to incompatibilities between parsers with and without script-mode enabled");
            this.tagNames.add(TagName.Companion.valueOf(tagName));
        }
        return this;
    }

    @NotNull
    public final Safelist removeTags(String ... tags) {
        Intrinsics.checkNotNullParameter((Object)tags, (String)"tags");
        for (String tag : tags) {
            Validate.INSTANCE.notEmpty(tag);
            TagName tagName = TagName.Companion.valueOf(tag);
            if (!this.tagNames.remove(tagName)) continue;
            this.attributes.remove(tagName);
            this.enforcedAttributes.remove(tagName);
            this.protocols.remove(tagName);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Safelist addAttributes(@NotNull String tag, String ... attributes) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Validate.INSTANCE.notEmpty(tag);
        Validate.INSTANCE.isTrue(!(attributes.length == 0), "No attribute names supplied.");
        String[] stringArray = new String[]{tag};
        this.addTags(stringArray);
        TagName tagName = TagName.Companion.valueOf(tag);
        Set attributeSet = new HashSet();
        for (String key : attributes) {
            Validate.INSTANCE.notEmpty(key);
            attributeSet.add(AttributeKey.Companion.valueOf(key));
        }
        Map<TagName, Set<AttributeKey>> map = this.attributes;
        TagName key$iv = tagName;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = new LinkedHashSet();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        Set attr = (Set)object;
        attr.addAll(attributeSet);
        return this;
    }

    @NotNull
    public final Safelist removeAttributes(@NotNull String tag, String ... attributes) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Validate.INSTANCE.notEmpty(tag);
        Validate.INSTANCE.isTrue(!(attributes.length == 0), "No attribute names supplied.");
        TagName tagName = TagName.Companion.valueOf(tag);
        Set attributeSet = new HashSet();
        for (String key : attributes) {
            Validate.INSTANCE.notEmpty(key);
            attributeSet.add(AttributeKey.Companion.valueOf(key));
        }
        if (this.tagNames.contains(tagName) && this.attributes.containsKey(tagName)) {
            Set<AttributeKey> set = this.attributes.get(tagName);
            Intrinsics.checkNotNull(set);
            Set<AttributeKey> currentSet = set;
            currentSet.removeAll(attributeSet);
            if (currentSet.isEmpty()) {
                this.attributes.remove(tagName);
            }
        }
        if (Intrinsics.areEqual((Object)tag, (Object)All)) {
            Iterator<Map.Entry<TagName, Set<AttributeKey>>> it = this.attributes.entrySet().iterator();
            while (it.hasNext()) {
                Set<AttributeKey> currentSet = it.next().getValue();
                currentSet.removeAll(attributeSet);
                if (!currentSet.isEmpty()) continue;
                it.remove();
            }
        }
        return this;
    }

    @NotNull
    public final Safelist addEnforcedAttribute(@NotNull String tag, @NotNull String attribute, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Validate.INSTANCE.notEmpty(tag);
        Validate.INSTANCE.notEmpty(attribute);
        Validate.INSTANCE.notEmpty(value);
        TagName tagName = TagName.Companion.valueOf(tag);
        this.tagNames.add(tagName);
        AttributeKey attrKey = AttributeKey.Companion.valueOf(attribute);
        AttributeValue attrVal = AttributeValue.Companion.valueOf(value);
        if (this.enforcedAttributes.containsKey(tagName)) {
            Map<AttributeKey, AttributeValue> map = this.enforcedAttributes.get(tagName);
            if (map != null) {
                map.put(attrKey, attrVal);
            }
        } else {
            Map attrMap = new HashMap();
            attrMap.put(attrKey, attrVal);
            this.enforcedAttributes.put(tagName, attrMap);
        }
        return this;
    }

    @NotNull
    public final Safelist removeEnforcedAttribute(@NotNull String tag, @NotNull String attribute) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        Validate.INSTANCE.notEmpty(tag);
        Validate.INSTANCE.notEmpty(attribute);
        TagName tagName = TagName.Companion.valueOf(tag);
        if (this.tagNames.contains(tagName) && this.enforcedAttributes.containsKey(tagName)) {
            Map<AttributeKey, AttributeValue> attrMap;
            AttributeKey attrKey = AttributeKey.Companion.valueOf(attribute);
            Map<AttributeKey, AttributeValue> map = attrMap = this.enforcedAttributes.get(tagName);
            if (map != null) {
                map.remove(attrKey);
            }
            Map<AttributeKey, AttributeValue> map2 = attrMap;
            boolean bl = map2 != null ? map2.isEmpty() : false;
            if (bl) {
                this.enforcedAttributes.remove(tagName);
            }
        }
        return this;
    }

    @NotNull
    public final Safelist preserveRelativeLinks(boolean preserve) {
        this.preserveRelativeLinks = preserve;
        return this;
    }

    public final boolean preserveRelativeLinks() {
        return this.preserveRelativeLinks;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Safelist addProtocols(@NotNull String tag, @NotNull String attribute, String ... protocols) {
        Object object;
        void $this$getOrPut$iv;
        Object object2;
        void $this$getOrPut$iv2;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        Intrinsics.checkNotNullParameter((Object)protocols, (String)"protocols");
        Validate.INSTANCE.notEmpty(tag);
        Validate.INSTANCE.notEmpty(attribute);
        TagName tagName = TagName.Companion.valueOf(tag);
        AttributeKey attrKey = AttributeKey.Companion.valueOf(attribute);
        Map<TagName, Map<AttributeKey, Set<Protocol>>> map = this.protocols;
        Object key$iv = tagName;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv2.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Map answer$iv = new LinkedHashMap();
            $this$getOrPut$iv2.put(key$iv, answer$iv);
            object2 = answer$iv;
        } else {
            object2 = value$iv;
        }
        Map attrMap = (Map)object2;
        key$iv = attrMap;
        AttributeKey key$iv2 = attrKey;
        boolean $i$f$getOrPut2 = false;
        Object value$iv2 = $this$getOrPut$iv.get(key$iv2);
        if (value$iv2 == null) {
            boolean bl = false;
            Set answer$iv = new HashSet();
            $this$getOrPut$iv.put(key$iv2, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv2;
        }
        Set protSet = (Set)object;
        for (String protocol : protocols) {
            Validate.INSTANCE.notEmpty(protocol);
            Protocol prot = Protocol.Companion.valueOf(protocol);
            protSet.add(prot);
        }
        return this;
    }

    @NotNull
    public final Safelist removeProtocols(@NotNull String tag, @NotNull String attribute, String ... removeProtocols) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        Intrinsics.checkNotNullParameter((Object)removeProtocols, (String)"removeProtocols");
        Validate.INSTANCE.notEmpty(tag);
        Validate.INSTANCE.notEmpty(attribute);
        TagName tagName = TagName.Companion.valueOf(tag);
        AttributeKey attr = AttributeKey.Companion.valueOf(attribute);
        Validate.INSTANCE.isTrue(this.protocols.containsKey(tagName), "Cannot remove a protocol that is not set.");
        Map<AttributeKey, Set<Protocol>> map = this.protocols.get(tagName);
        Intrinsics.checkNotNull(map);
        Map<AttributeKey, Set<Protocol>> tagProtocols = map;
        Validate.INSTANCE.isTrue(tagProtocols.containsKey(attr), "Cannot remove a protocol that is not set.");
        Set<Protocol> set = tagProtocols.get(attr);
        Intrinsics.checkNotNull(set);
        Set<Protocol> attrProtocols = set;
        for (String protocol : removeProtocols) {
            Validate.INSTANCE.notEmpty(protocol);
            attrProtocols.remove(Protocol.Companion.valueOf(protocol));
        }
        if (attrProtocols.isEmpty()) {
            tagProtocols.remove(attr);
            if (tagProtocols.isEmpty()) {
                this.protocols.remove(tagName);
            }
        }
        return this;
    }

    public boolean isSafeTag(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        return this.tagNames.contains(TagName.Companion.valueOf(tag));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSafeAttribute(@NotNull String tagName, @NotNull Element el, @NotNull Attribute attr) {
        String attrKey;
        Attributes expect;
        Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
        Intrinsics.checkNotNullParameter((Object)el, (String)"el");
        Intrinsics.checkNotNullParameter((Object)attr, (String)"attr");
        TagName tag = TagName.Companion.valueOf(tagName);
        AttributeKey key = AttributeKey.Companion.valueOf(attr.getKey());
        Set<AttributeKey> okSet = this.attributes.get(tag);
        if (okSet != null && okSet.contains(key)) {
            if (!this.protocols.containsKey(tag)) return true;
            Map<AttributeKey, Set<Protocol>> map = this.protocols.get(tag);
            Intrinsics.checkNotNull(map);
            Map<AttributeKey, Set<Protocol>> attrProts = map;
            if (!attrProts.containsKey(key)) return true;
            Set<Protocol> set = attrProts.get(key);
            Intrinsics.checkNotNull(set);
            if (!this.testValidProtocol(el, attr, set)) return false;
            return true;
        }
        Map<AttributeKey, AttributeValue> enforcedSet = this.enforcedAttributes.get(tag);
        if (enforcedSet != null && (expect = this.getEnforcedAttributes(tagName)).hasKeyIgnoreCase(attrKey = attr.getKey())) {
            return expect.getIgnoreCase(attrKey).equals(attr.getValue());
        }
        if (Intrinsics.areEqual((Object)tagName, (Object)All)) return false;
        if (!this.isSafeAttribute(All, el, attr)) return false;
        return true;
    }

    private final boolean testValidProtocol(Element el, Attribute attr, Set<Protocol> protocols) {
        String value = el.absUrl(attr.getKey());
        if (((CharSequence)value).length() == 0) {
            value = attr.getValue();
        }
        if (!this.preserveRelativeLinks) {
            attr.setValue(value);
        }
        for (Protocol protocol : protocols) {
            Object prot = protocol.toString();
            if (Intrinsics.areEqual((Object)prot, (Object)"#")) {
                if (!Safelist.Companion.isValidAnchor(value)) continue;
                return true;
            }
            prot = (String)prot + ":";
            if (!StringsKt.startsWith$default((String)Normalizer.INSTANCE.lowerCase(value), (String)prot, (boolean)false, (int)2, null)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public final Attributes getEnforcedAttributes(@NotNull String tagName) {
        Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
        Attributes attrs = new Attributes();
        TagName tag = TagName.Companion.valueOf(tagName);
        if (this.enforcedAttributes.containsKey(tag)) {
            Map<AttributeKey, AttributeValue> map = this.enforcedAttributes.get(tag);
            Intrinsics.checkNotNull(map);
            Map<AttributeKey, AttributeValue> keyVals = map;
            for (Map.Entry<AttributeKey, AttributeValue> entry : keyVals.entrySet()) {
                AttributeKey key = entry.getKey();
                AttributeValue value = entry.getValue();
                attrs.put(key.toString(), value.toString());
            }
        }
        return attrs;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0007"}, d2={"Lcom/fleeksoft/ksoup/safety/Safelist$AttributeKey;", "Lcom/fleeksoft/ksoup/safety/Safelist$TypedValue;", "value", "", "<init>", "(Ljava/lang/String;)V", "Companion", "ksoup"})
    public static final class AttributeKey
    extends TypedValue {
        @NotNull
        public static final Companion Companion = new Companion(null);

        public AttributeKey(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            super(value);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/fleeksoft/ksoup/safety/Safelist$AttributeKey$Companion;", "", "<init>", "()V", "valueOf", "Lcom/fleeksoft/ksoup/safety/Safelist$AttributeKey;", "value", "", "ksoup"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final AttributeKey valueOf(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return new AttributeKey(Normalizer.INSTANCE.lowerCase(value));
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0007"}, d2={"Lcom/fleeksoft/ksoup/safety/Safelist$AttributeValue;", "Lcom/fleeksoft/ksoup/safety/Safelist$TypedValue;", "value", "", "<init>", "(Ljava/lang/String;)V", "Companion", "ksoup"})
    public static final class AttributeValue
    extends TypedValue {
        @NotNull
        public static final Companion Companion = new Companion(null);

        public AttributeValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            super(value);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/fleeksoft/ksoup/safety/Safelist$AttributeValue$Companion;", "", "<init>", "()V", "valueOf", "Lcom/fleeksoft/ksoup/safety/Safelist$AttributeValue;", "value", "", "ksoup"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final AttributeValue valueOf(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return new AttributeValue(value);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0007J\u0006\u0010\t\u001a\u00020\u0007J\u0006\u0010\n\u001a\u00020\u0007J\u0006\u0010\u000b\u001a\u00020\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/fleeksoft/ksoup/safety/Safelist$Companion;", "", "<init>", "()V", "All", "", "none", "Lcom/fleeksoft/ksoup/safety/Safelist;", "simpleText", "basic", "basicWithImages", "relaxed", "isValidAnchor", "", "value", "ksoup"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Safelist none() {
            return new Safelist();
        }

        @NotNull
        public final Safelist simpleText() {
            String[] stringArray = new String[]{"b", "em", "i", "strong", "u"};
            return new Safelist().addTags(stringArray);
        }

        @NotNull
        public final Safelist basic() {
            String[] stringArray = new String[]{"a", "b", "blockquote", "br", "cite", "code", "dd", "dl", "dt", "em", "i", "li", "ol", "p", "pre", "q", "small", "span", "strike", "strong", "sub", "sup", "u", "ul"};
            Safelist safelist = new Safelist().addTags(stringArray);
            stringArray = new String[]{"href"};
            Safelist safelist2 = safelist.addAttributes("a", stringArray);
            stringArray = new String[]{"cite"};
            Safelist safelist3 = safelist2.addAttributes("blockquote", stringArray);
            stringArray = new String[]{"cite"};
            Safelist safelist4 = safelist3.addAttributes("q", stringArray);
            stringArray = new String[]{"ftp", "http", "https", "mailto"};
            Safelist safelist5 = safelist4.addProtocols("a", "href", stringArray);
            stringArray = new String[]{"http", "https"};
            Safelist safelist6 = safelist5.addProtocols("blockquote", "cite", stringArray);
            stringArray = new String[]{"http", "https"};
            return safelist6.addProtocols("cite", "cite", stringArray).addEnforcedAttribute("a", "rel", "nofollow");
        }

        @NotNull
        public final Safelist basicWithImages() {
            String[] stringArray = new String[]{"img"};
            Safelist safelist = this.basic().addTags(stringArray);
            stringArray = new String[]{"align", "alt", "height", "src", "title", "width"};
            Safelist safelist2 = safelist.addAttributes("img", stringArray);
            stringArray = new String[]{"http", "https"};
            return safelist2.addProtocols("img", "src", stringArray);
        }

        @NotNull
        public final Safelist relaxed() {
            String[] stringArray = new String[]{"a", "b", "blockquote", "br", "caption", "cite", "code", "col", "colgroup", "dd", "div", "dl", "dt", "em", "h1", "h2", "h3", "h4", "h5", "h6", "i", "img", "li", "ol", "p", "pre", "q", "small", "span", "strike", "strong", "sub", "sup", "table", "tbody", "td", "tfoot", "th", "thead", "tr", "u", "ul"};
            Safelist safelist = new Safelist().addTags(stringArray);
            stringArray = new String[]{"href", "title"};
            Safelist safelist2 = safelist.addAttributes("a", stringArray);
            stringArray = new String[]{"cite"};
            Safelist safelist3 = safelist2.addAttributes("blockquote", stringArray);
            stringArray = new String[]{"span", "width"};
            Safelist safelist4 = safelist3.addAttributes("col", stringArray);
            stringArray = new String[]{"span", "width"};
            Safelist safelist5 = safelist4.addAttributes("colgroup", stringArray);
            stringArray = new String[]{"align", "alt", "height", "src", "title", "width"};
            Safelist safelist6 = safelist5.addAttributes("img", stringArray);
            stringArray = new String[]{"start", "type"};
            Safelist safelist7 = safelist6.addAttributes("ol", stringArray);
            stringArray = new String[]{"cite"};
            Safelist safelist8 = safelist7.addAttributes("q", stringArray);
            stringArray = new String[]{"summary", "width"};
            Safelist safelist9 = safelist8.addAttributes("table", stringArray);
            stringArray = new String[]{"abbr", "axis", "colspan", "rowspan", "width"};
            Safelist safelist10 = safelist9.addAttributes("td", stringArray);
            stringArray = new String[]{"abbr", "axis", "colspan", "rowspan", "scope", "width"};
            Safelist safelist11 = safelist10.addAttributes("th", stringArray);
            stringArray = new String[]{"type"};
            Safelist safelist12 = safelist11.addAttributes("ul", stringArray);
            stringArray = new String[]{"ftp", "http", "https", "mailto"};
            Safelist safelist13 = safelist12.addProtocols("a", "href", stringArray);
            stringArray = new String[]{"http", "https"};
            Safelist safelist14 = safelist13.addProtocols("blockquote", "cite", stringArray);
            stringArray = new String[]{"http", "https"};
            Safelist safelist15 = safelist14.addProtocols("cite", "cite", stringArray);
            stringArray = new String[]{"http", "https"};
            Safelist safelist16 = safelist15.addProtocols("img", "src", stringArray);
            stringArray = new String[]{"http", "https"};
            return safelist16.addProtocols("q", "cite", stringArray);
        }

        private final boolean isValidAnchor(String value) {
            CharSequence charSequence;
            return StringsKt.startsWith$default((String)value, (String)"#", (boolean)false, (int)2, null) && !new Regex(".*\\s.*").matches(charSequence = (CharSequence)value);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0007"}, d2={"Lcom/fleeksoft/ksoup/safety/Safelist$Protocol;", "Lcom/fleeksoft/ksoup/safety/Safelist$TypedValue;", "value", "", "<init>", "(Ljava/lang/String;)V", "Companion", "ksoup"})
    public static final class Protocol
    extends TypedValue {
        @NotNull
        public static final Companion Companion = new Companion(null);

        public Protocol(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            super(value);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/fleeksoft/ksoup/safety/Safelist$Protocol$Companion;", "", "<init>", "()V", "valueOf", "Lcom/fleeksoft/ksoup/safety/Safelist$Protocol;", "value", "", "ksoup"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Protocol valueOf(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return new Protocol(value);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0007"}, d2={"Lcom/fleeksoft/ksoup/safety/Safelist$TagName;", "Lcom/fleeksoft/ksoup/safety/Safelist$TypedValue;", "value", "", "<init>", "(Ljava/lang/String;)V", "Companion", "ksoup"})
    public static final class TagName
    extends TypedValue {
        @NotNull
        public static final Companion Companion = new Companion(null);

        public TagName(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            super(value);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/fleeksoft/ksoup/safety/Safelist$TagName$Companion;", "", "<init>", "()V", "valueOf", "Lcom/fleeksoft/ksoup/safety/Safelist$TagName;", "value", "", "ksoup"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final TagName valueOf(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return new TagName(Normalizer.INSTANCE.lowerCase(value));
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000b\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/fleeksoft/ksoup/safety/Safelist$TypedValue;", "", "value", "", "<init>", "(Ljava/lang/String;)V", "hashCode", "", "equals", "", "other", "toString", "ksoup"})
    public static abstract class TypedValue {
        @NotNull
        private final String value;

        public TypedValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.value = value;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            TypedValue obj = (TypedValue)other;
            return Intrinsics.areEqual((Object)this.value, (Object)obj.value);
        }

        @NotNull
        public String toString() {
            return this.value;
        }
    }
}

