/*
 * Decompiled with CFR 0.152.
 */
package com.fleeksoft.ksoup.safety;

import com.fleeksoft.ksoup.nodes.Attribute;
import com.fleeksoft.ksoup.nodes.Attributes;
import com.fleeksoft.ksoup.nodes.DataNode;
import com.fleeksoft.ksoup.nodes.Document;
import com.fleeksoft.ksoup.nodes.Element;
import com.fleeksoft.ksoup.nodes.Node;
import com.fleeksoft.ksoup.nodes.TextNode;
import com.fleeksoft.ksoup.parser.ParseErrorList;
import com.fleeksoft.ksoup.parser.Parser;
import com.fleeksoft.ksoup.safety.Safelist;
import com.fleeksoft.ksoup.select.NodeVisitor;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u0016\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0007J\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/fleeksoft/ksoup/safety/Cleaner;", "", "safelist", "Lcom/fleeksoft/ksoup/safety/Safelist;", "<init>", "(Lcom/fleeksoft/ksoup/safety/Safelist;)V", "clean", "Lcom/fleeksoft/ksoup/nodes/Document;", "dirtyDocument", "isValid", "", "isValidBodyHtml", "bodyHtml", "", "copySafeNodes", "", "source", "Lcom/fleeksoft/ksoup/nodes/Element;", "dest", "createSafeElement", "Lcom/fleeksoft/ksoup/safety/Cleaner$ElementMeta;", "sourceEl", "CleaningVisitor", "ElementMeta", "ksoup"})
public final class Cleaner {
    @NotNull
    private final Safelist safelist;

    public Cleaner(@NotNull Safelist safelist) {
        Intrinsics.checkNotNullParameter((Object)safelist, (String)"safelist");
        this.safelist = safelist;
    }

    @NotNull
    public final Document clean(@NotNull Document dirtyDocument) {
        Intrinsics.checkNotNullParameter((Object)dirtyDocument, (String)"dirtyDocument");
        Document clean = Document.Companion.createShell(dirtyDocument.baseUri());
        this.copySafeNodes(dirtyDocument.body(), clean.body());
        clean.outputSettings(dirtyDocument.outputSettings().clone());
        return clean;
    }

    public final boolean isValid(@NotNull Document dirtyDocument) {
        Intrinsics.checkNotNullParameter((Object)dirtyDocument, (String)"dirtyDocument");
        Document clean = Document.Companion.createShell(dirtyDocument.baseUri());
        int numDiscarded = this.copySafeNodes(dirtyDocument.body(), clean.body());
        return numDiscarded == 0 && dirtyDocument.head().childNodes().isEmpty();
    }

    public final boolean isValidBodyHtml(@NotNull String bodyHtml) {
        Intrinsics.checkNotNullParameter((Object)bodyHtml, (String)"bodyHtml");
        String baseUri = this.safelist.preserveRelativeLinks() ? "https://dummy.example/" : "";
        Document clean = Document.Companion.createShell(baseUri);
        Document dirty = Document.Companion.createShell(baseUri);
        ParseErrorList errorList = ParseErrorList.Companion.tracking(1);
        List<Node> nodes = Parser.Companion.parseFragment(bodyHtml, dirty.body(), baseUri, errorList);
        dirty.body().insertChildren(0, (Collection<? extends Node>)nodes);
        int numDiscarded = this.copySafeNodes(dirty.body(), clean.body());
        return numDiscarded == 0 && errorList.isEmpty();
    }

    private final int copySafeNodes(Element source, Element dest) {
        CleaningVisitor cleaningVisitor = new CleaningVisitor(source, dest);
        cleaningVisitor.traverse(source);
        return cleaningVisitor.getNumDiscarded$ksoup();
    }

    private final ElementMeta createSafeElement(Element sourceEl) {
        Element dest = sourceEl.shallowClone();
        String sourceTag = sourceEl.tagName();
        Attributes destAttrs = dest.attributes();
        dest.clearAttributes();
        int numDiscarded = 0;
        Attributes sourceAttrs = sourceEl.attributes();
        for (Attribute sourceAttr : sourceAttrs) {
            Object object = this.safelist.isSafeAttribute(sourceTag, sourceEl, sourceAttr) ? destAttrs.put(sourceAttr) : Integer.valueOf(numDiscarded++);
        }
        Attributes enforcedAttrs = this.safelist.getEnforcedAttributes(sourceTag);
        if (sourceEl.nameIs("a") && Intrinsics.areEqual((Object)enforcedAttrs.get("rel"), (Object)"nofollow")) {
            String href = sourceEl.absUrl("href");
            String sourceBase = sourceEl.baseUri();
            if (!(((CharSequence)href).length() == 0) && !(((CharSequence)sourceBase).length() == 0) && StringsKt.startsWith$default((String)href, (String)sourceBase, (boolean)false, (int)2, null)) {
                enforcedAttrs.remove("rel");
            }
        }
        destAttrs.addAll(enforcedAttrs);
        dest.attributes().addAll(destAttrs);
        return new ElementMeta(dest, numDiscarded);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\bH\u0016J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/fleeksoft/ksoup/safety/Cleaner$CleaningVisitor;", "Lcom/fleeksoft/ksoup/select/NodeVisitor;", "root", "Lcom/fleeksoft/ksoup/nodes/Element;", "destination", "<init>", "(Lcom/fleeksoft/ksoup/safety/Cleaner;Lcom/fleeksoft/ksoup/nodes/Element;Lcom/fleeksoft/ksoup/nodes/Element;)V", "numDiscarded", "", "getNumDiscarded$ksoup", "()I", "setNumDiscarded$ksoup", "(I)V", "head", "", "node", "Lcom/fleeksoft/ksoup/nodes/Node;", "depth", "tail", "ksoup"})
    public final class CleaningVisitor
    implements NodeVisitor {
        @NotNull
        private final Element root;
        @NotNull
        private Element destination;
        private int numDiscarded;

        public CleaningVisitor(@NotNull Element root, Element destination) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
            this.root = root;
            this.destination = destination;
        }

        public final int getNumDiscarded$ksoup() {
            return this.numDiscarded;
        }

        public final void setNumDiscarded$ksoup(int n) {
            this.numDiscarded = n;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void head(@NotNull Node node, int depth) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (node instanceof Element) {
                if (Cleaner.this.safelist.isSafeTag(((Element)node).normalName())) {
                    ElementMeta meta = Cleaner.this.createSafeElement((Element)node);
                    Element destChild = meta.getEl();
                    this.destination.appendChild(destChild);
                    this.numDiscarded += meta.getNumAttribsDiscarded();
                    this.destination = destChild;
                } else if (node != this.root) {
                    int meta = this.numDiscarded;
                    this.numDiscarded = meta + 1;
                }
                object = Unit.INSTANCE;
                return;
            }
            if (node instanceof TextNode) {
                TextNode destText = new TextNode(((TextNode)node).getWholeText());
                object = this.destination.appendChild(destText);
                return;
            }
            if (node instanceof DataNode) {
                Safelist safelist = Cleaner.this.safelist;
                Element element = ((DataNode)node).parent();
                Intrinsics.checkNotNull((Object)element);
                if (safelist.isSafeTag(element.normalName())) {
                    Node sourceData = node;
                    DataNode destData = new DataNode(((DataNode)sourceData).getWholeData());
                    object = this.destination.appendChild(destData);
                    return;
                }
            }
            int n = this.numDiscarded;
            this.numDiscarded = n + 1;
            object = n;
        }

        @Override
        public void tail(@NotNull Node node, int depth) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (node instanceof Element && Cleaner.this.safelist.isSafeTag(((Element)node).normalName())) {
                Element element = this.destination.parent();
                Intrinsics.checkNotNull((Object)element);
                this.destination = element;
            }
        }

        @Override
        public void traverse(@NotNull Node root) {
            NodeVisitor.DefaultImpls.traverse(this, root);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/fleeksoft/ksoup/safety/Cleaner$ElementMeta;", "", "el", "Lcom/fleeksoft/ksoup/nodes/Element;", "numAttribsDiscarded", "", "<init>", "(Lcom/fleeksoft/ksoup/nodes/Element;I)V", "getEl", "()Lcom/fleeksoft/ksoup/nodes/Element;", "setEl", "(Lcom/fleeksoft/ksoup/nodes/Element;)V", "getNumAttribsDiscarded", "()I", "setNumAttribsDiscarded", "(I)V", "ksoup"})
    private static final class ElementMeta {
        @NotNull
        private Element el;
        private int numAttribsDiscarded;

        public ElementMeta(@NotNull Element el, int numAttribsDiscarded) {
            Intrinsics.checkNotNullParameter((Object)el, (String)"el");
            this.el = el;
            this.numAttribsDiscarded = numAttribsDiscarded;
        }

        @NotNull
        public final Element getEl() {
            return this.el;
        }

        public final void setEl(@NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"<set-?>");
            this.el = element;
        }

        public final int getNumAttribsDiscarded() {
            return this.numAttribsDiscarded;
        }

        public final void setNumAttribsDiscarded(int n) {
            this.numAttribsDiscarded = n;
        }
    }
}

