/*
 * Decompiled with CFR 0.152.
 */
package com.fleeksoft.ksoup.parser;

import com.fleeksoft.ksoup.helper.Validate;
import com.fleeksoft.ksoup.internal.StringUtil;
import com.fleeksoft.ksoup.nodes.Document;
import com.fleeksoft.ksoup.nodes.Entities;
import com.fleeksoft.ksoup.parser.CharacterReader;
import com.fleeksoft.ksoup.parser.ParseError;
import com.fleeksoft.ksoup.parser.ParseErrorList;
import com.fleeksoft.ksoup.parser.Token;
import com.fleeksoft.ksoup.parser.TokenData;
import com.fleeksoft.ksoup.parser.TokeniserState;
import com.fleeksoft.ksoup.parser.TreeBuilder;
import com.fleeksoft.ksoup.parser.XmlTreeBuilder;
import com.fleeksoft.ksoup.ported.CoreExtensionsKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u001e\u0018\u0000 \\2\u00020\u0001:\u0001\\B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u00109\u001a\u00020\rJ\u000e\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\rJ\u000e\u0010:\u001a\u00020;2\u0006\u0010=\u001a\u000201J\u000e\u0010:\u001a\u00020;2\u0006\u0010>\u001a\u00020?J\u000e\u0010:\u001a\u00020;2\u0006\u0010@\u001a\u000207J\u000e\u0010A\u001a\u00020;2\u0006\u0010B\u001a\u00020\u000bJ\u000e\u0010C\u001a\u00020;2\u0006\u0010B\u001a\u00020\u000bJ\u001f\u0010D\u001a\u0004\u0018\u0001072\b\u0010E\u001a\u0004\u0018\u00010?2\u0006\u0010F\u001a\u00020\u000f\u00a2\u0006\u0002\u0010GJ\u000e\u0010H\u001a\u00020\u001d2\u0006\u0010I\u001a\u00020\u000fJ\u000e\u0010J\u001a\u00020-2\u0006\u0010K\u001a\u00020\u000fJ\u0006\u0010L\u001a\u00020;J\u0006\u0010M\u001a\u00020;J\u0006\u0010N\u001a\u00020;J\u0006\u0010O\u001a\u00020;J\u0006\u0010P\u001a\u00020;J\u0006\u0010Q\u001a\u00020;J\u0006\u0010R\u001a\u00020;J\u0006\u0010S\u001a\u00020\u000fJ\b\u0010T\u001a\u0004\u0018\u000101J\u0006\u0010U\u001a\u000201J\u0010\u0010V\u001a\u00020;2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010W\u001a\u00020;2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010X\u001a\u00020;2\u0006\u0010Y\u001a\u000201H\u0002J\u000e\u0010V\u001a\u00020;2\u0006\u0010Z\u001a\u000201J\u000e\u0010[\u001a\u0002012\u0006\u0010F\u001a\u00020\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010(\u001a\u00020)\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010,\u001a\u00020-\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0010\u00100\u001a\u0004\u0018\u000101X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00102\u001a\u0004\u0018\u000101X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000204X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u000204X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u000207X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u000207X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006]"}, d2={"Lcom/fleeksoft/ksoup/parser/Tokeniser;", "", "treeBuilder", "Lcom/fleeksoft/ksoup/parser/TreeBuilder;", "<init>", "(Lcom/fleeksoft/ksoup/parser/TreeBuilder;)V", "reader", "Lcom/fleeksoft/ksoup/parser/CharacterReader;", "errors", "Lcom/fleeksoft/ksoup/parser/ParseErrorList;", "state", "Lcom/fleeksoft/ksoup/parser/TokeniserState;", "emitPending", "Lcom/fleeksoft/ksoup/parser/Token;", "isEmitPending", "", "dataBuffer", "Lcom/fleeksoft/ksoup/parser/TokenData;", "getDataBuffer", "()Lcom/fleeksoft/ksoup/parser/TokenData;", "syntax", "Lcom/fleeksoft/ksoup/nodes/Document$OutputSettings$Syntax;", "getSyntax", "()Lcom/fleeksoft/ksoup/nodes/Document$OutputSettings$Syntax;", "startPending", "Lcom/fleeksoft/ksoup/parser/Token$StartTag;", "endPending", "Lcom/fleeksoft/ksoup/parser/Token$EndTag;", "tagPending", "Lcom/fleeksoft/ksoup/parser/Token$Tag;", "getTagPending", "()Lcom/fleeksoft/ksoup/parser/Token$Tag;", "setTagPending", "(Lcom/fleeksoft/ksoup/parser/Token$Tag;)V", "charPending", "Lcom/fleeksoft/ksoup/parser/Token$Character;", "doctypePending", "Lcom/fleeksoft/ksoup/parser/Token$Doctype;", "getDoctypePending", "()Lcom/fleeksoft/ksoup/parser/Token$Doctype;", "commentPending", "Lcom/fleeksoft/ksoup/parser/Token$Comment;", "getCommentPending", "()Lcom/fleeksoft/ksoup/parser/Token$Comment;", "xmlDeclPending", "Lcom/fleeksoft/ksoup/parser/Token$XmlDecl;", "getXmlDeclPending", "()Lcom/fleeksoft/ksoup/parser/Token$XmlDecl;", "lastStartTag", "", "lastStartCloseSeq", "markupStartPos", "", "charStartPos", "codepointHolder", "", "multipointHolder", "read", "emit", "", "token", "str", "c", "", "codepoints", "transition", "newState", "advanceTransition", "consumeCharacterReference", "additionalAllowedCharacter", "inAttribute", "(Ljava/lang/Character;Z)[I", "createTagPending", "start", "createXmlDeclPending", "isDeclaration", "emitTagPending", "createCommentPending", "emitCommentPending", "createBogusCommentPending", "createDoctypePending", "emitDoctypePending", "createTempBuffer", "isAppropriateEndTagToken", "appropriateEndTagName", "appropriateEndTagSeq", "error", "eofError", "characterReferenceError", "message", "errorMsg", "unescapeEntities", "Companion", "ksoup"})
public final class Tokeniser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CharacterReader reader;
    @NotNull
    private final ParseErrorList errors;
    @NotNull
    private TokeniserState state;
    @Nullable
    private Token emitPending;
    private boolean isEmitPending;
    @NotNull
    private final TokenData dataBuffer;
    @NotNull
    private final Document.OutputSettings.Syntax syntax;
    @NotNull
    private final Token.StartTag startPending;
    @NotNull
    private final Token.EndTag endPending;
    @NotNull
    private Token.Tag tagPending;
    @NotNull
    private final Token.Character charPending;
    @NotNull
    private final Token.Doctype doctypePending;
    @NotNull
    private final Token.Comment commentPending;
    @NotNull
    private final Token.XmlDecl xmlDeclPending;
    @Nullable
    private String lastStartTag;
    @Nullable
    private String lastStartCloseSeq;
    private int markupStartPos;
    private int charStartPos;
    @NotNull
    private final int[] codepointHolder;
    @NotNull
    private final int[] multipointHolder;
    public static final char ReplacementChar = '\ufffd';
    @NotNull
    private static final char[] notCharRefCharsSorted;
    public static final int win1252ExtensionsStart = 128;
    @NotNull
    private static final int[] win1252Extensions;

    public Tokeniser(@NotNull TreeBuilder treeBuilder) {
        Intrinsics.checkNotNullParameter((Object)treeBuilder, (String)"treeBuilder");
        this.reader = treeBuilder.getReader();
        this.errors = treeBuilder.getParser().getErrors();
        this.state = TokeniserState.Data;
        this.dataBuffer = new TokenData();
        this.syntax = treeBuilder instanceof XmlTreeBuilder ? Document.OutputSettings.Syntax.xml : Document.OutputSettings.Syntax.html;
        this.startPending = new Token.StartTag(treeBuilder);
        this.endPending = new Token.EndTag(treeBuilder);
        this.tagPending = this.startPending;
        this.charPending = new Token.Character();
        this.doctypePending = new Token.Doctype();
        this.commentPending = new Token.Comment();
        this.xmlDeclPending = new Token.XmlDecl(treeBuilder);
        this.codepointHolder = new int[1];
        this.multipointHolder = new int[2];
    }

    @NotNull
    public final TokenData getDataBuffer() {
        return this.dataBuffer;
    }

    @NotNull
    public final Document.OutputSettings.Syntax getSyntax() {
        return this.syntax;
    }

    @NotNull
    public final Token.Tag getTagPending() {
        return this.tagPending;
    }

    public final void setTagPending(@NotNull Token.Tag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"<set-?>");
        this.tagPending = tag;
    }

    @NotNull
    public final Token.Doctype getDoctypePending() {
        return this.doctypePending;
    }

    @NotNull
    public final Token.Comment getCommentPending() {
        return this.commentPending;
    }

    @NotNull
    public final Token.XmlDecl getXmlDeclPending() {
        return this.xmlDeclPending;
    }

    @NotNull
    public final Token read() {
        Token token;
        while (!this.isEmitPending) {
            this.state.read(this, this.reader);
        }
        if (this.charPending.getData().hasData()) {
            token = this.charPending;
        } else {
            this.isEmitPending = false;
            token = this.emitPending;
            if (token == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
        }
        return token;
    }

    public final void emit(@NotNull Token token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Validate.INSTANCE.isFalse(this.isEmitPending);
        this.emitPending = token;
        this.isEmitPending = true;
        token.startPos(this.markupStartPos);
        token.endPos(this.reader.pos());
        this.charStartPos = this.reader.pos();
        switch (WhenMappings.$EnumSwitchMapping$0[token.getType().ordinal()]) {
            case 1: {
                Token.StartTag startTag = (Token.StartTag)token;
                this.lastStartTag = startTag.name();
                this.lastStartCloseSeq = null;
                break;
            }
            case 2: {
                Token.EndTag endTag = (Token.EndTag)token;
                if (!endTag.hasAttributes()) break;
                this.error("Attributes incorrectly present on end tag [/" + endTag.retrieveNormalName() + "]");
            }
        }
    }

    public final void emit(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        this.charPending.append(str);
        this.charPending.startPos(this.charStartPos);
        this.charPending.endPos(this.reader.pos());
    }

    public final void emit(char c) {
        this.charPending.getData().append(c);
        this.charPending.startPos(this.charStartPos);
        this.charPending.endPos(this.reader.pos());
    }

    public final void emit(@NotNull int[] codepoints) {
        Intrinsics.checkNotNullParameter((Object)codepoints, (String)"codepoints");
        this.emit(CoreExtensionsKt.codePointsToString(codepoints));
    }

    public final void transition(@NotNull TokeniserState newState) {
        Intrinsics.checkNotNullParameter((Object)((Object)newState), (String)"newState");
        if (newState == TokeniserState.TagOpen) {
            this.markupStartPos = this.reader.pos();
        }
        this.state = newState;
    }

    public final void advanceTransition(@NotNull TokeniserState newState) {
        Intrinsics.checkNotNullParameter((Object)((Object)newState), (String)"newState");
        this.transition(newState);
        this.reader.advance();
    }

    @Nullable
    public final int[] consumeCharacterReference(@Nullable Character additionalAllowedCharacter, boolean inAttribute) {
        Object nameRef;
        int[] codeRef;
        block25: {
            block26: {
                Object prefix;
                boolean found;
                if (this.reader.isEmpty()) {
                    return null;
                }
                if (additionalAllowedCharacter != null) {
                    char c = this.reader.current();
                    if (additionalAllowedCharacter.charValue() == c) {
                        return null;
                    }
                }
                if (this.reader.matchesAnySorted(notCharRefCharsSorted)) {
                    return null;
                }
                codeRef = this.codepointHolder;
                this.reader.mark();
                if (this.reader.matchConsume("#")) {
                    int n;
                    boolean isHexMode = this.reader.matchConsumeIgnoreCase("X");
                    String numRef = isHexMode ? this.reader.consumeHexSequence() : this.reader.consumeDigitSequence();
                    if (((CharSequence)numRef).length() == 0) {
                        this.characterReferenceError("numeric reference with no numerals");
                        this.reader.rewindToMark();
                        return null;
                    }
                    this.reader.unmark();
                    if (!this.reader.matchConsume(";")) {
                        this.characterReferenceError("missing semicolon on [&#" + numRef + "]");
                    }
                    try {
                        n = Integer.parseInt(numRef, CharsKt.checkRadix((int)(isHexMode ? 16 : 10)));
                    }
                    catch (NumberFormatException e) {
                        n = -1;
                    }
                    int charval = n;
                    if (charval == -1 || charval > 0x10FFFF) {
                        this.characterReferenceError("character [" + charval + "] outside of valid range");
                        codeRef[0] = 65533;
                    } else {
                        if (charval >= 128 && charval < 128 + win1252Extensions.length) {
                            this.characterReferenceError("character [" + charval + "] is not a valid unicode code point");
                            charval = win1252Extensions[charval - 128];
                        }
                        codeRef[0] = charval;
                    }
                    return codeRef;
                }
                nameRef = this.reader.consumeLetterThenDigitSequence();
                boolean looksLegit = this.reader.matches(';');
                boolean bl = found = Entities.INSTANCE.isBaseNamedEntity((String)nameRef) || Entities.INSTANCE.isNamedEntity((String)nameRef) && looksLegit;
                if (!found) {
                    this.reader.rewindToMark();
                    if (looksLegit) {
                        this.characterReferenceError("invalid named reference [" + (String)nameRef + "]");
                    }
                    if (inAttribute) {
                        return null;
                    }
                    prefix = Entities.INSTANCE.findPrefix((String)nameRef);
                    if (((CharSequence)prefix).length() == 0) {
                        return null;
                    }
                    this.reader.matchConsume((String)prefix);
                    nameRef = prefix;
                }
                if (!inAttribute) break block25;
                if (this.reader.matchesAsciiAlpha() || this.reader.matchesDigit()) break block26;
                prefix = new char[3];
                prefix[0] = 61;
                prefix[1] = 45;
                prefix[2] = 95;
                if (!this.reader.matchesAny((char[])prefix)) break block25;
            }
            this.reader.rewindToMark();
            return null;
        }
        this.reader.unmark();
        if (!this.reader.matchConsume(";")) {
            this.characterReferenceError("missing semicolon on [&" + (String)nameRef + "]");
        }
        int numChars = Entities.INSTANCE.codepointsForName((String)nameRef, this.multipointHolder);
        return switch (numChars) {
            case 1 -> {
                codeRef[0] = this.multipointHolder[0];
                yield codeRef;
            }
            case 2 -> this.multipointHolder;
            default -> {
                Validate.INSTANCE.fail("Unexpected characters returned for " + (String)nameRef);
                yield this.multipointHolder;
            }
        };
    }

    @NotNull
    public final Token.Tag createTagPending(boolean start) {
        this.tagPending = start ? this.startPending.reset() : this.endPending.reset();
        return this.tagPending;
    }

    @NotNull
    public final Token.XmlDecl createXmlDeclPending(boolean isDeclaration) {
        Token.XmlDecl decl = this.xmlDeclPending.reset();
        decl.setDeclaration(isDeclaration);
        this.tagPending = decl;
        return decl;
    }

    public final void emitTagPending() {
        this.tagPending.finaliseTag();
        this.emit(this.tagPending);
    }

    public final void createCommentPending() {
        this.commentPending.reset();
    }

    public final void emitCommentPending() {
        this.emit(this.commentPending);
    }

    public final void createBogusCommentPending() {
        this.commentPending.reset();
        this.commentPending.setBogus(true);
    }

    public final void createDoctypePending() {
        this.doctypePending.reset();
    }

    public final void emitDoctypePending() {
        this.emit(this.doctypePending);
    }

    public final void createTempBuffer() {
        this.dataBuffer.reset();
    }

    public final boolean isAppropriateEndTagToken() {
        return this.lastStartTag != null && StringsKt.equals((String)this.tagPending.name(), (String)this.lastStartTag, (boolean)true);
    }

    @Nullable
    public final String appropriateEndTagName() {
        return this.lastStartTag;
    }

    @NotNull
    public final String appropriateEndTagSeq() {
        if (this.lastStartCloseSeq == null) {
            this.lastStartCloseSeq = "</" + this.lastStartTag;
        }
        String string = this.lastStartCloseSeq;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    public final void error(@Nullable TokeniserState state) {
        if (this.errors.canAddError()) {
            this.errors.add(new ParseError(this.reader, "Unexpected character '" + this.reader.current() + "' in input state [" + state + "]"));
        }
    }

    public final void eofError(@Nullable TokeniserState state) {
        if (this.errors.canAddError()) {
            this.errors.add(new ParseError(this.reader, "Unexpectedly reached end of file (EOF) in input state [" + state + "]"));
        }
    }

    private final void characterReferenceError(String message) {
        if (this.errors.canAddError()) {
            this.errors.add(new ParseError(this.reader, "Invalid character reference: " + message));
        }
    }

    public final void error(@NotNull String errorMsg) {
        Intrinsics.checkNotNullParameter((Object)errorMsg, (String)"errorMsg");
        if (this.errors.canAddError()) {
            this.errors.add(new ParseError(this.reader, errorMsg));
        }
    }

    @NotNull
    public final String unescapeEntities(boolean inAttribute) {
        StringBuilder builder = StringUtil.INSTANCE.borrowBuilder();
        while (!this.reader.isEmpty()) {
            builder.append(this.reader.consumeTo('&'));
            if (!this.reader.matches('&')) continue;
            this.reader.consume();
            int[] c = this.consumeCharacterReference(null, inAttribute);
            if (c == null || c.length == 0) {
                builder.append('&');
                continue;
            }
            builder.appendCodePoint(c[0]);
            if (c.length != 2) continue;
            builder.appendCodePoint(c[1]);
        }
        return StringUtil.INSTANCE.releaseBuilder(builder);
    }

    static {
        Object[] objectArray = new char[]{'\t', '\n', '\r', '\f', ' ', '<', '&'};
        notCharRefCharsSorted = ArraysKt.sortedArray((char[])objectArray);
        objectArray = new int[32];
        objectArray[0] = 8364;
        objectArray[1] = 129;
        objectArray[2] = 8218;
        objectArray[3] = 402;
        objectArray[4] = 8222;
        objectArray[5] = 8230;
        objectArray[6] = 8224;
        objectArray[7] = 8225;
        objectArray[8] = 710;
        objectArray[9] = 8240;
        objectArray[10] = 352;
        objectArray[11] = 8249;
        objectArray[12] = 338;
        objectArray[13] = 141;
        objectArray[14] = 381;
        objectArray[15] = 143;
        objectArray[16] = 144;
        objectArray[17] = 8216;
        objectArray[18] = 8217;
        objectArray[19] = 8220;
        objectArray[20] = 8221;
        objectArray[21] = 8226;
        objectArray[22] = 8211;
        objectArray[23] = 8212;
        objectArray[24] = 732;
        objectArray[25] = 8482;
        objectArray[26] = 353;
        objectArray[27] = 8250;
        objectArray[28] = 339;
        objectArray[29] = 157;
        objectArray[30] = 382;
        objectArray[31] = 376;
        win1252Extensions = objectArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/fleeksoft/ksoup/parser/Tokeniser$Companion;", "", "<init>", "()V", "ReplacementChar", "", "notCharRefCharsSorted", "", "win1252ExtensionsStart", "", "win1252Extensions", "", "getWin1252Extensions", "()[I", "ksoup"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final int[] getWin1252Extensions() {
            return win1252Extensions;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Token.TokenType.values().length];
            try {
                nArray[Token.TokenType.StartTag.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.TokenType.EndTag.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

