/*
 * Decompiled with CFR 0.152.
 */
package com.fleeksoft.ksoup.parser;

import com.fleeksoft.ksoup.helper.Validate;
import com.fleeksoft.ksoup.internal.StringUtil;
import com.fleeksoft.ksoup.parser.CharacterReader;
import com.fleeksoft.ksoup.ported.Character;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0019\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 *2\u00060\u0001j\u0002`\u0002:\u0001*B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\fJ\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0004J\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\fJ\u0012\u0010\u0013\u001a\u00020\n2\n\u0010\u0011\u001a\u00020\u0014\"\u00020\fJ\u000e\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0004J\u000e\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\fJ\u0006\u0010\u0016\u001a\u00020\nJ\u0006\u0010\u0017\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0004J\u000e\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004J\u001f\u0010\u0019\u001a\u00020\u00042\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u001a\"\u00020\u0004\u00a2\u0006\u0002\u0010\u001bJ\u0016\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\fJ\u0006\u0010\u001f\u001a\u00020\nJ\u0006\u0010 \u001a\u00020\u0004J\u0006\u0010!\u001a\u00020\u0004J\u0014\u0010\"\u001a\u00020\u000e2\n\u0010#\u001a\u00060$j\u0002`%H\u0002J\u0014\u0010&\u001a\u00020\u00042\n\u0010\u0010\u001a\u00020\u0014\"\u00020\fH\u0002J\u0014\u0010'\u001a\u00020\n2\n\u0010\u0010\u001a\u00020\u0014\"\u00020\fH\u0002J\u0006\u0010(\u001a\u00020\u0004J\b\u0010)\u001a\u00020\u0004H\u0016J\b\u0010\u001e\u001a\u00020\u000eH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/fleeksoft/ksoup/parser/TokenQueue;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "data", "", "<init>", "(Ljava/lang/String;)V", "reader", "Lcom/fleeksoft/ksoup/parser/CharacterReader;", "isEmpty", "", "consume", "", "advance", "", "current", "matches", "seq", "c", "matchesAny", "", "matchChomp", "matchesWhitespace", "matchesWord", "consumeTo", "consumeToAny", "", "([Ljava/lang/String;)Ljava/lang/String;", "chompBalanced", "open", "close", "consumeWhitespace", "consumeElementSelector", "consumeCssIdentifier", "consumeCssEscapeSequenceInto", "out", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "consumeEscapedCssIdentifier", "matchesCssIdentifier", "remainder", "toString", "Companion", "ksoup"})
@SourceDebugExtension(value={"SMAP\nTokenQueue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TokenQueue.kt\ncom/fleeksoft/ksoup/parser/TokenQueue\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,286:1\n1#2:287\n*E\n"})
public final class TokenQueue
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CharacterReader reader;
    private static final char ESC = '\\';
    private static final char HYPHEN_MINUS = '-';
    private static final char UNICODE_NULL = '\u0000';
    private static final char REPLACEMENT = '\ufffd';
    @NotNull
    private static final char[] ELEMENT_SELECTOR_CHARS;

    public TokenQueue(@NotNull String data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        this.reader = new CharacterReader(data2);
    }

    public final boolean isEmpty() {
        return this.reader.isEmpty();
    }

    public final char consume() {
        return this.reader.consume();
    }

    public final void advance() {
        if (!this.isEmpty()) {
            this.reader.advance();
        }
    }

    public final char current() {
        return this.reader.current();
    }

    public final boolean matches(@NotNull String seq) {
        Intrinsics.checkNotNullParameter((Object)seq, (String)"seq");
        return this.reader.matchesIgnoreCase(seq);
    }

    public final boolean matches(char c) {
        return this.reader.matches(c);
    }

    public final boolean matchesAny(char ... seq) {
        Intrinsics.checkNotNullParameter((Object)seq, (String)"seq");
        return this.reader.matchesAny(Arrays.copyOf(seq, seq.length));
    }

    public final boolean matchChomp(@NotNull String seq) {
        Intrinsics.checkNotNullParameter((Object)seq, (String)"seq");
        return this.reader.matchConsumeIgnoreCase(seq);
    }

    public final boolean matchChomp(char c) {
        if (this.reader.matches(c)) {
            this.consume();
            return true;
        }
        return false;
    }

    public final boolean matchesWhitespace() {
        return CharsKt.isWhitespace((char)this.reader.current());
    }

    public final boolean matchesWord() {
        return java.lang.Character.isLetterOrDigit(this.reader.current());
    }

    public final void consume(@NotNull String seq) {
        Intrinsics.checkNotNullParameter((Object)seq, (String)"seq");
        if (!this.reader.matchConsumeIgnoreCase(seq)) {
            throw new IllegalStateException("Queue did not match expected sequence");
        }
    }

    @NotNull
    public final String consumeTo(@NotNull String seq) {
        Intrinsics.checkNotNullParameter((Object)seq, (String)"seq");
        return this.reader.consumeTo(seq);
    }

    @NotNull
    public final String consumeToAny(String ... seq) {
        Intrinsics.checkNotNullParameter((Object)seq, (String)"seq");
        StringBuilder sb = StringUtil.INSTANCE.borrowBuilder();
        block0: while (!this.isEmpty()) {
            for (String s : seq) {
                if (this.reader.matchesIgnoreCase(s)) break block0;
            }
            sb.append(this.consume());
        }
        return StringUtil.INSTANCE.releaseBuilder(sb);
    }

    @NotNull
    public final String chompBalanced(char open, char close) {
        StringBuilder accum = StringUtil.INSTANCE.borrowBuilder();
        int depth = 0;
        int prev = 0;
        boolean inSingle = false;
        boolean inDouble = false;
        boolean inRegexQE = false;
        this.reader.mark();
        while (!this.isEmpty()) {
            char c = this.consume();
            if (prev == 92) {
                switch (c) {
                    case 'Q': {
                        inRegexQE = true;
                        break;
                    }
                    case 'E': {
                        inRegexQE = false;
                    }
                }
                v0 = accum.append(c);
            } else {
                if (c == '\'' && c != open && !inDouble) {
                    inSingle = !inSingle;
                } else if (c == '\"' && c != open && !inSingle) {
                    boolean bl = inDouble = !inDouble;
                }
                if (inSingle || inDouble || inRegexQE) {
                    v0 = accum.append(c);
                } else if (c == open) {
                    if (++depth > 1) {
                        accum.append(c);
                    }
                    v0 = Unit.INSTANCE;
                } else if (c == close) {
                    if (--depth > 0) {
                        accum.append(c);
                    }
                    v0 = Unit.INSTANCE;
                } else {
                    v0 = accum.append(c);
                }
            }
            prev = c;
            if (depth > 0) continue;
        }
        String out = StringUtil.INSTANCE.releaseBuilder(accum);
        if (depth > 0) {
            this.reader.rewindToMark();
            Validate.INSTANCE.fail("Did not find balanced marker at '" + out + "'");
        }
        return out;
    }

    public final boolean consumeWhitespace() {
        boolean seen = false;
        while (this.matchesWhitespace()) {
            this.advance();
            seen = true;
        }
        return seen;
    }

    @NotNull
    public final String consumeElementSelector() {
        char[] cArray = ELEMENT_SELECTOR_CHARS;
        return this.consumeEscapedCssIdentifier(Arrays.copyOf(cArray, cArray.length));
    }

    @NotNull
    public final String consumeCssIdentifier() {
        StringBuilder stringBuilder;
        if (this.isEmpty()) {
            throw new IllegalArgumentException("CSS identifier expected, but end of input found");
        }
        String identifier2 = this.reader.consumeMatching((Function1<? super java.lang.Character, Boolean>)((Function1)new Function1<java.lang.Character, Boolean>((Object)Companion){

            public final Boolean invoke(char p0) {
                return com.fleeksoft.ksoup.parser.TokenQueue$Companion.access$isIdent((Companion)this.receiver, p0);
            }
        }));
        char c = this.current();
        if (c != '\\' && c != '\u0000') {
            return identifier2;
        }
        StringBuilder $this$consumeCssIdentifier_u24lambda_u240 = stringBuilder = StringUtil.INSTANCE.borrowBuilder();
        boolean bl = false;
        if (((CharSequence)identifier2).length() > 0) {
            $this$consumeCssIdentifier_u24lambda_u240.append(identifier2);
        }
        StringBuilder out = stringBuilder;
        while (!this.isEmpty()) {
            StringBuilder stringBuilder2;
            c = this.current();
            if (TokenQueue.Companion.isIdent(c)) {
                stringBuilder2 = out.append(this.consume());
                continue;
            }
            if (c == '\u0000') {
                this.advance();
                stringBuilder2 = out.append('\ufffd');
                continue;
            }
            if (c != '\\') break;
            this.advance();
            if (!this.isEmpty() && TokenQueue.Companion.isNewline(this.current())) {
                this.reader.unconsume();
                break;
            }
            this.consumeCssEscapeSequenceInto(out);
            stringBuilder2 = Unit.INSTANCE;
        }
        return StringUtil.INSTANCE.releaseBuilder(out);
    }

    private final void consumeCssEscapeSequenceInto(StringBuilder out) {
        if (this.isEmpty()) {
            out.append('\ufffd');
            return;
        }
        char firstEsc = this.consume();
        if (!StringUtil.INSTANCE.isHexDigit(firstEsc)) {
            out.append(firstEsc);
        } else {
            this.reader.unconsume();
            String hex = this.reader.consumeMatching((Function1<? super java.lang.Character, Boolean>)((Function1)TokenQueue::consumeCssEscapeSequenceInto$lambda$1), 6);
            Integer n = StringsKt.toIntOrNull((String)hex, (int)16);
            if (n == null) {
                throw new IllegalArgumentException("Invalid escape sequence: " + hex);
            }
            int cp = n;
            StringBuilder stringBuilder = TokenQueue.Companion.isValidCodePoint(cp) ? out.appendCodePoint(cp) : out.append('\ufffd');
            if (!this.isEmpty()) {
                char c2 = this.current();
                if (c2 == '\r') {
                    this.advance();
                    if (!this.isEmpty() && this.current() == '\n') {
                        this.advance();
                    }
                } else if (c2 == ' ' || c2 == '\t' || TokenQueue.Companion.isNewline(c2)) {
                    this.advance();
                }
            }
        }
    }

    private final String consumeEscapedCssIdentifier(char ... matches) {
        StringBuilder sb = StringUtil.INSTANCE.borrowBuilder();
        while (!this.isEmpty()) {
            char c = this.current();
            if (c == '\\') {
                this.advance();
                if (this.isEmpty()) break;
                sb.append(this.consume());
                continue;
            }
            if (!this.matchesCssIdentifier(Arrays.copyOf(matches, matches.length))) break;
            sb.append(c);
            this.advance();
        }
        return StringUtil.INSTANCE.releaseBuilder(sb);
    }

    private final boolean matchesCssIdentifier(char ... matches) {
        return this.matchesWord() || this.reader.matchesAny(Arrays.copyOf(matches, matches.length));
    }

    @NotNull
    public final String remainder() {
        return this.reader.consumeToEnd();
    }

    @NotNull
    public String toString() {
        return this.reader.toString();
    }

    @Override
    public void close() {
        this.reader.close();
    }

    private static final boolean consumeCssEscapeSequenceInto$lambda$1(char it) {
        return StringUtil.INSTANCE.isHexDigit(it);
    }

    @JvmStatic
    @NotNull
    public static final String unescape(@NotNull String input) {
        return Companion.unescape(input);
    }

    @JvmStatic
    @NotNull
    public static final String escapeCssIdentifier(@NotNull String input) {
        return Companion.escapeCssIdentifier(input);
    }

    static {
        char[] cArray = new char[]{'*', '|', '_', '-'};
        ELEMENT_SELECTOR_CHARS = cArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0007J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0007J\u001c\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J\u001c\u0010\u0015\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/fleeksoft/ksoup/parser/TokenQueue$Companion;", "", "<init>", "()V", "ESC", "", "HYPHEN_MINUS", "UNICODE_NULL", "REPLACEMENT", "ELEMENT_SELECTOR_CHARS", "", "unescape", "", "input", "escapeCssIdentifier", "appendEscaped", "", "out", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "c", "appendEscapedCodepoint", "isNonAscii", "", "isIdentStart", "isIdent", "isNewline", "isValidCodePoint", "codePoint", "", "ksoup"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final String unescape(@NotNull String input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            if (!StringsKt.contains$default((CharSequence)input, (char)'\\', (boolean)false, (int)2, null)) {
                return input;
            }
            StringBuilder out = StringUtil.INSTANCE.borrowBuilder();
            int last = 0;
            int n = input.length();
            for (int i = 0; i < n; ++i) {
                char c = input.charAt(i);
                if (c == '\\') {
                    if (last == 92) {
                        out.append(c);
                        last = 0;
                        continue;
                    }
                } else {
                    out.append(c);
                }
                last = c;
            }
            return StringUtil.INSTANCE.releaseBuilder(out);
        }

        @JvmStatic
        @NotNull
        public final String escapeCssIdentifier(@NotNull String input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            if (((CharSequence)input).length() == 0) {
                return input;
            }
            StringBuilder out = StringUtil.INSTANCE.borrowBuilder();
            TokenQueue q = new TokenQueue(input);
            char firstChar = q.current();
            if (firstChar == '-') {
                q.advance();
                if (q.isEmpty()) {
                    this.appendEscaped(out, '-');
                } else {
                    out.append('-');
                    if (StringUtil.INSTANCE.isDigit(q.current())) {
                        this.appendEscapedCodepoint(out, q.consume());
                    }
                }
            } else if (StringUtil.INSTANCE.isDigit(firstChar)) {
                this.appendEscapedCodepoint(out, q.consume());
            }
            while (!q.isEmpty()) {
                char c = q.consume();
                if (c == '\u0000') {
                    out.append('\ufffd');
                    continue;
                }
                if (Intrinsics.compare((int)c, (int)31) <= 0 || c == '\u007f') {
                    this.appendEscapedCodepoint(out, c);
                    continue;
                }
                if (this.isIdent(c)) {
                    out.append(c);
                    continue;
                }
                this.appendEscaped(out, c);
            }
            q.close();
            return StringUtil.INSTANCE.releaseBuilder(out);
        }

        private final void appendEscaped(StringBuilder out, char c) {
            out.append('\\').append(c);
        }

        private final void appendEscapedCodepoint(StringBuilder out, char c) {
            StringBuilder stringBuilder = out.append('\\');
            String string = Integer.toString(c, CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            stringBuilder.append(string).append(' ');
        }

        private final boolean isNonAscii(char c) {
            return Intrinsics.compare((int)c, (int)128) >= 0;
        }

        private final boolean isIdentStart(char c) {
            return c == '_' || StringUtil.INSTANCE.isAsciiLetter(c) || this.isNonAscii(c);
        }

        private final boolean isIdent(char c) {
            return c == '-' || StringUtil.INSTANCE.isDigit(c) || this.isIdentStart(c);
        }

        private final boolean isNewline(char c) {
            return c == '\n' || c == '\r' || c == '\f';
        }

        private final boolean isValidCodePoint(int codePoint) {
            return codePoint != 0 && Character.INSTANCE.isValidCodePoint(codePoint) && !CharsKt.isSurrogate((char)((char)codePoint));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

