/*
 * Decompiled with CFR 0.152.
 */
package com.fleeksoft.ksoup.parser;

import com.fleeksoft.ksoup.exception.UncheckedIOException;
import com.fleeksoft.ksoup.internal.SoftPool;
import com.fleeksoft.ksoup.internal.StringUtil;
import com.fleeksoft.ksoup.ported.StringKt;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0011\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b!\u0018\u0000 [2\u00060\u0001j\u0002`\u0002:\u0001[B\u0015\b\u0016\u0012\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nJ\u0006\u0010\u001c\u001a\u00020\u0017J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001eH\u0002J\b\u0010 \u001a\u00020\u001eH\u0002J\u0006\u0010!\u001a\u00020\u001eJ\u0006\u0010\"\u001a\u00020\u001eJ\u0006\u0010#\u001a\u00020\u001eJ\u0006\u0010$\u001a\u00020\u0011J\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u0017J\u0006\u0010'\u001a\u00020\u0017J\u0006\u0010(\u001a\u00020\u0011J\u000e\u0010(\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u0011J\u0006\u0010)\u001a\u00020\u0011J\u000e\u0010)\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u0011J\u0006\u0010*\u001a\u00020\tJ\u0010\u0010+\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u0011H\u0002J\b\u0010,\u001a\u00020\u001eH\u0002J\u0006\u0010-\u001a\u00020\u0017J\b\u0010.\u001a\u00020\u0017H\u0002J\u0006\u0010/\u001a\u000200J\u0006\u00101\u001a\u000200J\u0006\u00102\u001a\u00020\u001eJ\u0006\u00103\u001a\u00020\u001eJ\u000e\u00104\u001a\u00020\u00112\u0006\u00105\u001a\u000200J\u000e\u00104\u001a\u00020\u00112\u0006\u00106\u001a\u000207J\u000e\u00108\u001a\u00020\t2\u0006\u00105\u001a\u000200J\u000e\u00108\u001a\u00020\t2\u0006\u00106\u001a\u00020\tJ\u001a\u00109\u001a\u00020\t2\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020\u00170;J\"\u00109\u001a\u00020\t2\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020\u00170;2\u0006\u0010<\u001a\u00020\u0011J\u0012\u0010=\u001a\u00020\t2\n\u0010>\u001a\u00020\u000f\"\u000200J\u0012\u0010?\u001a\u00020\u0011*\u00020\u000f2\u0006\u00105\u001a\u000200J\u0012\u0010@\u001a\u00020\t2\n\u0010>\u001a\u00020\u000f\"\u000200J\u0006\u0010A\u001a\u00020\tJ\u000e\u0010B\u001a\u00020\t2\u0006\u0010C\u001a\u00020\u0017J\u0006\u0010D\u001a\u00020\tJ\u0006\u0010E\u001a\u00020\tJ\u0006\u0010F\u001a\u00020\tJ\u0006\u0010G\u001a\u00020\tJ\u0006\u0010H\u001a\u00020\tJ\u0006\u0010I\u001a\u00020\tJ\u0006\u0010J\u001a\u00020\tJ\u000e\u0010K\u001a\u00020\u00172\u0006\u00105\u001a\u000200J\u000e\u0010K\u001a\u00020\u00172\u0006\u00106\u001a\u00020\tJ\u000e\u0010L\u001a\u00020\u00172\u0006\u00106\u001a\u00020\tJ\u0012\u0010M\u001a\u00020\u00172\n\u00106\u001a\u00020\u000f\"\u000200J\u000e\u0010N\u001a\u00020\u00172\u0006\u00106\u001a\u00020\u000fJ\u0006\u0010O\u001a\u00020\u0017J\u0006\u0010P\u001a\u00020\u0017J\u000e\u0010Q\u001a\u00020\u00172\u0006\u00106\u001a\u00020\tJ\u000e\u0010R\u001a\u00020\u00172\u0006\u00106\u001a\u00020\tJ\u000e\u0010U\u001a\u00020\u00172\u0006\u00106\u001a\u00020\tJ\b\u0010V\u001a\u00020\tH\u0016J\u001e\u0010W\u001a\u00020\u00172\u0006\u0010X\u001a\u00020\u00112\u0006\u0010Y\u001a\u00020\u00112\u0006\u0010Z\u001a\u00020\tR\u001a\u0010\u000b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u0016\u0010\u0003\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0018\u001a\u0016\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0019j\n\u0012\u0004\u0012\u00020\u0011\u0018\u0001`\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010S\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010T\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\\"}, d2={"Lcom/fleeksoft/ksoup/parser/CharacterReader;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "reader", "Ljava/io/Reader;", "Lcom/fleeksoft/io/Reader;", "<init>", "(Ljava/io/Reader;)V", "html", "", "(Ljava/lang/String;)V", "stringCache", "", "[Ljava/lang/String;", "charBuf", "", "bufPos", "", "bufLength", "fillPoint", "consumed", "bufMark", "readFully", "", "newlinePositions", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "lineNumberOffset", "isClosed", "close", "", "bufferUp", "doBufferUp", "mark", "unmark", "rewindToMark", "pos", "trackNewlines", "track", "isTrackNewlines", "lineNumber", "columnNumber", "posLineCol", "lineNumIndex", "scanBufferForNewlines", "isEmpty", "isEmptyNoBufferUp", "current", "", "consume", "unconsume", "advance", "nextIndexOf", "c", "seq", "", "consumeTo", "consumeMatching", "func", "Lkotlin/Function1;", "maxLength", "consumeToAny", "chars", "binarySearch", "consumeToAnySorted", "consumeData", "consumeAttributeQuoted", "single", "consumeRawData", "consumeTagName", "consumeToEnd", "consumeLetterSequence", "consumeLetterThenDigitSequence", "consumeHexSequence", "consumeDigitSequence", "matches", "matchesIgnoreCase", "matchesAny", "matchesAnySorted", "matchesAsciiAlpha", "matchesDigit", "matchConsume", "matchConsumeIgnoreCase", "lastIcSeq", "lastIcIndex", "containsIgnoreCase", "toString", "rangeEquals", "start", "count", "cached", "Companion", "ksoup"})
@SourceDebugExtension(value={"SMAP\nCharacterReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CharacterReader.kt\ncom/fleeksoft/ksoup/parser/CharacterReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,671:1\n1#2:672\n19732#3,2:673\n*S KotlinDebug\n*F\n+ 1 CharacterReader.kt\ncom/fleeksoft/ksoup/parser/CharacterReader\n*L\n416#1:673,2\n*E\n"})
public final class CharacterReader
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String[] stringCache;
    @Nullable
    private Reader reader;
    @Nullable
    private char[] charBuf;
    private int bufPos;
    private int bufLength;
    private int fillPoint;
    private int consumed;
    private int bufMark;
    private boolean readFully;
    @Nullable
    private ArrayList<Integer> newlinePositions;
    private int lineNumberOffset;
    @Nullable
    private String lastIcSeq;
    private int lastIcIndex;
    public static final char EOF = '\uffff';
    private static final int MaxStringCacheLen = 12;
    private static final int StringCacheSize = 512;
    @NotNull
    private static final SoftPool<String[]> StringPool = new SoftPool(CharacterReader::StringPool$lambda$12);
    @NotNull
    private static final SoftPool<char[]> BufferPool = new SoftPool(CharacterReader::BufferPool$lambda$13);
    public static final int BufferSize = 2048;
    public static final int RefillPoint = 1024;
    private static final int RewindLimit = 1024;

    public CharacterReader(@NotNull Reader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        this.bufMark = -1;
        this.lineNumberOffset = 1;
        this.reader = reader;
        this.charBuf = BufferPool.borrow();
        this.stringCache = StringPool.borrow();
        this.bufferUp();
    }

    public CharacterReader(@NotNull String html) {
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        this(new StringReader(html));
    }

    public final boolean isClosed() {
        return this.reader == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            Reader reader = this.reader;
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            Object[] it;
            this.reader = null;
            if (this.charBuf != null) {
                ArraysKt.fill$default((char[])this.charBuf, (char)'\u0000', (int)0, (int)0, (int)6, null);
            }
            if (this.charBuf != null) {
                it = this.charBuf;
                boolean bl = false;
                BufferPool.release((char[])it);
            }
            this.charBuf = null;
            if (this.stringCache != null) {
                it = this.stringCache;
                boolean bl = false;
                StringPool.release((String[])it);
            }
            this.stringCache = null;
        }
    }

    private final void bufferUp() {
        if (this.readFully || this.bufPos < this.fillPoint || this.bufMark != -1) {
            return;
        }
        this.doBufferUp();
    }

    private final void doBufferUp() {
        this.consumed += this.bufPos;
        this.bufLength -= this.bufPos;
        if (this.bufLength > 0 && this.charBuf != null) {
            Intrinsics.checkNotNull((Object)this.charBuf);
            ArraysKt.copyInto((char[])this.charBuf, (char[])this.charBuf, (int)0, (int)this.bufPos, (int)(this.bufPos + this.bufLength));
        }
        this.bufPos = 0;
        while (this.bufLength < 2048) {
            try {
                Reader reader = this.reader;
                Intrinsics.checkNotNull((Object)reader);
                Intrinsics.checkNotNull((Object)this.charBuf);
                Intrinsics.checkNotNull((Object)this.charBuf);
                int read = reader.read(this.charBuf, this.bufLength, this.charBuf.length - this.bufLength);
                if (read == -1) {
                    this.readFully = true;
                    break;
                }
                if (read == 0) break;
                this.bufLength += read;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        this.fillPoint = Math.min(this.bufLength, 1024);
        this.scanBufferForNewlines();
        this.lastIcSeq = null;
    }

    public final void mark() {
        if (this.bufLength - this.bufPos < 1024) {
            this.fillPoint = 0;
        }
        this.bufferUp();
        this.bufMark = this.bufPos;
    }

    public final void unmark() {
        this.bufMark = -1;
    }

    public final void rewindToMark() {
        if (this.bufMark == -1) {
            throw new UncheckedIOException(new IOException("Mark invalid"));
        }
        this.bufPos = this.bufMark;
        this.unmark();
    }

    public final int pos() {
        return this.consumed + this.bufPos;
    }

    public final boolean readFully() {
        return this.readFully;
    }

    public final void trackNewlines(boolean track) {
        if (track && this.newlinePositions == null) {
            this.newlinePositions = new ArrayList(25);
            this.scanBufferForNewlines();
        } else if (!track) {
            this.newlinePositions = null;
        }
    }

    public final boolean isTrackNewlines() {
        return this.newlinePositions != null;
    }

    public final int lineNumber() {
        return this.lineNumber(this.pos());
    }

    public final int lineNumber(int pos) {
        if (!this.isTrackNewlines()) {
            return 1;
        }
        int i = this.lineNumIndex(pos);
        return i == -1 ? this.lineNumberOffset : i + this.lineNumberOffset + 1;
    }

    public final int columnNumber() {
        return this.columnNumber(this.pos());
    }

    public final int columnNumber(int pos) {
        int n;
        if (!this.isTrackNewlines()) {
            return pos + 1;
        }
        int i = this.lineNumIndex(pos);
        if (i == -1) {
            n = pos + 1;
        } else {
            ArrayList<Integer> arrayList = this.newlinePositions;
            Intrinsics.checkNotNull(arrayList);
            Integer n2 = arrayList.get(i);
            Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"get(...)");
            n = pos - ((Number)n2).intValue() + 1;
        }
        return n;
    }

    @NotNull
    public final String posLineCol() {
        return this.lineNumber() + ":" + this.columnNumber();
    }

    private final int lineNumIndex(int pos) {
        if (!this.isTrackNewlines()) {
            return 0;
        }
        ArrayList<Integer> arrayList = this.newlinePositions;
        Intrinsics.checkNotNull(arrayList);
        int i = CollectionsKt.binarySearch$default((List)arrayList, (Comparable)Integer.valueOf(pos), (int)0, (int)0, (int)6, null);
        if (i < -1) {
            i = Math.abs(i) - 2;
        }
        return i;
    }

    private final void scanBufferForNewlines() {
        if (!this.isTrackNewlines()) {
            return;
        }
        ArrayList<Integer> arrayList = this.newlinePositions;
        Intrinsics.checkNotNull(arrayList);
        if (!((Collection)arrayList).isEmpty()) {
            int index = this.lineNumIndex(this.consumed);
            if (index == -1) {
                index = 0;
            }
            ArrayList<Integer> arrayList2 = this.newlinePositions;
            Intrinsics.checkNotNull(arrayList2);
            Integer n = arrayList2.get(index);
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"get(...)");
            int linePos = ((Number)n).intValue();
            this.lineNumberOffset += index;
            ArrayList<Integer> arrayList3 = this.newlinePositions;
            Intrinsics.checkNotNull(arrayList3);
            arrayList3.clear();
            ArrayList<Integer> arrayList4 = this.newlinePositions;
            Intrinsics.checkNotNull(arrayList4);
            arrayList4.add(linePos);
        }
        int n = this.bufLength;
        for (int i = this.bufPos; i < n; ++i) {
            Intrinsics.checkNotNull((Object)this.charBuf);
            if (this.charBuf[i] != '\n') continue;
            ArrayList<Integer> arrayList5 = this.newlinePositions;
            Intrinsics.checkNotNull(arrayList5);
            arrayList5.add(1 + this.consumed + i);
        }
    }

    public final boolean isEmpty() {
        this.bufferUp();
        return this.bufPos >= this.bufLength;
    }

    private final boolean isEmptyNoBufferUp() {
        return this.bufPos >= this.bufLength;
    }

    public final char current() {
        char c;
        this.bufferUp();
        if (this.isEmptyNoBufferUp()) {
            c = '\uffff';
        } else {
            Intrinsics.checkNotNull((Object)this.charBuf);
            c = this.charBuf[this.bufPos];
        }
        return c;
    }

    public final char consume() {
        char c;
        this.bufferUp();
        if (this.isEmptyNoBufferUp()) {
            c = '\uffff';
        } else {
            Intrinsics.checkNotNull((Object)this.charBuf);
            c = this.charBuf[this.bufPos];
        }
        char value = c;
        int n = this.bufPos;
        this.bufPos = n + 1;
        return value;
    }

    public final void unconsume() {
        if (this.bufPos < 1) {
            throw new UncheckedIOException(new IOException("WTF: No buffer left to unconsume."));
        }
        int n = this.bufPos;
        this.bufPos = n + -1;
    }

    public final void advance() {
        int n = this.bufPos;
        this.bufPos = n + 1;
    }

    public final int nextIndexOf(char c) {
        this.bufferUp();
        int n = this.bufLength;
        for (int i = this.bufPos; i < n; ++i) {
            Intrinsics.checkNotNull((Object)this.charBuf);
            if (c != this.charBuf[i]) continue;
            return i - this.bufPos;
        }
        return -1;
    }

    public final int nextIndexOf(@NotNull CharSequence seq) {
        Intrinsics.checkNotNullParameter((Object)seq, (String)"seq");
        this.bufferUp();
        char startChar = seq.charAt(0);
        for (int offset = this.bufPos; offset < this.bufLength; ++offset) {
            Intrinsics.checkNotNull((Object)this.charBuf);
            if (startChar != this.charBuf[offset]) {
                while (++offset < this.bufLength) {
                    Intrinsics.checkNotNull((Object)this.charBuf);
                    if (startChar != this.charBuf[offset]) continue;
                }
            }
            int i = offset + 1;
            int last = i + seq.length() - 1;
            if (offset >= this.bufLength || last > this.bufLength) continue;
            int j = 1;
            while (i < last) {
                char c = seq.charAt(j);
                Intrinsics.checkNotNull((Object)this.charBuf);
                if (c != this.charBuf[i]) break;
                ++i;
                ++j;
            }
            if (i != last) continue;
            return offset - this.bufPos;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String consumeTo(char c) {
        String string;
        int offset = this.nextIndexOf(c);
        if (offset != -1) {
            void var3_3;
            String consumed = CharacterReader.Companion.cacheString(this.charBuf, this.stringCache, this.bufPos, offset);
            this.bufPos += offset;
            string = var3_3;
        } else {
            string = this.consumeToEnd();
        }
        return string;
    }

    @NotNull
    public final String consumeTo(@NotNull String seq) {
        String string;
        Intrinsics.checkNotNullParameter((Object)seq, (String)"seq");
        int offset = this.nextIndexOf(seq);
        if (offset != -1) {
            String consumed = CharacterReader.Companion.cacheString(this.charBuf, this.stringCache, this.bufPos, offset);
            this.bufPos += offset;
            string = consumed;
        } else if (this.bufLength - this.bufPos < seq.length()) {
            string = this.consumeToEnd();
        } else {
            int endPos = this.bufLength - seq.length() + 1;
            String consumed = CharacterReader.Companion.cacheString(this.charBuf, this.stringCache, this.bufPos, endPos - this.bufPos);
            this.bufPos = endPos;
            string = consumed;
        }
        return string;
    }

    @NotNull
    public final String consumeMatching(@NotNull Function1<? super Character, Boolean> func) {
        Intrinsics.checkNotNullParameter(func, (String)"func");
        return this.consumeMatching(func, -1);
    }

    @NotNull
    public final String consumeMatching(@NotNull Function1<? super Character, Boolean> func, int maxLength) {
        int pos;
        Intrinsics.checkNotNullParameter(func, (String)"func");
        this.bufferUp();
        int start = pos = this.bufPos;
        int remaining = this.bufLength;
        char[] valBuf = this.charBuf;
        while (pos < remaining && (maxLength == -1 || pos - start < maxLength)) {
            Intrinsics.checkNotNull((Object)valBuf);
            if (!((Boolean)func.invoke((Object)Character.valueOf(valBuf[pos]))).booleanValue()) break;
            ++pos;
        }
        this.bufPos = pos;
        return pos > start ? CharacterReader.Companion.cacheString(this.charBuf, this.stringCache, start, pos - start) : "";
    }

    @NotNull
    public final String consumeToAny(char ... chars) {
        Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
        return this.consumeMatching((Function1<? super Character, Boolean>)((Function1)arg_0 -> CharacterReader.consumeToAny$lambda$3(chars, arg_0)));
    }

    public final int binarySearch(@NotNull char[] $this$binarySearch, char c) {
        Intrinsics.checkNotNullParameter((Object)$this$binarySearch, (String)"<this>");
        return ArraysKt.indexOf((char[])$this$binarySearch, (char)c);
    }

    @NotNull
    public final String consumeToAnySorted(char ... chars) {
        Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
        return this.consumeMatching((Function1<? super Character, Boolean>)((Function1)arg_0 -> CharacterReader.consumeToAnySorted$lambda$4(this, chars, arg_0)));
    }

    @NotNull
    public final String consumeData() {
        return this.consumeMatching((Function1<? super Character, Boolean>)((Function1)CharacterReader::consumeData$lambda$5));
    }

    @NotNull
    public final String consumeAttributeQuoted(boolean single) {
        return this.consumeMatching((Function1<? super Character, Boolean>)((Function1)arg_0 -> CharacterReader.consumeAttributeQuoted$lambda$6(single, arg_0)));
    }

    @NotNull
    public final String consumeRawData() {
        return this.consumeMatching((Function1<? super Character, Boolean>)((Function1)CharacterReader::consumeRawData$lambda$7));
    }

    @NotNull
    public final String consumeTagName() {
        return this.consumeMatching((Function1<? super Character, Boolean>)((Function1)CharacterReader::consumeTagName$lambda$8));
    }

    @NotNull
    public final String consumeToEnd() {
        this.bufferUp();
        String data2 = CharacterReader.Companion.cacheString(this.charBuf, this.stringCache, this.bufPos, this.bufLength - this.bufPos);
        this.bufPos = this.bufLength;
        return data2;
    }

    @NotNull
    public final String consumeLetterSequence() {
        return this.consumeMatching((Function1<? super Character, Boolean>)((Function1)CharacterReader::consumeLetterSequence$lambda$9));
    }

    @NotNull
    public final String consumeLetterThenDigitSequence() {
        int n;
        this.bufferUp();
        int start = this.bufPos;
        while (this.bufPos < this.bufLength) {
            Intrinsics.checkNotNull((Object)this.charBuf);
            if (!StringUtil.INSTANCE.isAsciiLetter(this.charBuf[this.bufPos])) break;
            n = this.bufPos;
            this.bufPos = n + 1;
        }
        while (!this.isEmptyNoBufferUp()) {
            Intrinsics.checkNotNull((Object)this.charBuf);
            if (!StringUtil.INSTANCE.isDigit(this.charBuf[this.bufPos])) break;
            n = this.bufPos;
            this.bufPos = n + 1;
        }
        return CharacterReader.Companion.cacheString(this.charBuf, this.stringCache, start, this.bufPos - start);
    }

    @NotNull
    public final String consumeHexSequence() {
        return this.consumeMatching((Function1<? super Character, Boolean>)((Function1)CharacterReader::consumeHexSequence$lambda$10));
    }

    @NotNull
    public final String consumeDigitSequence() {
        return this.consumeMatching((Function1<? super Character, Boolean>)((Function1)CharacterReader::consumeDigitSequence$lambda$11));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean matches(char c) {
        if (this.isEmpty()) return false;
        Intrinsics.checkNotNull((Object)this.charBuf);
        if (this.charBuf[this.bufPos] != c) return false;
        return true;
    }

    public final boolean matches(@NotNull String seq) {
        Intrinsics.checkNotNullParameter((Object)seq, (String)"seq");
        this.bufferUp();
        int scanLength = seq.length();
        if (scanLength > this.bufLength - this.bufPos) {
            return false;
        }
        for (int offset = 0; offset < scanLength; ++offset) {
            char c = seq.charAt(offset);
            Intrinsics.checkNotNull((Object)this.charBuf);
            if (c == this.charBuf[this.bufPos + offset]) continue;
            return false;
        }
        return true;
    }

    public final boolean matchesIgnoreCase(@NotNull String seq) {
        Intrinsics.checkNotNullParameter((Object)seq, (String)"seq");
        this.bufferUp();
        int scanLength = seq.length();
        if (scanLength > this.bufLength - this.bufPos) {
            return false;
        }
        for (int offset = 0; offset < scanLength; ++offset) {
            char scan = seq.charAt(offset);
            Intrinsics.checkNotNull((Object)this.charBuf);
            char target = this.charBuf[this.bufPos + offset];
            if (scan == target || (scan = Character.toUpperCase(scan)) == (target = Character.toUpperCase(target))) continue;
            return false;
        }
        return true;
    }

    public final boolean matchesAny(char ... seq) {
        Intrinsics.checkNotNullParameter((Object)seq, (String)"seq");
        if (this.isEmpty()) {
            return false;
        }
        this.bufferUp();
        Intrinsics.checkNotNull((Object)this.charBuf);
        char c = this.charBuf[this.bufPos];
        for (char seek : seq) {
            if (seek != c) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean matchesAnySorted(@NotNull char[] seq) {
        Intrinsics.checkNotNullParameter((Object)seq, (String)"seq");
        this.bufferUp();
        if (this.isEmpty()) return false;
        Intrinsics.checkNotNull((Object)this.charBuf);
        if (!ArraysKt.contains((char[])seq, (char)this.charBuf[this.bufPos])) return false;
        return true;
    }

    public final boolean matchesAsciiAlpha() {
        if (this.isEmpty()) {
            return false;
        }
        Intrinsics.checkNotNull((Object)this.charBuf);
        return StringUtil.INSTANCE.isAsciiLetter(this.charBuf[this.bufPos]);
    }

    public final boolean matchesDigit() {
        if (this.isEmpty()) {
            return false;
        }
        Intrinsics.checkNotNull((Object)this.charBuf);
        return StringUtil.INSTANCE.isDigit(this.charBuf[this.bufPos]);
    }

    public final boolean matchConsume(@NotNull String seq) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)seq, (String)"seq");
        this.bufferUp();
        if (this.matches(seq)) {
            this.bufPos += seq.length();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean matchConsumeIgnoreCase(@NotNull String seq) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)seq, (String)"seq");
        if (this.matchesIgnoreCase(seq)) {
            this.bufPos += seq.length();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean containsIgnoreCase(@NotNull String seq) {
        Intrinsics.checkNotNullParameter((Object)seq, (String)"seq");
        if (Intrinsics.areEqual((Object)seq, (Object)this.lastIcSeq)) {
            if (this.lastIcIndex == -1) {
                return false;
            }
            if (this.lastIcIndex >= this.bufPos) {
                return true;
            }
        }
        this.lastIcSeq = seq;
        String string = seq.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String loScan = string;
        int lo = this.nextIndexOf(loScan);
        if (lo > -1) {
            this.lastIcIndex = this.bufPos + lo;
            return true;
        }
        String string2 = seq.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        String hiScan = string2;
        int hi = this.nextIndexOf(hiScan);
        boolean found = hi > -1;
        this.lastIcIndex = found ? this.bufPos + hi : -1;
        return found;
    }

    @NotNull
    public String toString() {
        if (this.bufLength - this.bufPos < 0) {
            return "";
        }
        Intrinsics.checkNotNull((Object)this.charBuf);
        return StringsKt.concatToString((char[])this.charBuf, (int)this.bufPos, (int)(this.bufPos + (this.bufLength - this.bufPos)));
    }

    public final boolean rangeEquals(int start, int count, @NotNull String cached) {
        Intrinsics.checkNotNullParameter((Object)cached, (String)"cached");
        return Companion.rangeEquals(this.charBuf, start, count, cached);
    }

    private static final boolean consumeToAny$lambda$3(char[] $chars, char c) {
        boolean bl;
        block1: {
            char[] $this$none$iv = $chars;
            boolean $i$f$none = false;
            int n = $this$none$iv.length;
            for (int i = 0; i < n; ++i) {
                char element$iv;
                char seek = element$iv = $this$none$iv[i];
                boolean bl2 = false;
                if (!(c == seek)) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    private static final boolean consumeToAnySorted$lambda$4(CharacterReader this$0, char[] $chars, char c) {
        return this$0.binarySearch($chars, c) < 0;
    }

    private static final boolean consumeData$lambda$5(char c) {
        return c != '&' && c != '<' && c != '\u0000';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean consumeAttributeQuoted$lambda$6(boolean $single, char c) {
        if (c == '\u0000') return false;
        if (c == '&') return false;
        if ($single) {
            if (c == '\'') return false;
            return true;
        }
        if (c == '\"') return false;
        return true;
    }

    private static final boolean consumeRawData$lambda$7(char c) {
        return c != '<' && c != '\u0000';
    }

    private static final boolean consumeTagName$lambda$8(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': 
            case '/': 
            case '>': {
                return false;
            }
        }
        return true;
    }

    private static final boolean consumeLetterSequence$lambda$9(char ch) {
        return Character.isLetter(ch);
    }

    private static final boolean consumeHexSequence$lambda$10(char c) {
        return StringUtil.INSTANCE.isHexDigit(c);
    }

    private static final boolean consumeDigitSequence$lambda$11(char c) {
        return Intrinsics.compare((int)c, (int)48) >= 0 && Intrinsics.compare((int)c, (int)57) <= 0;
    }

    private static final String[] StringPool$lambda$12() {
        return new String[512];
    }

    private static final char[] BufferPool$lambda$13() {
        return new char[2048];
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0019\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J9\u0010\u0012\u001a\u00020\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u000e2\u0010\u0010\u0014\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010\u000b2\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\u0017J(\u0010\u0018\u001a\u00020\u00192\b\u0010\u0013\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/fleeksoft/ksoup/parser/CharacterReader$Companion;", "", "<init>", "()V", "EOF", "", "MaxStringCacheLen", "", "StringCacheSize", "StringPool", "Lcom/fleeksoft/ksoup/internal/SoftPool;", "", "", "BufferPool", "", "BufferSize", "RefillPoint", "RewindLimit", "cacheString", "charBuf", "stringCache", "start", "count", "([C[Ljava/lang/String;II)Ljava/lang/String;", "rangeEquals", "", "cached", "ksoup"})
    public static final class Companion {
        private Companion() {
        }

        private final String cacheString(char[] charBuf, String[] stringCache, int start, int count) {
            if (count > 12) {
                Intrinsics.checkNotNull((Object)charBuf);
                return StringKt.buildString(StringCompanionObject.INSTANCE, charBuf, start, count);
            }
            if (count < 1) {
                return "";
            }
            int hash = 0;
            int end = count + start;
            for (int i = start; i < end; ++i) {
                Intrinsics.checkNotNull((Object)charBuf);
                hash = 31 * hash + charBuf[i];
            }
            int index = hash & 0x1FF;
            Intrinsics.checkNotNull((Object)stringCache);
            String cached = stringCache[index];
            if (cached != null && this.rangeEquals(charBuf, start, count, cached)) {
                return cached;
            }
            Intrinsics.checkNotNull((Object)charBuf);
            stringCache[index] = cached = StringKt.buildString(StringCompanionObject.INSTANCE, charBuf, start, count);
            return cached;
        }

        public final boolean rangeEquals(@Nullable char[] charBuf, int start, int count, @NotNull String cached) {
            Intrinsics.checkNotNullParameter((Object)cached, (String)"cached");
            int loopCount = count;
            if (loopCount == cached.length()) {
                int i = start;
                int j = 0;
                while (loopCount-- != 0) {
                    Intrinsics.checkNotNull((Object)charBuf);
                    if (charBuf[i++] == cached.charAt(j++)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

