/*
 * Decompiled with CFR 0.152.
 */
package com.fleeksoft.ksoup.nodes;

import com.fleeksoft.ksoup.helper.Validate;
import com.fleeksoft.ksoup.internal.QuietAppendable;
import com.fleeksoft.ksoup.internal.StringUtil;
import com.fleeksoft.ksoup.nodes.Document;
import com.fleeksoft.ksoup.nodes.Element;
import com.fleeksoft.ksoup.nodes.Entities;
import com.fleeksoft.ksoup.nodes.LeafNode;
import com.fleeksoft.ksoup.nodes.Node;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0003H\u0016J\b\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u0002\u001a\u00020\u00002\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003J\u0006\u0010\u0007\u001a\u00020\u0003J\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fJ\u001d\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0010\u00a2\u0006\u0002\b\u0013J\b\u0010\u0014\u001a\u00020\u0003H\u0016J\r\u0010\u0015\u001a\u00020\u0016H\u0010\u00a2\u0006\u0002\b\u0017J\b\u0010\u0018\u001a\u00020\u0000H\u0016\u00a8\u0006\u001a"}, d2={"Lcom/fleeksoft/ksoup/nodes/TextNode;", "Lcom/fleeksoft/ksoup/nodes/LeafNode;", "text", "", "<init>", "(Ljava/lang/String;)V", "nodeName", "getWholeText", "isBlank", "", "splitText", "offset", "", "outerHtmlHead", "", "accum", "Lcom/fleeksoft/ksoup/internal/QuietAppendable;", "out", "Lcom/fleeksoft/ksoup/nodes/Document$OutputSettings;", "outerHtmlHead$ksoup", "toString", "createClone", "Lcom/fleeksoft/ksoup/nodes/Node;", "createClone$ksoup", "clone", "Companion", "ksoup"})
public class TextNode
extends LeafNode {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public TextNode(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        super(text2);
    }

    @Override
    @NotNull
    public String nodeName() {
        return "#text";
    }

    @NotNull
    public String text() {
        return StringUtil.INSTANCE.normaliseWhitespace(this.getWholeText());
    }

    @NotNull
    public final TextNode text(@Nullable String text2) {
        this.coreValue(text2);
        return this;
    }

    @NotNull
    public final String getWholeText() {
        return this.coreValue();
    }

    public final boolean isBlank() {
        return StringUtil.INSTANCE.isBlank(this.coreValue());
    }

    @NotNull
    public final TextNode splitText(int offset) {
        String text2 = this.coreValue();
        Validate.INSTANCE.isTrue(offset >= 0, "Split offset must be not be negative");
        Validate.INSTANCE.isTrue(offset < text2.length(), "Split offset must not be greater than current text length");
        String string = text2.substring(0, offset);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String head = string;
        String string2 = text2.substring(offset);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String tail = string2;
        this.text(head);
        TextNode tailNode = new TextNode(tail);
        if (this.get_parentNode() != null) {
            Element element = this.get_parentNode();
            Intrinsics.checkNotNull((Object)element);
            Node[] nodeArray = new Node[]{tailNode};
            element.addChildren(this.siblingIndex() + 1, nodeArray);
        }
        return tailNode;
    }

    @Override
    public void outerHtmlHead$ksoup(@NotNull QuietAppendable accum, @NotNull Document.OutputSettings out) {
        Intrinsics.checkNotNullParameter((Object)accum, (String)"accum");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Entities.INSTANCE.escape(accum, this.coreValue(), out, 1);
    }

    @Override
    @NotNull
    public String toString() {
        return this.outerHtml();
    }

    @Override
    @NotNull
    public Node createClone$ksoup() {
        TextNode clone = new TextNode("");
        clone.setValue$ksoup(this.getValue$ksoup());
        return clone;
    }

    @Override
    @NotNull
    public TextNode clone() {
        Node node = super.clone();
        Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type com.fleeksoft.ksoup.nodes.TextNode");
        return (TextNode)node;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007J\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007J\u0019\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u00060\u000ej\u0002`\u000fH\u0000\u00a2\u0006\u0002\b\u0010\u00a8\u0006\u0011"}, d2={"Lcom/fleeksoft/ksoup/nodes/TextNode$Companion;", "", "<init>", "()V", "createFromEncoded", "Lcom/fleeksoft/ksoup/nodes/TextNode;", "encodedText", "", "normaliseWhitespace", "text", "stripLeadingWhitespace", "lastCharIsWhitespace", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "lastCharIsWhitespace$ksoup", "ksoup"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TextNode createFromEncoded(@NotNull String encodedText) {
            Intrinsics.checkNotNullParameter((Object)encodedText, (String)"encodedText");
            String text2 = Entities.INSTANCE.unescape(encodedText);
            return new TextNode(text2);
        }

        @NotNull
        public final String normaliseWhitespace(@NotNull String text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            return StringUtil.INSTANCE.normaliseWhitespace(text2);
        }

        @NotNull
        public final String stripLeadingWhitespace(@NotNull String text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            CharSequence charSequence = text2;
            Regex regex = new Regex("^\\s+");
            String string = "";
            return regex.replaceFirst(charSequence, string);
        }

        public final boolean lastCharIsWhitespace$ksoup(@NotNull StringBuilder sb) {
            Intrinsics.checkNotNullParameter((Object)sb, (String)"sb");
            return ((CharSequence)sb).length() > 0 && sb.charAt(sb.length() - 1) == ' ';
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

