/*
 * Decompiled with CFR 0.152.
 */
package com.fleeksoft.ksoup.nodes;

import com.fleeksoft.ksoup.internal.QuietAppendable;
import com.fleeksoft.ksoup.internal.StringUtil;
import com.fleeksoft.ksoup.nodes.Document;
import com.fleeksoft.ksoup.nodes.Element;
import com.fleeksoft.ksoup.nodes.Entities;
import com.fleeksoft.ksoup.nodes.LeafNode;
import com.fleeksoft.ksoup.nodes.Node;
import com.fleeksoft.ksoup.nodes.NodeUtils;
import com.fleeksoft.ksoup.nodes.TextNode;
import com.fleeksoft.ksoup.ported.CharacterKt;
import com.fleeksoft.ksoup.select.NodeVisitor;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 #2\u00020\u0001:\u0003!\"#B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010 \u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006$"}, d2={"Lcom/fleeksoft/ksoup/nodes/Printer;", "Lcom/fleeksoft/ksoup/select/NodeVisitor;", "root", "Lcom/fleeksoft/ksoup/nodes/Node;", "accum", "Lcom/fleeksoft/ksoup/internal/QuietAppendable;", "settings", "Lcom/fleeksoft/ksoup/nodes/Document$OutputSettings;", "<init>", "(Lcom/fleeksoft/ksoup/nodes/Node;Lcom/fleeksoft/ksoup/internal/QuietAppendable;Lcom/fleeksoft/ksoup/nodes/Document$OutputSettings;)V", "getRoot", "()Lcom/fleeksoft/ksoup/nodes/Node;", "getAccum", "()Lcom/fleeksoft/ksoup/internal/QuietAppendable;", "getSettings", "()Lcom/fleeksoft/ksoup/nodes/Document$OutputSettings;", "addHead", "", "el", "Lcom/fleeksoft/ksoup/nodes/Element;", "depth", "", "addTail", "addText", "textNode", "Lcom/fleeksoft/ksoup/nodes/TextNode;", "textOptions", "addNode", "node", "Lcom/fleeksoft/ksoup/nodes/LeafNode;", "indent", "head", "tail", "Pretty", "Outline", "Companion", "ksoup"})
public class Printer
implements NodeVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Node root;
    @NotNull
    private final QuietAppendable accum;
    @NotNull
    private final Document.OutputSettings settings;

    public Printer(@NotNull Node root, @NotNull QuietAppendable accum, @NotNull Document.OutputSettings settings) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)accum, (String)"accum");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.root = root;
        this.accum = accum;
        this.settings = settings;
    }

    @NotNull
    public final Node getRoot() {
        return this.root;
    }

    @NotNull
    public final QuietAppendable getAccum() {
        return this.accum;
    }

    @NotNull
    public final Document.OutputSettings getSettings() {
        return this.settings;
    }

    public void addHead(@NotNull Element el, int depth) {
        Intrinsics.checkNotNullParameter((Object)el, (String)"el");
        el.outerHtmlHead$ksoup(this.accum, this.settings);
    }

    public void addTail(@NotNull Element el, int depth) {
        Intrinsics.checkNotNullParameter((Object)el, (String)"el");
        el.outerHtmlTail$ksoup(this.accum, this.settings);
    }

    public void addText(@NotNull TextNode textNode, int textOptions, int depth) {
        Intrinsics.checkNotNullParameter((Object)textNode, (String)"textNode");
        int options = 1 | textOptions;
        Entities.INSTANCE.escape(this.accum, textNode.coreValue(), this.settings, options);
    }

    public void addNode(@NotNull LeafNode node, int depth) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        node.outerHtmlHead$ksoup(this.accum, this.settings);
    }

    public final void indent(int depth) {
        this.accum.append('\n').append(StringUtil.INSTANCE.padding(depth * this.settings.indentAmount(), this.settings.maxPaddingWidth()));
    }

    @Override
    public void head(@NotNull Node node, int depth) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node.getClass() == TextNode.class) {
            this.addText((TextNode)node, 0, depth);
        } else if (node instanceof Element) {
            this.addHead((Element)node, depth);
        } else {
            this.addNode((LeafNode)node, depth);
        }
    }

    @Override
    public void tail(@NotNull Node node, int depth) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node instanceof Element) {
            this.addTail((Element)node, depth);
        }
    }

    @Override
    public void traverse(@NotNull Node root) {
        NodeVisitor.DefaultImpls.traverse(this, root);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/fleeksoft/ksoup/nodes/Printer$Companion;", "", "<init>", "()V", "printerFor", "Lcom/fleeksoft/ksoup/nodes/Printer;", "root", "Lcom/fleeksoft/ksoup/nodes/Node;", "accum", "Lcom/fleeksoft/ksoup/internal/QuietAppendable;", "ksoup"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Printer printerFor(@NotNull Node root, @NotNull QuietAppendable accum) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)accum, (String)"accum");
            Document.OutputSettings settings = NodeUtils.INSTANCE.outputSettings(root);
            return settings.outline() ? (Printer)new Outline(root, accum, settings) : (settings.prettyPrint() ? (Printer)new Pretty(root, accum, settings) : new Printer(root, accum, settings));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010\r\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/fleeksoft/ksoup/nodes/Printer$Outline;", "Lcom/fleeksoft/ksoup/nodes/Printer$Pretty;", "root", "Lcom/fleeksoft/ksoup/nodes/Node;", "accum", "Lcom/fleeksoft/ksoup/internal/QuietAppendable;", "settings", "Lcom/fleeksoft/ksoup/nodes/Document$OutputSettings;", "<init>", "(Lcom/fleeksoft/ksoup/nodes/Node;Lcom/fleeksoft/ksoup/internal/QuietAppendable;Lcom/fleeksoft/ksoup/nodes/Document$OutputSettings;)V", "isBlockEl", "", "node", "shouldIndent", "ksoup"})
    public static class Outline
    extends Pretty {
        public Outline(@NotNull Node root, @NotNull QuietAppendable accum, @NotNull Document.OutputSettings settings) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)accum, (String)"accum");
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            super(root, accum, settings);
        }

        @Override
        public boolean isBlockEl(@Nullable Node node) {
            return node != null;
        }

        @Override
        public boolean shouldIndent(@Nullable Node node) {
            if (node == null || Intrinsics.areEqual((Object)node, (Object)this.getRoot()) || this.getPreserveWhitespace() || Pretty.Companion.isBlankText(node)) {
                return false;
            }
            if (node instanceof TextNode) {
                return ((TextNode)node).previousSibling() != null || ((TextNode)node).nextSibling() != null;
            }
            return true;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 !2\u00020\u0001:\u0001!B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u0015J\u0012\u0010\u001f\u001a\u00020\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010 \u001a\u00020\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u0016R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\""}, d2={"Lcom/fleeksoft/ksoup/nodes/Printer$Pretty;", "Lcom/fleeksoft/ksoup/nodes/Printer;", "root", "Lcom/fleeksoft/ksoup/nodes/Node;", "accum", "Lcom/fleeksoft/ksoup/internal/QuietAppendable;", "settings", "Lcom/fleeksoft/ksoup/nodes/Document$OutputSettings;", "<init>", "(Lcom/fleeksoft/ksoup/nodes/Node;Lcom/fleeksoft/ksoup/internal/QuietAppendable;Lcom/fleeksoft/ksoup/nodes/Document$OutputSettings;)V", "preserveWhitespace", "", "getPreserveWhitespace", "()Z", "setPreserveWhitespace", "(Z)V", "addHead", "", "el", "Lcom/fleeksoft/ksoup/nodes/Element;", "depth", "", "addTail", "addNode", "node", "Lcom/fleeksoft/ksoup/nodes/LeafNode;", "addText", "Lcom/fleeksoft/ksoup/nodes/TextNode;", "textOptions", "textTrim", "options", "shouldIndent", "isBlockEl", "Companion", "ksoup"})
    public static class Pretty
    extends Printer {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private boolean preserveWhitespace;
        public static final int maxScan = 5;

        public Pretty(@NotNull Node root, @NotNull QuietAppendable accum, @NotNull Document.OutputSettings settings) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)accum, (String)"accum");
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            super(root, accum, settings);
            for (Node node = root; node != null; node = node.parentNode()) {
                if (!Companion.tagIs(64, node)) continue;
                this.preserveWhitespace = true;
                break;
            }
        }

        public final boolean getPreserveWhitespace() {
            return this.preserveWhitespace;
        }

        public final void setPreserveWhitespace(boolean bl) {
            this.preserveWhitespace = bl;
        }

        @Override
        public void addHead(@NotNull Element el, int depth) {
            Intrinsics.checkNotNullParameter((Object)el, (String)"el");
            if (this.shouldIndent(el)) {
                this.indent(depth);
            }
            super.addHead(el, depth);
            if (Companion.tagIs(64, el)) {
                this.preserveWhitespace = true;
            }
        }

        @Override
        public void addTail(@NotNull Element el, int depth) {
            Intrinsics.checkNotNullParameter((Object)el, (String)"el");
            if (this.shouldIndent(Companion.nextNonBlank(el.firstChild()))) {
                this.indent(depth);
            }
            super.addTail(el, depth);
            if (this.preserveWhitespace && el.getTag().is(64)) {
                for (Element parent = el.parent(); parent != null; parent = parent.parent()) {
                    if (!parent.tag().preserveWhitespace()) continue;
                    return;
                }
                this.preserveWhitespace = false;
            }
        }

        @Override
        public void addNode(@NotNull LeafNode node, int depth) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (this.shouldIndent(node)) {
                this.indent(depth);
            }
            super.addNode(node, depth);
        }

        @Override
        public void addText(@NotNull TextNode node, int textOptions, int depth) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            int options = textOptions;
            if (!this.preserveWhitespace) {
                options |= 4;
                options = this.textTrim(node, options);
                if (!node.isBlank() && this.isBlockEl(node.parentNode()) && this.shouldIndent(node)) {
                    this.indent(depth);
                }
            }
            super.addText(node, options, depth);
        }

        public final int textTrim(@NotNull TextNode node, int options) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (!this.isBlockEl(node.parentNode())) {
                return options;
            }
            Node prev = node.previousSibling();
            Node next = node.nextSibling();
            int opts = options;
            if ((!(prev instanceof Element) || this.isBlockEl(prev)) && (prev == null || !(prev instanceof TextNode) && this.shouldIndent(prev))) {
                opts |= 8;
            }
            if (next == null || !(next instanceof TextNode) && this.shouldIndent(next)) {
                opts |= 0x10;
            } else if ((next = Companion.nextNonBlank(next)) instanceof TextNode && StringUtil.INSTANCE.isWhitespace(CharacterKt.codePointAt(((TextNode)next).nodeValue(), 0).getValue())) {
                opts |= 0x10;
            }
            return opts;
        }

        public boolean shouldIndent(@Nullable Node node) {
            Node prevSib;
            block7: {
                block6: {
                    if (node == null || Intrinsics.areEqual((Object)node, (Object)this.getRoot()) || this.preserveWhitespace || Companion.isBlankText(node)) {
                        return false;
                    }
                    if (this.isBlockEl(node)) {
                        return true;
                    }
                    prevSib = Companion.previousNonblank(node);
                    if (this.isBlockEl(prevSib)) {
                        return true;
                    }
                    Element parent = node.get_parentNode();
                    if (!this.isBlockEl(parent)) break block6;
                    Element element = parent;
                    Intrinsics.checkNotNull((Object)element);
                    if (!element.tag().is(8) && Companion.hasNonTextNodes(parent)) break block7;
                }
                return false;
            }
            return prevSib == null || !(prevSib instanceof TextNode) && (this.isBlockEl(prevSib) || !(prevSib instanceof Element));
        }

        public boolean isBlockEl(@Nullable Node node) {
            if (node == null) {
                return false;
            }
            if (node instanceof Element) {
                Node el = node;
                return ((Element)el).isBlock() || !((Element)el).getTag().isKnownTag() && (((Element)el).parentNode() instanceof Document || Companion.hasChildBlocks((Element)el));
            }
            return false;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\fJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\fJ\u0010\u0010\u000f\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\fJ\u0018\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/fleeksoft/ksoup/nodes/Printer$Pretty$Companion;", "", "<init>", "()V", "maxScan", "", "hasChildBlocks", "", "el", "Lcom/fleeksoft/ksoup/nodes/Element;", "hasNonTextNodes", "previousNonblank", "Lcom/fleeksoft/ksoup/nodes/Node;", "node", "nextNonBlank", "isBlankText", "tagIs", "option", "ksoup"})
        public static final class Companion {
            private Companion() {
            }

            public final boolean hasChildBlocks(@NotNull Element el) {
                Intrinsics.checkNotNullParameter((Object)el, (String)"el");
                Element child = el.firstElementChild();
                for (int i = 0; i < 5 && child != null; child = child.nextElementSibling(), ++i) {
                    if (!child.isBlock() && child.getTag().isKnownTag()) continue;
                    return true;
                }
                return false;
            }

            public final boolean hasNonTextNodes(@NotNull Element el) {
                Intrinsics.checkNotNullParameter((Object)el, (String)"el");
                Node child = el.firstChild();
                for (int i = 0; i < 5 && child != null; ++i) {
                    if (!(child instanceof TextNode)) {
                        return true;
                    }
                    child = ((TextNode)child).nextSibling();
                }
                return false;
            }

            @Nullable
            public final Node previousNonblank(@NotNull Node node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Node prev = node.previousSibling();
                while (this.isBlankText(prev)) {
                    Node node2 = prev;
                    prev = node2 != null ? node2.previousSibling() : null;
                }
                return prev;
            }

            @Nullable
            public final Node nextNonBlank(@Nullable Node node) {
                Node n = node;
                while (this.isBlankText(n)) {
                    Node node2 = n;
                    n = node2 != null ? node2.nextSibling() : null;
                }
                return n;
            }

            public final boolean isBlankText(@Nullable Node node) {
                return node instanceof TextNode && ((TextNode)node).isBlank();
            }

            public final boolean tagIs(int option, @Nullable Node node) {
                return node instanceof Element && ((Element)node).getTag().is(option);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

