/*
 * Decompiled with CFR 0.152.
 */
package com.fleeksoft.ksoup.nodes;

import com.fleeksoft.charset.Charsets;
import com.fleeksoft.ksoup.helper.Validate;
import com.fleeksoft.ksoup.internal.StringUtil;
import com.fleeksoft.ksoup.nodes.Attributes;
import com.fleeksoft.ksoup.nodes.DocumentType;
import com.fleeksoft.ksoup.nodes.Element;
import com.fleeksoft.ksoup.nodes.Entities;
import com.fleeksoft.ksoup.nodes.FormElement;
import com.fleeksoft.ksoup.nodes.LeafNode;
import com.fleeksoft.ksoup.nodes.Node;
import com.fleeksoft.ksoup.nodes.XmlDeclaration;
import com.fleeksoft.ksoup.parser.ParseSettings;
import com.fleeksoft.ksoup.parser.Parser;
import com.fleeksoft.ksoup.parser.Tag;
import com.fleeksoft.ksoup.ported.KCloneable;
import com.fleeksoft.ksoup.select.Elements;
import com.fleeksoft.ksoup.select.Evaluator;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 .2\u00020\u0001:\u0003,-.B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0013\b\u0016\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0007\u0010\nJ\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003J\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\b\u0010\u0011\u001a\u00020\u0001H\u0002J\u0006\u0010\u0012\u001a\u00020\u0001J\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001J\u0006\u0010\u0014\u001a\u00020\u0001J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0019\u001a\u00020\u0003J\u0006\u0010\u001a\u001a\u00020\u0003J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u0003J\u000e\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u0003J\b\u0010\u001e\u001a\u00020\u0003H\u0016J\u0010\u0010\u001f\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\b\u0010 \u001a\u00020\u0003H\u0016J\u0012\u0010!\u001a\u00020\u001b2\n\u0010!\u001a\u00060\"j\u0002`#J\n\u0010!\u001a\u00060\"j\u0002`#J\b\u0010$\u001a\u00020\u0000H\u0016J\r\u0010%\u001a\u00020&H\u0010\u00a2\u0006\u0002\b'J\b\u0010(\u001a\u00020\u0000H\u0016J\b\u0010)\u001a\u00020\u001bH\u0002J\b\u0010*\u001a\u00020+H\u0002J\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/fleeksoft/ksoup/nodes/Document;", "Lcom/fleeksoft/ksoup/nodes/Element;", "namespace", "", "location", "parser", "Lcom/fleeksoft/ksoup/parser/Parser;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/fleeksoft/ksoup/parser/Parser;)V", "baseUri", "(Ljava/lang/String;)V", "outputSettings", "Lcom/fleeksoft/ksoup/nodes/Document$OutputSettings;", "quirksMode", "Lcom/fleeksoft/ksoup/nodes/Document$QuirksMode;", "documentType", "Lcom/fleeksoft/ksoup/nodes/DocumentType;", "htmlEl", "head", "headOrNull", "body", "forms", "", "Lcom/fleeksoft/ksoup/nodes/FormElement;", "expectForm", "cssQuery", "title", "", "createElement", "tagName", "outerHtml", "text", "nodeName", "charset", "Ljava/nio/charset/Charset;", "Lcom/fleeksoft/charset/Charset;", "clone", "createClone", "Lcom/fleeksoft/ksoup/nodes/Node;", "createClone$ksoup", "shallowClone", "ensureMetaCharsetElement", "ensureXmlDecl", "Lcom/fleeksoft/ksoup/nodes/XmlDeclaration;", "OutputSettings", "QuirksMode", "Companion", "ksoup"})
public final class Document
extends Element {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String namespace;
    @Nullable
    private final String location;
    @NotNull
    private Parser parser;
    @NotNull
    private OutputSettings outputSettings;
    @NotNull
    private QuirksMode quirksMode;
    @NotNull
    private static final Evaluator titleEval = new Evaluator.Tag("title");

    public Document(@NotNull String namespace, @Nullable String location, @NotNull Parser parser) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        super(new Tag("#root", namespace), location);
        this.namespace = namespace;
        this.location = location;
        this.parser = parser;
        this.outputSettings = new OutputSettings(null, null, false, false, 0, 0, null, 127, null);
        this.quirksMode = QuirksMode.noQuirks;
    }

    public /* synthetic */ Document(String string, String string2, Parser parser, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            parser = Parser.Companion.htmlParser();
        }
        this(string, string2, parser);
    }

    public Document(@Nullable String baseUri) {
        this("http://www.w3.org/1999/xhtml", baseUri, null, 4, null);
    }

    @Nullable
    public final String location() {
        return this.location;
    }

    @Nullable
    public final DocumentType documentType() {
        for (Node node : this.getChildNodes()) {
            if (node instanceof DocumentType) {
                return (DocumentType)node;
            }
            if (node instanceof LeafNode) continue;
            break;
        }
        return null;
    }

    private final Element htmlEl() {
        for (Element el = this.firstElementChild(); el != null; el = el.nextElementSibling()) {
            if (!el.nameIs("html")) continue;
            return el;
        }
        return Element.appendElement$default(this, "html", null, 2, null);
    }

    @NotNull
    public final Element head() {
        Element html = this.htmlEl();
        for (Element el = html.firstElementChild(); el != null; el = el.nextElementSibling()) {
            if (!el.nameIs("head")) continue;
            return el;
        }
        return Element.prependElement$default(html, "head", null, 2, null);
    }

    @Nullable
    public final Element headOrNull() {
        Element html = this.htmlEl();
        for (Element el = html.firstElementChild(); el != null; el = el.nextElementSibling()) {
            if (!el.nameIs("head")) continue;
            return el;
        }
        return null;
    }

    @NotNull
    public final Element body() {
        Element html = this.htmlEl();
        for (Element el = html.firstElementChild(); el != null; el = el.nextElementSibling()) {
            if (!el.nameIs("body") && !el.nameIs("frameset")) continue;
            return el;
        }
        return Element.appendElement$default(html, "body", null, 2, null);
    }

    @NotNull
    public final List<FormElement> forms() {
        return this.select("form").forms();
    }

    @Nullable
    public final FormElement expectForm(@NotNull String cssQuery) {
        Intrinsics.checkNotNullParameter((Object)cssQuery, (String)"cssQuery");
        Elements els = this.select(cssQuery);
        for (Element el : els) {
            if (!(el instanceof FormElement)) continue;
            return (FormElement)el;
        }
        Validate.INSTANCE.fail("No form elements matched the query '" + cssQuery + "' in the document.");
        return null;
    }

    @NotNull
    public final String title() {
        Element titleEl;
        Element element = titleEl = this.head().selectFirst(titleEval);
        return element != null ? ((Object)StringsKt.trim((CharSequence)StringUtil.INSTANCE.normaliseWhitespace(element.text()))).toString() : "";
    }

    public final void title(@NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Element titleEl = this.head().selectFirst(titleEval);
        if (titleEl == null) {
            titleEl = Element.appendElement$default(this.head(), "title", null, 2, null);
        }
        titleEl.text(title);
    }

    @NotNull
    public final Element createElement(@NotNull String tagName) {
        Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
        return new Element(this.parser.tagSet().valueOf(tagName, this.parser.defaultNamespace(), ParseSettings.Companion.getPreserveCase()), Element.Companion.searchUpForAttribute(this, Element.Companion.getBaseUriKey()));
    }

    @Override
    @NotNull
    public String outerHtml() {
        return super.html();
    }

    @Override
    @NotNull
    public Element text(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.body().text(text2);
        return this;
    }

    @Override
    @NotNull
    public String nodeName() {
        return "#document";
    }

    public final void charset(@NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        this.outputSettings.charset(charset);
        this.ensureMetaCharsetElement();
    }

    @NotNull
    public final Charset charset() {
        return this.outputSettings.charset();
    }

    @Override
    @NotNull
    public Document clone() {
        Element element = super.clone();
        Intrinsics.checkNotNull((Object)element, (String)"null cannot be cast to non-null type com.fleeksoft.ksoup.nodes.Document");
        Document clone = (Document)element;
        clone.outputSettings = this.outputSettings.clone();
        Attributes attributes = this.getAttributes$ksoup();
        clone.setAttributes$ksoup(attributes != null ? attributes.clone() : null);
        return clone;
    }

    @Override
    @NotNull
    public Node createClone$ksoup() {
        Document clone = new Document(this.namespace, this.location, null, 4, null);
        clone.outputSettings = this.outputSettings;
        clone.parser = this.parser;
        clone.setAttributes$ksoup(this.getAttributes$ksoup());
        clone.setChildNodes(this.getChildNodes());
        clone.setTag(this.getTag());
        clone.setBaseUri(this.baseUri());
        return clone;
    }

    @Override
    @NotNull
    public Document shallowClone() {
        Document clone = new Document(this.tag().namespace(), this.baseUri(), this.parser);
        Attributes attributes = this.getAttributes$ksoup();
        clone.setAttributes$ksoup(attributes != null ? attributes.clone() : null);
        clone.outputSettings = this.outputSettings.clone();
        return clone;
    }

    private final void ensureMetaCharsetElement() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.outputSettings().syntax().ordinal()]) {
            case 1: {
                Element metaCharset = this.selectFirst("meta[charset]");
                Element element = metaCharset != null ? metaCharset.attr("charset", this.charset().name()) : Element.appendElement$default(this.head(), "meta", null, 2, null).attr("charset", this.charset().name());
                this.select("meta[name=charset]").remove();
                break;
            }
            case 2: {
                XmlDeclaration xmlDeclaration;
                XmlDeclaration $this$ensureMetaCharsetElement_u24lambda_u240 = xmlDeclaration = this.ensureXmlDecl();
                boolean bl = false;
                $this$ensureMetaCharsetElement_u24lambda_u240.attr("version", "1.0");
                $this$ensureMetaCharsetElement_u24lambda_u240.attr("encoding", this.charset().name());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final XmlDeclaration ensureXmlDecl() {
        Node node = this.firstChild();
        if (node instanceof XmlDeclaration && Intrinsics.areEqual((Object)((XmlDeclaration)node).name(), (Object)"xml")) {
            return (XmlDeclaration)node;
        }
        XmlDeclaration decl = new XmlDeclaration("xml", false);
        this.prependChild(decl);
        return decl;
    }

    @NotNull
    public final OutputSettings outputSettings() {
        return this.outputSettings;
    }

    @NotNull
    public final Document outputSettings(@NotNull OutputSettings outputSettings) {
        Intrinsics.checkNotNullParameter((Object)outputSettings, (String)"outputSettings");
        this.outputSettings = outputSettings;
        return this;
    }

    @NotNull
    public final QuirksMode quirksMode() {
        return this.quirksMode;
    }

    @NotNull
    public final Document quirksMode(@NotNull QuirksMode quirksMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)quirksMode), (String)"quirksMode");
        this.quirksMode = quirksMode;
        return this;
    }

    @Nullable
    public final Parser parser() {
        return this.parser;
    }

    @NotNull
    public final Document parser(@NotNull Parser parser) {
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        this.parser = parser;
        return this;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/fleeksoft/ksoup/nodes/Document$Companion;", "", "<init>", "()V", "createShell", "Lcom/fleeksoft/ksoup/nodes/Document;", "baseUri", "", "titleEval", "Lcom/fleeksoft/ksoup/select/Evaluator;", "ksoup"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Document createShell(@NotNull String baseUri) {
            Intrinsics.checkNotNullParameter((Object)baseUri, (String)"baseUri");
            Document doc = new Document(baseUri);
            Element html = Element.appendElement$default(doc, "html", null, 2, null);
            Element.appendElement$default(html, "head", null, 2, null);
            Element.appendElement$default(html, "body", null, 2, null);
            return doc;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\"BQ\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\f\b\u0002\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006J\u0012\u0010\u0004\u001a\u00020\u00002\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0011J\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\bJ\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u000bJ\b\u0010\u0014\u001a\u00020\u0000H\u0016J\t\u0010\u0015\u001a\u00020\u0003H\u00c2\u0003J\r\u0010\u0016\u001a\u00060\u0005j\u0002`\u0006H\u00c2\u0003J\t\u0010\u0017\u001a\u00020\bH\u00c2\u0003J\t\u0010\u0018\u001a\u00020\bH\u00c2\u0003J\t\u0010\u0019\u001a\u00020\u000bH\u00c2\u0003J\t\u0010\u001a\u001a\u00020\u000bH\u00c2\u0003J\t\u0010\u001b\u001a\u00020\u000eH\u00c2\u0003JS\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\f\b\u0002\u0010\u0004\u001a\u00060\u0005j\u0002`\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u00d6\u0003J\t\u0010 \u001a\u00020\u000bH\u00d6\u0001J\t\u0010!\u001a\u00020\u0011H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/fleeksoft/ksoup/nodes/Document$OutputSettings;", "Lcom/fleeksoft/ksoup/ported/KCloneable;", "escapeMode", "Lcom/fleeksoft/ksoup/nodes/Entities$EscapeMode;", "charset", "Ljava/nio/charset/Charset;", "Lcom/fleeksoft/charset/Charset;", "prettyPrint", "", "outline", "indentAmount", "", "maxPaddingWidth", "syntax", "Lcom/fleeksoft/ksoup/nodes/Document$OutputSettings$Syntax;", "<init>", "(Lcom/fleeksoft/ksoup/nodes/Entities$EscapeMode;Ljava/nio/charset/Charset;ZZIILcom/fleeksoft/ksoup/nodes/Document$OutputSettings$Syntax;)V", "", "pretty", "outlineMode", "clone", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "", "hashCode", "toString", "Syntax", "ksoup"})
    public static final class OutputSettings
    implements KCloneable<OutputSettings> {
        @NotNull
        private Entities.EscapeMode escapeMode;
        @NotNull
        private Charset charset;
        private boolean prettyPrint;
        private boolean outline;
        private int indentAmount;
        private int maxPaddingWidth;
        @NotNull
        private Syntax syntax;

        public OutputSettings(@NotNull Entities.EscapeMode escapeMode, @NotNull Charset charset, boolean prettyPrint, boolean outline, int indentAmount, int maxPaddingWidth, @NotNull Syntax syntax) {
            Intrinsics.checkNotNullParameter((Object)((Object)escapeMode), (String)"escapeMode");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            Intrinsics.checkNotNullParameter((Object)((Object)syntax), (String)"syntax");
            this.escapeMode = escapeMode;
            this.charset = charset;
            this.prettyPrint = prettyPrint;
            this.outline = outline;
            this.indentAmount = indentAmount;
            this.maxPaddingWidth = maxPaddingWidth;
            this.syntax = syntax;
        }

        public /* synthetic */ OutputSettings(Entities.EscapeMode escapeMode, Charset charset, boolean bl, boolean bl2, int n, int n2, Syntax syntax, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                escapeMode = Entities.EscapeMode.base;
            }
            if ((n3 & 2) != 0) {
                charset = Charsets.INSTANCE.getUTF8();
            }
            if ((n3 & 4) != 0) {
                bl = true;
            }
            if ((n3 & 8) != 0) {
                bl2 = false;
            }
            if ((n3 & 0x10) != 0) {
                n = 1;
            }
            if ((n3 & 0x20) != 0) {
                n2 = 30;
            }
            if ((n3 & 0x40) != 0) {
                syntax = Syntax.html;
            }
            this(escapeMode, charset, bl, bl2, n, n2, syntax);
        }

        @NotNull
        public final Entities.EscapeMode escapeMode() {
            return this.escapeMode;
        }

        @NotNull
        public final OutputSettings escapeMode(@NotNull Entities.EscapeMode escapeMode) {
            Intrinsics.checkNotNullParameter((Object)((Object)escapeMode), (String)"escapeMode");
            this.escapeMode = escapeMode;
            return this;
        }

        @NotNull
        public final Charset charset() {
            return this.charset;
        }

        @NotNull
        public final OutputSettings charset(@NotNull Charset charset) {
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            this.charset = charset;
            return this;
        }

        @NotNull
        public final OutputSettings charset(@NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            this.charset(Charsets.INSTANCE.forName(charset));
            return this;
        }

        @NotNull
        public final Syntax syntax() {
            return this.syntax;
        }

        @NotNull
        public final OutputSettings syntax(@NotNull Syntax syntax) {
            Intrinsics.checkNotNullParameter((Object)((Object)syntax), (String)"syntax");
            this.syntax = syntax;
            if (syntax == Syntax.xml) {
                this.escapeMode(Entities.EscapeMode.xhtml);
            }
            return this;
        }

        public final boolean prettyPrint() {
            return this.prettyPrint;
        }

        @NotNull
        public final OutputSettings prettyPrint(boolean pretty) {
            this.prettyPrint = pretty;
            return this;
        }

        public final boolean outline() {
            return this.outline;
        }

        @NotNull
        public final OutputSettings outline(boolean outlineMode) {
            this.outline = outlineMode;
            return this;
        }

        public final int indentAmount() {
            return this.indentAmount;
        }

        @NotNull
        public final OutputSettings indentAmount(int indentAmount) {
            Validate.INSTANCE.isTrue(indentAmount >= 0);
            this.indentAmount = indentAmount;
            return this;
        }

        public final int maxPaddingWidth() {
            return this.maxPaddingWidth;
        }

        @NotNull
        public final OutputSettings maxPaddingWidth(int maxPaddingWidth) {
            Validate.INSTANCE.isTrue(maxPaddingWidth >= -1);
            this.maxPaddingWidth = maxPaddingWidth;
            return this;
        }

        @Override
        @NotNull
        public OutputSettings clone() {
            return OutputSettings.copy$default(this, null, null, false, false, 0, 0, null, 127, null);
        }

        private final Entities.EscapeMode component1() {
            return this.escapeMode;
        }

        private final Charset component2() {
            return this.charset;
        }

        private final boolean component3() {
            return this.prettyPrint;
        }

        private final boolean component4() {
            return this.outline;
        }

        private final int component5() {
            return this.indentAmount;
        }

        private final int component6() {
            return this.maxPaddingWidth;
        }

        private final Syntax component7() {
            return this.syntax;
        }

        @NotNull
        public final OutputSettings copy(@NotNull Entities.EscapeMode escapeMode, @NotNull Charset charset, boolean prettyPrint, boolean outline, int indentAmount, int maxPaddingWidth, @NotNull Syntax syntax) {
            Intrinsics.checkNotNullParameter((Object)((Object)escapeMode), (String)"escapeMode");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            Intrinsics.checkNotNullParameter((Object)((Object)syntax), (String)"syntax");
            return new OutputSettings(escapeMode, charset, prettyPrint, outline, indentAmount, maxPaddingWidth, syntax);
        }

        public static /* synthetic */ OutputSettings copy$default(OutputSettings outputSettings, Entities.EscapeMode escapeMode, Charset charset, boolean bl, boolean bl2, int n, int n2, Syntax syntax, int n3, Object object) {
            if ((n3 & 1) != 0) {
                escapeMode = outputSettings.escapeMode;
            }
            if ((n3 & 2) != 0) {
                charset = outputSettings.charset;
            }
            if ((n3 & 4) != 0) {
                bl = outputSettings.prettyPrint;
            }
            if ((n3 & 8) != 0) {
                bl2 = outputSettings.outline;
            }
            if ((n3 & 0x10) != 0) {
                n = outputSettings.indentAmount;
            }
            if ((n3 & 0x20) != 0) {
                n2 = outputSettings.maxPaddingWidth;
            }
            if ((n3 & 0x40) != 0) {
                syntax = outputSettings.syntax;
            }
            return outputSettings.copy(escapeMode, charset, bl, bl2, n, n2, syntax);
        }

        @NotNull
        public String toString() {
            return "OutputSettings(escapeMode=" + this.escapeMode + ", charset=" + this.charset + ", prettyPrint=" + this.prettyPrint + ", outline=" + this.outline + ", indentAmount=" + this.indentAmount + ", maxPaddingWidth=" + this.maxPaddingWidth + ", syntax=" + this.syntax + ")";
        }

        public int hashCode() {
            int result = this.escapeMode.hashCode();
            result = result * 31 + this.charset.hashCode();
            result = result * 31 + Boolean.hashCode(this.prettyPrint);
            result = result * 31 + Boolean.hashCode(this.outline);
            result = result * 31 + Integer.hashCode(this.indentAmount);
            result = result * 31 + Integer.hashCode(this.maxPaddingWidth);
            result = result * 31 + this.syntax.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OutputSettings)) {
                return false;
            }
            OutputSettings outputSettings = (OutputSettings)other;
            if (this.escapeMode != outputSettings.escapeMode) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.charset, (Object)outputSettings.charset)) {
                return false;
            }
            if (this.prettyPrint != outputSettings.prettyPrint) {
                return false;
            }
            if (this.outline != outputSettings.outline) {
                return false;
            }
            if (this.indentAmount != outputSettings.indentAmount) {
                return false;
            }
            if (this.maxPaddingWidth != outputSettings.maxPaddingWidth) {
                return false;
            }
            return this.syntax == outputSettings.syntax;
        }

        public OutputSettings() {
            this(null, null, false, false, 0, 0, null, 127, null);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/fleeksoft/ksoup/nodes/Document$OutputSettings$Syntax;", "", "<init>", "(Ljava/lang/String;I)V", "html", "xml", "ksoup"})
        public static final class Syntax
        extends Enum<Syntax> {
            public static final /* enum */ Syntax html = new Syntax();
            public static final /* enum */ Syntax xml = new Syntax();
            private static final /* synthetic */ Syntax[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static Syntax[] values() {
                return (Syntax[])$VALUES.clone();
            }

            public static Syntax valueOf(String value) {
                return Enum.valueOf(Syntax.class, value);
            }

            @NotNull
            public static EnumEntries<Syntax> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = syntaxArray = new Syntax[]{Syntax.html, Syntax.xml};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/fleeksoft/ksoup/nodes/Document$QuirksMode;", "", "<init>", "(Ljava/lang/String;I)V", "noQuirks", "quirks", "limitedQuirks", "ksoup"})
    public static final class QuirksMode
    extends Enum<QuirksMode> {
        public static final /* enum */ QuirksMode noQuirks = new QuirksMode();
        public static final /* enum */ QuirksMode quirks = new QuirksMode();
        public static final /* enum */ QuirksMode limitedQuirks = new QuirksMode();
        private static final /* synthetic */ QuirksMode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static QuirksMode[] values() {
            return (QuirksMode[])$VALUES.clone();
        }

        public static QuirksMode valueOf(String value) {
            return Enum.valueOf(QuirksMode.class, value);
        }

        @NotNull
        public static EnumEntries<QuirksMode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = quirksModeArray = new QuirksMode[]{QuirksMode.noQuirks, QuirksMode.quirks, QuirksMode.limitedQuirks};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OutputSettings.Syntax.values().length];
            try {
                nArray[OutputSettings.Syntax.html.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OutputSettings.Syntax.xml.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

