/*
 * Decompiled with CFR 0.152.
 */
package com.fleeksoft.ksoup.nodes;

import com.fleeksoft.ksoup.helper.Validate;
import com.fleeksoft.ksoup.internal.QuietAppendable;
import com.fleeksoft.ksoup.internal.StringUtil;
import com.fleeksoft.ksoup.nodes.Attribute;
import com.fleeksoft.ksoup.nodes.Document;
import com.fleeksoft.ksoup.nodes.Range;
import com.fleeksoft.ksoup.parser.ParseSettings;
import com.fleeksoft.ksoup.ported.KCloneable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010%\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010)\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 O2\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0003:\u0002NOB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0007H\u0002J\u000e\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u000eJ\u0010\u0010 \u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u000eH\u0002J\u0011\u0010!\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u000eH\u0086\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00022\b\u0010\u001f\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010#\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u000eJ\u0018\u0010$\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u000e2\b\u0010\u0006\u001a\u0004\u0018\u00010\u000eJ\u001a\u0010%\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u000e2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0015H\u0002J\u0018\u0010&\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u000e2\b\u0010\u0006\u001a\u0004\u0018\u00010\u000eJ\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00150(J\u0006\u0010)\u001a\u00020*J\u0010\u0010'\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001f\u001a\u00020\u000eJ\u0018\u0010'\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u000e2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0015J\u0018\u0010+\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u000e2\b\u0010\u0006\u001a\u0004\u0018\u00010\u000eJ\u0016\u0010&\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020*J\u000e\u0010&\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0002J\u0010\u0010,\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020\u0007H\u0002J\u000e\u0010,\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u000eJ\u000e\u0010.\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u000eJ\u000e\u0010/\u001a\u00020*2\u0006\u0010\u001f\u001a\u00020\u000eJ\u000e\u00100\u001a\u00020*2\u0006\u0010\u001f\u001a\u00020\u000eJ\u000e\u00101\u001a\u00020*2\u0006\u0010\u001f\u001a\u00020\u000eJ\u000e\u00102\u001a\u00020*2\u0006\u0010\u001f\u001a\u00020\u000eJ\u0006\u0010\b\u001a\u00020\u0007J\u0006\u00103\u001a\u00020*J\u000e\u00104\u001a\u00020\u001c2\u0006\u00105\u001a\u00020\u0000J\u000e\u00106\u001a\u0002072\u0006\u0010\u001f\u001a\u00020\u000eJ\u0014\u00108\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u000207\u0018\u00010(J\u0016\u00106\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u00109\u001a\u000207J\u000f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00020;H\u0096\u0002J\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00020=J\u0006\u0010>\u001a\u00020?J\u0006\u0010@\u001a\u00020\u000eJ\u0016\u0010@\u001a\u00020\u001c2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020DJ\b\u0010E\u001a\u00020\u000eH\u0016J\u0013\u0010F\u001a\u00020*2\b\u0010G\u001a\u0004\u0018\u00010\u0015H\u0096\u0002J\b\u0010H\u001a\u00020\u0007H\u0016J\b\u0010I\u001a\u00020\u0000H\u0016J\u0006\u0010J\u001a\u00020\u001cJ\u000e\u0010K\u001a\u00020\u00072\u0006\u0010L\u001a\u00020MR&\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\u0005\u001a\u0004\b\n\u0010\u000bR$\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rX\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0013\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R$\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\rX\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001a\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006P"}, d2={"Lcom/fleeksoft/ksoup/nodes/Attributes;", "", "Lcom/fleeksoft/ksoup/nodes/Attribute;", "Lcom/fleeksoft/ksoup/ported/KCloneable;", "<init>", "()V", "value", "", "size", "getSize$annotations", "getSize", "()I", "keys", "", "", "getKeys$ksoup", "()[Ljava/lang/String;", "setKeys$ksoup", "([Ljava/lang/String;)V", "[Ljava/lang/String;", "vals", "", "getVals$ksoup", "()[Ljava/lang/Object;", "setVals$ksoup", "([Ljava/lang/Object;)V", "[Ljava/lang/Object;", "checkCapacity", "", "minNewSize", "indexOfKey", "key", "indexOfKeyIgnoreCase", "get", "attribute", "getIgnoreCase", "add", "addObject", "put", "userData", "", "hasUserData", "", "putIgnoreCase", "remove", "index", "removeIgnoreCase", "hasKey", "hasKeyIgnoreCase", "hasDeclaredValueForKey", "hasDeclaredValueForKeyIgnoreCase", "isEmpty", "addAll", "incoming", "sourceRange", "Lcom/fleeksoft/ksoup/nodes/Range$AttributeRange;", "getRanges", "range", "iterator", "", "asList", "", "dataset", "Lcom/fleeksoft/ksoup/nodes/Attributes$Dataset;", "html", "accum", "Lcom/fleeksoft/ksoup/internal/QuietAppendable;", "out", "Lcom/fleeksoft/ksoup/nodes/Document$OutputSettings;", "toString", "equals", "other", "hashCode", "clone", "normalize", "deduplicate", "settings", "Lcom/fleeksoft/ksoup/parser/ParseSettings;", "Dataset", "Companion", "ksoup"})
public final class Attributes
implements Iterable<Attribute>,
KCloneable<Attributes>,
KMappedMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int size;
    @NotNull
    private String[] keys = new String[3];
    @NotNull
    private Object[] vals = new Object[3];
    private static final char InternalPrefix = '/';
    @NotNull
    public static final String dataPrefix = "data-";
    @NotNull
    private static final String EmptyString = "";
    private static final int InitialCapacity = 3;
    private static final int GrowthFactor = 2;
    public static final int NotFound = -1;

    public final int getSize() {
        return this.size;
    }

    public static /* synthetic */ void getSize$annotations() {
    }

    @NotNull
    public final String[] getKeys$ksoup() {
        return this.keys;
    }

    public final void setKeys$ksoup(@NotNull String[] stringArray) {
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"<set-?>");
        this.keys = stringArray;
    }

    @NotNull
    public final Object[] getVals$ksoup() {
        return this.vals;
    }

    public final void setVals$ksoup(@NotNull Object[] objectArray) {
        Intrinsics.checkNotNullParameter((Object)objectArray, (String)"<set-?>");
        this.vals = objectArray;
    }

    private final void checkCapacity(int minNewSize) {
        int newCap;
        Validate.INSTANCE.isTrue(minNewSize >= this.size);
        int curCap = this.keys.length;
        if (curCap >= minNewSize) {
            return;
        }
        int n = newCap = curCap >= 3 ? this.size * 2 : 3;
        if (minNewSize > newCap) {
            newCap = minNewSize;
        }
        String[] stringArray = Arrays.copyOf(this.keys, newCap);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"copyOf(...)");
        this.keys = stringArray;
        Object[] objectArray = Arrays.copyOf(this.vals, newCap);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
        this.vals = objectArray;
    }

    public final int indexOfKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (!Intrinsics.areEqual((Object)key, (Object)this.keys[i])) continue;
            return i;
        }
        return -1;
    }

    private final int indexOfKeyIgnoreCase(String key) {
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (!StringsKt.equals((String)key, (String)this.keys[i], (boolean)true)) continue;
            return i;
        }
        return -1;
    }

    @NotNull
    public final String get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        int i = this.indexOfKey(key);
        return i == -1 ? EmptyString : Companion.checkNotNull(this.vals[i]);
    }

    @Nullable
    public final Attribute attribute(@Nullable String key) {
        String string = key;
        Intrinsics.checkNotNull((Object)string);
        int i = this.indexOfKey(string);
        return i == -1 ? null : new Attribute(key, Companion.checkNotNull(this.vals[i]), this);
    }

    @NotNull
    public final String getIgnoreCase(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        int i = this.indexOfKeyIgnoreCase(key);
        return i == -1 ? EmptyString : Companion.checkNotNull(this.vals[i]);
    }

    @NotNull
    public final Attributes add(@NotNull String key, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.addObject(key, value);
        return this;
    }

    private final void addObject(String key, Object value) {
        this.checkCapacity(this.size + 1);
        this.keys[this.size] = key;
        this.vals[this.size] = value;
        int n = this.size;
        this.size = n + 1;
    }

    @NotNull
    public final Attributes put(@NotNull String key, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        int i = this.indexOfKey(key);
        if (i != -1) {
            this.vals[i] = value;
        } else {
            this.addObject(key, value);
        }
        return this;
    }

    @NotNull
    public final Map<String, Object> userData() {
        Map userData = null;
        int i = this.indexOfKey("/ksoup.userdata");
        if (i == -1) {
            userData = new HashMap();
            this.addObject("/ksoup.userdata", userData);
        } else {
            Object object = this.vals[i];
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.Any>");
            userData = TypeIntrinsics.asMutableMap((Object)object);
        }
        return userData;
    }

    public final boolean hasUserData() {
        return this.hasKey("/ksoup.userdata");
    }

    @Nullable
    public final Object userData(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (!this.hasUserData()) {
            return null;
        }
        Map<String, Object> userData = this.userData();
        return userData.get(key);
    }

    @NotNull
    public final Attributes userData(@NotNull String key, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (value == null && !this.hasUserData()) {
            return this;
        }
        Map<String, Object> userData = this.userData();
        Object object = value == null ? userData.remove(key) : userData.put(key, value);
        return this;
    }

    public final void putIgnoreCase(@NotNull String key, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        int i = this.indexOfKeyIgnoreCase(key);
        if (i != -1) {
            this.vals[i] = value;
            String old = this.keys[i];
            if (old != null && !Intrinsics.areEqual((Object)old, (Object)key)) {
                this.keys[i] = key;
            }
        } else {
            this.addObject(key, value);
        }
    }

    @NotNull
    public final Attributes put(@NotNull String key, boolean value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (value) {
            this.putIgnoreCase(key, null);
        } else {
            this.remove(key);
        }
        return this;
    }

    @NotNull
    public final Attributes put(@NotNull Attribute attribute) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        this.put(attribute.getKey(), attribute.getValue());
        attribute.setParent(this);
        return this;
    }

    private final void remove(int index) {
        Validate.INSTANCE.isFalse(index >= this.size);
        int shifted = this.size - index - 1;
        if (shifted > 0) {
            ArraysKt.copyInto((Object[])this.keys, (Object[])this.keys, (int)index, (int)(index + 1), (int)(index + 1 + shifted));
            ArraysKt.copyInto((Object[])this.vals, (Object[])this.vals, (int)index, (int)(index + 1), (int)(index + 1 + shifted));
        }
        int n = this.size;
        this.size = n + -1;
        this.keys[this.size] = null;
        this.vals[this.size] = null;
    }

    public final void remove(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        int i = this.indexOfKey(key);
        if (i != -1) {
            this.remove(i);
        }
    }

    public final void removeIgnoreCase(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        int i = this.indexOfKeyIgnoreCase(key);
        if (i != -1) {
            this.remove(i);
        }
    }

    public final boolean hasKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.indexOfKey(key) != -1;
    }

    public final boolean hasKeyIgnoreCase(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.indexOfKeyIgnoreCase(key) != -1;
    }

    public final boolean hasDeclaredValueForKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        int i = this.indexOfKey(key);
        return i != -1 && this.vals[i] != null;
    }

    public final boolean hasDeclaredValueForKeyIgnoreCase(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        int i = this.indexOfKeyIgnoreCase(key);
        return i != -1 && this.vals[i] != null;
    }

    public final int size() {
        if (this.size == 0) {
            return 0;
        }
        int count = 0;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            String string = this.keys[i];
            Intrinsics.checkNotNull((Object)string);
            if (Companion.isInternalKey(string)) continue;
            ++count;
        }
        return count;
    }

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    public final void addAll(@NotNull Attributes incoming) {
        Intrinsics.checkNotNullParameter((Object)incoming, (String)"incoming");
        int incomingSize = incoming.size();
        if (incomingSize == 0) {
            return;
        }
        this.checkCapacity(this.size + incomingSize);
        boolean needsPut = this.size != 0;
        for (Attribute attr : incoming) {
            if (needsPut) {
                this.put(attr);
                continue;
            }
            this.addObject(attr.getKey(), attr.getValue());
        }
    }

    @NotNull
    public final Range.AttributeRange sourceRange(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (!this.hasKey(key)) {
            return Range.AttributeRange.Companion.getUntrackedAttr();
        }
        Map<String, Range.AttributeRange> map = this.getRanges();
        if (map == null) {
            return Range.AttributeRange.Companion.getUntrackedAttr();
        }
        Map<String, Range.AttributeRange> ranges = map;
        Range.AttributeRange attributeRange = ranges.get(key);
        if (attributeRange == null) {
            attributeRange = Range.AttributeRange.Companion.getUntrackedAttr();
        }
        return attributeRange;
    }

    @Nullable
    public final Map<String, Range.AttributeRange> getRanges() {
        return TypeIntrinsics.asMutableMap((Object)this.userData("ksoup.attrs"));
    }

    @NotNull
    public final Attributes sourceRange(@NotNull String key, @NotNull Range.AttributeRange range) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Map ranges = this.getRanges();
        if (ranges == null) {
            ranges = new LinkedHashMap();
            this.userData("ksoup.attrs", ranges);
        }
        ranges.put((String)key, (Range.AttributeRange)range);
        return this;
    }

    @Override
    @NotNull
    public Iterator<Attribute> iterator() {
        return new Iterator<Attribute>(this){
            private int expectedSize;
            private int i;
            final /* synthetic */ Attributes this$0;
            {
                this.this$0 = $receiver;
                this.expectedSize = $receiver.getSize();
            }

            public final int getExpectedSize() {
                return this.expectedSize;
            }

            public final void setExpectedSize(int n) {
                this.expectedSize = n;
            }

            public final int getI() {
                return this.i;
            }

            public final void setI(int n) {
                this.i = n;
            }

            public boolean hasNext() {
                this.checkModified();
                while (this.i < this.this$0.getSize()) {
                    String key = this.this$0.getKeys$ksoup()[this.i];
                    if (!(key != null)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    if (!Attributes.Companion.isInternalKey(key)) break;
                    int n = this.i;
                    this.i = n + 1;
                }
                return this.i < this.this$0.getSize();
            }

            public Attribute next() {
                this.checkModified();
                if (this.i >= this.this$0.getSize()) {
                    throw new NoSuchElementException();
                }
                String string = this.this$0.getKeys$ksoup()[this.i];
                Intrinsics.checkNotNull((Object)string);
                Attribute attr = new Attribute(string, (String)this.this$0.getVals$ksoup()[this.i], this.this$0);
                int n = this.i;
                this.i = n + 1;
                return attr;
            }

            private final void checkModified() {
                if (this.this$0.getSize() != this.expectedSize) {
                    throw new ConcurrentModificationException("Use Iterator#remove() instead to remove attributes while iterating.");
                }
            }

            public void remove() {
                this.i += -1;
                Attributes.access$remove(this.this$0, this.i);
                int n = this.expectedSize;
                this.expectedSize = n + -1;
            }
        };
    }

    @NotNull
    public final List<Attribute> asList() {
        ArrayList<Attribute> list = new ArrayList<Attribute>(this.size);
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            String key;
            Intrinsics.checkNotNull((Object)this.keys[i]);
            if (Companion.isInternalKey(key)) continue;
            Attribute attr = new Attribute(key, (String)this.vals[i], this);
            list.add(attr);
        }
        return CollectionsKt.toList((Iterable)list);
    }

    @NotNull
    public final Dataset dataset() {
        return new Dataset(this);
    }

    @NotNull
    public final String html() {
        StringBuilder sb = StringUtil.INSTANCE.borrowBuilder();
        this.html(QuietAppendable.Companion.wrap(sb), new Document.OutputSettings(null, null, false, false, 0, 0, null, 127, null));
        return StringUtil.INSTANCE.releaseBuilder(sb);
    }

    public final void html(@NotNull QuietAppendable accum, @NotNull Document.OutputSettings out) {
        Intrinsics.checkNotNullParameter((Object)accum, (String)"accum");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        int sz = this.size;
        for (int i = 0; i < sz; ++i) {
            String validated;
            String key;
            Intrinsics.checkNotNull((Object)this.keys[i]);
            if (Companion.isInternalKey(key) || (validated = Attribute.Companion.getValidKey(key, out.syntax())) == null) continue;
            Attribute.Companion.htmlNoValidate(validated, (String)this.vals[i], accum.append(' '), out);
        }
    }

    @NotNull
    public String toString() {
        return this.html();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Attributes that = (Attributes)other;
        if (this.size != that.size) {
            return false;
        }
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            String key;
            Intrinsics.checkNotNull((Object)this.keys[i]);
            int thatI = that.indexOfKey(key);
            if (thatI != -1 && Intrinsics.areEqual((Object)this.vals[i], (Object)that.vals[thatI])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.size;
        result = 31 * result + this.keys.hashCode();
        result = 31 * result + this.vals.hashCode();
        return result;
    }

    @Override
    @NotNull
    public Attributes clone() {
        Attributes attributes = new Attributes();
        attributes.addAll(this);
        attributes.size = this.size;
        String[] stringArray = Arrays.copyOf(this.keys, this.size);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"copyOf(...)");
        attributes.keys = stringArray;
        Object[] objectArray = Arrays.copyOf(this.vals, this.size);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
        attributes.vals = objectArray;
        int i = this.indexOfKey("/ksoup.userdata");
        if (i != -1) {
            Object object = this.vals[i];
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String?, kotlin.Any?>");
            this.vals[i] = new HashMap(TypeIntrinsics.asMutableMap((Object)object));
        }
        return attributes;
    }

    public final void normalize() {
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            String key;
            Intrinsics.checkNotNull((Object)this.keys[i]);
            if (Companion.isInternalKey(key)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)key.toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
        }
    }

    public final int deduplicate(@NotNull ParseSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        if (this.size == 0) {
            return 0;
        }
        boolean preserve = settings.preserveAttributeCase();
        int dupes = 0;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            String keyI = this.keys[i];
            for (int j = i + 1; j < this.size; ++j) {
                if ((!preserve || !Intrinsics.areEqual((Object)keyI, (Object)this.keys[j])) && (preserve || !StringsKt.equals((String)keyI, (String)this.keys[j], (boolean)true))) continue;
                ++dupes;
                this.remove(j);
                --j;
            }
        }
        return dupes;
    }

    public static final /* synthetic */ void access$remove(Attributes $this, int index) {
        $this.remove(index);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\u000e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/fleeksoft/ksoup/nodes/Attributes$Companion;", "", "<init>", "()V", "InternalPrefix", "", "dataPrefix", "", "EmptyString", "InitialCapacity", "", "GrowthFactor", "NotFound", "checkNotNull", "value", "dataKey", "key", "internalKey", "isInternalKey", "", "ksoup"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String checkNotNull(@Nullable Object value) {
            Object object = value;
            return object == null ? Attributes.EmptyString : (String)object;
        }

        private final String dataKey(String key) {
            return Attributes.dataPrefix + key;
        }

        @NotNull
        public final String internalKey(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return "/" + key;
        }

        public final boolean isInternalKey(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return key.length() > 1 && key.charAt(0) == '/';
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0086\u0002J\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0086\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lcom/fleeksoft/ksoup/nodes/Attributes$Dataset;", "", "attributes", "Lcom/fleeksoft/ksoup/nodes/Attributes;", "<init>", "(Lcom/fleeksoft/ksoup/nodes/Attributes;)V", "size", "", "getSize", "()I", "set", "", "key", "value", "get", "remove", "", "ksoup"})
    @SourceDebugExtension(value={"SMAP\nAttributes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Attributes.kt\ncom/fleeksoft/ksoup/nodes/Attributes$Dataset\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,647:1\n1788#2,4:648\n*S KotlinDebug\n*F\n+ 1 Attributes.kt\ncom/fleeksoft/ksoup/nodes/Attributes$Dataset\n*L\n584#1:648,4\n*E\n"})
    public static final class Dataset {
        @NotNull
        private final Attributes attributes;

        public Dataset(@NotNull Attributes attributes) {
            Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
            this.attributes = attributes;
        }

        /*
         * WARNING - void declaration
         */
        public final int getSize() {
            int n;
            Iterable $this$count$iv = this.attributes;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                void var3_3;
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    Attribute it = (Attribute)element$iv;
                    boolean bl = false;
                    if (!it.isDataAttribute() || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = var3_3;
            }
            return n;
        }

        @Nullable
        public final String set(@NotNull String key, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            String dataKey = Companion.dataKey(key);
            String oldValue = this.attributes.hasKey(dataKey) ? this.attributes.get(dataKey) : null;
            this.attributes.put(dataKey, value);
            return oldValue;
        }

        @Nullable
        public final String get(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            String dataKey = Attributes.dataPrefix + key;
            return dataKey.length() > 5 && this.attributes.hasKey(dataKey) ? this.attributes.get(dataKey) : null;
        }

        public final void remove(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.attributes.remove(Attributes.dataPrefix + key);
        }
    }
}

