/*
 * Decompiled with CFR 0.152.
 */
package com.fleeksoft.ksoup.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0002J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u001a\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\b\b\u0002\u0010\u0010\u001a\u00020\tH\u0002J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u0005H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/fleeksoft/ksoup/internal/URLUtil;", "", "<init>", "()V", "resolve", "", "base", "relative", "isAbsoluteUrl", "", "url", "mergePaths", "basePath", "relativePath", "normalizePath", "path", "addRoot", "stripQueryAndFragment", "parseUrl", "Lcom/fleeksoft/ksoup/internal/URLUtil$ParsedUrl;", "ParsedUrl", "ksoup"})
@SourceDebugExtension(value={"SMAP\nURLUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 URLUtil.kt\ncom/fleeksoft/ksoup/internal/URLUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,181:1\n1#2:182\n1878#3,3:183\n*S KotlinDebug\n*F\n+ 1 URLUtil.kt\ncom/fleeksoft/ksoup/internal/URLUtil\n*L\n87#1:183,3\n*E\n"})
public final class URLUtil {
    @NotNull
    public static final URLUtil INSTANCE = new URLUtil();

    private URLUtil() {
    }

    @NotNull
    public final String resolve(@NotNull String base, @NotNull String relative) {
        String string;
        int queryOrFragmentIndex;
        String string2;
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)relative, (String)"relative");
        if (((CharSequence)relative).length() == 0) {
            return base;
        }
        if (this.isAbsoluteUrl(relative)) {
            return relative;
        }
        if (!this.isAbsoluteUrl(base)) {
            return "";
        }
        ParsedUrl baseUrl = this.parseUrl(base);
        if (StringsKt.startsWith$default((String)relative, (String)"//", (boolean)false, (int)2, null)) {
            return baseUrl.getScheme() + ":" + relative;
        }
        if (StringsKt.startsWith$default((String)relative, (String)"?", (boolean)false, (int)2, null)) {
            return baseUrl.getScheme() + ":" + baseUrl.getSchemeSeparator() + baseUrl.getAuthority() + baseUrl.getPath() + relative;
        }
        if (StringsKt.startsWith$default((String)relative, (String)"#", (boolean)false, (int)2, null)) {
            String string3 = baseUrl.getScheme();
            String string4 = baseUrl.getSchemeSeparator();
            String string5 = baseUrl.getAuthority();
            String string6 = baseUrl.getPath();
            String string7 = baseUrl.getQuery();
            if (string7 == null) {
                string7 = "";
            }
            return string3 + ":" + string4 + string5 + string6 + string7 + relative;
        }
        if (StringsKt.startsWith$default((String)relative, (String)"/", (boolean)false, (int)2, null)) {
            string2 = relative;
        } else {
            String cleanedBasePath = this.stripQueryAndFragment(baseUrl.getPath());
            string2 = this.mergePaths(cleanedBasePath, relative);
        }
        String resolvedPath = string2;
        int relQueryIndex = StringsKt.indexOf$default((CharSequence)resolvedPath, (String)"?", (int)0, (boolean)false, (int)6, null);
        int relFragmentIndex = StringsKt.indexOf$default((CharSequence)resolvedPath, (String)"#", (int)0, (boolean)false, (int)6, null);
        int n = relQueryIndex != -1 && relFragmentIndex != -1 ? Math.min(relQueryIndex, relFragmentIndex) : (queryOrFragmentIndex = relFragmentIndex != -1 ? relFragmentIndex : relQueryIndex);
        if (queryOrFragmentIndex != -1) {
            String string8 = resolvedPath.substring(queryOrFragmentIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"substring(...)");
            String result = string8;
            String string9 = resolvedPath.substring(0, queryOrFragmentIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"substring(...)");
            resolvedPath = string9;
            string = result;
        } else {
            string = null;
        }
        String queryOrFragment = string;
        String it = this.normalizePath(resolvedPath, ((CharSequence)baseUrl.getAuthority()).length() > 0);
        boolean bl = false;
        String string10 = queryOrFragment;
        Object normalizedPath = string10 != null ? it + string10 : it;
        StringBuilder finalUrl = new StringBuilder();
        finalUrl.append(baseUrl.getScheme() + ":" + baseUrl.getSchemeSeparator() + baseUrl.getAuthority() + (String)normalizedPath);
        String string11 = finalUrl.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"toString(...)");
        return string11;
    }

    private final boolean isAbsoluteUrl(String url) {
        return url.length() > 2 && StringsKt.contains$default((CharSequence)url, (CharSequence)":", (boolean)false, (int)2, null);
    }

    private final String mergePaths(String basePath, String relativePath) {
        String string;
        if (StringsKt.endsWith$default((String)basePath, (String)"/", (boolean)false, (int)2, null)) {
            string = basePath;
        } else {
            String string2 = basePath.substring(0, StringsKt.lastIndexOf$default((CharSequence)basePath, (char)'/', (int)0, (boolean)false, (int)6, null) + 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        }
        String baseDir = string;
        return baseDir + relativePath;
    }

    /*
     * WARNING - void declaration
     */
    private final String normalizePath(String path, boolean addRoot) {
        String[] stringArray = new String[]{"/"};
        List segments = CollectionsKt.toMutableList((Collection)StringsKt.split$default((CharSequence)path, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        List result = new ArrayList();
        Iterable $this$forEachIndexed$iv = segments;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void segment;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int index = n;
            boolean bl = false;
            if (((CharSequence)segment).length() == 0 || Intrinsics.areEqual((Object)segment, (Object)".")) {
                if (index != segments.size() - 1) continue;
                result.add("");
                continue;
            }
            if (Intrinsics.areEqual((Object)segment, (Object)"..")) {
                if (!(!((Collection)result).isEmpty())) continue;
                result.remove(result.size() - 1);
                continue;
            }
            result.add(segment);
        }
        return (addRoot ? "/" : "") + CollectionsKt.joinToString$default((Iterable)result, (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
    }

    static /* synthetic */ String normalizePath$default(URLUtil uRLUtil, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return uRLUtil.normalizePath(string, bl);
    }

    private final String stripQueryAndFragment(String path) {
        String string;
        int queryIndex = StringsKt.indexOf$default((CharSequence)path, (char)'?', (int)0, (boolean)false, (int)6, null);
        int fragmentIndex = StringsKt.indexOf$default((CharSequence)path, (char)'#', (int)0, (boolean)false, (int)6, null);
        if (queryIndex != -1) {
            String string2 = path.substring(0, queryIndex);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else if (fragmentIndex != -1) {
            String string3 = path.substring(0, fragmentIndex);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        } else {
            string = path;
        }
        return string;
    }

    private final ParsedUrl parseUrl(String url) {
        String string;
        String fragment;
        String query;
        int fragmentStartIndex;
        String string2;
        String authority;
        int authorityEndIndex;
        String remainingUrl = url;
        String scheme = null;
        String schemeSeparator = null;
        int schemeEndIndex = StringsKt.indexOf$default((CharSequence)url, (String)":", (int)0, (boolean)false, (int)6, null);
        if (schemeEndIndex != -1) {
            schemeSeparator = StringsKt.indexOf$default((CharSequence)url, (String)"://", (int)0, (boolean)false, (int)6, null) != -1 ? "//" : (StringsKt.indexOf$default((CharSequence)url, (String)":/", (int)0, (boolean)false, (int)6, null) != -1 ? "/" : "");
            String string3 = url.substring(0, schemeEndIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            scheme = string3;
            String string4 = url.substring(schemeEndIndex + schemeSeparator.length() + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            remainingUrl = string4;
        } else {
            scheme = "https";
            schemeSeparator = "//";
        }
        if (!Intrinsics.areEqual((Object)schemeSeparator, (Object)"/")) {
            Integer n = StringsKt.indexOf$default((CharSequence)remainingUrl, (char)'/', (int)0, (boolean)false, (int)6, null);
            int it2 = ((Number)n).intValue();
            boolean bl = false;
            Integer n2 = it2 != -1 ? n : null;
            if (n2 != null) {
                v3 = n2;
            } else {
                Integer it2 = StringsKt.indexOf$default((CharSequence)remainingUrl, (char)'?', (int)0, (boolean)false, (int)6, null);
                int it32 = ((Number)it2).intValue();
                boolean bl2 = false;
                Integer n3 = it32 != -1 ? it2 : null;
                if (n3 != null) {
                    v3 = n3;
                } else {
                    Integer it32 = StringsKt.indexOf$default((CharSequence)remainingUrl, (char)'#', (int)0, (boolean)false, (int)6, null);
                    int it4 = ((Number)it32).intValue();
                    boolean bl3 = false;
                    Integer n4 = it4 != -1 ? it32 : null;
                    v3 = n4 != null ? n4.intValue() : remainingUrl.length();
                }
            }
        } else {
            v3 = authorityEndIndex = -1;
        }
        if (authorityEndIndex != -1) {
            String string5 = remainingUrl.substring(0, authorityEndIndex);
            v7 = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
        } else {
            v7 = authority = null;
        }
        if (authorityEndIndex == -1) {
            string2 = remainingUrl;
        } else {
            String string6 = remainingUrl.substring(authorityEndIndex);
            string2 = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
        }
        String pathAndMore = string2;
        Object it4 = new char[]{'?', '#'};
        it4 = StringsKt.indexOfAny$default((CharSequence)pathAndMore, (char[])it4, (int)0, (boolean)false, (int)6, null);
        int it = ((Number)it4).intValue();
        boolean $i$a$-takeIf-URLUtil$parseUrl$pathEndIndex$22 = false;
        Object object = it != -1 ? it4 : null;
        int pathEndIndex = object != null ? ((Integer)object).intValue() : pathAndMore.length();
        String string7 = pathAndMore.substring(0, pathEndIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
        String path = string7;
        Integer $i$a$-takeIf-URLUtil$parseUrl$pathEndIndex$22 = StringsKt.indexOf$default((CharSequence)pathAndMore, (char)'?', (int)0, (boolean)false, (int)6, null);
        int it22 = ((Number)$i$a$-takeIf-URLUtil$parseUrl$pathEndIndex$22).intValue();
        boolean bl = false;
        Integer n = it22 != -1 ? $i$a$-takeIf-URLUtil$parseUrl$pathEndIndex$22 : null;
        int queryStartIndex = n != null ? n.intValue() : pathAndMore.length();
        Integer it22 = StringsKt.indexOf$default((CharSequence)pathAndMore, (char)'#', (int)0, (boolean)false, (int)6, null);
        int it5 = ((Number)it22).intValue();
        boolean bl4 = false;
        Integer n5 = it5 != -1 ? it22 : null;
        int n6 = fragmentStartIndex = n5 != null ? n5.intValue() : pathAndMore.length();
        if (queryStartIndex != pathAndMore.length()) {
            String string8 = pathAndMore.substring(queryStartIndex, fragmentStartIndex);
            v16 = string8;
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"substring(...)");
        } else {
            v16 = query = null;
        }
        if (fragmentStartIndex != pathAndMore.length()) {
            String string9 = pathAndMore.substring(fragmentStartIndex);
            v18 = string9;
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"substring(...)");
        } else {
            v18 = fragment = null;
        }
        if ((string = authority) == null) {
            string = "";
        }
        return new ParsedUrl(scheme, schemeSeparator, string, path, query, fragment);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003JI\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\f\u00a8\u0006\u001f"}, d2={"Lcom/fleeksoft/ksoup/internal/URLUtil$ParsedUrl;", "", "scheme", "", "schemeSeparator", "authority", "path", "query", "fragment", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getScheme", "()Ljava/lang/String;", "getSchemeSeparator", "getAuthority", "getPath", "getQuery", "getFragment", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "ksoup"})
    private static final class ParsedUrl {
        @NotNull
        private final String scheme;
        @NotNull
        private final String schemeSeparator;
        @NotNull
        private final String authority;
        @NotNull
        private final String path;
        @Nullable
        private final String query;
        @Nullable
        private final String fragment;

        public ParsedUrl(@NotNull String scheme, @NotNull String schemeSeparator, @NotNull String authority, @NotNull String path, @Nullable String query, @Nullable String fragment) {
            Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
            Intrinsics.checkNotNullParameter((Object)schemeSeparator, (String)"schemeSeparator");
            Intrinsics.checkNotNullParameter((Object)authority, (String)"authority");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.scheme = scheme;
            this.schemeSeparator = schemeSeparator;
            this.authority = authority;
            this.path = path;
            this.query = query;
            this.fragment = fragment;
        }

        public /* synthetic */ ParsedUrl(String string, String string2, String string3, String string4, String string5, String string6, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                string5 = null;
            }
            if ((n & 0x20) != 0) {
                string6 = null;
            }
            this(string, string2, string3, string4, string5, string6);
        }

        @NotNull
        public final String getScheme() {
            return this.scheme;
        }

        @NotNull
        public final String getSchemeSeparator() {
            return this.schemeSeparator;
        }

        @NotNull
        public final String getAuthority() {
            return this.authority;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @Nullable
        public final String getQuery() {
            return this.query;
        }

        @Nullable
        public final String getFragment() {
            return this.fragment;
        }

        @NotNull
        public final String component1() {
            return this.scheme;
        }

        @NotNull
        public final String component2() {
            return this.schemeSeparator;
        }

        @NotNull
        public final String component3() {
            return this.authority;
        }

        @NotNull
        public final String component4() {
            return this.path;
        }

        @Nullable
        public final String component5() {
            return this.query;
        }

        @Nullable
        public final String component6() {
            return this.fragment;
        }

        @NotNull
        public final ParsedUrl copy(@NotNull String scheme, @NotNull String schemeSeparator, @NotNull String authority, @NotNull String path, @Nullable String query, @Nullable String fragment) {
            Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
            Intrinsics.checkNotNullParameter((Object)schemeSeparator, (String)"schemeSeparator");
            Intrinsics.checkNotNullParameter((Object)authority, (String)"authority");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return new ParsedUrl(scheme, schemeSeparator, authority, path, query, fragment);
        }

        public static /* synthetic */ ParsedUrl copy$default(ParsedUrl parsedUrl, String string, String string2, String string3, String string4, String string5, String string6, int n, Object object) {
            if ((n & 1) != 0) {
                string = parsedUrl.scheme;
            }
            if ((n & 2) != 0) {
                string2 = parsedUrl.schemeSeparator;
            }
            if ((n & 4) != 0) {
                string3 = parsedUrl.authority;
            }
            if ((n & 8) != 0) {
                string4 = parsedUrl.path;
            }
            if ((n & 0x10) != 0) {
                string5 = parsedUrl.query;
            }
            if ((n & 0x20) != 0) {
                string6 = parsedUrl.fragment;
            }
            return parsedUrl.copy(string, string2, string3, string4, string5, string6);
        }

        @NotNull
        public String toString() {
            return "ParsedUrl(scheme=" + this.scheme + ", schemeSeparator=" + this.schemeSeparator + ", authority=" + this.authority + ", path=" + this.path + ", query=" + this.query + ", fragment=" + this.fragment + ")";
        }

        public int hashCode() {
            int result = this.scheme.hashCode();
            result = result * 31 + this.schemeSeparator.hashCode();
            result = result * 31 + this.authority.hashCode();
            result = result * 31 + this.path.hashCode();
            result = result * 31 + (this.query == null ? 0 : this.query.hashCode());
            result = result * 31 + (this.fragment == null ? 0 : this.fragment.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ParsedUrl)) {
                return false;
            }
            ParsedUrl parsedUrl = (ParsedUrl)other;
            if (!Intrinsics.areEqual((Object)this.scheme, (Object)parsedUrl.scheme)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.schemeSeparator, (Object)parsedUrl.schemeSeparator)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.authority, (Object)parsedUrl.authority)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.path, (Object)parsedUrl.path)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.query, (Object)parsedUrl.query)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.fragment, (Object)parsedUrl.fragment);
        }
    }
}

