/*
 * Decompiled with CFR 0.152.
 */
package com.fleeksoft.ksoup.internal;

import com.fleeksoft.ksoup.internal.SoftPool;
import com.fleeksoft.ksoup.internal.URLUtil;
import com.fleeksoft.ksoup.ported.CharacterKt;
import com.fleeksoft.ksoup.ported.CodePoint;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010(\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001;B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\n\u001a\u00020\u00062\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u0006J\u001a\u0010\n\u001a\u00020\u00062\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\r\u001a\u00020\u0006J\u0018\u0010\u0004\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0010J\u0010\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\u0015\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\u0016\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0006J\u000e\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0010J\u000e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0010J\u000e\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0010J\u000e\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006J\"\u0010\u001c\u001a\u00020\u001d2\n\u0010\u001e\u001a\u00060\u001fj\u0002` 2\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u0013J'\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u00062\u0012\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006\u00a2\u0006\u0002\u0010%J#\u0010&\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u00062\u000e\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010%J\u000e\u0010'\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0006J\u0016\u0010(\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u0006J\u0010\u0010-\u001a\u00020\u00062\u0006\u0010.\u001a\u00020\u0006H\u0002J\n\u00103\u001a\u00060\u001fj\u0002` J\u0012\u00104\u001a\u00020\u00062\n\u00105\u001a\u00060\u001fj\u0002` J\u0012\u00106\u001a\u00020\u001d2\n\u00105\u001a\u00060\u001fj\u0002` J\u000e\u00107\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u000208J\u000e\u00109\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u000208J\u000e\u0010:\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u000208R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u00101\u001a\f\u0012\b\u0012\u00060\u001fj\u0002` 02X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/fleeksoft/ksoup/internal/StringUtil;", "", "<init>", "()V", "padding", "", "", "getPadding", "()[Ljava/lang/String;", "[Ljava/lang/String;", "join", "strings", "", "sep", "", "width", "", "maxPaddingWidth", "isBlank", "", "string", "startsWithNewline", "isNumeric", "isWhitespace", "c", "isActuallyWhitespace", "isInvisibleChar", "normaliseWhitespace", "appendNormalisedWhitespace", "", "accum", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "stripLeading", "isIn", "needle", "haystack", "(Ljava/lang/String;[Ljava/lang/String;)Z", "inSorted", "isAscii", "resolve", "baseUrl", "relUrl", "controlChars", "Lkotlin/text/Regex;", "stripControlChars", "input", "InitBuilderSize", "MaxBuilderSize", "BuilderPool", "Lcom/fleeksoft/ksoup/internal/SoftPool;", "borrowBuilder", "releaseBuilder", "sb", "releaseBuilderVoid", "isAsciiLetter", "", "isDigit", "isHexDigit", "StringJoiner", "ksoup"})
@SourceDebugExtension(value={"SMAP\nStringUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringUtil.kt\ncom/fleeksoft/ksoup/internal/StringUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KsoupExt.kt\ncom/fleeksoft/ksoup/ported/KsoupExtKt\n*L\n1#1,343:1\n1#2:344\n4#3,16:345\n*S KotlinDebug\n*F\n+ 1 StringUtil.kt\ncom/fleeksoft/ksoup/internal/StringUtil\n*L\n211#1:345,16\n*E\n"})
public final class StringUtil {
    @NotNull
    public static final StringUtil INSTANCE = new StringUtil();
    @NotNull
    private static final String[] padding;
    @NotNull
    private static final Regex controlChars;
    private static final int InitBuilderSize = 1024;
    private static final int MaxBuilderSize = 8192;
    @NotNull
    private static final SoftPool<StringBuilder> BuilderPool;

    private StringUtil() {
    }

    @NotNull
    public final String[] getPadding() {
        return padding;
    }

    @NotNull
    public final String join(@NotNull Collection<?> strings, @NotNull String sep) {
        Intrinsics.checkNotNullParameter(strings, (String)"strings");
        Intrinsics.checkNotNullParameter((Object)sep, (String)"sep");
        return this.join(strings.iterator(), sep);
    }

    @NotNull
    public final String join(@NotNull Iterator<?> strings, @NotNull String sep) {
        Intrinsics.checkNotNullParameter(strings, (String)"strings");
        Intrinsics.checkNotNullParameter((Object)sep, (String)"sep");
        if (!strings.hasNext()) {
            return "";
        }
        String start = String.valueOf(strings.next());
        if (!strings.hasNext()) {
            return start;
        }
        StringJoiner j = new StringJoiner(sep);
        j.add(start);
        while (strings.hasNext()) {
            j.add(strings.next());
        }
        return j.complete();
    }

    @NotNull
    public final String padding(int width, int maxPaddingWidth) {
        if (!(width >= 0)) {
            boolean bl = false;
            String string = "width must be >= 0";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(maxPaddingWidth >= -1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int effectiveWidth = maxPaddingWidth != -1 ? Math.min(width, maxPaddingWidth) : width;
        return effectiveWidth < padding.length ? padding[effectiveWidth] : StringsKt.repeat((CharSequence)" ", (int)effectiveWidth);
    }

    public static /* synthetic */ String padding$default(StringUtil stringUtil, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 30;
        }
        return stringUtil.padding(n, n2);
    }

    public final boolean isBlank(@Nullable String string) {
        CharSequence charSequence = string;
        if (charSequence == null || charSequence.length() == 0) {
            return true;
        }
        int l = string.length();
        for (int i = 0; i < l; ++i) {
            if (this.isWhitespace(CharacterKt.codePointValueAt(string, i))) continue;
            return false;
        }
        return true;
    }

    public final boolean startsWithNewline(@Nullable String string) {
        CharSequence charSequence = string;
        return charSequence == null || charSequence.length() == 0 ? false : string.charAt(0) == '\n';
    }

    public final boolean isNumeric(@Nullable String string) {
        CharSequence charSequence = string;
        if (charSequence == null || charSequence.length() == 0) {
            return false;
        }
        int l = string.length();
        for (int i = 0; i < l; ++i) {
            if (this.isDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public final boolean isWhitespace(int c) {
        return c == 32 || c == 9 || c == 10 || c == 12 || c == 13;
    }

    public final boolean isActuallyWhitespace(int c) {
        return c == 32 || c == 9 || c == 10 || c == 12 || c == 13 || c == 160;
    }

    public final boolean isInvisibleChar(int c) {
        return c == 8203 || c == 173;
    }

    @NotNull
    public final String normaliseWhitespace(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        StringBuilder sb = this.borrowBuilder();
        this.appendNormalisedWhitespace(sb, string, false);
        return this.releaseBuilder(sb);
    }

    public final void appendNormalisedWhitespace(@NotNull StringBuilder accum, @NotNull String string, boolean stripLeading) {
        Intrinsics.checkNotNullParameter((Object)accum, (String)"accum");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        boolean lastWasWhite = false;
        boolean reachedNonWhite = false;
        int len = string.length();
        CodePoint c = null;
        int i = 0;
        while (i < len) {
            c = CharacterKt.codePointAt(string, i);
            if (this.isActuallyWhitespace(c.getValue())) {
                if (stripLeading && !reachedNonWhite || lastWasWhite) {
                    i += c.getCharCount();
                    continue;
                }
                accum.append(' ');
                lastWasWhite = true;
            } else if (!this.isInvisibleChar(c.getValue())) {
                accum.appendCodePoint(c.getValue());
                lastWasWhite = false;
                reachedNonWhite = true;
            }
            i += c.getCharCount();
        }
    }

    public final boolean isIn(@NotNull String needle, String ... haystack) {
        Intrinsics.checkNotNullParameter((Object)needle, (String)"needle");
        Intrinsics.checkNotNullParameter((Object)haystack, (String)"haystack");
        int len = haystack.length;
        for (int i = 0; i < len; ++i) {
            if (!Intrinsics.areEqual((Object)haystack[i], (Object)needle)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean inSorted(@NotNull String needle, @NotNull String[] haystack) {
        int n;
        block3: {
            void $this$binarySearch$iv;
            Intrinsics.checkNotNullParameter((Object)needle, (String)"needle");
            Intrinsics.checkNotNullParameter((Object)haystack, (String)"haystack");
            Comparable[] comparableArray = (Comparable[])haystack;
            Comparable element$iv = (Comparable)((Object)needle);
            boolean $i$f$binarySearch = false;
            int low$iv = 0;
            int high$iv = ((void)$this$binarySearch$iv).length - 1;
            while (low$iv <= high$iv) {
                int mid$iv = low$iv + high$iv >>> 1;
                void midVal$iv = $this$binarySearch$iv[mid$iv];
                int cmp$iv = ComparisonsKt.compareValues((Comparable)midVal$iv, (Comparable)element$iv);
                if (cmp$iv < 0) {
                    low$iv = mid$iv + 1;
                    continue;
                }
                if (cmp$iv > 0) {
                    high$iv = mid$iv - 1;
                    continue;
                }
                n = mid$iv;
                break block3;
            }
            n = -(low$iv + 1);
        }
        return n >= 0;
    }

    public final boolean isAscii(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char element = string.charAt(i);
            char c = element;
            if (c <= '\u007f') continue;
            return false;
        }
        return true;
    }

    @NotNull
    public final String resolve(@NotNull String baseUrl, @NotNull String relUrl) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)relUrl, (String)"relUrl");
        String cleanedBaseUrl = this.stripControlChars(baseUrl);
        String cleanedRelUrl = this.stripControlChars(relUrl);
        return URLUtil.INSTANCE.resolve(cleanedBaseUrl, cleanedRelUrl);
    }

    private final String stripControlChars(String input) {
        CharSequence charSequence = input;
        Regex regex = controlChars;
        String string = "";
        return regex.replace(charSequence, string);
    }

    @NotNull
    public final StringBuilder borrowBuilder() {
        return BuilderPool.borrow();
    }

    @NotNull
    public final String releaseBuilder(@NotNull StringBuilder sb) {
        Intrinsics.checkNotNullParameter((Object)sb, (String)"sb");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String str = string;
        this.releaseBuilderVoid(sb);
        return str;
    }

    public final void releaseBuilderVoid(@NotNull StringBuilder sb) {
        Intrinsics.checkNotNullParameter((Object)sb, (String)"sb");
        if (sb.length() <= 8192) {
            Intrinsics.checkNotNullExpressionValue((Object)sb.delete(0, sb.length()), (String)"delete(...)");
            BuilderPool.release(sb);
        }
    }

    public final boolean isAsciiLetter(char c) {
        return Intrinsics.compare((int)c, (int)97) >= 0 && Intrinsics.compare((int)c, (int)122) <= 0 || Intrinsics.compare((int)c, (int)65) >= 0 && Intrinsics.compare((int)c, (int)90) <= 0;
    }

    public final boolean isDigit(char c) {
        return Intrinsics.compare((int)c, (int)48) >= 0 && Intrinsics.compare((int)c, (int)57) <= 0;
    }

    public final boolean isHexDigit(char c) {
        return this.isDigit(c) || Intrinsics.compare((int)c, (int)97) >= 0 && Intrinsics.compare((int)c, (int)102) <= 0 || Intrinsics.compare((int)c, (int)65) >= 0 && Intrinsics.compare((int)c, (int)70) <= 0;
    }

    private static final StringBuilder BuilderPool$lambda$1() {
        return new StringBuilder(1024);
    }

    static {
        String[] stringArray = new String[]{"", " ", "  ", "   ", "    ", "     ", "      ", "       ", "        ", "         ", "          ", "           ", "            ", "             ", "              ", "               ", "                ", "                 ", "                  ", "                   ", "                    "};
        padding = stringArray;
        controlChars = new Regex("[\\x00-\\x1f]*");
        BuilderPool = new SoftPool(StringUtil::BuilderPool$lambda$1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\u00002\b\u0010\f\u001a\u0004\u0018\u00010\u0001J\u0010\u0010\r\u001a\u00020\u00002\b\u0010\f\u001a\u0004\u0018\u00010\u0001J\u0006\u0010\u000e\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/fleeksoft/ksoup/internal/StringUtil$StringJoiner;", "", "separator", "", "<init>", "(Ljava/lang/String;)V", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "first", "", "add", "stringy", "append", "complete", "ksoup"})
    @SourceDebugExtension(value={"SMAP\nStringUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringUtil.kt\ncom/fleeksoft/ksoup/internal/StringUtil$StringJoiner\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,343:1\n1#2:344\n*E\n"})
    public static final class StringJoiner {
        @NotNull
        private final String separator;
        @Nullable
        private StringBuilder sb;
        private boolean first;

        public StringJoiner(@NotNull String separator) {
            Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
            this.separator = separator;
            this.sb = INSTANCE.borrowBuilder();
            this.first = true;
        }

        @NotNull
        public final StringJoiner add(@Nullable Object stringy) {
            if (!this.first) {
                StringBuilder stringBuilder = this.sb;
                Intrinsics.checkNotNull((Object)stringBuilder);
                stringBuilder.append(this.separator);
            }
            StringBuilder stringBuilder = this.sb;
            Intrinsics.checkNotNull((Object)stringBuilder);
            stringBuilder.append(stringy);
            this.first = false;
            return this;
        }

        @NotNull
        public final StringJoiner append(@Nullable Object stringy) {
            StringBuilder stringBuilder = this.sb;
            Intrinsics.checkNotNull((Object)stringBuilder);
            stringBuilder.append(stringy);
            return this;
        }

        @NotNull
        public final String complete() {
            String string;
            StringBuilder stringBuilder = this.sb;
            if (stringBuilder != null) {
                StringBuilder it = stringBuilder;
                boolean bl = false;
                string = INSTANCE.releaseBuilder(it);
            } else {
                string = null;
            }
            String string2 = string;
            this.sb = null;
            String string3 = string2;
            if (string3 == null) {
                string3 = "";
            }
            return string3;
        }
    }
}

