/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.plugins.compression;

import io.ktor.http.ContentType;
import io.ktor.http.HttpHeaders;
import io.ktor.http.content.OutgoingContent;
import io.ktor.server.application.ApplicationCall;
import io.ktor.server.plugins.compression.CompressionConfig;
import io.ktor.server.plugins.compression.CompressionEncoderBuilder;
import io.ktor.server.plugins.compression.ConditionsHolderBuilder;
import io.ktor.util.ContentEncoder;
import io.ktor.util.DeflateEncoder;
import io.ktor.util.GZipEncoder;
import io.ktor.util.IdentityEncoder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a,\u0010\u0006\u001a\u00020\u0003*\u00020\u00002\u0019\b\u0002\u0010\u0005\u001a\u0013\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a,\u0010\b\u001a\u00020\u0003*\u00020\u00002\u0019\b\u0002\u0010\u0005\u001a\u0013\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0004\b\b\u0010\u0007\u001a,\u0010\t\u001a\u00020\u0003*\u00020\u00002\u0019\b\u0002\u0010\u0005\u001a\u0013\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0004\b\t\u0010\u0007\u001a0\u0010\u0010\u001a\u00020\u0003*\u00020\n2\u001d\u0010\u000f\u001a\u0019\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u000b\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0011\u001a\u0019\u0010\u0014\u001a\u00020\u0003*\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015\u001a%\u0010\u0019\u001a\u00020\u0003*\u00020\n2\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0016\"\u00020\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001a\u001a%\u0010\u001b\u001a\u00020\u0003*\u00020\n2\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0016\"\u00020\u0017\u00a2\u0006\u0004\b\u001b\u0010\u001a\u001a\u0013\u0010\u001c\u001a\u00020\u0003*\u00020\nH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lio/ktor/server/plugins/compression/CompressionConfig;", "Lkotlin/Function1;", "Lio/ktor/server/plugins/compression/CompressionEncoderBuilder;", "", "Lkotlin/ExtensionFunctionType;", "block", "gzip", "(Lio/ktor/server/plugins/compression/CompressionConfig;Lkotlin/jvm/functions/Function1;)V", "deflate", "identity", "Lio/ktor/server/plugins/compression/ConditionsHolderBuilder;", "Lkotlin/Function2;", "Lio/ktor/server/application/ApplicationCall;", "Lio/ktor/http/content/OutgoingContent;", "", "predicate", "condition", "(Lio/ktor/server/plugins/compression/ConditionsHolderBuilder;Lkotlin/jvm/functions/Function2;)V", "", "minSize", "minimumSize", "(Lio/ktor/server/plugins/compression/ConditionsHolderBuilder;J)V", "", "Lio/ktor/http/ContentType;", "mimeTypes", "matchContentType", "(Lio/ktor/server/plugins/compression/ConditionsHolderBuilder;[Lio/ktor/http/ContentType;)V", "excludeContentType", "defaultConditions", "(Lio/ktor/server/plugins/compression/ConditionsHolderBuilder;)V", "ktor-server-compression"})
@SourceDebugExtension(value={"SMAP\nConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Config.kt\nio/ktor/server/plugins/compression/ConfigKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,266:1\n1#2:267\n12637#3,2:268\n19652#3,2:270\n*S KotlinDebug\n*F\n+ 1 Config.kt\nio/ktor/server/plugins/compression/ConfigKt\n*L\n230#1:268,2\n247#1:270,2\n*E\n"})
public final class ConfigKt {
    public static final void gzip(@NotNull CompressionConfig $this$gzip, @NotNull Function1<? super CompressionEncoderBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$gzip, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        $this$gzip.encoder((ContentEncoder)GZipEncoder.INSTANCE, block);
    }

    public static /* synthetic */ void gzip$default(CompressionConfig compressionConfig, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = ConfigKt::gzip$lambda$0;
        }
        ConfigKt.gzip(compressionConfig, (Function1<? super CompressionEncoderBuilder, Unit>)function1);
    }

    public static final void deflate(@NotNull CompressionConfig $this$deflate, @NotNull Function1<? super CompressionEncoderBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$deflate, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        $this$deflate.encoder((ContentEncoder)DeflateEncoder.INSTANCE, (Function1<? super CompressionEncoderBuilder, Unit>)((Function1)arg_0 -> ConfigKt.deflate$lambda$2(block, arg_0)));
    }

    public static /* synthetic */ void deflate$default(CompressionConfig compressionConfig, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = ConfigKt::deflate$lambda$1;
        }
        ConfigKt.deflate(compressionConfig, (Function1<? super CompressionEncoderBuilder, Unit>)function1);
    }

    public static final void identity(@NotNull CompressionConfig $this$identity, @NotNull Function1<? super CompressionEncoderBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$identity, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        $this$identity.encoder((ContentEncoder)IdentityEncoder.INSTANCE, block);
    }

    public static /* synthetic */ void identity$default(CompressionConfig compressionConfig, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = ConfigKt::identity$lambda$3;
        }
        ConfigKt.identity(compressionConfig, (Function1<? super CompressionEncoderBuilder, Unit>)function1);
    }

    public static final void condition(@NotNull ConditionsHolderBuilder $this$condition, @NotNull Function2<? super ApplicationCall, ? super OutgoingContent, Boolean> predicate) {
        Intrinsics.checkNotNullParameter((Object)$this$condition, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        $this$condition.getConditions().add(predicate);
    }

    public static final void minimumSize(@NotNull ConditionsHolderBuilder $this$minimumSize, long minSize) {
        Intrinsics.checkNotNullParameter((Object)$this$minimumSize, (String)"<this>");
        ConfigKt.condition($this$minimumSize, (Function2<? super ApplicationCall, ? super OutgoingContent, Boolean>)((Function2)(arg_0, arg_1) -> ConfigKt.minimumSize$lambda$5(minSize, arg_0, arg_1)));
    }

    public static final void matchContentType(@NotNull ConditionsHolderBuilder $this$matchContentType, ContentType ... mimeTypes) {
        Intrinsics.checkNotNullParameter((Object)$this$matchContentType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)mimeTypes, (String)"mimeTypes");
        ConfigKt.condition($this$matchContentType, (Function2<? super ApplicationCall, ? super OutgoingContent, Boolean>)((Function2)(arg_0, arg_1) -> ConfigKt.matchContentType$lambda$7(mimeTypes, arg_0, arg_1)));
    }

    public static final void excludeContentType(@NotNull ConditionsHolderBuilder $this$excludeContentType, ContentType ... mimeTypes) {
        Intrinsics.checkNotNullParameter((Object)$this$excludeContentType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)mimeTypes, (String)"mimeTypes");
        ConfigKt.condition($this$excludeContentType, (Function2<? super ApplicationCall, ? super OutgoingContent, Boolean>)((Function2)(arg_0, arg_1) -> ConfigKt.excludeContentType$lambda$10(mimeTypes, arg_0, arg_1)));
    }

    private static final void defaultConditions(ConditionsHolderBuilder $this$defaultConditions) {
        ContentType[] contentTypeArray = new ContentType[]{ContentType.Video.INSTANCE.getAny(), ContentType.Image.INSTANCE.getJPEG(), ContentType.Image.INSTANCE.getPNG(), ContentType.Audio.INSTANCE.getAny(), ContentType.MultiPart.INSTANCE.getAny(), ContentType.Text.INSTANCE.getEventStream()};
        ConfigKt.excludeContentType($this$defaultConditions, contentTypeArray);
        ConfigKt.minimumSize($this$defaultConditions, 200L);
    }

    private static final Unit gzip$lambda$0(CompressionEncoderBuilder compressionEncoderBuilder) {
        Intrinsics.checkNotNullParameter((Object)compressionEncoderBuilder, (String)"<this>");
        return Unit.INSTANCE;
    }

    private static final Unit deflate$lambda$1(CompressionEncoderBuilder compressionEncoderBuilder) {
        Intrinsics.checkNotNullParameter((Object)compressionEncoderBuilder, (String)"<this>");
        return Unit.INSTANCE;
    }

    private static final Unit deflate$lambda$2(Function1 $block, CompressionEncoderBuilder $this$encoder) {
        Intrinsics.checkNotNullParameter((Object)$this$encoder, (String)"$this$encoder");
        $this$encoder.setPriority(0.9);
        $block.invoke((Object)$this$encoder);
        return Unit.INSTANCE;
    }

    private static final Unit identity$lambda$3(CompressionEncoderBuilder compressionEncoderBuilder) {
        Intrinsics.checkNotNullParameter((Object)compressionEncoderBuilder, (String)"<this>");
        return Unit.INSTANCE;
    }

    private static final boolean minimumSize$lambda$5(long $minSize, ApplicationCall $this$condition, OutgoingContent content) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$condition, (String)"$this$condition");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Long l = content.getContentLength();
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl2 = false;
            bl = it >= $minSize;
        } else {
            bl = true;
        }
        return bl;
    }

    private static final boolean matchContentType$lambda$7(ContentType[] $mimeTypes, ApplicationCall $this$condition, OutgoingContent content) {
        boolean bl;
        block2: {
            Intrinsics.checkNotNullParameter((Object)$this$condition, (String)"$this$condition");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            ContentType contentType = content.getContentType();
            if (contentType == null) {
                return false;
            }
            ContentType contentType2 = contentType;
            ContentType[] $this$any$iv = $mimeTypes;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                ContentType element$iv;
                ContentType it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!contentType2.match(it)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    private static final boolean excludeContentType$lambda$10(ContentType[] $mimeTypes, ApplicationCall $this$condition, OutgoingContent content) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)$this$condition, (String)"$this$condition");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            ContentType contentType = content.getContentType();
            if (contentType == null) {
                ContentType contentType2;
                String string = $this$condition.getResponse().getHeaders().get(HttpHeaders.INSTANCE.getContentType());
                if (string != null) {
                    String it = string;
                    boolean bl2 = false;
                    contentType2 = ContentType.Companion.parse(it);
                } else {
                    contentType2 = contentType = null;
                }
                if (contentType2 == null) {
                    return true;
                }
            }
            ContentType contentType3 = contentType;
            ContentType[] $this$none$iv = $mimeTypes;
            boolean $i$f$none = false;
            int n = $this$none$iv.length;
            for (int i = 0; i < n; ++i) {
                ContentType element$iv;
                ContentType excludePattern = element$iv = $this$none$iv[i];
                boolean bl3 = false;
                if (!contentType3.match(excludePattern)) continue;
                bl = false;
                break block5;
            }
            bl = true;
        }
        return bl;
    }

    public static final /* synthetic */ void access$defaultConditions(ConditionsHolderBuilder $receiver) {
        ConfigKt.defaultConditions($receiver);
    }
}

