/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.plugins.compression;

import io.ktor.http.ContentType;
import io.ktor.http.HeaderValue;
import io.ktor.http.HttpHeaderValueParserKt;
import io.ktor.http.HttpHeaders;
import io.ktor.http.content.CompressedContentKt;
import io.ktor.http.content.OutgoingContent;
import io.ktor.server.application.ApplicationCall;
import io.ktor.server.application.CreatePluginUtilsKt;
import io.ktor.server.application.Hook;
import io.ktor.server.application.OnCallReceiveContext;
import io.ktor.server.application.PipelineCall;
import io.ktor.server.application.RouteScopedPlugin;
import io.ktor.server.application.RouteScopedPluginBuilder;
import io.ktor.server.application.TransformBodyContext;
import io.ktor.server.http.content.SuppressionAttributeKt;
import io.ktor.server.plugins.compression.CompressionConfig;
import io.ktor.server.plugins.compression.CompressionEncoderConfig;
import io.ktor.server.plugins.compression.CompressionKt;
import io.ktor.server.plugins.compression.CompressionOptions;
import io.ktor.server.plugins.compression.ContentEncoding;
import io.ktor.server.request.ApplicationRequest;
import io.ktor.server.request.ApplicationRequestPropertiesKt;
import io.ktor.server.response.PipelineResponse;
import io.ktor.util.AttributeKey;
import io.ktor.util.ContentEncoder;
import io.ktor.util.Encoder;
import io.ktor.util.logging.KtorSimpleLoggerJvmKt;
import io.ktor.util.reflect.TypeInfo;
import io.ktor.utils.io.ByteReadChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a*\u0010\u0007\u001a\u00020\u0006*\b\u0012\u0004\u0012\u00020\u00010\u00002\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0082@\u00a2\u0006\u0004\b\u0007\u0010\b\u001a#\u0010\n\u001a\u00020\u0006*\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\n\u0010\u000b\u001a\u0013\u0010\u000e\u001a\u00020\r*\u00020\fH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000f\"\u001b\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\"&\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u00168\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a\"\u001e\u0010\u001d\u001a\u00060\u001bj\u0002`\u001c8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 \"\u0014\u0010\"\u001a\u00020!8\u0000X\u0080T\u00a2\u0006\u0006\n\u0004\b\"\u0010#\"\u001d\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00010$8\u0006\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(\u00a8\u0006)"}, d2={"Lio/ktor/server/application/OnCallReceiveContext;", "Lio/ktor/server/plugins/compression/CompressionConfig;", "Lio/ktor/server/application/PipelineCall;", "call", "Lio/ktor/server/plugins/compression/CompressionOptions;", "options", "", "decode", "(Lio/ktor/server/application/OnCallReceiveContext;Lio/ktor/server/application/PipelineCall;Lio/ktor/server/plugins/compression/CompressionOptions;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lio/ktor/server/plugins/compression/ContentEncoding$Context;", "encode", "(Lio/ktor/server/plugins/compression/ContentEncoding$Context;Lio/ktor/server/application/PipelineCall;Lio/ktor/server/plugins/compression/CompressionOptions;)V", "Lio/ktor/server/response/PipelineResponse;", "", "isSSEResponse", "(Lio/ktor/server/response/PipelineResponse;)Z", "Lio/ktor/server/request/ApplicationRequest;", "", "", "getAppliedDecoders", "(Lio/ktor/server/request/ApplicationRequest;)Ljava/util/List;", "appliedDecoders", "Lio/ktor/util/AttributeKey;", "DecompressionListAttribute", "Lio/ktor/util/AttributeKey;", "getDecompressionListAttribute", "()Lio/ktor/util/AttributeKey;", "Lorg/slf4j/Logger;", "Lio/ktor/util/logging/Logger;", "LOGGER", "Lorg/slf4j/Logger;", "getLOGGER", "()Lorg/slf4j/Logger;", "", "DEFAULT_MINIMAL_COMPRESSION_SIZE", "J", "Lio/ktor/server/application/RouteScopedPlugin;", "Compression", "Lio/ktor/server/application/RouteScopedPlugin;", "getCompression", "()Lio/ktor/server/application/RouteScopedPlugin;", "ktor-server-compression"})
@SourceDebugExtension(value={"SMAP\nCompression.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Compression.kt\nio/ktor/server/plugins/compression/CompressionKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Attributes.kt\nio/ktor/util/AttributesKt\n+ 5 Type.kt\nio/ktor/util/reflect/TypeKt\n*L\n1#1,182:1\n1617#2,9:183\n1869#2:192\n1870#2:194\n1626#2:195\n1563#2:196\n1634#2,3:197\n1563#2:200\n1634#2,3:201\n774#2:204\n865#2,2:205\n1374#2:207\n1460#2,2:208\n1563#2:210\n1634#2,3:211\n1462#2,3:215\n1563#2:218\n1634#2,3:219\n1761#2,3:222\n295#2:225\n1740#2,3:226\n296#2:229\n1#3:193\n1#3:214\n21#4:230\n69#5:231\n84#5,8:232\n*S KotlinDebug\n*F\n+ 1 Compression.kt\nio/ktor/server/plugins/compression/CompressionKt\n*L\n92#1:183,9\n92#1:192\n92#1:194\n92#1:195\n97#1:196\n97#1:197,3\n99#1:200\n99#1:201,3\n139#1:204\n139#1:205,2\n140#1:207\n140#1:208,2\n142#1:210\n142#1:211,3\n140#1:215,3\n147#1:218\n147#1:219,3\n155#1:222,3\n166#1:225\n166#1:226,3\n166#1:229\n92#1:193\n25#1:230\n25#1:231\n25#1:232,8\n*E\n"})
public final class CompressionKt {
    @NotNull
    private static final AttributeKey<List<String>> DecompressionListAttribute;
    @NotNull
    private static final Logger LOGGER;
    public static final long DEFAULT_MINIMAL_COMPRESSION_SIZE = 200L;
    @NotNull
    private static final RouteScopedPlugin<CompressionConfig> Compression;

    @NotNull
    public static final List<String> getAppliedDecoders(@NotNull ApplicationRequest $this$appliedDecoders) {
        Intrinsics.checkNotNullParameter((Object)$this$appliedDecoders, (String)"<this>");
        List list = (List)$this$appliedDecoders.getCall().getAttributes().getOrNull(DecompressionListAttribute);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public static final AttributeKey<List<String>> getDecompressionListAttribute() {
        return DecompressionListAttribute;
    }

    @NotNull
    public static final Logger getLOGGER() {
        return LOGGER;
    }

    @NotNull
    public static final RouteScopedPlugin<CompressionConfig> getCompression() {
        return Compression;
    }

    /*
     * WARNING - void declaration
     */
    private static final Object decode(OnCallReceiveContext<CompressionConfig> $this$decode, PipelineCall call, CompressionOptions options, Continuation<? super Unit> $completion) {
        Collection collection;
        void $this$mapTo$iv$iv;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        String encodingRaw = call.getRequest().getHeaders().get(HttpHeaders.INSTANCE.getContentEncoding());
        if (SuppressionAttributeKt.isDecompressionSuppressed((ApplicationCall)((ApplicationCall)call))) {
            LOGGER.trace("Skip decompression for " + ApplicationRequestPropertiesKt.getUri((ApplicationRequest)((ApplicationRequest)call.getRequest())) + " because it is suppressed.");
            return Unit.INSTANCE;
        }
        if (encodingRaw == null) {
            LOGGER.trace("Skip decompression for " + ApplicationRequestPropertiesKt.getUri((ApplicationRequest)((ApplicationRequest)call.getRequest())) + " because no content encoding provided.");
            return Unit.INSTANCE;
        }
        List encoding = HttpHeaderValueParserKt.parseHeaderValue((String)encodingRaw);
        Iterable $this$mapNotNull$iv = encoding;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable<CompressionEncoderConfig> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            CompressionEncoderConfig it$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            HeaderValue it = (HeaderValue)element$iv$iv;
            boolean bl2 = false;
            if (options.getEncoders().get(it.getValue()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List encoders = (List)destination$iv$iv;
        if (encoders.isEmpty()) {
            LOGGER.trace("Skip decompression for " + ApplicationRequestPropertiesKt.getUri((ApplicationRequest)((ApplicationRequest)call.getRequest())) + " because no suitable encoders found.");
            return Unit.INSTANCE;
        }
        Iterable $this$map$iv = encoders;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            element$iv$iv$iv = (CompressionEncoderConfig)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(it.getEncoder().getName());
        }
        List encoderNames = (List)destination$iv$iv2;
        if (encoding.size() > encoders.size()) {
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv2 = encoding;
            boolean $i$f$map2 = false;
            destination$iv$iv2 = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                HeaderValue bl = (HeaderValue)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl4 = false;
                collection.add(it.getValue());
            }
            List missingEncoders = CollectionsKt.minus((Iterable)((List)destination$iv$iv3), (Iterable)CollectionsKt.toSet((Iterable)encoderNames));
            call.getRequest().setHeader(HttpHeaders.INSTANCE.getContentEncoding(), missingEncoders);
            LOGGER.trace("Skip some of decompression for " + ApplicationRequestPropertiesKt.getUri((ApplicationRequest)((ApplicationRequest)call.getRequest())) + " because no suitable encoders found for " + missingEncoders);
        } else {
            call.getRequest().setHeader(HttpHeaders.INSTANCE.getContentEncoding(), null);
        }
        call.getAttributes().put(DecompressionListAttribute, (Object)encoderNames);
        Object object = $this$decode.transformBody((Function3)new Function3<TransformBodyContext, ByteReadChannel, Continuation<? super Object>, Object>((List<CompressionEncoderConfig>)encoders, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ List<CompressionEncoderConfig> $encoders;
            {
                this.$encoders = $encoders;
                super(3, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ByteReadChannel body = (ByteReadChannel)this.L$0;
                        Iterable $this$fold$iv = this.$encoders;
                        boolean $i$f$fold = false;
                        ByteReadChannel accumulator$iv = body;
                        for (T element$iv : $this$fold$iv) {
                            void encoder;
                            CompressionEncoderConfig compressionEncoderConfig = (CompressionEncoderConfig)element$iv;
                            ByteReadChannel content = accumulator$iv;
                            boolean bl = false;
                            accumulator$iv = Encoder.DefaultImpls.decode$default((Encoder)((Encoder)encoder.getEncoder()), (ByteReadChannel)content, null, (int)2, null);
                        }
                        return accumulator$iv;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(TransformBodyContext p1, ByteReadChannel p2, Continuation<Object> p3) {
                Function3<TransformBodyContext, ByteReadChannel, Continuation<? super Object>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                function3.L$0 = p2;
                return function3.invokeSuspend((Object)Unit.INSTANCE);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final void encode(ContentEncoding.Context $this$encode, PipelineCall call, CompressionOptions options) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable list$iv$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        HeaderValue it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        if (CompressionKt.isSSEResponse(call.getResponse())) {
            LOGGER.trace("Skip compression for sse response " + ApplicationRequestPropertiesKt.getUri((ApplicationRequest)((ApplicationRequest)call.getRequest())) + ' ');
            return;
        }
        Function1[] function1Array = new Function1[]{CompressionKt::encode$lambda$4, CompressionKt::encode$lambda$5};
        Comparator comparator = ComparisonsKt.compareBy((Function1[])function1Array).reversed();
        String acceptEncodingRaw = ApplicationRequestPropertiesKt.acceptEncoding((ApplicationRequest)((ApplicationRequest)call.getRequest()));
        if (acceptEncodingRaw == null) {
            LOGGER.trace("Skip compression for " + ApplicationRequestPropertiesKt.getUri((ApplicationRequest)((ApplicationRequest)call.getRequest())) + " because no accept encoding provided.");
            return;
        }
        if (SuppressionAttributeKt.isCompressionSuppressed((ApplicationCall)((ApplicationCall)call))) {
            LOGGER.trace("Skip compression for " + ApplicationRequestPropertiesKt.getUri((ApplicationRequest)((ApplicationRequest)call.getRequest())) + " because it is suppressed.");
            return;
        }
        Iterable iterable = HttpHeaderValueParserKt.parseHeaderValue((String)acceptEncodingRaw);
        boolean $i$f$filter = false;
        void var8_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (HeaderValue)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it.getValue(), (Object)"*") || options.getEncoders().containsKey(it.getValue()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Object object;
            block12: {
                block13: {
                    HeaderValue header;
                    block11: {
                        void $this$mapTo$iv$iv2;
                        header = (HeaderValue)element$iv$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)header.getValue(), (Object)"*")) break block11;
                        Iterable $this$map$iv2 = options.getEncoders().values();
                        boolean $i$f$map = false;
                        Iterable iterable2 = $this$map$iv2;
                        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                            void it2;
                            CompressionEncoderConfig compressionEncoderConfig = (CompressionEncoderConfig)item$iv$iv;
                            Collection collection = destination$iv$iv2;
                            boolean bl2 = false;
                            collection.add(TuplesKt.to((Object)it2, (Object)header));
                        }
                        object = (List)destination$iv$iv2;
                        break block12;
                    }
                    object = options.getEncoders().get(header.getValue());
                    if (object == null) break block13;
                    CompressionEncoderConfig it3 = object;
                    boolean bl = false;
                    List list = CollectionsKt.listOf((Object)TuplesKt.to((Object)it3, (Object)header));
                    object = list;
                    if (list != null) break block12;
                }
                object = CollectionsKt.emptyList();
            }
            list$iv$iv = (Iterable)object;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable iterable3 = (List)destination$iv$iv;
        Intrinsics.checkNotNull(comparator);
        $this$flatMap$iv = CollectionsKt.sortedWith((Iterable)iterable3, comparator);
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((CompressionEncoderConfig)it.getFirst());
        }
        List encoders = (List)destination$iv$iv;
        if (encoders.isEmpty()) {
            LOGGER.trace("Skip compression for " + ApplicationRequestPropertiesKt.getUri((ApplicationRequest)((ApplicationRequest)call.getRequest())) + " because no encoders provided.");
            return;
        }
        $this$encode.transformBody((Function1<? super OutgoingContent, ? extends OutgoingContent>)((Function1)arg_0 -> CompressionKt.encode$lambda$14(options, call, encoders, arg_0)));
    }

    private static final boolean isSSEResponse(PipelineResponse $this$isSSEResponse) {
        ContentType contentType;
        ContentType contentType2;
        String string = $this$isSSEResponse.getHeaders().get(HttpHeaders.INSTANCE.getContentType());
        if (string != null) {
            String it = string;
            boolean bl = false;
            contentType2 = ContentType.Companion.parse(it);
        } else {
            contentType2 = null;
        }
        ContentType contentType3 = contentType = contentType2;
        return Intrinsics.areEqual((Object)(contentType3 != null ? contentType3.withoutParameters() : null), (Object)ContentType.Text.INSTANCE.getEventStream());
    }

    private static final Unit Compression$lambda$0(RouteScopedPluginBuilder $this$createRouteScopedPlugin) {
        Intrinsics.checkNotNullParameter((Object)$this$createRouteScopedPlugin, (String)"$this$createRouteScopedPlugin");
        if (MapsKt.none(((CompressionConfig)$this$createRouteScopedPlugin.getPluginConfig()).getEncoders())) {
            ((CompressionConfig)$this$createRouteScopedPlugin.getPluginConfig()).default();
        }
        CompressionOptions options = ((CompressionConfig)$this$createRouteScopedPlugin.getPluginConfig()).buildOptions$ktor_server_compression();
        CompressionConfig.Mode mode = ((CompressionConfig)$this$createRouteScopedPlugin.getPluginConfig()).getMode();
        $this$createRouteScopedPlugin.on((Hook)ContentEncoding.INSTANCE, (Object)new Function3<ContentEncoding.Context, PipelineCall, Continuation<? super Unit>, Object>(mode, options, null){
            int label;
            private /* synthetic */ Object L$0;
            /* synthetic */ Object L$1;
            final /* synthetic */ CompressionConfig.Mode $mode;
            final /* synthetic */ CompressionOptions $options;
            {
                this.$mode = $mode;
                this.$options = $options;
                super(3, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ContentEncoding.Context $this$on = (ContentEncoding.Context)this.L$0;
                        PipelineCall call = (PipelineCall)this.L$1;
                        if (!this.$mode.getResponse$ktor_server_compression()) {
                            return Unit.INSTANCE;
                        }
                        CompressionKt.access$encode($this$on, call, this.$options);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(ContentEncoding.Context p1, PipelineCall p2, Continuation<? super Unit> p3) {
                Function3<ContentEncoding.Context, PipelineCall, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                function3.L$0 = p1;
                function3.L$1 = p2;
                return function3.invokeSuspend((Object)Unit.INSTANCE);
            }
        });
        $this$createRouteScopedPlugin.onCallReceive((Function3)new Function3<OnCallReceiveContext<CompressionConfig>, PipelineCall, Continuation<? super Unit>, Object>(mode, options, null){
            int label;
            private /* synthetic */ Object L$0;
            /* synthetic */ Object L$1;
            final /* synthetic */ CompressionConfig.Mode $mode;
            final /* synthetic */ CompressionOptions $options;
            {
                this.$mode = $mode;
                this.$options = $options;
                super(3, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        OnCallReceiveContext $this$onCallReceive = (OnCallReceiveContext)this.L$0;
                        PipelineCall call = (PipelineCall)this.L$1;
                        if (!this.$mode.getRequest$ktor_server_compression()) {
                            return Unit.INSTANCE;
                        }
                        this.L$0 = null;
                        this.label = 1;
                        Object object3 = CompressionKt.access$decode($this$onCallReceive, call, this.$options, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(OnCallReceiveContext<CompressionConfig> p1, PipelineCall p2, Continuation<? super Unit> p3) {
                Function3<OnCallReceiveContext<CompressionConfig>, PipelineCall, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                function3.L$0 = p1;
                function3.L$1 = p2;
                return function3.invokeSuspend((Object)Unit.INSTANCE);
            }
        });
        return Unit.INSTANCE;
    }

    private static final Comparable encode$lambda$4(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Double.valueOf(((HeaderValue)it.getSecond()).getQuality());
    }

    private static final Comparable encode$lambda$5(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Double.valueOf(((CompressionEncoderConfig)it.getFirst()).getPriority());
    }

    private static final OutgoingContent encode$lambda$14(CompressionOptions $options, PipelineCall $call, List $encoders, OutgoingContent message) {
        Object v2;
        block12: {
            boolean bl;
            block10: {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Iterable $this$any$iv = $options.getConditions();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Function2 it = (Function2)element$iv;
                        boolean bl2 = false;
                        if (!((Boolean)it.invoke((Object)$call, (Object)message) == false)) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
            }
            if (bl) {
                LOGGER.trace("Skip compression for " + ApplicationRequestPropertiesKt.getUri((ApplicationRequest)((ApplicationRequest)$call.getRequest())) + " because preconditions doesn't meet.");
                return null;
            }
            String encodingHeader = message.getHeaders().get(HttpHeaders.INSTANCE.getContentEncoding());
            if (encodingHeader != null) {
                LOGGER.trace("Skip compression for " + ApplicationRequestPropertiesKt.getUri((ApplicationRequest)((ApplicationRequest)$call.getRequest())) + " because content is already encoded.");
                return null;
            }
            Iterable $this$firstOrNull$iv = $encoders;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl3;
                block11: {
                    CompressionEncoderConfig encoder = (CompressionEncoderConfig)element$iv;
                    boolean bl4 = false;
                    Iterable $this$all$iv = encoder.getConditions();
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl3 = true;
                    } else {
                        for (Object element$iv2 : $this$all$iv) {
                            Function2 it = (Function2)element$iv2;
                            boolean bl5 = false;
                            if (((Boolean)it.invoke((Object)$call, (Object)message)).booleanValue()) continue;
                            bl3 = false;
                            break block11;
                        }
                        bl3 = true;
                    }
                }
                if (!bl3) continue;
                v2 = element$iv;
                break block12;
            }
            v2 = null;
        }
        CompressionEncoderConfig encoderOptions = v2;
        if (encoderOptions == null) {
            LOGGER.trace("Skip compression for " + ApplicationRequestPropertiesKt.getUri((ApplicationRequest)((ApplicationRequest)$call.getRequest())) + " because no suitable encoder found.");
            return null;
        }
        LOGGER.trace("Encoding body for " + ApplicationRequestPropertiesKt.getUri((ApplicationRequest)((ApplicationRequest)$call.getRequest())) + " using " + encoderOptions.getEncoder().getName() + '.');
        return CompressedContentKt.compressed$default((OutgoingContent)message, (ContentEncoder)encoderOptions.getEncoder(), null, (int)2, null);
    }

    public static final /* synthetic */ Object access$decode(OnCallReceiveContext $receiver, PipelineCall call, CompressionOptions options, Continuation $completion) {
        return CompressionKt.decode((OnCallReceiveContext<CompressionConfig>)$receiver, call, options, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ void access$encode(ContentEncoding.Context $receiver, PipelineCall call, CompressionOptions options) {
        CompressionKt.encode($receiver, call, options);
    }

    static {
        KType kType;
        String name$iv = "DecompressionListAttribute";
        boolean $i$f$AttributeKey = false;
        String string = name$iv;
        boolean $i$f$typeInfo = false;
        KClass kClass = Reflection.getOrCreateKotlinClass(List.class);
        boolean $i$f$typeOfOrNull = false;
        try {
            kType = Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(String.class)));
        }
        catch (Throwable throwable) {
            kType = null;
        }
        KType kType2 = kType;
        KClass kClass2 = kClass;
        TypeInfo typeInfo = new TypeInfo(kClass2, kType2);
        String string2 = string;
        DecompressionListAttribute = new AttributeKey(string2, typeInfo);
        LOGGER = KtorSimpleLoggerJvmKt.KtorSimpleLogger((String)"io.ktor.server.plugins.compression.Compression");
        Compression = CreatePluginUtilsKt.createRouteScopedPlugin((String)"Compression", (Function0)Compression.1.INSTANCE, CompressionKt::Compression$lambda$0);
    }
}

