/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.utils;

import com.crosspaste.utils.CodecsUtils;
import com.crosspaste.utils.CodecsUtils_desktopKt;
import com.fleeksoft.ksoup.Ksoup;
import com.fleeksoft.ksoup.nodes.Document;
import com.fleeksoft.ksoup.nodes.Element;
import com.fleeksoft.ksoup.nodes.Node;
import com.fleeksoft.ksoup.safety.Safelist;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u0010\u0010\t\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0007J\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/crosspaste/utils/HtmlUtils;", "", "<init>", "()V", "codecsUtils", "Lcom/crosspaste/utils/CodecsUtils;", "dataUrl", "", "html", "getHtmlText", "ensureHtmlCharsetUtf8", "shared"})
@SourceDebugExtension(value={"SMAP\nHtmlUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HtmlUtils.kt\ncom/crosspaste/utils/HtmlUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,55:1\n1869#2,2:56\n1#3:58\n*S KotlinDebug\n*F\n+ 1 HtmlUtils.kt\ncom/crosspaste/utils/HtmlUtils\n*L\n48#1:56,2\n*E\n"})
public final class HtmlUtils {
    @NotNull
    public static final HtmlUtils INSTANCE = new HtmlUtils();
    @NotNull
    private static final CodecsUtils codecsUtils = CodecsUtils_desktopKt.getCodecsUtils();

    private HtmlUtils() {
    }

    @NotNull
    public final String dataUrl(@NotNull String html) {
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        String encodedContent = codecsUtils.base64Encode(StringsKt.encodeToByteArray((String)html));
        return "data:text/html;charset=UTF-8;base64," + encodedContent;
    }

    @Nullable
    public final String getHtmlText(@NotNull String html) {
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        Object object = this;
        try {
            HtmlUtils $this$getHtmlText_u24lambda_u240 = object;
            boolean bl = false;
            Document ksoupDoc = Ksoup.parse$default((Ksoup)Ksoup.INSTANCE, (String)html, null, (int)2, null);
            Document.OutputSettings outputSettings = new Document.OutputSettings(null, null, false, false, 0, 0, null, 127, null);
            outputSettings.prettyPrint(false);
            ksoupDoc.outputSettings(outputSettings);
            ksoupDoc.select("br").before("\\n");
            ksoupDoc.select("p").before("\\n");
            CharSequence charSequence = ksoupDoc.html();
            Regex regex = new Regex("\\\\n");
            String string = "\n";
            String str = regex.replace(charSequence, string);
            return Ksoup.INSTANCE.clean(str, Safelist.Companion.none(), "", outputSettings);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            return (String)(Result.isFailure-impl((Object)object) ? null : object);
        }
    }

    @NotNull
    public final String ensureHtmlCharsetUtf8(@NotNull String html) {
        Object object;
        Object $this$ensureHtmlCharsetUtf8_u24lambda_u242;
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        Object object2 = this;
        try {
            $this$ensureHtmlCharsetUtf8_u24lambda_u242 = object2;
            boolean bl = false;
            Document doc = Ksoup.parse$default((Ksoup)Ksoup.INSTANCE, (String)html, null, (int)2, null);
            Element head = doc.head();
            head.select("meta[charset]").remove();
            head.select("meta[http-equiv=Content-Type]").remove();
            head.select("meta[name=viewport]").remove();
            Object[] objectArray = new Element[]{doc.createElement("meta").attr("charset", "UTF-8"), doc.createElement("meta").attr("http-equiv", "Content-Type").attr("content", "text/html; charset=UTF-8")};
            List metaTags = CollectionsKt.listOf((Object[])objectArray);
            Iterable $this$forEach$iv = CollectionsKt.reversed((Iterable)metaTags);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Element meta = (Element)element$iv;
                boolean bl2 = false;
                head.prependChild((Node)meta);
            }
            $this$ensureHtmlCharsetUtf8_u24lambda_u242 = Result.constructor-impl((Object)doc.html());
        }
        catch (Throwable bl) {
            $this$ensureHtmlCharsetUtf8_u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$ensureHtmlCharsetUtf8_u24lambda_u242;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            object = html;
        }
        return (String)object;
    }
}

