/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.utils;

import com.crosspaste.utils.CodecsUtils;
import com.crosspaste.utils.FileUtils;
import com.crosspaste.utils.FileUtils_desktopKt;
import dev.whyoleg.cryptography.CryptographyAlgorithmId;
import dev.whyoleg.cryptography.CryptographyProvider;
import dev.whyoleg.cryptography.algorithms.Digest;
import dev.whyoleg.cryptography.algorithms.SHA256;
import dev.whyoleg.cryptography.operations.Hasher;
import java.io.ByteArrayOutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.Path;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lcom/crosspaste/utils/DesktopCodecsUtils;", "Lcom/crosspaste/utils/CodecsUtils;", "<init>", "()V", "fileUtils", "Lcom/crosspaste/utils/FileUtils;", "getFileUtils", "()Lcom/crosspaste/utils/FileUtils;", "provider", "Ldev/whyoleg/cryptography/CryptographyProvider;", "sha256", "Ldev/whyoleg/cryptography/operations/Hasher;", "getSha256", "()Ldev/whyoleg/cryptography/operations/Hasher;", "hashByArray", "", "array", "", "([Ljava/lang/String;)Ljava/lang/String;", "shared"})
@SourceDebugExtension(value={"SMAP\nCodecsUtils.desktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodecsUtils.desktop.kt\ncom/crosspaste/utils/DesktopCodecsUtils\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,32:1\n13472#2,2:33\n*S KotlinDebug\n*F\n+ 1 CodecsUtils.desktop.kt\ncom/crosspaste/utils/DesktopCodecsUtils\n*L\n25#1:33,2\n*E\n"})
public final class DesktopCodecsUtils
implements CodecsUtils {
    @NotNull
    public static final DesktopCodecsUtils INSTANCE = new DesktopCodecsUtils();
    @NotNull
    private static final FileUtils fileUtils = FileUtils_desktopKt.getFileUtils();
    @NotNull
    private static final CryptographyProvider provider = CryptographyProvider.Companion.getDefault();
    @NotNull
    private static final Hasher sha256 = ((Digest)provider.get((CryptographyAlgorithmId)SHA256.INSTANCE)).hasher();

    private DesktopCodecsUtils() {
    }

    @Override
    @NotNull
    public FileUtils getFileUtils() {
        return fileUtils;
    }

    @Override
    @NotNull
    public Hasher getSha256() {
        return sha256;
    }

    @Override
    @NotNull
    public String hashByArray(@NotNull String[] array) {
        String string;
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        if (array.length == 0) {
            throw new IllegalArgumentException("Array is empty");
        }
        if (array.length == 1) {
            string = this.hashByString(array[0]);
        } else {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            String[] $this$forEach$iv = array;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                outputStream.write(StringsKt.encodeToByteArray((String)it));
            }
            byte[] byArray = outputStream.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
            string = this.hash(byArray);
        }
        return string;
    }

    @Override
    @NotNull
    public String sha256(@NotNull Path path) {
        return CodecsUtils.super.sha256(path);
    }

    @Override
    @NotNull
    public String base64Encode(@NotNull byte[] bytes) {
        return CodecsUtils.super.base64Encode(bytes);
    }

    @Override
    @NotNull
    public byte[] base64Decode(@NotNull String string) {
        return CodecsUtils.super.base64Decode(string);
    }

    @Override
    @NotNull
    public String hash(@NotNull byte[] bytes) {
        return CodecsUtils.super.hash(bytes);
    }

    @Override
    @NotNull
    public String hash(@NotNull Path path) {
        return CodecsUtils.super.hash(path);
    }

    @Override
    @NotNull
    public String hashByString(@NotNull String string) {
        return CodecsUtils.super.hashByString(string);
    }
}

