/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.utils;

import com.crosspaste.utils.DateTimeFormatOptions;
import com.crosspaste.utils.RelativeTime;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Clock;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlin.time.Instant;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import kotlinx.datetime.format.DateTimeFormat;
import kotlinx.datetime.format.DateTimeFormatBuilder;
import kotlinx.datetime.format.UnicodeKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\nJ\u001e\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0015J\u0006\u0010\u001b\u001a\u00020\nJ\u0006\u0010\u001c\u001a\u00020\u000fJ\u0006\u0010\u001d\u001a\u00020\u0011J\u000e\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u000fJ\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000f2\b\b\u0002\u0010\u001b\u001a\u00020\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\u0003\u001a\u0004\b\f\u0010\r\u00a8\u0006#"}, d2={"Lcom/crosspaste/utils/DateUtils;", "", "<init>", "()V", "TIME_ZONE", "Lkotlinx/datetime/TimeZone;", "getTIME_ZONE", "()Lkotlinx/datetime/TimeZone;", "YMD_FORMAT", "Lkotlinx/datetime/format/DateTimeFormat;", "Lkotlinx/datetime/LocalDateTime;", "getYMD_FORMAT$annotations", "getYMD_FORMAT", "()Lkotlinx/datetime/format/DateTimeFormat;", "getOffsetDay", "", "currentTime", "Lkotlin/time/Instant;", "days", "", "getYMD", "", "date", "getDateDesc", "options", "Lcom/crosspaste/utils/DateTimeFormatOptions;", "locale", "now", "nowEpochMilliseconds", "nowInstant", "epochMillisecondsToLocalDateTime", "epochMilliseconds", "getRelativeTime", "Lcom/crosspaste/utils/RelativeTime;", "timestamp", "shared"})
public final class DateUtils {
    @NotNull
    public static final DateUtils INSTANCE = new DateUtils();
    @NotNull
    private static final TimeZone TIME_ZONE = TimeZone.Companion.currentSystemDefault();
    @NotNull
    private static final DateTimeFormat<LocalDateTime> YMD_FORMAT = LocalDateTime.Companion.Format(DateUtils::YMD_FORMAT$lambda$0);

    private DateUtils() {
    }

    @NotNull
    public final TimeZone getTIME_ZONE() {
        return TIME_ZONE;
    }

    @NotNull
    public final DateTimeFormat<LocalDateTime> getYMD_FORMAT() {
        return YMD_FORMAT;
    }

    public static /* synthetic */ void getYMD_FORMAT$annotations() {
    }

    public final long getOffsetDay(@NotNull Instant currentTime, int days) {
        Intrinsics.checkNotNullParameter((Object)currentTime, (String)"currentTime");
        Instant offsetDay = currentTime.plus-LRDsOJo(DurationKt.toDuration((int)days, (DurationUnit)DurationUnit.DAYS));
        return offsetDay.toEpochMilliseconds();
    }

    public static /* synthetic */ long getOffsetDay$default(DateUtils dateUtils, Instant instant, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            instant = dateUtils.nowInstant();
        }
        return dateUtils.getOffsetDay(instant, n);
    }

    @NotNull
    public final String getYMD(@NotNull LocalDateTime date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return YMD_FORMAT.format((Object)date);
    }

    public static /* synthetic */ String getYMD$default(DateUtils dateUtils, LocalDateTime localDateTime, int n, Object object) {
        if ((n & 1) != 0) {
            localDateTime = dateUtils.now();
        }
        return dateUtils.getYMD(localDateTime);
    }

    @NotNull
    public final String getDateDesc(@NotNull LocalDateTime date, @NotNull DateTimeFormatOptions options, @NotNull String locale) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        DateTimeFormat dateTimeFormat = LocalDateTime.Companion.Format(arg_0 -> DateUtils.getDateDesc$lambda$1(options, locale, arg_0));
        return dateTimeFormat.format((Object)date);
    }

    @NotNull
    public final LocalDateTime now() {
        Instant currentInstant = this.nowInstant();
        return TimeZoneKt.toLocalDateTime((Instant)currentInstant, (TimeZone)TIME_ZONE);
    }

    public final long nowEpochMilliseconds() {
        return this.nowInstant().toEpochMilliseconds();
    }

    @NotNull
    public final Instant nowInstant() {
        return Clock.System.INSTANCE.now();
    }

    @NotNull
    public final LocalDateTime epochMillisecondsToLocalDateTime(long epochMilliseconds) {
        Instant instant = Instant.Companion.fromEpochMilliseconds(epochMilliseconds);
        return TimeZoneKt.toLocalDateTime((Instant)instant, (TimeZone)TIME_ZONE);
    }

    @NotNull
    public final RelativeTime getRelativeTime(long timestamp, long now) {
        RelativeTime relativeTime;
        long duration = DurationKt.toDuration((long)(now - timestamp), (DurationUnit)DurationUnit.MILLISECONDS);
        if (Duration.compareTo-LRDsOJo((long)duration, (long)DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.SECONDS)) < 0) {
            relativeTime = new RelativeTime(null, "relative_now");
        } else if (Duration.compareTo-LRDsOJo((long)duration, (long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES)) < 0) {
            int seconds = (int)Duration.getInWholeSeconds-impl((long)duration);
            relativeTime = new RelativeTime(seconds, "relative_seconds_ago");
        } else if (Duration.compareTo-LRDsOJo((long)duration, (long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.HOURS)) < 0) {
            int minutes = (int)Duration.getInWholeMinutes-impl((long)duration);
            relativeTime = new RelativeTime(minutes, "relative_minutes_ago");
        } else if (Duration.compareTo-LRDsOJo((long)duration, (long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.DAYS)) < 0) {
            int hours = (int)Duration.getInWholeHours-impl((long)duration);
            relativeTime = new RelativeTime(hours, "relative_hours_ago");
        } else if (Duration.compareTo-LRDsOJo((long)duration, (long)DurationKt.toDuration((int)7, (DurationUnit)DurationUnit.DAYS)) < 0) {
            int days = (int)Duration.getInWholeDays-impl((long)duration);
            relativeTime = new RelativeTime(days, "relative_days_ago");
        } else if (Duration.compareTo-LRDsOJo((long)duration, (long)DurationKt.toDuration((int)31, (DurationUnit)DurationUnit.DAYS)) < 0) {
            int weeks = (int)(Duration.getInWholeDays-impl((long)duration) / (long)7);
            relativeTime = new RelativeTime(weeks, "relative_weeks_ago");
        } else if (Duration.compareTo-LRDsOJo((long)duration, (long)DurationKt.toDuration((int)365, (DurationUnit)DurationUnit.DAYS)) < 0) {
            int months = (int)(Duration.getInWholeDays-impl((long)duration) / (long)30);
            relativeTime = new RelativeTime(months, "relative_months_ago");
        } else {
            int years = (int)(Duration.getInWholeDays-impl((long)duration) / (long)365);
            relativeTime = new RelativeTime(years, "relative_years_ago");
        }
        return relativeTime;
    }

    public static /* synthetic */ RelativeTime getRelativeTime$default(DateUtils dateUtils, long l, long l2, int n, Object object) {
        if ((n & 2) != 0) {
            l2 = dateUtils.nowEpochMilliseconds();
        }
        return dateUtils.getRelativeTime(l, l2);
    }

    private static final Unit YMD_FORMAT$lambda$0(DateTimeFormatBuilder.WithDateTime $this$Format) {
        Intrinsics.checkNotNullParameter((Object)$this$Format, (String)"$this$Format");
        UnicodeKt.byUnicodePattern((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$Format), (String)"yyyy-MM-dd");
        return Unit.INSTANCE;
    }

    private static final Unit getDateDesc$lambda$1(DateTimeFormatOptions $options, String $locale, DateTimeFormatBuilder.WithDateTime $this$Format) {
        Intrinsics.checkNotNullParameter((Object)$this$Format, (String)"$this$Format");
        UnicodeKt.byUnicodePattern((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$Format), (String)($options.getDateStyle().toPattern$shared($locale) + " " + $options.getTimeStyle().toPattern$shared($locale)));
        return Unit.INSTANCE;
    }
}

