/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.utils;

import com.crosspaste.utils.CodecsUtilsKt;
import com.crosspaste.utils.FileUtils;
import com.crosspaste.utils.StringUtilsKt;
import dev.whyoleg.cryptography.operations.HashFunction;
import dev.whyoleg.cryptography.operations.Hasher;
import java.io.Closeable;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.ULong;
import kotlin.Unit;
import kotlin.io.encoding.Base64;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.HexExtensionsKt;
import kotlin.text.StringsKt;
import okio.BufferedSource;
import okio.Okio;
import okio.Path;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u001b\u0010\u0014\u001a\u00020\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0016H&\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0006\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0018\u00c0\u0006\u0003"}, d2={"Lcom/crosspaste/utils/CodecsUtils;", "", "fileUtils", "Lcom/crosspaste/utils/FileUtils;", "getFileUtils", "()Lcom/crosspaste/utils/FileUtils;", "sha256", "Ldev/whyoleg/cryptography/operations/Hasher;", "getSha256", "()Ldev/whyoleg/cryptography/operations/Hasher;", "base64Encode", "", "bytes", "", "base64Decode", "string", "hash", "path", "Lokio/Path;", "hashByString", "hashByArray", "array", "", "([Ljava/lang/String;)Ljava/lang/String;", "shared"})
@SourceDebugExtension(value={"SMAP\nCodecsUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodecsUtils.kt\ncom/crosspaste/utils/CodecsUtils\n+ 2 Okio.kt\nokio/Okio__OkioKt\n*L\n1#1,61:1\n72#2:62\n58#2,22:63\n*S KotlinDebug\n*F\n+ 1 CodecsUtils.kt\ncom/crosspaste/utils/CodecsUtils\n*L\n50#1:62\n50#1:63,22\n*E\n"})
public interface CodecsUtils {
    @NotNull
    public FileUtils getFileUtils();

    @NotNull
    public Hasher getSha256();

    @NotNull
    default public String base64Encode(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return Base64.encode$default((Base64)((Base64)Base64.Default), (byte[])bytes, (int)0, (int)0, (int)6, null);
    }

    @NotNull
    default public byte[] base64Decode(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return Base64.decode$default((Base64)((Base64)Base64.Default), (CharSequence)string, (int)0, (int)0, (int)6, null);
    }

    @NotNull
    default public String hash(@NotNull byte[] bytes) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        ULong[] uLongArray = CodecsUtilsKt.getCROSSPASTE_HASH().hash128x64(bytes);
        long hash1 = uLongArray[0].unbox-impl();
        long hash2 = uLongArray[1].unbox-impl();
        int n = 32;
        StringBuilder $this$hash_u24lambda_u240 = stringBuilder = new StringBuilder(n);
        boolean bl = false;
        StringUtilsKt.appendHex-2TYgG_w($this$hash_u24lambda_u240, hash1);
        StringUtilsKt.appendHex-2TYgG_w($this$hash_u24lambda_u240, hash2);
        return stringBuilder.toString();
    }

    @NotNull
    default public String hash(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.getFileUtils().getFileHash(path);
    }

    @NotNull
    default public String hashByString(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return this.hash(StringsKt.encodeToByteArray((String)string));
    }

    @NotNull
    public String hashByArray(@NotNull String[] var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    default public String sha256(@NotNull Path path) {
        Unit unit;
        Throwable thrown$iv;
        HashFunction sha256Hasher;
        block16: {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            sha256Hasher = this.getSha256().createHashFunction();
            int bufferSize = this.getFileUtils().getFileBufferSize();
            byte[] buffer = new byte[bufferSize];
            Closeable $this$use$iv = (Closeable)Okio.buffer((Source)this.getFileUtils().getFileSystem().source(path));
            boolean $i$f$use = false;
            thrown$iv = null;
            try {
                int bytesRead;
                BufferedSource bufferedSource = (BufferedSource)$this$use$iv;
                boolean bl = false;
                while ((bytesRead = bufferedSource.read(buffer, 0, bufferSize)) != -1) {
                    sha256Hasher.update(buffer, 0, bytesRead);
                }
                unit = Unit.INSTANCE;
            }
            catch (Throwable t$iv) {
                try {
                    thrown$iv = t$iv;
                    unit = null;
                    break block16;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    block17: {
                        try {
                            Closeable closeable = $this$use$iv;
                            if (closeable != null) {
                                closeable.close();
                            }
                        }
                        catch (Throwable t$iv2) {
                            if (thrown$iv == null) {
                                thrown$iv = t$iv2;
                                break block17;
                            }
                            ExceptionsKt.addSuppressed((Throwable)thrown$iv, (Throwable)t$iv2);
                        }
                    }
                }
            }
            try {
                Closeable closeable = $this$use$iv;
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (Throwable t$iv) {
                thrown$iv = t$iv;
            }
        }
        Unit result$iv = unit;
        Throwable throwable = thrown$iv;
        if (throwable != null) {
            throw throwable;
        }
        byte[] hash = sha256Hasher.hashToByteArray();
        return HexExtensionsKt.toHexString$default((byte[])hash, null, (int)1, null);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Deprecated
        @NotNull
        public static String base64Encode(@NotNull CodecsUtils $this, @NotNull byte[] bytes) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            return $this.base64Encode(bytes);
        }

        @Deprecated
        @NotNull
        public static byte[] base64Decode(@NotNull CodecsUtils $this, @NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            return $this.base64Decode(string);
        }

        @Deprecated
        @NotNull
        public static String hash(@NotNull CodecsUtils $this, @NotNull byte[] bytes) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            return $this.hash(bytes);
        }

        @Deprecated
        @NotNull
        public static String hash(@NotNull CodecsUtils $this, @NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return $this.hash(path);
        }

        @Deprecated
        @NotNull
        public static String hashByString(@NotNull CodecsUtils $this, @NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            return $this.hashByString(string);
        }

        @Deprecated
        @NotNull
        public static String sha256(@NotNull CodecsUtils $this, @NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return $this.sha256(path);
        }
    }
}

