/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.presist;

import com.crosspaste.presist.FilesChunk;
import com.crosspaste.presist.FilesChunkBuilder;
import com.crosspaste.presist.FilesIndex;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import okio.Path;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003J\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/crosspaste/presist/FilesIndexBuilder;", "", "chunkSize", "", "<init>", "(J)V", "filesChunks", "", "Lcom/crosspaste/presist/FilesChunk;", "filesChunkBuilder", "Lcom/crosspaste/presist/FilesChunkBuilder;", "addFile", "", "filePath", "Lokio/Path;", "size", "build", "Lcom/crosspaste/presist/FilesIndex;", "shared"})
public final class FilesIndexBuilder {
    private final long chunkSize;
    @NotNull
    private final List<FilesChunk> filesChunks;
    @NotNull
    private FilesChunkBuilder filesChunkBuilder;

    public FilesIndexBuilder(long chunkSize) {
        this.chunkSize = chunkSize;
        this.filesChunks = new ArrayList();
        this.filesChunkBuilder = new FilesChunkBuilder(this.chunkSize);
    }

    public final void addFile(@NotNull Path filePath, long size) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        long remainingSize = size;
        do {
            if ((remainingSize = this.filesChunkBuilder.addFile(filePath, remainingSize, size)) <= 0L) continue;
            this.filesChunks.add(this.filesChunkBuilder.build());
            this.filesChunkBuilder = new FilesChunkBuilder(this.chunkSize);
        } while (remainingSize > 0L);
    }

    @NotNull
    public final FilesIndex build() {
        if (this.filesChunkBuilder.isNotEmpty()) {
            this.filesChunks.add(this.filesChunkBuilder.build());
        }
        return new FilesIndex(CollectionsKt.toList((Iterable)this.filesChunks));
    }
}

