/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.path;

import com.crosspaste.app.AppFileType;
import com.crosspaste.config.AppConfig;
import com.crosspaste.config.ConfigManager;
import com.crosspaste.exception.PasteException;
import com.crosspaste.exception.StandardErrorCode;
import com.crosspaste.paste.item.PasteFiles;
import com.crosspaste.path.PathProvider;
import com.crosspaste.path.PlatformUserDataPathProvider;
import com.crosspaste.presist.DirFileInfoTree;
import com.crosspaste.presist.FileInfoTree;
import com.crosspaste.presist.FilesIndexBuilder;
import com.crosspaste.utils.FileUtils;
import com.crosspaste.utils.FileUtils_desktopKt;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0010\u0010\u0002\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J&\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0015J\u0006\u0010\u0016\u001a\u00020\u0017J8\u0010\u000e\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!J2\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0002J\u0006\u0010'\u001a\u00020\u000fR\u0018\u0010\u0002\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006("}, d2={"Lcom/crosspaste/path/UserDataPathProvider;", "Lcom/crosspaste/path/PathProvider;", "configManager", "Lcom/crosspaste/config/ConfigManager;", "Lcom/crosspaste/config/AppConfig;", "Lcom/crosspaste/config/CommonConfigManager;", "platformUserDataPathProvider", "Lcom/crosspaste/path/PlatformUserDataPathProvider;", "<init>", "(Lcom/crosspaste/config/ConfigManager;Lcom/crosspaste/path/PlatformUserDataPathProvider;)V", "fileUtils", "Lcom/crosspaste/utils/FileUtils;", "getFileUtils", "()Lcom/crosspaste/utils/FileUtils;", "resolve", "Lokio/Path;", "fileName", "", "appFileType", "Lcom/crosspaste/app/AppFileType;", "getBasePath", "Lkotlin/Function0;", "cleanTemp", "", "appInstanceId", "dateString", "pasteId", "", "pasteFiles", "Lcom/crosspaste/paste/item/PasteFiles;", "isPull", "", "filesIndexBuilder", "Lcom/crosspaste/presist/FilesIndexBuilder;", "resolveFileInfoTree", "basePath", "name", "fileInfoTree", "Lcom/crosspaste/presist/FileInfoTree;", "getUserDataPath", "shared"})
@SourceDebugExtension(value={"SMAP\nUserDataPathProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserDataPathProvider.kt\ncom/crosspaste/path/UserDataPathProvider\n+ 2 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,134:1\n32#2,2:135\n*S KotlinDebug\n*F\n+ 1 UserDataPathProvider.kt\ncom/crosspaste/path/UserDataPathProvider\n*L\n121#1:135,2\n*E\n"})
public final class UserDataPathProvider
implements PathProvider {
    @NotNull
    private final ConfigManager<AppConfig> configManager;
    @NotNull
    private final PlatformUserDataPathProvider platformUserDataPathProvider;
    @NotNull
    private final FileUtils fileUtils;

    public UserDataPathProvider(@NotNull ConfigManager<AppConfig> configManager, @NotNull PlatformUserDataPathProvider platformUserDataPathProvider) {
        Intrinsics.checkNotNullParameter(configManager, (String)"configManager");
        Intrinsics.checkNotNullParameter((Object)platformUserDataPathProvider, (String)"platformUserDataPathProvider");
        this.configManager = configManager;
        this.platformUserDataPathProvider = platformUserDataPathProvider;
        this.fileUtils = FileUtils_desktopKt.getFileUtils();
    }

    @Override
    @NotNull
    public FileUtils getFileUtils() {
        return this.fileUtils;
    }

    @Override
    @NotNull
    public Path resolve(@Nullable String fileName, @NotNull AppFileType appFileType) {
        Intrinsics.checkNotNullParameter((Object)((Object)appFileType), (String)"appFileType");
        return this.resolve(fileName, appFileType, (Function0<Path>)((Function0)() -> UserDataPathProvider.resolve$lambda$0(this)));
    }

    @NotNull
    public final Path resolve(@Nullable String fileName, @NotNull AppFileType appFileType, @NotNull Function0<Path> getBasePath) {
        String string;
        block17: {
            Path path;
            block16: {
                Intrinsics.checkNotNullParameter((Object)((Object)appFileType), (String)"appFileType");
                Intrinsics.checkNotNullParameter(getBasePath, (String)"getBasePath");
                Path basePath = (Path)getBasePath.invoke();
                path = switch (WhenMappings.$EnumSwitchMapping$0[appFileType.ordinal()]) {
                    case 1 -> Path.resolve$default((Path)basePath, (String)"files", (boolean)false, (int)2, null);
                    case 2 -> Path.resolve$default((Path)basePath, (String)"images", (boolean)false, (int)2, null);
                    case 3 -> Path.resolve$default((Path)basePath, (String)"data", (boolean)false, (int)2, null);
                    case 4 -> Path.resolve$default((Path)basePath, (String)"html", (boolean)false, (int)2, null);
                    case 5 -> Path.resolve$default((Path)basePath, (String)"opengraph", (boolean)false, (int)2, null);
                    case 6 -> Path.resolve$default((Path)basePath, (String)"rtf", (boolean)false, (int)2, null);
                    case 7 -> Path.resolve$default((Path)basePath, (String)"icons", (boolean)false, (int)2, null);
                    case 8 -> Path.resolve$default((Path)basePath, (String)"favicon", (boolean)false, (int)2, null);
                    case 9 -> Path.resolve$default((Path)basePath, (String)"file_ext_icons", (boolean)false, (int)2, null);
                    case 10 -> Path.resolve$default((Path)basePath, (String)"videos", (boolean)false, (int)2, null);
                    case 11 -> Path.resolve$default((Path)basePath, (String)"temp", (boolean)false, (int)2, null);
                    case 12 -> Path.resolve$default((Path)basePath, (String)"marketing", (boolean)false, (int)2, null);
                    default -> basePath;
                };
                this.autoCreateDir(path);
                string = fileName;
                if (string == null) break block16;
                String it = string;
                boolean bl = false;
                Path path2 = Path.resolve$default((Path)path, (String)fileName, (boolean)false, (int)2, null);
                string = path2;
                if (path2 != null) break block17;
            }
            string = path;
        }
        return string;
    }

    public final void cleanTemp() {
        UserDataPathProvider userDataPathProvider = this;
        try {
            UserDataPathProvider $this$cleanTemp_u24lambda_u242 = userDataPathProvider;
            boolean bl = false;
            Path tempPath = PathProvider.resolve$default($this$cleanTemp_u24lambda_u242, null, AppFileType.TEMP, 1, null);
            $this$cleanTemp_u24lambda_u242.getFileUtils().getFileSystem().deleteRecursively(tempPath);
            Object object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    public final void resolve(@NotNull String appInstanceId, @NotNull String dateString, long pasteId, @NotNull PasteFiles pasteFiles, boolean isPull, @Nullable FilesIndexBuilder filesIndexBuilder) {
        Intrinsics.checkNotNullParameter((Object)appInstanceId, (String)"appInstanceId");
        Intrinsics.checkNotNullParameter((Object)dateString, (String)"dateString");
        Intrinsics.checkNotNullParameter((Object)pasteFiles, (String)"pasteFiles");
        String string = pasteFiles.getBasePath();
        if (string == null || (string = Path.Companion.get$default((Path.Companion)Path.Companion, (String)string, (boolean)false, (int)1, null)) == null) {
            UserDataPathProvider $this$resolve_u24lambda_u243 = this;
            boolean bl = false;
            string = Path.resolve$default((Path)Path.resolve$default((Path)Path.resolve$default((Path)PathProvider.resolve$default($this$resolve_u24lambda_u243, null, pasteFiles.getAppFileType(), 1, null), (String)appInstanceId, (boolean)false, (int)2, null), (String)dateString, (boolean)false, (int)2, null), (String)String.valueOf(pasteId), (boolean)false, (int)2, null);
        }
        String basePath = string;
        if (isPull) {
            this.autoCreateDir((Path)basePath);
        }
        Map<String, FileInfoTree> fileInfoTreeMap = pasteFiles.getFileInfoTreeMap();
        for (Path filePath : pasteFiles.getFilePaths(this)) {
            FileInfoTree it;
            if (fileInfoTreeMap.get(filePath.name()) == null) continue;
            boolean bl = false;
            this.resolveFileInfoTree((Path)basePath, filePath.name(), it, isPull, filesIndexBuilder);
        }
    }

    private final void resolveFileInfoTree(Path basePath, String name, FileInfoTree fileInfoTree, boolean isPull, FilesIndexBuilder filesIndexBuilder) {
        if (fileInfoTree.isFile()) {
            Path filePath = Path.resolve$default((Path)basePath, (String)name, (boolean)false, (int)2, null);
            if (isPull && Result.isFailure-impl((Object)this.getFileUtils().createEmptyPasteFile-gIAlu-s(filePath, fileInfoTree.getSize()))) {
                throw new PasteException(StandardErrorCode.CANT_CREATE_FILE.toErrorCode(), "Failed to create file: " + filePath);
            }
            FilesIndexBuilder filesIndexBuilder2 = filesIndexBuilder;
            if (filesIndexBuilder2 != null) {
                filesIndexBuilder2.addFile(filePath, fileInfoTree.getSize());
            }
        } else {
            Path dirPath = Path.resolve$default((Path)basePath, (String)name, (boolean)false, (int)2, null);
            if (isPull) {
                this.autoCreateDir(dirPath);
            }
            Intrinsics.checkNotNull((Object)fileInfoTree, (String)"null cannot be cast to non-null type com.crosspaste.presist.DirFileInfoTree");
            DirFileInfoTree dirFileInfoTree = (DirFileInfoTree)fileInfoTree;
            Iterator<Pair<String, FileInfoTree>> $this$forEach$iv = dirFileInfoTree.iterator();
            boolean $i$f$forEach = false;
            Iterator<Pair<String, FileInfoTree>> iterator = $this$forEach$iv;
            while (iterator.hasNext()) {
                Pair<String, FileInfoTree> element$iv;
                Pair<String, FileInfoTree> pair = element$iv = iterator.next();
                boolean bl = false;
                String subName = (String)pair.component1();
                FileInfoTree subFileInfoTree = (FileInfoTree)pair.component2();
                this.resolveFileInfoTree(dirPath, subName, subFileInfoTree, isPull, filesIndexBuilder);
            }
        }
    }

    @NotNull
    public final Path getUserDataPath() {
        return this.configManager.getCurrentConfig().getUseDefaultStoragePath() ? this.platformUserDataPathProvider.getUserDefaultStoragePath() : Path.Companion.get(this.configManager.getCurrentConfig().getStoragePath(), true);
    }

    @Override
    @NotNull
    public Path resolve(@NotNull Path basePath, @NotNull String path, boolean autoCreate, boolean isFile) {
        return PathProvider.super.resolve(basePath, path, autoCreate, isFile);
    }

    @Override
    public void autoCreateDir(@NotNull Path path) {
        PathProvider.super.autoCreateDir(path);
    }

    private static final Path resolve$lambda$0(UserDataPathProvider this$0) {
        return this$0.getUserDataPath();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AppFileType.values().length];
            try {
                nArray[AppFileType.FILE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AppFileType.IMAGE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AppFileType.DATA.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AppFileType.HTML.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AppFileType.OPEN_GRAPH.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AppFileType.RTF.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AppFileType.ICON.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AppFileType.FAVICON.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AppFileType.FILE_EXT_ICON.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AppFileType.VIDEO.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AppFileType.TEMP.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AppFileType.MARKETING.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

