/*
 * Decompiled with CFR 0.152.
 */
package com.mohamedrejeb.ksoup.html.parser;

import com.mohamedrejeb.ksoup.html.parser.KsoupHtmlHandler;
import com.mohamedrejeb.ksoup.html.parser.KsoupHtmlOptions;
import com.mohamedrejeb.ksoup.html.tokenizer.KsoupTokenizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0015\u0018\u0000 N2\u00020\u0001:\u0002MNB\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0018\u0010(\u001a\u00020&2\u0006\u0010)\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\u0011H\u0002J\u0018\u0010,\u001a\u00020&2\u0006\u0010'\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010-\u001a\u00020&2\u0006\u0010+\u001a\u00020\u0011H\u0002J\u0010\u0010.\u001a\u00020&2\u0006\u0010/\u001a\u00020\u0019H\u0002J\u0010\u00100\u001a\u00020&2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0018\u00101\u001a\u00020&2\u0006\u0010'\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u00102\u001a\u00020&2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u00103\u001a\u00020&2\u0006\u00104\u001a\u00020\u0019H\u0002J\u0018\u00105\u001a\u00020&2\u0006\u0010'\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0018\u00106\u001a\u00020&2\u0006\u0010'\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u00107\u001a\u00020&2\u0006\u0010)\u001a\u00020\rH\u0016J\u0018\u00108\u001a\u00020&2\u0006\u00109\u001a\u00020:2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010;\u001a\u00020\u00112\u0006\u0010<\u001a\u00020\u0011H\u0002J\u0018\u0010=\u001a\u00020&2\u0006\u0010'\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0018\u0010>\u001a\u00020&2\u0006\u0010'\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J \u0010?\u001a\u00020&2\u0006\u0010'\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010@\u001a\u00020\rH\u0016J \u0010A\u001a\u00020&2\u0006\u0010'\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010@\u001a\u00020\rH\u0016J\b\u0010B\u001a\u00020&H\u0016J\u0006\u0010C\u001a\u00020&J\u000e\u0010D\u001a\u00020&2\u0006\u0010E\u001a\u00020\u0011J\u0018\u0010F\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\r2\u0006\u0010G\u001a\u00020\rH\u0002J\b\u0010H\u001a\u00020&H\u0002J\u000e\u0010I\u001a\u00020&2\u0006\u0010J\u001a\u00020\u0011J\u0012\u0010G\u001a\u00020&2\n\b\u0002\u0010J\u001a\u0004\u0018\u00010\u0011J\u0006\u0010K\u001a\u00020&J\u0006\u0010L\u001a\u00020&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010 R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lcom/mohamedrejeb/ksoup/html/parser/KsoupHtmlParser;", "Lcom/mohamedrejeb/ksoup/html/tokenizer/KsoupTokenizer$Callbacks;", "handler", "Lcom/mohamedrejeb/ksoup/html/parser/KsoupHtmlHandler;", "options", "Lcom/mohamedrejeb/ksoup/html/parser/KsoupHtmlOptions;", "<init>", "(Lcom/mohamedrejeb/ksoup/html/parser/KsoupHtmlHandler;Lcom/mohamedrejeb/ksoup/html/parser/KsoupHtmlOptions;)V", "getHandler", "()Lcom/mohamedrejeb/ksoup/html/parser/KsoupHtmlHandler;", "getOptions", "()Lcom/mohamedrejeb/ksoup/html/parser/KsoupHtmlOptions;", "startIndex", "", "endIndex", "openTagStart", "tagName", "", "attribName", "attribValue", "attribs", "", "stack", "", "foreignContext", "", "buffers", "bufferOffset", "writeIndex", "ended", "lowerCaseTagNames", "getLowerCaseTagNames", "()Z", "lowerCaseAttributeNames", "getLowerCaseAttributeNames", "ksoupTokenizer", "Lcom/mohamedrejeb/ksoup/html/tokenizer/KsoupTokenizer;", "onText", "", "start", "onTextEntity", "codepoint", "isVoidElement", "name", "onOpenTagName", "emitOpenTag", "endOpenTag", "isImplied", "onOpenTagEnd", "onCloseTag", "onSelfClosingTag", "closeCurrentTag", "isOpenImplied", "onAttribName", "onAttribData", "onAttribEntity", "onAttribEnd", "quote", "Lcom/mohamedrejeb/ksoup/html/parser/KsoupHtmlParser$QuoteType;", "getInstructionName", "value", "onDeclaration", "onProcessingInstruction", "onComment", "offset", "onCData", "onEnd", "reset", "parseComplete", "data", "getSlice", "end", "shiftBuffer", "write", "chunk", "pause", "resume", "QuoteType", "Companion", "ksoup-html"})
@SourceDebugExtension(value={"SMAP\nKsoupHtmlParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KsoupHtmlParser.kt\ncom/mohamedrejeb/ksoup/html/parser/KsoupHtmlParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,537:1\n1863#2,2:538\n1#3:540\n*S KotlinDebug\n*F\n+ 1 KsoupHtmlParser.kt\ncom/mohamedrejeb/ksoup/html/parser/KsoupHtmlParser\n*L\n300#1:538,2\n*E\n"})
public final class KsoupHtmlParser
implements KsoupTokenizer.Callbacks {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final KsoupHtmlHandler handler;
    @NotNull
    private final KsoupHtmlOptions options;
    private int startIndex;
    private int endIndex;
    private int openTagStart;
    @NotNull
    private String tagName;
    @NotNull
    private String attribName;
    @NotNull
    private String attribValue;
    @Nullable
    private Map<String, String> attribs;
    @NotNull
    private final List<String> stack;
    @NotNull
    private final List<Boolean> foreignContext;
    @NotNull
    private final List<String> buffers;
    private int bufferOffset;
    private int writeIndex;
    private boolean ended;
    @NotNull
    private final KsoupTokenizer ksoupTokenizer;
    @NotNull
    private static final Set<String> formTags;
    @NotNull
    private static final Set<String> pTag;
    @NotNull
    private static final Set<String> tableSectionTags;
    @NotNull
    private static final Set<String> ddtTags;
    @NotNull
    private static final Set<String> rtpTags;
    @NotNull
    private static final Map<String, Set<String>> openImpliesClose;
    @NotNull
    private static final Set<String> voidElements;
    @NotNull
    private static final Set<String> foreignContextElements;
    @NotNull
    private static final Set<String> htmlIntegrationElements;
    @NotNull
    private static final Regex reNameEnd;

    public KsoupHtmlParser(@NotNull KsoupHtmlHandler handler, @NotNull KsoupHtmlOptions options) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.handler = handler;
        this.options = options;
        this.tagName = "";
        this.attribName = "";
        this.attribValue = "";
        this.stack = new ArrayList();
        this.foreignContext = new ArrayList();
        this.buffers = new ArrayList();
        this.ksoupTokenizer = new KsoupTokenizer(this.options, this);
    }

    public /* synthetic */ KsoupHtmlParser(KsoupHtmlHandler ksoupHtmlHandler, KsoupHtmlOptions ksoupHtmlOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            ksoupHtmlHandler = KsoupHtmlHandler.Default.INSTANCE;
        }
        if ((n & 2) != 0) {
            ksoupHtmlOptions = KsoupHtmlOptions.Companion.getDefault();
        }
        this(ksoupHtmlHandler, ksoupHtmlOptions);
    }

    @NotNull
    public final KsoupHtmlHandler getHandler() {
        return this.handler;
    }

    @NotNull
    public final KsoupHtmlOptions getOptions() {
        return this.options;
    }

    private final boolean getLowerCaseTagNames() {
        return this.options.getLowerCaseTags();
    }

    private final boolean getLowerCaseAttributeNames() {
        return this.options.getLowerCaseAttributeNames();
    }

    @Override
    public void onText(int start, int endIndex) {
        String data = this.getSlice(start, endIndex);
        this.endIndex = endIndex - 1;
        this.handler.onText(data);
        this.startIndex = endIndex;
    }

    @Override
    public void onTextEntity(int codepoint, int endIndex) {
        this.endIndex = endIndex - 1;
        if (codepoint < 0 || codepoint > 65535) {
            throw new IllegalArgumentException("Invalid Char code: " + codepoint);
        }
        this.handler.onText(String.valueOf((char)codepoint));
        this.startIndex = endIndex;
    }

    private final boolean isVoidElement(String name) {
        return !this.options.getXmlMode() && voidElements.contains(name);
    }

    @Override
    public void onOpenTagName(int start, int endIndex) {
        this.endIndex = endIndex;
        String name = this.getSlice(start, endIndex);
        if (this.getLowerCaseTagNames()) {
            String string = name.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            name = string;
        }
        this.emitOpenTag(name);
    }

    private final void emitOpenTag(String name) {
        this.openTagStart = this.startIndex;
        this.tagName = name;
        Set<String> impliesClose = openImpliesClose.get(name);
        if (!this.options.getXmlMode() && impliesClose != null) {
            while (!((Collection)this.stack).isEmpty() && impliesClose.contains(CollectionsKt.last(this.stack))) {
                String element = (String)CollectionsKt.removeLast(this.stack);
                this.handler.onCloseTag(element, true);
            }
        }
        if (!this.isVoidElement(name)) {
            this.stack.add(name);
            if (foreignContextElements.contains(name)) {
                this.foreignContext.add(true);
            } else if (htmlIntegrationElements.contains(name)) {
                this.foreignContext.add(false);
            }
        }
        this.handler.onOpenTagName(name);
        this.attribs = new LinkedHashMap();
    }

    private final void endOpenTag(boolean isImplied) {
        this.startIndex = this.openTagStart;
        Map<String, String> map = this.attribs;
        if (map != null) {
            Map<String, String> it = map;
            boolean bl = false;
            this.handler.onOpenTag(this.tagName, it, isImplied);
            this.attribs = null;
        }
        if (this.isVoidElement(this.tagName)) {
            this.handler.onCloseTag(this.tagName, true);
        }
        this.tagName = "";
    }

    @Override
    public void onOpenTagEnd(int endIndex) {
        this.endIndex = endIndex;
        this.endOpenTag(false);
        this.startIndex = endIndex + 1;
    }

    @Override
    public void onCloseTag(int start, int endIndex) {
        this.endIndex = endIndex;
        String name = this.getSlice(start, endIndex);
        if (this.getLowerCaseTagNames()) {
            String string = name.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            name = string;
        }
        if (foreignContextElements.contains(name) && htmlIntegrationElements.contains(name)) {
            CollectionsKt.removeLast(this.foreignContext);
        }
        if (!this.isVoidElement(name)) {
            int pos = this.stack.lastIndexOf(name);
            if (pos != -1) {
                int count = this.stack.size() - pos;
                while (count-- > 0) {
                    String element = (String)CollectionsKt.removeLast(this.stack);
                    this.handler.onCloseTag(element, count != 0);
                }
            } else if (!this.options.getXmlMode() && Intrinsics.areEqual((Object)name, (Object)"p")) {
                this.emitOpenTag("p");
                this.closeCurrentTag(true);
            }
        } else if (!this.options.getXmlMode() && Intrinsics.areEqual((Object)name, (Object)"br")) {
            this.handler.onOpenTagName("br");
            this.handler.onOpenTag("br", MapsKt.emptyMap(), true);
            this.handler.onCloseTag("br", false);
        }
        this.startIndex = endIndex + 1;
    }

    @Override
    public void onSelfClosingTag(int endIndex) {
        this.endIndex = endIndex;
        if (this.options.getXmlMode() || this.options.getRecognizeSelfClosing() || Intrinsics.areEqual((Object)CollectionsKt.lastOrNull(this.foreignContext), (Object)true)) {
            this.closeCurrentTag(false);
            this.startIndex = endIndex + 1;
        } else {
            this.onOpenTagEnd(endIndex);
        }
    }

    private final void closeCurrentTag(boolean isOpenImplied) {
        String name = this.tagName;
        this.endOpenTag(isOpenImplied);
        if (this.stack.size() > 0 && Intrinsics.areEqual((Object)this.stack.get(this.stack.size() - 1), (Object)name)) {
            this.handler.onCloseTag(name, !isOpenImplied);
            CollectionsKt.removeLast(this.stack);
        }
    }

    @Override
    public void onAttribName(int start, int endIndex) {
        String string;
        this.startIndex = start;
        String name = this.getSlice(start, endIndex);
        if (this.getLowerCaseAttributeNames()) {
            String string2 = name.toLowerCase(Locale.ROOT);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        } else {
            string = name;
        }
        this.attribName = string;
    }

    @Override
    public void onAttribData(int start, int endIndex) {
        this.attribValue = this.attribValue + this.getSlice(start, endIndex);
    }

    @Override
    public void onAttribEntity(int codepoint) {
        if (codepoint < 0 || codepoint > 65535) {
            throw new IllegalArgumentException("Invalid Char code: " + codepoint);
        }
        this.attribValue = this.attribValue + (char)codepoint;
    }

    @Override
    public void onAttribEnd(@NotNull QuoteType quote, int endIndex) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)quote), (String)"quote");
        this.endIndex = endIndex;
        switch (WhenMappings.$EnumSwitchMapping$0[quote.ordinal()]) {
            case 1: {
                string = "\"";
                break;
            }
            case 2: {
                string = "'";
                break;
            }
            default: {
                string = null;
            }
        }
        this.handler.onAttribute(this.attribName, this.attribValue, string);
        Map<String, String> map = this.attribs;
        if (map != null) {
            Map<String, String> it = map;
            boolean bl = false;
            it.put(this.attribName, this.attribValue);
        }
        this.attribValue = "";
    }

    private final String getInstructionName(String value) {
        String string;
        int index;
        MatchResult matchResult = Regex.find$default((Regex)reNameEnd, (CharSequence)value, (int)0, (int)2, null);
        int n = matchResult != null && (matchResult = matchResult.getRange()) != null ? matchResult.getStart() : (index = -1);
        if (index < 0) {
            string = value;
        } else {
            String string2 = value.substring(0, index);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        }
        String name = string;
        if (this.getLowerCaseTagNames()) {
            String string3 = name.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            name = string3;
        }
        return name;
    }

    @Override
    public void onDeclaration(int start, int endIndex) {
        this.endIndex = endIndex;
        String value = this.getSlice(start, endIndex);
        String name = this.getInstructionName(value);
        this.handler.onProcessingInstruction(name, value);
        this.startIndex = endIndex + 1;
    }

    @Override
    public void onProcessingInstruction(int start, int endIndex) {
        this.endIndex = endIndex;
        String value = this.getSlice(start, endIndex);
        String name = this.getInstructionName(value);
        this.handler.onProcessingInstruction(name, value);
        this.startIndex = endIndex + 1;
    }

    @Override
    public void onComment(int start, int endIndex, int offset) {
        this.endIndex = endIndex;
        this.handler.onComment(this.getSlice(start, endIndex - offset));
        this.handler.onCommentEnd();
        this.startIndex = endIndex + 1;
    }

    @Override
    public void onCData(int start, int endIndex, int offset) {
        this.endIndex = endIndex;
        String value = this.getSlice(start, endIndex - offset);
        if (this.options.getXmlMode() || this.options.getRecognizeCDATA()) {
            this.handler.onCDataStart();
            this.handler.onText(value);
            this.handler.onCDataEnd();
        } else {
            this.handler.onComment("[CDATA[" + value + "]]");
            this.handler.onCommentEnd();
        }
        this.startIndex = endIndex + 1;
    }

    @Override
    public void onEnd() {
        this.endIndex = this.startIndex;
        Iterable $this$forEach$iv = (Iterable)CollectionsKt.getIndices((Collection)this.stack);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int i = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            int index = CollectionsKt.getLastIndex(this.stack) - i;
            this.handler.onCloseTag(this.stack.get(index), true);
        }
        this.handler.onEnd();
    }

    public final void reset() {
        this.handler.onReset();
        this.ksoupTokenizer.reset();
        this.tagName = "";
        this.attribName = "";
        this.attribValue = "";
        this.attribs = null;
        this.stack.clear();
        this.startIndex = 0;
        this.endIndex = 0;
        this.handler.onParserInit(this);
        this.buffers.clear();
        this.bufferOffset = 0;
        this.writeIndex = 0;
        this.ended = false;
    }

    public final void parseComplete(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.reset();
        this.end(data);
    }

    private final String getSlice(int start, int end) {
        while (start - this.bufferOffset >= ((String)CollectionsKt.first(this.buffers)).length()) {
            this.shiftBuffer();
        }
        String string = ((String)CollectionsKt.first(this.buffers)).substring(start - this.bufferOffset, end - this.bufferOffset);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String slice = string;
        while (end - this.bufferOffset > ((String)CollectionsKt.first(this.buffers)).length()) {
            this.shiftBuffer();
            StringBuilder stringBuilder = new StringBuilder().append(slice);
            String string2 = ((String)CollectionsKt.first(this.buffers)).substring(0, end - this.bufferOffset);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            slice = stringBuilder.append(string2).toString();
        }
        return slice;
    }

    private final void shiftBuffer() {
        this.bufferOffset += ((String)CollectionsKt.first(this.buffers)).length();
        int n = this.writeIndex;
        this.writeIndex = n + -1;
        CollectionsKt.removeFirst(this.buffers);
    }

    public final void write(@NotNull String chunk) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        if (this.ended) {
            this.handler.onError(new Exception(".write() after done!"));
            return;
        }
        this.buffers.add(chunk);
        if (this.ksoupTokenizer.getRunning()) {
            this.ksoupTokenizer.write(chunk);
            int n = this.writeIndex;
            this.writeIndex = n + 1;
        }
    }

    public final void end(@Nullable String chunk) {
        if (this.ended) {
            this.handler.onError(new Exception(".end() after done!"));
            return;
        }
        String string = chunk;
        if (string != null) {
            String it = string;
            boolean bl = false;
            this.write(it);
        }
        this.ended = true;
        this.ksoupTokenizer.end();
    }

    public static /* synthetic */ void end$default(KsoupHtmlParser ksoupHtmlParser, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        ksoupHtmlParser.end(string);
    }

    public final void pause() {
        this.ksoupTokenizer.pause();
    }

    public final void resume() {
        this.ksoupTokenizer.resume();
        while (this.ksoupTokenizer.getRunning() && this.writeIndex < this.buffers.size()) {
            int n = this.writeIndex;
            this.writeIndex = n + 1;
            this.ksoupTokenizer.write(this.buffers.get(n));
        }
        if (this.ended) {
            this.ksoupTokenizer.end();
        }
    }

    public KsoupHtmlParser() {
        this(null, null, 3, null);
    }

    static {
        Object[] objectArray = new String[]{"input", "option", "optgroup", "select", "button", "datalist", "textarea"};
        formTags = SetsKt.setOf((Object[])objectArray);
        pTag = SetsKt.setOf((Object)"p");
        objectArray = new String[]{"thead", "tbody"};
        tableSectionTags = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"dt", "dd"};
        ddtTags = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"rt", "rp"};
        rtpTags = SetsKt.setOf((Object[])objectArray);
        objectArray = new Pair[48];
        Object[] objectArray2 = new String[]{"tr", "th", "td"};
        objectArray[0] = TuplesKt.to((Object)"tr", (Object)SetsKt.setOf((Object[])objectArray2));
        objectArray[1] = TuplesKt.to((Object)"th", (Object)SetsKt.setOf((Object)"th"));
        objectArray2 = new String[]{"thead", "th", "td"};
        objectArray[2] = TuplesKt.to((Object)"td", (Object)SetsKt.setOf((Object[])objectArray2));
        objectArray2 = new String[]{"head", "link", "script"};
        objectArray[3] = TuplesKt.to((Object)"body", (Object)SetsKt.setOf((Object[])objectArray2));
        objectArray[4] = TuplesKt.to((Object)"li", (Object)SetsKt.setOf((Object)"li"));
        objectArray[5] = TuplesKt.to((Object)"p", pTag);
        objectArray[6] = TuplesKt.to((Object)"h1", pTag);
        objectArray[7] = TuplesKt.to((Object)"h2", pTag);
        objectArray[8] = TuplesKt.to((Object)"h3", pTag);
        objectArray[9] = TuplesKt.to((Object)"h4", pTag);
        objectArray[10] = TuplesKt.to((Object)"h5", pTag);
        objectArray[11] = TuplesKt.to((Object)"h6", pTag);
        objectArray[12] = TuplesKt.to((Object)"select", formTags);
        objectArray[13] = TuplesKt.to((Object)"input", formTags);
        objectArray[14] = TuplesKt.to((Object)"output", formTags);
        objectArray[15] = TuplesKt.to((Object)"button", formTags);
        objectArray[16] = TuplesKt.to((Object)"datalist", formTags);
        objectArray[17] = TuplesKt.to((Object)"textarea", formTags);
        objectArray[18] = TuplesKt.to((Object)"option", (Object)SetsKt.setOf((Object)"option"));
        objectArray2 = new String[]{"optgroup", "option"};
        objectArray[19] = TuplesKt.to((Object)"optgroup", (Object)SetsKt.setOf((Object[])objectArray2));
        objectArray[20] = TuplesKt.to((Object)"dd", ddtTags);
        objectArray[21] = TuplesKt.to((Object)"dt", ddtTags);
        objectArray[22] = TuplesKt.to((Object)"address", pTag);
        objectArray[23] = TuplesKt.to((Object)"article", pTag);
        objectArray[24] = TuplesKt.to((Object)"aside", pTag);
        objectArray[25] = TuplesKt.to((Object)"blockquote", pTag);
        objectArray[26] = TuplesKt.to((Object)"details", pTag);
        objectArray[27] = TuplesKt.to((Object)"div", pTag);
        objectArray[28] = TuplesKt.to((Object)"dl", pTag);
        objectArray[29] = TuplesKt.to((Object)"fieldset", pTag);
        objectArray[30] = TuplesKt.to((Object)"figcaption", pTag);
        objectArray[31] = TuplesKt.to((Object)"figure", pTag);
        objectArray[32] = TuplesKt.to((Object)"footer", pTag);
        objectArray[33] = TuplesKt.to((Object)"form", pTag);
        objectArray[34] = TuplesKt.to((Object)"header", pTag);
        objectArray[35] = TuplesKt.to((Object)"hr", pTag);
        objectArray[36] = TuplesKt.to((Object)"main", pTag);
        objectArray[37] = TuplesKt.to((Object)"menu", pTag);
        objectArray[38] = TuplesKt.to((Object)"nav", pTag);
        objectArray[39] = TuplesKt.to((Object)"ol", pTag);
        objectArray[40] = TuplesKt.to((Object)"pre", pTag);
        objectArray[41] = TuplesKt.to((Object)"section", pTag);
        objectArray[42] = TuplesKt.to((Object)"table", pTag);
        objectArray[43] = TuplesKt.to((Object)"ul", pTag);
        objectArray[44] = TuplesKt.to((Object)"rt", rtpTags);
        objectArray[45] = TuplesKt.to((Object)"rp", rtpTags);
        objectArray[46] = TuplesKt.to((Object)"tbody", tableSectionTags);
        objectArray[47] = TuplesKt.to((Object)"tfoot", tableSectionTags);
        openImpliesClose = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new String[]{"area", "base", "basefont", "br", "col", "command", "embed", "frame", "hr", "img", "input", "isindex", "keygen", "link", "meta", "param", "source", "track", "wbr"};
        voidElements = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"math", "svg"};
        foreignContextElements = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"mi", "mo", "mn", "ms", "mtext", "annotation-xml", "foreignobject", "desc", "title"};
        htmlIntegrationElements = SetsKt.setOf((Object[])objectArray);
        reNameEnd = new Regex("\\s|/");
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/mohamedrejeb/ksoup/html/parser/KsoupHtmlParser$Companion;", "", "<init>", "()V", "formTags", "", "", "pTag", "tableSectionTags", "ddtTags", "rtpTags", "openImpliesClose", "", "voidElements", "foreignContextElements", "htmlIntegrationElements", "reNameEnd", "Lkotlin/text/Regex;", "ksoup-html"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/mohamedrejeb/ksoup/html/parser/KsoupHtmlParser$QuoteType;", "", "<init>", "(Ljava/lang/String;I)V", "NoValue", "Unquoted", "Single", "Double", "ksoup-html"})
    public static final class QuoteType
    extends Enum<QuoteType> {
        public static final /* enum */ QuoteType NoValue = new QuoteType();
        public static final /* enum */ QuoteType Unquoted = new QuoteType();
        public static final /* enum */ QuoteType Single = new QuoteType();
        public static final /* enum */ QuoteType Double = new QuoteType();
        private static final /* synthetic */ QuoteType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static QuoteType[] values() {
            return (QuoteType[])$VALUES.clone();
        }

        public static QuoteType valueOf(String value) {
            return Enum.valueOf(QuoteType.class, value);
        }

        @NotNull
        public static EnumEntries<QuoteType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = quoteTypeArray = new QuoteType[]{QuoteType.NoValue, QuoteType.Unquoted, QuoteType.Single, QuoteType.Double};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[QuoteType.values().length];
            try {
                nArray[QuoteType.Double.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QuoteType.Single.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

