/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material;

import androidx.compose.material.DraggableAnchors;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001b\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\rJ\u0017\u0010\u000e\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000f\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u0010J\u001f\u0010\u000e\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0005H\u0016J\b\u0010\u0014\u001a\u00020\u0005H\u0016J\u0013\u0010\u0019\u001a\u00020\f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\b\u0010\u001c\u001a\u00020\u0016H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001f"}, d2={"Landroidx/compose/material/MapDraggableAnchors;", "T", "Landroidx/compose/material/DraggableAnchors;", "anchors", "", "", "<init>", "(Ljava/util/Map;)V", "positionOf", "value", "(Ljava/lang/Object;)F", "hasAnchorFor", "", "(Ljava/lang/Object;)Z", "closestAnchor", "position", "(F)Ljava/lang/Object;", "searchUpwards", "(FZ)Ljava/lang/Object;", "minAnchor", "maxAnchor", "size", "", "getSize", "()I", "equals", "other", "", "hashCode", "toString", "", "material"})
@SourceDebugExtension(value={"SMAP\nAnchoredDraggable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnchoredDraggable.kt\nandroidx/compose/material/MapDraggableAnchors\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,875:1\n1#2:876\n*E\n"})
final class MapDraggableAnchors<T>
implements DraggableAnchors<T> {
    @NotNull
    private final Map<T, Float> anchors;

    public MapDraggableAnchors(@NotNull Map<T, Float> anchors) {
        Intrinsics.checkNotNullParameter(anchors, (String)"anchors");
        this.anchors = anchors;
    }

    @Override
    public float positionOf(T value) {
        Float f = this.anchors.get(value);
        return f != null ? f.floatValue() : Float.NaN;
    }

    @Override
    public boolean hasAnchorFor(T value) {
        return this.anchors.containsKey(value);
    }

    @Override
    @Nullable
    public T closestAnchor(float position) {
        Object v0;
        Iterable iterable = this.anchors.entrySet();
        Iterator iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            v0 = null;
        } else {
            Object t = iterator.next();
            if (!iterator.hasNext()) {
                v0 = t;
            } else {
                Map.Entry it = (Map.Entry)t;
                boolean bl = false;
                float f = Math.abs(position - ((Number)it.getValue()).floatValue());
                do {
                    Object t2 = iterator.next();
                    Map.Entry it2 = (Map.Entry)t2;
                    $i$a$-minByOrNull-MapDraggableAnchors$closestAnchor$1 = false;
                    float f2 = Math.abs(position - ((Number)it2.getValue()).floatValue());
                    if (Float.compare(f, f2) <= 0) continue;
                    t = t2;
                    f = f2;
                } while (iterator.hasNext());
                v0 = t;
            }
        }
        Map.Entry entry = v0;
        return (T)(entry != null ? entry.getKey() : null);
    }

    @Override
    @Nullable
    public T closestAnchor(float position, boolean searchUpwards) {
        Object v0;
        Iterable iterable = this.anchors.entrySet();
        Iterator iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            v0 = null;
        } else {
            Object t = iterator.next();
            if (!iterator.hasNext()) {
                v0 = t;
            } else {
                Map.Entry entry = (Map.Entry)t;
                boolean bl = false;
                float anchor = ((Number)entry.getValue()).floatValue();
                float delta = searchUpwards ? anchor - position : position - anchor;
                float f = delta < 0.0f ? Float.POSITIVE_INFINITY : delta;
                do {
                    float f2;
                    Object t2 = iterator.next();
                    Map.Entry entry2 = (Map.Entry)t2;
                    $i$a$-minByOrNull-MapDraggableAnchors$closestAnchor$2 = false;
                    float anchor2 = ((Number)entry2.getValue()).floatValue();
                    float delta2 = searchUpwards ? anchor2 - position : position - anchor2;
                    float f3 = f2 = delta2 < 0.0f ? Float.POSITIVE_INFINITY : delta2;
                    if (Float.compare(f, f2) <= 0) continue;
                    t = t2;
                    f = f2;
                } while (iterator.hasNext());
                v0 = t;
            }
        }
        Map.Entry entry = v0;
        return entry != null ? (T)entry.getKey() : null;
    }

    @Override
    public float minAnchor() {
        Float f = CollectionsKt.minOrNull((Iterable)this.anchors.values());
        return f != null ? f.floatValue() : Float.NaN;
    }

    @Override
    public float maxAnchor() {
        Float f = CollectionsKt.maxOrNull((Iterable)this.anchors.values());
        return f != null ? f.floatValue() : Float.NaN;
    }

    @Override
    public int getSize() {
        return this.anchors.size();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MapDraggableAnchors)) {
            return false;
        }
        return Intrinsics.areEqual(this.anchors, ((MapDraggableAnchors)other).anchors);
    }

    public int hashCode() {
        return 31 * ((Object)this.anchors).hashCode();
    }

    @NotNull
    public String toString() {
        return "MapDraggableAnchors(" + this.anchors + ")";
    }
}

