/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.serialization.asn1.internal;

import dev.whyoleg.cryptography.bigint.BigInt;
import dev.whyoleg.cryptography.serialization.asn1.BitArray;
import dev.whyoleg.cryptography.serialization.asn1.ContextSpecificTag;
import dev.whyoleg.cryptography.serialization.asn1.Der;
import dev.whyoleg.cryptography.serialization.asn1.ObjectIdentifier;
import dev.whyoleg.cryptography.serialization.asn1.internal.ByteArrayInput;
import dev.whyoleg.cryptography.serialization.asn1.internal.DerInput;
import dev.whyoleg.cryptography.serialization.asn1.internal.DerTagKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.AbstractDecoder;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u000fH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J!\u0010!\u001a\u0002H\"\"\u0004\b\u0000\u0010\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H\"0$H\u0016\u00a2\u0006\u0002\u0010%J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010*\u001a\u00020)2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010+\u001a\u00020\u000fH\u0016J\u0010\u0010,\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020\u0015H\u0016J\b\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u000201H\u0016J\b\u00102\u001a\u00020\u0017H\u0016J\b\u00103\u001a\u000204H\u0016J\b\u00105\u001a\u000206H\u0016J\b\u00107\u001a\u000208H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Ldev/whyoleg/cryptography/serialization/asn1/internal/DerDecoder;", "Lkotlinx/serialization/encoding/AbstractDecoder;", "der", "Ldev/whyoleg/cryptography/serialization/asn1/Der;", "byteArrayInput", "Ldev/whyoleg/cryptography/serialization/asn1/internal/ByteArrayInput;", "<init>", "(Ldev/whyoleg/cryptography/serialization/asn1/Der;Ldev/whyoleg/cryptography/serialization/asn1/internal/ByteArrayInput;)V", "input", "Ldev/whyoleg/cryptography/serialization/asn1/internal/DerInput;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "currentIndex", "", "tagOverride", "Ldev/whyoleg/cryptography/serialization/asn1/ContextSpecificTag;", "getAndResetTagOverride", "decodeElementIndex", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "decodeNotNullMark", "", "decodeNull", "", "decodeByte", "", "decodeShort", "", "decodeInt", "decodeLong", "", "decodeSerializableValue", "T", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "(Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "beginStructure", "Lkotlinx/serialization/encoding/CompositeDecoder;", "decodeInline", "Lkotlinx/serialization/encoding/Decoder;", "decodeInlineElement", "index", "decodeEnum", "enumDescriptor", "decodeString", "", "decodeChar", "", "decodeBoolean", "decodeDouble", "", "decodeFloat", "", "decodeValue", "", "cryptography-serialization-asn1"})
public final class DerDecoder
extends AbstractDecoder {
    @NotNull
    private final Der der;
    @NotNull
    private final DerInput input;
    private int currentIndex;
    @Nullable
    private ContextSpecificTag tagOverride;

    public DerDecoder(@NotNull Der der, @NotNull ByteArrayInput byteArrayInput) {
        Intrinsics.checkNotNullParameter((Object)der, (String)"der");
        Intrinsics.checkNotNullParameter((Object)byteArrayInput, (String)"byteArrayInput");
        this.der = der;
        this.input = new DerInput(byteArrayInput);
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.der.getSerializersModule();
    }

    private final ContextSpecificTag getAndResetTagOverride() {
        ContextSpecificTag tag = this.tagOverride;
        this.tagOverride = null;
        return tag;
    }

    public int decodeElementIndex(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (this.input.getEof()) {
            return -1;
        }
        byte tag = this.input.peakTag();
        while (true) {
            ContextSpecificTag requiredTag;
            int index = this.currentIndex;
            this.tagOverride = DerTagKt.getElementContextSpecificTag(descriptor, index);
            if (!descriptor.isElementOptional(index)) break;
            if (this.tagOverride == null) {
                boolean bl = false;
                String string = "Optional element " + descriptor + '[' + index + "] must have context specific tag";
                throw new IllegalStateException(string.toString());
            }
            if (tag == DerTagKt.getTag(requiredTag)) break;
            int n = this.currentIndex;
            this.currentIndex = n + 1;
        }
        int n = this.currentIndex;
        this.currentIndex = n + 1;
        return n;
    }

    public boolean decodeNotNullMark() {
        return this.input.isNotNull();
    }

    @Nullable
    public Void decodeNull() {
        return this.input.readNull();
    }

    public byte decodeByte() {
        return this.input.readInteger(this.getAndResetTagOverride()).byteValue();
    }

    public short decodeShort() {
        return this.input.readInteger(this.getAndResetTagOverride()).shortValue();
    }

    public int decodeInt() {
        return this.input.readInteger(this.getAndResetTagOverride()).intValue();
    }

    public long decodeLong() {
        return this.input.readInteger(this.getAndResetTagOverride()).longValue();
    }

    public <T> T decodeSerializableValue(@NotNull DeserializationStrategy<? extends T> deserializer) {
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        SerialDescriptor serialDescriptor = deserializer.getDescriptor();
        return (T)(Intrinsics.areEqual((Object)serialDescriptor, (Object)BuiltinSerializersKt.ByteArraySerializer().getDescriptor()) ? (Object)this.input.readOctetString(this.getAndResetTagOverride()) : (Intrinsics.areEqual((Object)serialDescriptor, (Object)BitArray.Companion.serializer().getDescriptor()) ? (Object)this.input.readBitString(this.getAndResetTagOverride()) : (Intrinsics.areEqual((Object)serialDescriptor, (Object)ObjectIdentifier.Companion.serializer().getDescriptor()) ? ObjectIdentifier.box-impl(this.input.readObjectIdentifier-iVrrli8(this.getAndResetTagOverride())) : (Intrinsics.areEqual((Object)serialDescriptor, (Object)BigInt.Companion.serializer().getDescriptor()) ? (Object)this.input.readInteger(this.getAndResetTagOverride()) : deserializer.deserialize((Decoder)this)))));
    }

    @NotNull
    public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        SerialKind serialKind = descriptor.getKind();
        if (!Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.CLASS.INSTANCE) && !(serialKind instanceof PolymorphicKind)) {
            throw new SerializationException("This serial kind is not supported as structure: " + descriptor);
        }
        return (CompositeDecoder)new DerDecoder(this.der, this.input.readSequence(this.getAndResetTagOverride()));
    }

    @NotNull
    public Decoder decodeInline(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return (Decoder)this;
    }

    @NotNull
    public Decoder decodeInlineElement(@NotNull SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return (Decoder)this;
    }

    public int decodeEnum(@NotNull SerialDescriptor enumDescriptor) {
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        throw new IllegalStateException("Enum decoding is not supported".toString());
    }

    @NotNull
    public String decodeString() {
        throw new IllegalStateException("String decoding is not supported".toString());
    }

    public char decodeChar() {
        throw new IllegalStateException("Char decoding is not supported".toString());
    }

    public boolean decodeBoolean() {
        throw new IllegalStateException("Boolean decoding is not supported".toString());
    }

    public double decodeDouble() {
        throw new IllegalStateException("Double decoding is not supported".toString());
    }

    public float decodeFloat() {
        throw new IllegalStateException("Float decoding is not supported".toString());
    }

    @NotNull
    public Object decodeValue() {
        throw new IllegalStateException("should not be called".toString());
    }
}

