/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.serialization.asn1.internal;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u0006\u0010\u000e\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0007J\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Ldev/whyoleg/cryptography/serialization/asn1/internal/ByteArrayOutput;", "", "<init>", "()V", "array", "", "position", "", "size", "getSize", "()I", "ensureCapacity", "", "elementsToAppend", "toByteArray", "write", "byte", "", "bytes", "output", "cryptography-serialization-asn1"})
public final class ByteArrayOutput {
    @NotNull
    private byte[] array = new byte[32];
    private int position;

    public final int getSize() {
        return this.position;
    }

    private final void ensureCapacity(int elementsToAppend) {
        if (this.position + elementsToAppend <= this.array.length) {
            return;
        }
        byte[] byArray = Arrays.copyOf(this.array, Integer.highestOneBit(this.position + elementsToAppend) << 1);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
        this.array = byArray;
    }

    @NotNull
    public final byte[] toByteArray() {
        byte[] byArray = Arrays.copyOf(this.array, this.position);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
        return byArray;
    }

    public final void write(byte by) {
        this.ensureCapacity(1);
        int n = this.position;
        this.position = n + 1;
        this.array[n] = by;
    }

    public final void write(int n) {
        this.write((byte)n);
    }

    public final void write(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        if (bytes.length == 0) {
            return;
        }
        this.ensureCapacity(bytes.length);
        ArraysKt.copyInto$default((byte[])bytes, (byte[])this.array, (int)this.position, (int)0, (int)0, (int)12, null);
        this.position += bytes.length;
    }

    public final void write(@NotNull ByteArrayOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        if (output.getSize() == 0) {
            return;
        }
        this.ensureCapacity(output.position);
        ArraysKt.copyInto((byte[])output.array, (byte[])this.array, (int)this.position, (int)0, (int)output.position);
        this.position += output.position;
    }
}

